/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.exception.InternalExpressionException;
import carpet.script.value.ListValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.ThreadValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_2520;

public abstract class Value
implements Comparable<Value>,
Cloneable {
    public static Value FALSE = new NumericValue(0L);
    public static Value TRUE = new NumericValue(1L);
    public static Value ZERO = FALSE;
    public static Value NULL = new NullValue();
    public String boundVariable = null;

    public static <T> T assertNotNull(T t) {
        if (t == null) {
            throw new InternalExpressionException("Operand may not be null");
        }
        return t;
    }

    public static <T> void assertNotNull(T t1, T t2) {
        if (t1 == null) {
            throw new InternalExpressionException("First operand may not be null");
        }
        if (t2 == null) {
            throw new InternalExpressionException("Second operand may not be null");
        }
    }

    public boolean isBound() {
        return this.boundVariable != null;
    }

    public String getVariable() {
        return this.boundVariable;
    }

    public Value reboundedTo(String var) {
        Value copy;
        try {
            copy = (Value)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new InternalExpressionException("Variable of type " + this.getTypeString() + " is not cloneable. Tell gnembon about it, this shoudn't happen");
        }
        copy.boundVariable = var;
        return copy;
    }

    public Value bindTo(String var) {
        this.boundVariable = var;
        return this;
    }

    public abstract String getString();

    public String getPrettyString() {
        return this.getString();
    }

    public abstract boolean getBoolean();

    public Value add(Value o) {
        String lstr = this.getString();
        if (lstr == null) {
            return new StringValue(o.getString());
        }
        String rstr = o.getString();
        if (rstr == null) {
            return new StringValue(lstr);
        }
        return new StringValue(lstr + rstr);
    }

    public Value subtract(Value v) {
        return new StringValue(this.getString().replace(v.getString(), ""));
    }

    public Value multiply(Value v) {
        if (v instanceof NumericValue || v instanceof ListValue) {
            return v.multiply(this);
        }
        return new StringValue(this.getString() + "." + v.getString());
    }

    public Value divide(Value v) {
        if (v instanceof NumericValue) {
            String lstr = this.getString();
            return new StringValue(lstr.substring(0, (int)((double)lstr.length() / ((NumericValue)v).getDouble())));
        }
        return new StringValue(this.getString() + "/" + v.getString());
    }

    @Override
    public int compareTo(Value o) {
        if (o instanceof NumericValue || o instanceof ListValue || o instanceof ThreadValue) {
            return -o.compareTo(this);
        }
        return this.getString().compareTo(o.getString());
    }

    public boolean equals(Object o) {
        if (o instanceof Value) {
            return this.compareTo((Value)o) == 0;
        }
        return false;
    }

    public void assertAssignable() {
        if (this.boundVariable == null || this.boundVariable.startsWith("_")) {
            if (this.boundVariable != null) {
                throw new InternalExpressionException(this.boundVariable + " cannot be assigned a new value");
            }
            throw new InternalExpressionException(this.getString() + " is not a variable");
        }
    }

    public Value in(Value value1) {
        Pattern p;
        try {
            p = Pattern.compile(value1.getString());
        }
        catch (PatternSyntaxException pse) {
            throw new InternalExpressionException("Incorrect matching pattern: " + pse.getMessage());
        }
        Matcher m = p.matcher(this.getString());
        if (!m.find()) {
            return NULL;
        }
        int gc = m.groupCount();
        if (gc == 0) {
            return new StringValue(m.group());
        }
        if (gc == 1) {
            return new StringValue(m.group(1));
        }
        ArrayList<Value> groups = new ArrayList<Value>(gc);
        for (int i = 1; i <= gc; ++i) {
            groups.add(new StringValue(m.group(i)));
        }
        return ListValue.wrap(groups);
    }

    public int length() {
        return this.getString().length();
    }

    public Value slice(long from, long to) {
        String value = this.getString();
        int size = value.length();
        if (to > (long)size) {
            to = -1L;
        }
        if (from < 0L) {
            from = 0L;
        }
        if (from > (long)size) {
            from = size;
        }
        if (to >= 0L) {
            return new StringValue(value.substring((int)from, (int)to));
        }
        return new StringValue(value.substring((int)from));
    }

    public double readDoubleNumber() {
        String s = this.getString();
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public long readInteger() {
        return (long)this.readDoubleNumber();
    }

    public String getTypeString() {
        throw new InternalExpressionException("How did you get here? Cannot get type of an intenal type.");
    }

    public int hashCode() {
        String stringVal = this.getString();
        if (stringVal.isEmpty()) {
            return 0;
        }
        return ("s" + stringVal).hashCode();
    }

    public Value deepcopy() {
        try {
            return (Value)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalExpressionException("Cannot make a copy of value: " + this);
        }
    }

    public abstract class_2520 toTag(boolean var1);

    public JsonElement toJson() {
        return new JsonPrimitive(this.getString());
    }

    public boolean isNull() {
        return false;
    }
}

