/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.language.Operators;
import carpet.script.value.Value;

public class ControlFlow {
    public static void apply(Expression expression) {
        expression.addLazyBinaryOperator(";", Operators.precedence.get("nextop;"), true, (c, t, lv1, lv2) -> {
            lv1.evalValue((Context)c, 1);
            Value v2 = lv2.evalValue((Context)c, (Integer)t);
            return (cc, tt) -> v2;
        });
        expression.addLazyFunction("if", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'if' statement needs to have at least one condition and one case");
            }
            for (int i = 0; i < lv.size() - 1; i += 2) {
                if (!((LazyValue)lv.get(i)).evalValue((Context)c, 2).getBoolean()) continue;
                Value ret = ((LazyValue)lv.get(i + 1)).evalValue((Context)c, (Integer)t);
                return (cc, tt) -> ret;
            }
            if (lv.size() % 2 == 1) {
                Value ret = ((LazyValue)lv.get(lv.size() - 1)).evalValue((Context)c, (Integer)t);
                return (cc, tt) -> ret;
            }
            return (cc, tt) -> Value.NULL;
        });
        expression.addFunction("exit", lv -> {
            throw new ExitStatement(lv.size() == 0 ? Value.NULL : (Value)lv.get(0));
        });
        expression.addFunction("throw", lv -> {
            throw new ThrowStatement(lv.size() == 0 ? Value.NULL : (Value)lv.get(0));
        });
        expression.addLazyFunction("try", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'try' needs at least an expression block");
            }
            try {
                Value retval = ((LazyValue)lv.get(0)).evalValue((Context)c, (Integer)t);
                return (c_, t_) -> retval;
            }
            catch (ThrowStatement ret) {
                if (lv.size() == 1) {
                    return (c_, t_) -> Value.NULL;
                }
                LazyValue __ = c.getVariable("_");
                c.setVariable("_", (__c, __t) -> ret.retval.reboundedTo("_"));
                Value val = ((LazyValue)lv.get(1)).evalValue((Context)c, (Integer)t);
                c.setVariable("_", __);
                return (c_, t_) -> val;
            }
        });
    }
}

