/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.fakes.MinecraftServerInterface;
import carpet.fakes.StatTypeInterface;
import carpet.fakes.ThreadedAnvilChunkStorageInterface;
import carpet.helpers.FeatureGenerator;
import carpet.script.CarpetContext;
import carpet.script.CarpetScriptHost;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.argument.BlockArgument;
import carpet.script.argument.FunctionArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.InternalExpressionException;
import carpet.script.utils.ShapeDispatcher;
import carpet.script.utils.WorldTools;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import carpet.utils.Messenger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_151;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2379;
import net.minecraft.class_2394;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2596;
import net.minecraft.class_2660;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class Auxiliary {
    public static final String MARKER_STRING = "__scarpet_marker";
    private static final Map<String, class_3419> mixerMap = Arrays.stream(class_3419.values()).collect(Collectors.toMap(class_3419::method_14840, k -> k));

    public static String recognizeResource(Value value) {
        String origfile = value.getString();
        String file = origfile.toLowerCase(Locale.ROOT).replaceAll("[^A-Za-z0-9\\-+_/]", "");
        if ((file = Arrays.stream(file.split("/+")).filter(s -> !s.isEmpty()).collect(Collectors.joining("/"))).isEmpty()) {
            throw new InternalExpressionException("Cannot use " + origfile + " as resource name - must have some letters and numbers");
        }
        return file;
    }

    public static void apply(Expression expression) {
        expression.addLazyFunction("sound", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2960 soundName = new class_2960(((LazyValue)lv.get(0)).evalValue((Context)c).getString());
            Vector3Argument locator = Vector3Argument.findIn(cc, lv, 1);
            if (class_2378.field_11156.method_10223(soundName) == null) {
                throw new InternalExpressionException("No such sound: " + soundName.method_12832());
            }
            float volume = 1.0f;
            float pitch = 1.0f;
            class_3419 mixer = class_3419.field_15250;
            if (lv.size() > 0 + locator.offset) {
                volume = (float)NumericValue.asNumber(((LazyValue)lv.get(0 + locator.offset)).evalValue((Context)c)).getDouble();
                if (lv.size() > 1 + locator.offset) {
                    String mixerName;
                    pitch = (float)NumericValue.asNumber(((LazyValue)lv.get(1 + locator.offset)).evalValue((Context)c)).getDouble();
                    if (lv.size() > 2 + locator.offset && (mixer = mixerMap.get((mixerName = ((LazyValue)lv.get(2 + locator.offset)).evalValue((Context)c).getString()).toLowerCase(Locale.ROOT))) == null) {
                        throw new InternalExpressionException(mixerName + " is not a valid mixer name");
                    }
                }
            }
            class_243 vec = locator.vec;
            double d0 = Math.pow(volume > 1.0f ? (double)(volume * 16.0f) : 16.0, 2.0);
            int count = 0;
            for (class_3222 player : cc.s.method_9225().method_18766(p -> p.method_5707(vec) < d0)) {
                ++count;
                player.field_13987.method_14364((class_2596)new class_2660(soundName, mixer, vec, volume, pitch));
            }
            int totalPlayed = count;
            return (_c, _t) -> new NumericValue(totalPlayed);
        });
        expression.addLazyFunction("particle", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            MinecraftServer ms = cc.s.method_9211();
            class_3218 world = cc.s.method_9225();
            Vector3Argument locator = Vector3Argument.findIn(cc, lv, 1);
            String particleName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            int count = 10;
            double speed = 0.0;
            float spread = 0.5f;
            class_3222 player = null;
            if (lv.size() > locator.offset) {
                count = (int)NumericValue.asNumber(((LazyValue)lv.get(locator.offset)).evalValue((Context)c)).getLong();
                if (lv.size() > 1 + locator.offset) {
                    spread = (float)NumericValue.asNumber(((LazyValue)lv.get(1 + locator.offset)).evalValue((Context)c)).getDouble();
                    if (lv.size() > 2 + locator.offset) {
                        speed = NumericValue.asNumber(((LazyValue)lv.get(2 + locator.offset)).evalValue((Context)c)).getDouble();
                        if (lv.size() > 3 + locator.offset) {
                            player = ms.method_3760().method_14566(((LazyValue)lv.get(3 + locator.offset)).evalValue((Context)c).getString());
                        }
                    }
                }
            }
            class_2394 particle = ShapeDispatcher.getParticleData(particleName);
            class_243 vec = locator.vec;
            if (player == null) {
                for (class_1657 p : world.method_18456()) {
                    world.method_14166((class_3222)p, particle, true, vec.field_1352, vec.field_1351, vec.field_1350, count, (double)spread, (double)spread, (double)spread, speed);
                }
            } else {
                world.method_14166(player, particle, true, vec.field_1352, vec.field_1351, vec.field_1350, count, (double)spread, (double)spread, (double)spread, speed);
            }
            return (c_, t_) -> Value.TRUE;
        });
        expression.addLazyFunction("particle_line", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            String particleName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            class_2394 particle = ShapeDispatcher.getParticleData(particleName);
            Vector3Argument pos1 = Vector3Argument.findIn(cc, lv, 1);
            Vector3Argument pos2 = Vector3Argument.findIn(cc, lv, pos1.offset);
            double density = 1.0;
            class_3222 player = null;
            if (lv.size() > pos2.offset + 0) {
                density = NumericValue.asNumber(((LazyValue)lv.get(pos2.offset + 0)).evalValue((Context)c)).getDouble();
                if (density <= 0.0) {
                    throw new InternalExpressionException("Particle density should be positive");
                }
                if (lv.size() > pos2.offset + 1) {
                    Value playerValue = ((LazyValue)lv.get(pos2.offset + 1)).evalValue((Context)c);
                    if (playerValue instanceof EntityValue) {
                        class_1297 e = ((EntityValue)playerValue).getEntity();
                        if (!(e instanceof class_3222)) {
                            throw new InternalExpressionException("'particle_line' player argument has to be a player");
                        }
                        player = (class_3222)e;
                    } else {
                        player = cc.s.method_9211().method_3760().method_14566(playerValue.getString());
                    }
                }
            }
            NumericValue retval = new NumericValue(ShapeDispatcher.drawParticleLine(player == null ? world.method_18456() : Collections.singletonList(player), particle, pos1.vec, pos2.vec, density));
            return (c_, t_) -> retval;
        });
        expression.addLazyFunction("particle_box", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            String particleName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            class_2394 particle = ShapeDispatcher.getParticleData(particleName);
            Vector3Argument pos1 = Vector3Argument.findIn(cc, lv, 1);
            Vector3Argument pos2 = Vector3Argument.findIn(cc, lv, pos1.offset);
            double density = 1.0;
            class_3222 player = null;
            if (lv.size() > pos2.offset + 0) {
                density = NumericValue.asNumber(((LazyValue)lv.get(pos2.offset + 0)).evalValue((Context)c)).getDouble();
                if (density <= 0.0) {
                    throw new InternalExpressionException("Particle density should be positive");
                }
                if (lv.size() > pos2.offset + 1) {
                    Value playerValue = ((LazyValue)lv.get(pos2.offset + 1)).evalValue((Context)c);
                    if (playerValue instanceof EntityValue) {
                        class_1297 e = ((EntityValue)playerValue).getEntity();
                        if (!(e instanceof class_3222)) {
                            throw new InternalExpressionException("'particle_box' player argument has to be a player");
                        }
                        player = (class_3222)e;
                    } else {
                        player = cc.s.method_9211().method_3760().method_14566(playerValue.getString());
                    }
                }
            }
            class_243 a = pos1.vec;
            class_243 b = pos2.vec;
            class_243 from = new class_243(Math.min(a.field_1352, b.field_1352), Math.min(a.field_1351, b.field_1351), Math.min(a.field_1350, b.field_1350));
            class_243 to = new class_243(Math.max(a.field_1352, b.field_1352), Math.max(a.field_1351, b.field_1351), Math.max(a.field_1350, b.field_1350));
            int particleCount = ShapeDispatcher.Box.particleMesh(player == null ? world.method_18456() : Collections.singletonList(player), particle, density, from, to);
            return (c_, t_) -> new NumericValue(particleCount);
        });
        expression.alias("particle_rect", "particle_box");
        expression.addLazyFunction("draw_shape", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3222[] player = new class_3222[]{null};
            ArrayList<Pair<ShapeDispatcher.ExpiringShape, Map<String, Value>>> shapes = new ArrayList<Pair<ShapeDispatcher.ExpiringShape, Map<String, Value>>>();
            if (lv.size() == 1) {
                Value specLoad = ((LazyValue)lv.get(0)).evalValue((Context)c);
                if (!(specLoad instanceof ListValue)) {
                    throw new InternalExpressionException("In bulk mode - shapes need to be provided as a list of shape specs");
                }
                for (Value list : ((ListValue)specLoad).getItems()) {
                    if (!(list instanceof ListValue)) {
                        throw new InternalExpressionException("In bulk mode - shapes need to be provided as a list of shape specs");
                    }
                    shapes.add(ShapeDispatcher.fromFunctionArgs(cc, ((ListValue)list).getItems(), player));
                }
            } else {
                ArrayList<Value> params = new ArrayList<Value>();
                for (LazyValue v : lv) {
                    params.add(v.evalValue((Context)c));
                }
                shapes.add(ShapeDispatcher.fromFunctionArgs(cc, params, player));
            }
            ShapeDispatcher.sendShape(player[0] == null ? cc.s.method_9225().method_18456() : Collections.singletonList(player[0]), shapes);
            return LazyValue.TRUE;
        });
        expression.addLazyFunction("create_marker", -1, (c, t, lv) -> {
            Vector3Argument pointLocator;
            String name;
            CarpetContext cc = (CarpetContext)c;
            class_2680 targetBlock = null;
            boolean interactable = true;
            try {
                Value nameValue = ((LazyValue)lv.get(0)).evalValue((Context)c);
                name = nameValue instanceof NullValue ? "" : nameValue.getString();
                pointLocator = Vector3Argument.findIn(cc, lv, 1, true);
                if (lv.size() > pointLocator.offset) {
                    BlockArgument blockLocator = BlockArgument.findIn(cc, lv, pointLocator.offset, true, true);
                    if (blockLocator.block != null) {
                        targetBlock = blockLocator.block.getBlockState();
                    }
                    if (lv.size() > blockLocator.offset) {
                        interactable = ((LazyValue)lv.get(blockLocator.offset)).evalValue((Context)c, 2).getBoolean();
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new InternalExpressionException("'create_marker' requires a name and three coordinates, with optional direction, and optional block on its head");
            }
            class_1531 armorstand = new class_1531(class_1299.field_6131, (class_1937)cc.s.method_9225());
            double yoffset = targetBlock == null && name.isEmpty() ? 0.0 : (!interactable && targetBlock == null ? -0.41 : (targetBlock == null ? (double)(-armorstand.method_17682()) - 0.41 : (double)(-armorstand.method_17682()) + 0.3));
            armorstand.method_5808(pointLocator.vec.field_1352, pointLocator.vec.field_1351 + yoffset, pointLocator.vec.field_1350, (float)pointLocator.yaw, (float)pointLocator.pitch);
            armorstand.method_5780("__scarpet_marker_" + (cc.host.getName() == null ? "" : cc.host.getName()));
            armorstand.method_5780(MARKER_STRING);
            if (targetBlock != null) {
                armorstand.method_5673(class_1304.field_6169, new class_1799((class_1935)targetBlock.method_26204().method_8389()));
            }
            if (!name.isEmpty()) {
                armorstand.method_5665((class_2561)new class_2585(name));
                armorstand.method_5880(true);
            }
            armorstand.method_6919(new class_2379((float)((int)pointLocator.pitch), 0.0f, 0.0f));
            armorstand.method_5875(true);
            armorstand.method_5648(true);
            armorstand.method_5684(true);
            armorstand.method_5841().method_12778(class_1531.field_7107, (Object)((byte)(interactable ? 8 : 24)));
            cc.s.method_9225().method_8649((class_1297)armorstand);
            EntityValue result = new EntityValue((class_1297)armorstand);
            return (_c, _t) -> result;
        });
        expression.addLazyFunction("remove_all_markers", 0, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            int total = 0;
            String markerName = "__scarpet_marker_" + (cc.host.getName() == null ? "" : cc.host.getName());
            for (class_1297 e : cc.s.method_9225().method_18198(class_1299.field_6131, as -> as.method_5752().contains(markerName))) {
                ++total;
                e.method_5650();
            }
            int finalTotal = total;
            return (_cc, _tt) -> new NumericValue(finalTotal);
        });
        expression.addLazyFunction("nbt", 1, (c, t, lv) -> {
            Value ret = NBTSerializableValue.fromValue(((LazyValue)lv.get(0)).evalValue((Context)c));
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("escape_nbt", 1, (c, t, lv) -> {
            Value v = ((LazyValue)lv.get(0)).evalValue((Context)c);
            String string = v.getString();
            StringValue ret = new StringValue(class_2519.method_10706((String)string));
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("parse_nbt", 1, (c, t, lv) -> {
            Value v = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (v instanceof NBTSerializableValue) {
                Value parsed = ((NBTSerializableValue)v).toValue();
                return (cc, tt) -> parsed;
            }
            NBTSerializableValue ret = NBTSerializableValue.parseString(v.getString());
            if (ret == null) {
                return LazyValue.NULL;
            }
            Value parsed = ret.toValue();
            return (cc, tt) -> parsed;
        });
        expression.addLazyFunction("encode_nbt", -1, (c, t, lv) -> {
            class_2520 tag;
            int argSize = lv.size();
            if (argSize == 0 || argSize > 2) {
                throw new InternalExpressionException("'encode_nbt' requires 1 or 2 parameters");
            }
            Value v = ((LazyValue)lv.get(0)).evalValue((Context)c);
            boolean force = argSize > 1 && ((LazyValue)lv.get(1)).evalValue((Context)c).getBoolean();
            try {
                tag = v.toTag(force);
            }
            catch (NBTSerializableValue.IncompatibleTypeException ignored) {
                throw new InternalExpressionException("cannot reliably encode to a tag the value of '" + ignored.val.getPrettyString() + "'");
            }
            NBTSerializableValue tagValue = new NBTSerializableValue(tag);
            return (cc, tt) -> tagValue;
        });
        expression.addLazyFunction("print", -1, (c, t, lv) -> {
            if (lv.size() == 0 || lv.size() > 2) {
                throw new InternalExpressionException("'print' takes one or two arguments");
            }
            class_2168 s = ((CarpetContext)c).s;
            Value res = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (lv.size() == 2) {
                class_3222 player = EntityValue.getPlayerByValue(s.method_9211(), res);
                s = player.method_5671();
                res = ((LazyValue)lv.get(1)).evalValue((Context)c);
            }
            if (res instanceof FormattedTextValue) {
                s.method_9226(((FormattedTextValue)res).getText(), false);
            } else if (s.method_9228() instanceof class_1657) {
                Messenger.m((class_1657)s.method_9228(), "w " + res.getString());
            } else {
                Messenger.m(s, "w " + res.getString());
            }
            Value finalRes = res;
            return (_c, _t) -> finalRes;
        });
        expression.addLazyFunction("format", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'format' requires at least one component");
            }
            List<Object> values = lv.stream().map(lazy -> lazy.evalValue((Context)c)).collect(Collectors.toList());
            if (values.get(0) instanceof ListValue && values.size() == 1) {
                values = ((ListValue)values.get(0)).getItems();
            }
            FormattedTextValue ret = new FormattedTextValue((class_2561)Messenger.c(values.stream().map(Value::getString).toArray()));
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("run", 1, (c, t, lv) -> {
            class_2338 target = ((CarpetContext)c).origin;
            class_243 posf = new class_243((double)target.method_10263() + 0.5, (double)target.method_10264(), (double)target.method_10260() + 0.5);
            class_2168 s = ((CarpetContext)c).s;
            try {
                final Value[] error = new Value[]{Value.NULL};
                final ArrayList<Value> output = new ArrayList<Value>();
                NumericValue retval = new NumericValue(s.method_9211().method_3734().method_9249(new class_2168(class_2165.field_17395, posf, class_241.field_1340, s.method_9225(), CarpetSettings.runPermissionLevel, s.method_9214(), s.method_9223(), s.method_9211(), s.method_9228(), true, (ctx, succ, res) -> {}, class_2183.class_2184.field_9853){

                    public void method_9213(class_2561 message) {
                        error[0] = new FormattedTextValue(message);
                    }

                    public void method_9226(class_2561 message, boolean broadcastToOps) {
                        output.add(new FormattedTextValue(message));
                    }
                }, ((LazyValue)lv.get(0)).evalValue((Context)c).getString()));
                ListValue ret = ListValue.of(retval, ListValue.wrap(output), error[0]);
                return (c_, t_) -> ret;
            }
            catch (Exception exc) {
                ListValue ret = ListValue.of(Value.NULL, ListValue.of(new Value[0]), new FormattedTextValue((class_2561)new class_2585(exc.getMessage())));
                return (c_, t_) -> ret;
            }
        });
        expression.addLazyFunction("save", 0, (c, t, lv) -> {
            class_2168 s = ((CarpetContext)c).s;
            s.method_9211().method_3760().method_14617();
            s.method_9211().method_3723(true, true, true);
            s.method_9225().method_14178().method_12127(() -> true);
            CarpetSettings.LOG.warn("Saved chunks");
            return (cc, tt) -> Value.TRUE;
        });
        expression.addLazyFunction("tick_time", 0, (c, t, lv) -> {
            NumericValue time = new NumericValue(((CarpetContext)c).s.method_9211().method_3780());
            return (cc, tt) -> time;
        });
        expression.addLazyFunction("world_time", 0, (c, t, lv) -> {
            NumericValue time = new NumericValue(((CarpetContext)c).s.method_9225().method_8510());
            return (cc, tt) -> time;
        });
        expression.addLazyFunction("day_time", -1, (c, t, lv) -> {
            NumericValue time = new NumericValue(((CarpetContext)c).s.method_9225().method_8532());
            if (lv.size() > 0) {
                long newTime = NumericValue.asNumber(((LazyValue)lv.get(0)).evalValue((Context)c)).getLong();
                if (newTime < 0L) {
                    newTime = 0L;
                }
                ((CarpetContext)c).s.method_9225().method_29199(newTime);
            }
            return (cc, tt) -> time;
        });
        expression.addLazyFunction("last_tick_times", -1, (c, t, lv) -> {
            int currentReportedTick = ((CarpetContext)c).s.method_9211().method_3780() - 1;
            ArrayList<Value> ticks = new ArrayList<Value>(100);
            long[] tickArray = ((CarpetContext)c).s.method_9211().field_4573;
            for (int i = currentReportedTick + 100; i > currentReportedTick; --i) {
                ticks.add(new NumericValue((double)tickArray[i % 100] / 1000000.0));
            }
            ListValue ret = ListValue.wrap(ticks);
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("game_tick", -1, (c, t, lv) -> {
            long ms_total;
            long end_expected;
            long wait;
            class_2168 s = ((CarpetContext)c).s;
            if (!s.method_9211().method_18854()) {
                throw new InternalExpressionException("Unable to run ticks from threads");
            }
            ((MinecraftServerInterface)s.method_9211()).forceTick(() -> System.nanoTime() - CarpetServer.scriptServer.tickStart < 50000000L);
            if (lv.size() > 0 && (wait = (end_expected = CarpetServer.scriptServer.tickStart + (ms_total = NumericValue.asNumber(((LazyValue)lv.get(0)).evalValue((Context)c)).getLong()) * 1000000L) - System.nanoTime()) > 0L) {
                try {
                    Thread.sleep(wait / 1000000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            CarpetServer.scriptServer.tickStart = System.nanoTime();
            Thread.yield();
            if (CarpetServer.scriptServer.stopAll) {
                throw new ExitStatement(Value.NULL);
            }
            return (cc, tt) -> Value.TRUE;
        });
        expression.addLazyFunction("seed", -1, (c, t, lv) -> {
            class_2168 s = ((CarpetContext)c).s;
            NumericValue ret = new NumericValue(s.method_9225().method_8412());
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("relight", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_2338 pos = locator.block.getPos();
            class_3218 world = cc.s.method_9225();
            ((ThreadedAnvilChunkStorageInterface)world.method_14178().field_17254).relightChunk(new class_1923(pos));
            WorldTools.forceChunkUpdate(pos, world);
            return LazyValue.TRUE;
        });
        expression.addLazyFunction("current_dimension", 0, (c, t, lv) -> {
            class_2168 s = ((CarpetContext)c).s;
            Value retval = ValueConversions.of(s.method_9225());
            return (cc, tt) -> retval;
        });
        expression.addLazyFunction("view_distance", 0, (c, t, lv) -> {
            class_2168 s = ((CarpetContext)c).s;
            NumericValue retval = new NumericValue(s.method_9211().method_3760().method_14568());
            return (cc, tt) -> retval;
        });
        expression.addLazyFunction("in_dimension", 2, (c, t, lv) -> {
            class_2168 outerSource = ((CarpetContext)c).s;
            Value dimensionValue = ((LazyValue)lv.get(0)).evalValue((Context)c);
            class_1937 world = ValueConversions.dimFromValue(dimensionValue, outerSource.method_9211());
            if (world == outerSource.method_9225()) {
                return (LazyValue)lv.get(1);
            }
            class_2168 innerSource = outerSource.method_9227((class_3218)world);
            Context newCtx = c.recreate();
            ((CarpetContext)newCtx).s = innerSource;
            newCtx.variables = c.variables;
            Value retval = ((LazyValue)lv.get(1)).evalValue(newCtx);
            return (cc, tt) -> retval;
        });
        expression.addLazyFunction("plop", 4, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            if (lv.size() <= locator.offset) {
                throw new InternalExpressionException("'plop' needs extra argument indicating what to plop");
            }
            String what = ((LazyValue)lv.get(locator.offset)).evalValue((Context)c).getString();
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).s.method_9211().method_19537(() -> {
                Boolean res = FeatureGenerator.plop(what, ((CarpetContext)c).s.method_9225(), locator.block.getPos());
                if (res == null) {
                    return;
                }
                if (what.equalsIgnoreCase("boulder")) {
                    WorldTools.forceChunkUpdate(locator.block.getPos(), ((CarpetContext)c).s.method_9225());
                }
                result[0] = new NumericValue(res);
            });
            Value ret = result[0];
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("schedule", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'schedule' should have at least 2 arguments, delay and call name");
            }
            long delay = NumericValue.asNumber(((LazyValue)lv.get(0)).evalValue((Context)c)).getLong();
            FunctionArgument functionArgument = FunctionArgument.findIn(c, expression.module, lv, 1, true, false, true);
            CarpetServer.scriptServer.events.scheduleCall((CarpetContext)c, functionArgument.function, functionArgument.resolveArgs((Context)c, 0), delay);
            return (c_, t_) -> Value.TRUE;
        });
        expression.addLazyFunction("logger", -1, (c, t, lv) -> {
            Value res;
            if (lv.size() == 1) {
                res = ((LazyValue)lv.get(0)).evalValue((Context)c);
                CarpetSettings.LOG.info(res.getString());
            } else if (lv.size() == 2) {
                String level = ((LazyValue)lv.get(0)).evalValue((Context)c).getString().toLowerCase(Locale.ROOT);
                res = ((LazyValue)lv.get(1)).evalValue((Context)c);
                switch (level) {
                    case "error": {
                        CarpetSettings.LOG.error(res.getString());
                        break;
                    }
                    case "warn": {
                        CarpetSettings.LOG.warn(res.getString());
                        break;
                    }
                    case "debug": {
                        CarpetSettings.LOG.debug(res.getString());
                        break;
                    }
                    case "fatal": {
                        CarpetSettings.LOG.fatal(res.getString());
                        break;
                    }
                    case "info": {
                        CarpetSettings.LOG.info(res.getString());
                        break;
                    }
                    default: {
                        throw new InternalExpressionException("Unknown log level for 'logger': " + level);
                    }
                }
            } else {
                throw new InternalExpressionException("logger takes 1 or 2 arguments");
            }
            return (_c, _t) -> res;
        });
        expression.addLazyFunction("read_file", 2, (c, t, lv) -> {
            Value retVal;
            String type;
            String resource = Auxiliary.recognizeResource(((LazyValue)lv.get(0)).evalValue((Context)c));
            String origtype = ((LazyValue)lv.get(1)).evalValue((Context)c).getString().toLowerCase(Locale.ROOT);
            boolean shared = origtype.startsWith("shared_");
            String string = type = shared ? origtype.substring(7) : origtype;
            if (!(type.equals("raw") || type.equals("text") || type.equals("nbt"))) {
                throw new InternalExpressionException("Unsupported file type: " + origtype);
            }
            if (type.equals("nbt")) {
                class_2520 state = ((CarpetScriptHost)((CarpetContext)c).host).readFileTag(resource, shared);
                if (state == null) {
                    return LazyValue.NULL;
                }
                retVal = new NBTSerializableValue(state);
            } else {
                List<String> content = ((CarpetScriptHost)((CarpetContext)c).host).readTextResource(resource, shared);
                if (content == null) {
                    return LazyValue.NULL;
                }
                retVal = ListValue.wrap(content.stream().map(StringValue::new).collect(Collectors.toList()));
            }
            return (cc, tt) -> retVal;
        });
        expression.addLazyFunction("delete_file", 2, (c, t, lv) -> {
            String type;
            String resource = Auxiliary.recognizeResource(((LazyValue)lv.get(0)).evalValue((Context)c));
            String origtype = ((LazyValue)lv.get(1)).evalValue((Context)c).getString().toLowerCase(Locale.ROOT);
            boolean shared = origtype.startsWith("shared_");
            String string = type = shared ? origtype.substring(7) : origtype;
            if (!(type.equals("raw") || type.equals("text") || type.equals("nbt"))) {
                throw new InternalExpressionException("Unsupported file type: " + origtype);
            }
            boolean success = ((CarpetScriptHost)((CarpetContext)c).host).removeResourceFile(resource, shared, type);
            return success ? LazyValue.TRUE : LazyValue.FALSE;
        });
        expression.addLazyFunction("write_file", -1, (c, t, lv) -> {
            boolean success;
            String type;
            if (lv.size() < 3) {
                throw new InternalExpressionException("'write_file' requires three or more arguments");
            }
            String resource = Auxiliary.recognizeResource(((LazyValue)lv.get(0)).evalValue((Context)c));
            String origtype = ((LazyValue)lv.get(1)).evalValue((Context)c).getString().toLowerCase(Locale.ROOT);
            boolean shared = origtype.startsWith("shared_");
            String string = type = shared ? origtype.substring(7) : origtype;
            if (!(type.equals("raw") || type.equals("text") || type.equals("nbt"))) {
                throw new InternalExpressionException("Unsupported file type: " + origtype);
            }
            if (type.equals("nbt")) {
                Value val = ((LazyValue)lv.get(2)).evalValue((Context)c);
                NBTSerializableValue tagValue = val instanceof NBTSerializableValue ? (NBTSerializableValue)val : new NBTSerializableValue(val.getString());
                class_2520 tag = tagValue.getTag();
                success = ((CarpetScriptHost)((CarpetContext)c).host).writeTagFile(tag, resource, shared);
            } else {
                ArrayList<String> data = new ArrayList<String>();
                if (lv.size() == 3) {
                    Value val = ((LazyValue)lv.get(2)).evalValue((Context)c);
                    if (val instanceof ListValue) {
                        List<Value> lval = ((ListValue)val).getItems();
                        lval.forEach(v -> data.add(v.getString()));
                    } else {
                        data.add(val.getString());
                    }
                } else {
                    for (int i = 2; i < lv.size(); ++i) {
                        data.add(((LazyValue)lv.get(i)).evalValue((Context)c).getString());
                    }
                }
                success = ((CarpetScriptHost)((CarpetContext)c).host).appendLogFile(resource, shared, type, data);
            }
            return success ? LazyValue.TRUE : LazyValue.FALSE;
        });
        expression.addLazyFunction("load_app_data", -1, (c, t, lv) -> {
            class_2520 state;
            String file = null;
            boolean shared = false;
            if (lv.size() > 0) {
                file = Auxiliary.recognizeResource(((LazyValue)lv.get(0)).evalValue((Context)c));
                if (lv.size() > 1) {
                    shared = ((LazyValue)lv.get(1)).evalValue((Context)c).getBoolean();
                }
            }
            if ((state = ((CarpetScriptHost)((CarpetContext)c).host).readFileTag(file, shared)) == null) {
                return (cc, tt) -> Value.NULL;
            }
            NBTSerializableValue retVal = new NBTSerializableValue(state);
            return (cc, tt) -> retVal;
        });
        expression.addLazyFunction("store_app_data", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'store_app_data' needs NBT tag and an optional file");
            }
            Value val = ((LazyValue)lv.get(0)).evalValue((Context)c);
            String file = null;
            boolean shared = false;
            if (lv.size() > 1) {
                file = Auxiliary.recognizeResource(((LazyValue)lv.get(1)).evalValue((Context)c));
                if (lv.size() > 2) {
                    shared = ((LazyValue)lv.get(2)).evalValue((Context)c).getBoolean();
                }
            }
            NBTSerializableValue tagValue = val instanceof NBTSerializableValue ? (NBTSerializableValue)val : new NBTSerializableValue(val.getString());
            class_2520 tag = tagValue.getTag();
            boolean success = ((CarpetScriptHost)((CarpetContext)c).host).writeTagFile(tag, file, shared);
            return success ? LazyValue.TRUE : LazyValue.FALSE;
        });
        expression.addLazyFunction("statistic", 3, (c, t, lv) -> {
            class_2960 statName;
            class_2960 category;
            Value playerValue = ((LazyValue)lv.get(0)).evalValue((Context)c);
            CarpetContext cc = (CarpetContext)c;
            class_3222 player = EntityValue.getPlayerByValue(cc.s.method_9211(), playerValue);
            if (player == null) {
                return LazyValue.NULL;
            }
            try {
                category = new class_2960(((LazyValue)lv.get(1)).evalValue((Context)c).getString());
                statName = new class_2960(((LazyValue)lv.get(2)).evalValue((Context)c).getString());
            }
            catch (class_151 e) {
                return LazyValue.NULL;
            }
            class_3448 type = (class_3448)class_2378.field_11152.method_10223(category);
            if (type == null) {
                return LazyValue.NULL;
            }
            class_3445 stat = Auxiliary.getStat(type, statName);
            if (stat == null) {
                return LazyValue.NULL;
            }
            return (_c, _t) -> new NumericValue(player.method_14248().method_15025(stat));
        });
    }

    private static <T> class_3445<T> getStat(class_3448<T> type, class_2960 id) {
        Object key = type.method_14959().method_10223(id);
        if (key == null || !((StatTypeInterface)type).hasStatCreated(key)) {
            return null;
        }
        return type.method_14956(key);
    }
}

