/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.Tokenizer;
import carpet.script.exception.ExpressionException;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.List;

public abstract class Fluff {

    public static abstract class AbstractUnaryOperator
    extends AbstractOperator {
        AbstractUnaryOperator(int precedence, boolean leftAssoc) {
            super(precedence, leftAssoc);
        }

        @Override
        public LazyValue lazyEval(Context cc, Integer type, Expression e, Tokenizer.Token t, LazyValue v1, LazyValue v2) {
            try {
                if (v2 != null) {
                    throw new ExpressionException(cc, e, t, "Did not expect a second parameter for unary operator");
                }
                return (c, ignored_type) -> this.evalUnary(v1.evalValue(c));
            }
            catch (RuntimeException exc) {
                throw Expression.handleCodeException(cc, exc, e, t);
            }
        }

        @Override
        public Value eval(Value v1, Value v2) {
            throw new RuntimeException("Shouldn't end up here");
        }

        public abstract Value evalUnary(Value var1);
    }

    public static abstract class AbstractOperator
    extends AbstractLazyOperator
    implements IOperator {
        AbstractOperator(int precedence, boolean leftAssoc) {
            super(precedence, leftAssoc);
        }

        @Override
        public LazyValue lazyEval(Context cc, Integer type, Expression e, Tokenizer.Token t, LazyValue v1, LazyValue v2) {
            try {
                return (c, type_ignored) -> this.eval(v1.evalValue(c), v2.evalValue(c));
            }
            catch (RuntimeException exc) {
                throw Expression.handleCodeException(cc, exc, e, t);
            }
        }
    }

    public static abstract class AbstractLazyOperator
    implements ILazyOperator {
        int precedence;
        boolean leftAssoc;

        AbstractLazyOperator(int precedence, boolean leftAssoc) {
            this.precedence = precedence;
            this.leftAssoc = leftAssoc;
        }

        @Override
        public int getPrecedence() {
            return this.precedence;
        }

        @Override
        public boolean isLeftAssoc() {
            return this.leftAssoc;
        }
    }

    public static abstract class AbstractFunction
    extends AbstractLazyFunction
    implements IFunction {
        AbstractFunction(int numParams) {
            super(numParams);
        }

        @Override
        public LazyValue lazyEval(Context cc, Integer type, Expression e, Tokenizer.Token t, final List<LazyValue> lazyParams) {
            try {
                return new LazyValue(){
                    private List<Value> params;

                    @Override
                    public Value evalValue(Context c, Integer type) {
                        return this.eval(this.getParams(c));
                    }

                    private List<Value> getParams(Context c) {
                        if (this.params == null) {
                            this.params = new ArrayList<Value>();
                            for (LazyValue lazyParam : lazyParams) {
                                this.params.add(lazyParam.evalValue(c));
                            }
                        }
                        return this.params;
                    }
                };
            }
            catch (RuntimeException exc) {
                throw Expression.handleCodeException(cc, exc, e, t);
            }
        }
    }

    public static abstract class AbstractLazyFunction
    implements ILazyFunction {
        protected String name;
        int numParams;

        AbstractLazyFunction(int numParams) {
            this.numParams = numParams;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int getNumParams() {
            return this.numParams;
        }

        @Override
        public boolean numParamsVaries() {
            return this.numParams < 0;
        }
    }

    public static interface IOperator
    extends ILazyOperator {
        public Value eval(Value var1, Value var2);
    }

    public static interface ILazyOperator {
        public int getPrecedence();

        public boolean isLeftAssoc();

        public LazyValue lazyEval(Context var1, Integer var2, Expression var3, Tokenizer.Token var4, LazyValue var5, LazyValue var6);
    }

    public static interface IFunction
    extends ILazyFunction {
        public Value eval(List<Value> var1);
    }

    public static interface ILazyFunction {
        public int getNumParams();

        public boolean numParamsVaries();

        public LazyValue lazyEval(Context var1, Integer var2, Expression var3, Tokenizer.Token var4, List<LazyValue> var5);
    }

    @FunctionalInterface
    public static interface SexFunction<A, B, C, D, E, F, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6);
    }

    @FunctionalInterface
    public static interface QuinnFunction<A, B, C, D, E, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5);
    }

    @FunctionalInterface
    public static interface QuadFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface QuadConsumer<A, B, C, D> {
        public void accept(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

