/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.utils.Messenger;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2554;
import net.minecraft.class_2588;
import net.minecraft.server.MinecraftServer;

public class HopperCounter {
    public static final Map<class_1767, HopperCounter> COUNTERS;
    public final class_1767 color;
    private final Object2LongMap<class_1792> counter = new Object2LongLinkedOpenHashMap();
    private long startTick;
    private long startMillis;

    private HopperCounter(class_1767 color) {
        this.color = color;
    }

    public void add(MinecraftServer server, class_1799 stack) {
        if (this.startTick == 0L) {
            this.startTick = server.method_3847(class_1937.field_25179).method_8510();
            this.startMillis = System.currentTimeMillis();
        }
        class_1792 item = stack.method_7909();
        this.counter.put((Object)item, this.counter.getLong((Object)item) + (long)stack.method_7947());
    }

    public void reset(MinecraftServer server) {
        this.counter.clear();
        this.startTick = server.method_3847(class_1937.field_25179).method_8510();
        this.startMillis = System.currentTimeMillis();
    }

    public static void resetAll(MinecraftServer server) {
        for (HopperCounter counter : COUNTERS.values()) {
            counter.reset(server);
        }
    }

    public static List<class_2554> formatAll(MinecraftServer server, boolean realtime) {
        ArrayList<class_2554> text = new ArrayList<class_2554>();
        for (HopperCounter counter : COUNTERS.values()) {
            List<class_2554> temp = counter.format(server, realtime, false);
            if (temp.size() <= 1) continue;
            if (!text.isEmpty()) {
                text.add(Messenger.s(""));
            }
            text.addAll(temp);
        }
        if (text.isEmpty()) {
            text.add(Messenger.s("No items have been counted yet."));
        }
        return text;
    }

    public List<class_2554> format(MinecraftServer server, boolean realTime, boolean brief) {
        if (this.counter.isEmpty()) {
            if (brief) {
                return Collections.singletonList(Messenger.c("g " + this.color + ": -, -/h, - min "));
            }
            return Collections.singletonList(Messenger.s(String.format("No items for %s yet", this.color.method_7792())));
        }
        long total = this.getTotalItems();
        long ticks = Math.max(realTime ? (System.currentTimeMillis() - this.startMillis) / 50L : server.method_3847(class_1937.field_25179).method_8510() - this.startTick, 1L);
        if (total == 0L) {
            if (brief) {
                return Collections.singletonList(Messenger.c(String.format("c %s: 0, 0/h, %.1f min ", this.color, (double)ticks / 1200.0)));
            }
            return Collections.singletonList(Messenger.c(String.format("w No items for %s yet (%.2f min.%s)", this.color.method_7792(), (double)ticks / 1200.0, realTime ? " - real time" : ""), "nb  [X]", "^g reset", "!/counter " + this.color.method_7792() + " reset"));
        }
        if (brief) {
            return Collections.singletonList(Messenger.c(String.format("c %s: %d, %d/h, %.1f min ", this.color.method_7792(), total, total * 72000L / ticks, (double)ticks / 1200.0)));
        }
        ArrayList<class_2554> items = new ArrayList<class_2554>();
        items.add(Messenger.c(String.format("w Items for %s (%.2f min.%s), total: %d, (%.1f/h):", this.color, (double)ticks * 1.0 / 1200.0, realTime ? " - real time" : "", total, (double)total * 1.0 * 72000.0 / (double)ticks), "nb [X]", "^g reset", "!/counter " + this.color + " reset"));
        items.addAll(this.counter.object2LongEntrySet().stream().sorted((e, f) -> Long.compare(f.getLongValue(), e.getLongValue())).map(e -> {
            class_2588 itemName = new class_2588(((class_1792)e.getKey()).method_7876());
            long count = e.getLongValue();
            return Messenger.c("w - ", itemName, String.format("w : %d, %.1f/h", count, (double)count * 72000.0 / (double)ticks));
        }).collect(Collectors.toList()));
        return items;
    }

    public static HopperCounter getCounter(String color) {
        try {
            class_1767 colorEnum = class_1767.valueOf((String)color.toUpperCase(Locale.ROOT));
            return COUNTERS.get(colorEnum);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public long getTotalItems() {
        return this.counter.values().stream().mapToLong(Long::longValue).sum();
    }

    static {
        EnumMap<class_1767, HopperCounter> counterMap = new EnumMap<class_1767, HopperCounter>(class_1767.class);
        for (class_1767 color : class_1767.values()) {
            counterMap.put(color, new HopperCounter(color));
        }
        COUNTERS = Maps.immutableEnumMap(counterMap);
    }
}

