/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.settings.SettingsManager;
import carpet.utils.BlockInfo;
import carpet.utils.EntityInfo;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2554;

public class InfoCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandInfo))).then(class_2170.method_9247((String)"block").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"block position", (ArgumentType)class_2262.method_9698()).executes(c -> InfoCommand.infoBlock((class_2168)c.getSource(), class_2262.method_9697((CommandContext)c, (String)"block position"), null))).then(class_2170.method_9247((String)"grep").then(class_2170.method_9244((String)"regexp", (ArgumentType)StringArgumentType.greedyString()).executes(c -> InfoCommand.infoBlock((class_2168)c.getSource(), class_2262.method_9697((CommandContext)c, (String)"block position"), StringArgumentType.getString((CommandContext)c, (String)"regexp")))))))).then(class_2170.method_9247((String)"entity").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity selector", (ArgumentType)class_2186.method_9306()).executes(c -> InfoCommand.infoEntities((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"entity selector"), null))).then(class_2170.method_9247((String)"grep").then(class_2170.method_9244((String)"regexp", (ArgumentType)StringArgumentType.greedyString()).executes(c -> InfoCommand.infoEntities((class_2168)c.getSource(), class_2186.method_9317((CommandContext)c, (String)"entity selector"), StringArgumentType.getString((CommandContext)c, (String)"regexp")))))));
        dispatcher.register(command);
    }

    public static void printEntity(List<class_2554> messages, class_2168 source, String grep) {
        List<Object> actual = new ArrayList();
        if (grep != null) {
            Pattern p = Pattern.compile(grep);
            actual.add(messages.get(0));
            boolean empty = true;
            for (int i = 1; i < messages.size(); ++i) {
                class_2554 line = messages.get(i);
                Matcher m = p.matcher(line.getString());
                if (!m.find()) continue;
                empty = false;
                actual.add(line);
            }
            if (empty) {
                return;
            }
        } else {
            actual = messages;
        }
        Messenger.m(source, "");
        Messenger.send(source, actual);
    }

    public static void printBlock(List<class_2554> messages, class_2168 source, String grep) {
        Messenger.m(source, "");
        if (grep != null) {
            Pattern p = Pattern.compile(grep);
            Messenger.m(source, messages.get(0));
            for (int i = 1; i < messages.size(); ++i) {
                class_2554 line = messages.get(i);
                Matcher m = p.matcher(line.getString());
                if (!m.find()) continue;
                Messenger.m(source, line);
            }
        } else {
            Messenger.send(source, messages);
        }
    }

    private static int infoEntities(class_2168 source, Collection<? extends class_1297> entities, String grep) {
        for (class_1297 class_12972 : entities) {
            List<class_2554> report = EntityInfo.entityInfo(class_12972, (class_1937)source.method_9225());
            InfoCommand.printEntity(report, source, grep);
        }
        return 1;
    }

    private static int infoBlock(class_2168 source, class_2338 pos, String grep) {
        InfoCommand.printBlock(BlockInfo.blockInfo(pos, source.method_9225()), source, grep);
        return 1;
    }
}

