/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.gui.DescriptionListWidget;
import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListWidget;
import io.github.prospector.modmenu.gui.ModMenuTexturedButtonWidget;
import io.github.prospector.modmenu.util.BadgeRenderer;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_407;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModsScreen
extends class_437 {
    private static final class_2960 FILTERS_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/filters_button.png");
    private static final class_2960 CONFIGURE_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/configure_button.png");
    private static final class_2588 TOGGLE_FILTER_OPTIONS = new class_2588("modmenu.toggleFilterOptions");
    private static final class_2588 CONFIGURE = new class_2588("modmenu.configure");
    private static final class_2561 DROP = new class_2588("modmenu.dropInfo").method_27692(class_124.field_1080);
    private static final Logger LOGGER = LogManager.getLogger();
    private class_342 searchBox;
    private DescriptionListWidget descriptionListWidget;
    private final class_437 previousScreen;
    private ModListWidget modList;
    private class_2561 tooltip;
    private ModListEntry selected;
    private BadgeRenderer badgeRenderer;
    private double scrollPercent = 0.0;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public final Set<String> showModChildren = new HashSet<String>();

    public ModsScreen(class_437 previousScreen) {
        super((class_2561)new class_2588("modmenu.title"));
        this.previousScreen = previousScreen;
    }

    public boolean method_25401(double double_1, double double_2, double double_3) {
        if (this.modList.method_25405(double_1, double_2)) {
            return this.modList.method_25401(double_1, double_2, double_3);
        }
        if (this.descriptionListWidget.method_25405(double_1, double_2)) {
            return this.descriptionListWidget.method_25401(double_1, double_2, double_3);
        }
        return false;
    }

    public void method_25393() {
        this.searchBox.method_1865();
    }

    protected void method_25426() {
        Objects.requireNonNull(this.field_22787).field_1774.method_1462(true);
        this.paneY = 48;
        this.paneWidth = this.field_22789 / 2 - 8;
        this.rightPaneX = this.field_22789 - this.paneWidth;
        int searchBoxWidth = this.paneWidth - 32 - 22;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - 11;
        this.searchBox = new class_342(this.field_22793, this.searchBoxX, 22, searchBoxWidth, 20, this.searchBox, (class_2561)new class_2588("modmenu.search"));
        this.searchBox.method_1863(string_1 -> this.modList.filter((String)string_1, false));
        this.modList = new ModListWidget(this.field_22787, this.paneWidth, this.field_22790, this.paneY + 19, this.field_22790 - 36, 36, this.searchBox.method_1882(), this.modList, this);
        this.modList.method_25333(0);
        this.field_22793.getClass();
        this.descriptionListWidget = new DescriptionListWidget(this.field_22787, this.paneWidth, this.field_22790, this.paneY + 60, this.field_22790 - 36, 9 + 1, this);
        this.descriptionListWidget.method_25333(this.rightPaneX);
        ModMenuTexturedButtonWidget configureButton = new ModMenuTexturedButtonWidget(this.field_22789 - 24, this.paneY, 20, 20, 0, 0, CONFIGURE_BUTTON_LOCATION, 32, 64, button -> {
            String modid = Objects.requireNonNull(this.selected).getMetadata().getId();
            class_437 screen = ModMenu.getConfigScreen(modid, this);
            if (screen != null) {
                this.field_22787.method_1507(screen);
            } else {
                ModMenu.openConfigScreen(modid);
            }
        }, (class_2561)CONFIGURE, (buttonWidget, matrices, mouseX, mouseY) -> {
            ModMenuTexturedButtonWidget button = (ModMenuTexturedButtonWidget)buttonWidget;
            if (button.isJustHovered()) {
                this.method_25424(matrices, (class_2561)CONFIGURE, mouseX, mouseY);
            } else if (button.isFocusedButNotHovered()) {
                this.method_25424(matrices, (class_2561)CONFIGURE, button.field_22760, button.field_22761);
            }
        }){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                String modid;
                this.field_22763 = ModsScreen.this.selected != null ? ModMenu.hasConfigScreenFactory(modid = ModsScreen.this.selected.getMetadata().getId()) || ModMenu.hasLegacyConfigScreenTask(modid) : false;
                this.field_22764 = this.field_22763;
                super.method_25394(matrices, mouseX, mouseY, delta);
            }

            @Override
            public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.method_25359(matrices, mouseX, mouseY, delta);
            }
        };
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        class_4185 websiteButton = new class_4185(this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, Math.min(urlButtonWidths, 200), 20, (class_2561)new class_2588("modmenu.website"), button -> {
            ModMetadata metadata = Objects.requireNonNull(this.selected).getMetadata();
            this.field_22787.method_1507((class_437)new class_407(bool -> {
                if (bool) {
                    class_156.method_668().method_670((String)metadata.getContact().get("homepage").get());
                }
                this.field_22787.method_1507((class_437)this);
            }, (String)metadata.getContact().get("homepage").get(), true));
        }){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                this.field_22764 = ModsScreen.this.selected != null;
                this.field_22763 = this.field_22764 && ModsScreen.this.selected.getMetadata().getContact().get("homepage").isPresent();
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        };
        class_4185 issuesButton = new class_4185(this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, Math.min(urlButtonWidths, 200), 20, (class_2561)new class_2588("modmenu.issues"), button -> {
            ModMetadata metadata = Objects.requireNonNull(this.selected).getMetadata();
            this.field_22787.method_1507((class_437)new class_407(bool -> {
                if (bool) {
                    class_156.method_668().method_670((String)metadata.getContact().get("issues").get());
                }
                this.field_22787.method_1507((class_437)this);
            }, (String)metadata.getContact().get("issues").get(), true));
        }){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                this.field_22764 = ModsScreen.this.selected != null;
                this.field_22763 = this.field_22764 && ModsScreen.this.selected.getMetadata().getContact().get("issues").isPresent();
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        };
        this.field_22786.add(this.searchBox);
        this.method_25411((class_339)new ModMenuTexturedButtonWidget(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, FILTERS_BUTTON_LOCATION, 32, 64, button -> {
            this.filterOptionsShown = !this.filterOptionsShown;
        }, (class_2561)TOGGLE_FILTER_OPTIONS, (buttonWidget, matrices, mouseX, mouseY) -> {
            ModMenuTexturedButtonWidget button = (ModMenuTexturedButtonWidget)buttonWidget;
            if (button.isJustHovered()) {
                this.method_25424(matrices, (class_2561)TOGGLE_FILTER_OPTIONS, mouseX, mouseY);
            } else if (button.isFocusedButNotHovered()) {
                this.method_25424(matrices, (class_2561)TOGGLE_FILTER_OPTIONS, button.field_22760, button.field_22761);
            }
        }));
        class_2588 showLibrariesText = new class_2588("modmenu.showLibraries", new Object[]{new class_2588("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries())});
        class_2588 sortingText = new class_2588("modmenu.sorting", new Object[]{new class_2588(ModMenuConfigManager.getConfig().getSorting().getTranslationKey())});
        int showLibrariesWidth = this.field_22793.method_27525((class_5348)showLibrariesText) + 20;
        int sortingWidth = this.field_22793.method_27525((class_5348)sortingText) + 20;
        this.filtersWidth = showLibrariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX();
        this.method_25411((class_339)new class_4185(this.filtersX, 45, sortingWidth, 20, (class_2561)sortingText, button -> {
            ModMenuConfigManager.getConfig().toggleSortMode();
            this.modList.reloadFilters();
        }){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                matrices.method_22904(0.0, 0.0, 1.0);
                this.field_22764 = ModsScreen.this.filterOptionsShown;
                this.method_25355((class_2561)new class_2588("modmenu.sorting", new Object[]{new class_2588(ModMenuConfigManager.getConfig().getSorting().getTranslationKey())}));
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        });
        this.method_25411((class_339)new class_4185(this.filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, (class_2561)new class_2588("modmenu.showLibraries", new Object[]{new class_2588("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries())}), button -> {
            ModMenuConfigManager.getConfig().toggleShowLibraries();
            this.modList.reloadFilters();
        }){

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                matrices.method_22904(0.0, 0.0, 1.0);
                this.field_22764 = ModsScreen.this.filterOptionsShown;
                this.method_25355((class_2561)new class_2588("modmenu.showLibraries", new Object[]{new class_2588("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries())}));
                super.method_25394(matrices, mouseX, mouseY, delta);
            }
        });
        this.field_22786.add(this.modList);
        if (!ModMenuConfigManager.getConfig().isHidingConfigurationButtons()) {
            this.method_25411((class_339)configureButton);
        }
        this.method_25411((class_339)websiteButton);
        this.method_25411((class_339)issuesButton);
        this.field_22786.add(this.descriptionListWidget);
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20, (class_2561)new class_2588("modmenu.modsFolder"), button -> class_156.method_668().method_672(new File(FabricLoader.getInstance().getGameDirectory(), "mods"))));
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20, class_5244.field_24334, button -> this.field_22787.method_1507(this.previousScreen)));
        this.method_20085((class_364)this.searchBox);
        this.init = true;
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        return super.method_25404(int_1, int_2, int_3) || this.searchBox.method_25404(int_1, int_2, int_3);
    }

    public boolean method_25400(char char_1, int int_1) {
        return this.searchBox.method_25400(char_1, int_1);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.tooltip = null;
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.method_25394(matrices, mouseX, mouseY, delta);
        }
        this.modList.method_25394(matrices, mouseX, mouseY, delta);
        this.searchBox.method_25394(matrices, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        ModsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.modList.getWidth() / 2), (int)8, (int)0xFFFFFF);
        class_5250 class_52502 = new class_2588("modmenu.dropInfo.1").method_27692(class_124.field_1080);
        int n = this.field_22789 - this.modList.getWidth() / 2;
        int n2 = this.paneY / 2;
        this.field_22787.field_1772.getClass();
        ModsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_52502, (int)n, (int)(n2 - 9 - 1), (int)0xFFFFFF);
        ModsScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)new class_2588("modmenu.dropInfo.2").method_27692(class_124.field_1080), (int)(this.field_22789 - this.modList.getWidth() / 2), (int)(this.paneY / 2 + 1), (int)0xFFFFFF);
        class_2561 fullModCount = this.computeModCountText(true);
        if (this.updateFiltersX()) {
            if (this.filterOptionsShown) {
                if (!ModMenuConfigManager.getConfig().showLibraries() || this.field_22793.method_27525((class_5348)fullModCount) <= this.filtersX - 5) {
                    this.field_22793.method_27528(matrices, fullModCount.method_30937(), (float)this.searchBoxX, 52.0f, 0xFFFFFF);
                } else {
                    this.field_22793.method_27528(matrices, this.computeModCountText(false).method_30937(), (float)this.searchBoxX, 46.0f, 0xFFFFFF);
                    this.field_22793.method_27528(matrices, this.computeLibraryCountText().method_30937(), (float)this.searchBoxX, 57.0f, 0xFFFFFF);
                }
            } else if (!ModMenuConfigManager.getConfig().showLibraries() || this.field_22793.method_27525((class_5348)fullModCount) <= this.modList.getWidth() - 5) {
                this.field_22793.method_27528(matrices, fullModCount.method_30937(), (float)this.searchBoxX, 52.0f, 0xFFFFFF);
            } else {
                this.field_22793.method_27528(matrices, this.computeModCountText(false).method_30937(), (float)this.searchBoxX, 46.0f, 0xFFFFFF);
                this.field_22793.method_27528(matrices, this.computeLibraryCountText().method_30937(), (float)this.searchBoxX, 57.0f, 0xFFFFFF);
            }
        }
        if (selectedEntry != null) {
            ModMetadata metadata = selectedEntry.getMetadata();
            int x = this.rightPaneX;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.selected.bindIconTexture();
            RenderSystem.enableBlend();
            ModsScreen.method_25290((class_4587)matrices, (int)x, (int)this.paneY, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.disableBlend();
            this.field_22793.getClass();
            int lineSpacing = 9 + 1;
            int imageOffset = 36;
            class_2585 name = new class_2585(metadata.getName());
            class_2585 trimmedName = name = HardcodedUtil.formatFabricModuleName(name.method_10851());
            int maxNameWidth = this.field_22789 - (x + imageOffset);
            if (this.field_22793.method_27525((class_5348)name) > maxNameWidth) {
                class_5348 ellipsis = class_5348.method_29430((String)"...");
                trimmedName = class_5348.method_29433((class_5348[])new class_5348[]{this.field_22793.method_1714((class_5348)name, maxNameWidth - this.field_22793.method_27525(ellipsis)), ellipsis});
            }
            this.field_22793.method_27528(matrices, class_2477.method_10517().method_30934((class_5348)trimmedName), (float)(x + imageOffset), (float)(this.paneY + 1), 0xFFFFFF);
            if (mouseX > x + imageOffset && mouseY > this.paneY + 1) {
                this.field_22793.getClass();
                if (mouseY < this.paneY + 1 + 9 && mouseX < x + imageOffset + this.field_22793.method_27525((class_5348)trimmedName)) {
                    this.setTooltip((class_2561)new class_2588("modmenu.modIdToolTip", new Object[]{metadata.getId()}));
                }
            }
            if (this.init || this.badgeRenderer == null || this.badgeRenderer.getMetadata() != metadata) {
                this.badgeRenderer = new BadgeRenderer(x + imageOffset + Objects.requireNonNull(this.field_22787).field_1772.method_27525((class_5348)trimmedName) + 2, this.paneY, this.field_22789 - 28, selectedEntry.container, this);
                this.init = false;
            }
            this.badgeRenderer.draw(matrices, mouseX, mouseY);
            this.field_22793.method_1729(matrices, "v" + metadata.getVersion().getFriendlyString(), (float)(x + imageOffset), (float)(this.paneY + 2 + lineSpacing), 0x808080);
            ArrayList names = new ArrayList();
            metadata.getAuthors().stream().filter(Objects::nonNull).map(Person::getName).filter(Objects::nonNull).forEach(names::add);
            if (!names.isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : (String)names.get(0);
                RenderUtils.drawWrappedString(matrices, class_1074.method_4662((String)"modmenu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, this.paneY + 2 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.tooltip != null) {
            this.method_25417(matrices, this.field_22793.method_1728((class_5348)this.tooltip, Integer.MAX_VALUE), mouseX, mouseY);
        }
    }

    private class_2561 computeModCountText(boolean includeLibs) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_NONLIB_MODS);
        if (includeLibs && ModMenuConfigManager.getConfig().showLibraries()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_LIBRARIES);
            return ModsScreen.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
        }
        return ModsScreen.translateNumeric("modmenu.showingMods", new int[][]{rootMods});
    }

    private class_2561 computeLibraryCountText() {
        if (ModMenuConfigManager.getConfig().showLibraries()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_LIBRARIES);
            return ModsScreen.translateNumeric("modmenu.showingLibraries", new int[][]{rootLibs});
        }
        return new class_2585(null);
    }

    private static class_2561 translateNumeric(String key, int[] ... args) {
        Object[] realArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            NumberFormat nf = NumberFormat.getInstance();
            if (args[i].length == 1) {
                realArgs[i] = nf.format(args[i][0]);
                continue;
            }
            assert (args[i].length == 2);
            realArgs[i] = nf.format(args[i][0]) + "/" + nf.format(args[i][1]);
        }
        int[] override = new int[args.length];
        Arrays.fill(override, -1);
        for (int i = 0; i < args.length; ++i) {
            int[] arg = args[i];
            if (arg == null) {
                throw new NullPointerException("args[" + i + "]");
            }
            if (arg.length != 1) continue;
            override[i] = arg[0];
        }
        String lastKey = key;
        for (int flags = (1 << args.length) - 1; flags >= 0; --flags) {
            StringBuilder fullKey = new StringBuilder(key);
            for (int i = 0; i < args.length; ++i) {
                fullKey.append('.');
                if ((flags & 1 << i) != 0 && override[i] != -1) {
                    fullKey.append(override[i]);
                    continue;
                }
                fullKey.append('a');
            }
            lastKey = fullKey.toString();
            if (!class_1074.method_4663((String)lastKey)) continue;
            return new class_2588(lastKey, realArgs);
        }
        return new class_2588(lastKey, realArgs);
    }

    private int[] formatModCount(Set<String> set) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size())) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    public void method_25420(class_4587 matrices) {
        ModsScreen.overlayBackground(0, 0, this.field_22789, this.field_22790, 64, 64, 64, 255, 255);
    }

    static void overlayBackground(int x1, int y1, int x2, int y2, int red, int green, int blue, int startAlpha, int endAlpha) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        Objects.requireNonNull(class_310.method_1551()).method_1531().method_22813(class_332.field_22735);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_22912((double)x1, (double)y2, 0.0).method_22913((float)x1 / 32.0f, (float)y2 / 32.0f).method_1336(red, green, blue, endAlpha).method_1344();
        buffer.method_22912((double)x2, (double)y2, 0.0).method_22913((float)x2 / 32.0f, (float)y2 / 32.0f).method_1336(red, green, blue, endAlpha).method_1344();
        buffer.method_22912((double)x2, (double)y1, 0.0).method_22913((float)x2 / 32.0f, (float)y1 / 32.0f).method_1336(red, green, blue, startAlpha).method_1344();
        buffer.method_22912((double)x1, (double)y1, 0.0).method_22913((float)x1 / 32.0f, (float)y1 / 32.0f).method_1336(red, green, blue, startAlpha).method_1344();
        tessellator.method_1350();
    }

    public void method_25419() {
        super.method_25419();
        this.modList.close();
        this.field_22787.method_1507(this.previousScreen);
    }

    private void setTooltip(class_2561 tooltip) {
        this.tooltip = tooltip;
    }

    ModListEntry getSelectedEntry() {
        return this.selected;
    }

    void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
        }
    }

    double getScrollPercent() {
        return this.scrollPercent;
    }

    void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.method_1882();
    }

    private boolean updateFiltersX() {
        if (this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeModCountText(true)) + 20 >= this.searchRowWidth && (this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeModCountText(false)) + 20 >= this.searchRowWidth || this.filtersWidth + this.field_22793.method_27525((class_5348)this.computeLibraryCountText()) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }

    public void method_29638(List<Path> paths) {
        Path modsDirectory = FabricLoader.getInstance().getGameDir().resolve("mods");
        List mods = paths.stream().filter(ModsScreen::isFabricMod).collect(Collectors.toList());
        if (mods.isEmpty()) {
            return;
        }
        String modList = mods.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.field_22787.method_1507((class_437)new class_410(value -> {
            if (value) {
                boolean allSuccessful = true;
                for (Path path : mods) {
                    try {
                        Files.copy(path, modsDirectory.resolve(path.getFileName()), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to copy mod from {} to {}", (Object)path, (Object)modsDirectory.resolve(path.getFileName()));
                        class_370.method_29627((class_310)this.field_22787, (String)path.toString());
                        allSuccessful = false;
                        break;
                    }
                }
                if (allSuccessful) {
                    class_370.method_27024((class_374)this.field_22787.method_1566(), (class_370.class_371)class_370.class_371.field_2218, (class_2561)new class_2588("modmenu.dropSuccessful.line1"), (class_2561)new class_2588("modmenu.dropSuccessful.line2"));
                }
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)new class_2588("modmenu.dropConfirm"), (class_2561)new class_2585(modList)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isFabricMod(Path mod) {
        try (JarFile jarFile = new JarFile(mod.toFile());){
            boolean bl = jarFile.getEntry("fabric.mod.json") != null;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

