/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.IngredientBlacklistType;
import mezz.jei.config.KeyBindings;
import mezz.jei.events.EventBusHelper;
import mezz.jei.gui.Focus;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.LeftAreaDispatcher;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.GuiContainerWrapper;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseUtil;
import mezz.jei.util.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InputHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IIngredientManager ingredientManager;
    private final WeakReference<IngredientFilter> weakIngredientFilter;
    private final RecipesGui recipesGui;
    private final IngredientListOverlay ingredientListOverlay;
    private final IEditModeConfig editModeConfig;
    private final IWorldConfig worldConfig;
    private final GuiScreenHelper guiScreenHelper;
    private final LeftAreaDispatcher leftAreaDispatcher;
    private final BookmarkList bookmarkList;
    private final List<IShowsRecipeFocuses> showsRecipeFocuses = new ArrayList<IShowsRecipeFocuses>();
    private final IntSet clickHandled = new IntArraySet();

    public InputHandler(RecipesGui recipesGui, IngredientFilter ingredientFilter, IngredientManager ingredientManager, IngredientListOverlay ingredientListOverlay, IEditModeConfig editModeConfig, IWorldConfig worldConfig, GuiScreenHelper guiScreenHelper, LeftAreaDispatcher leftAreaDispatcher, BookmarkList bookmarkList) {
        this.ingredientManager = ingredientManager;
        this.weakIngredientFilter = new WeakReference<IngredientFilter>(ingredientFilter);
        this.recipesGui = recipesGui;
        this.ingredientListOverlay = ingredientListOverlay;
        this.editModeConfig = editModeConfig;
        this.worldConfig = worldConfig;
        this.guiScreenHelper = guiScreenHelper;
        this.leftAreaDispatcher = leftAreaDispatcher;
        this.bookmarkList = bookmarkList;
        this.showsRecipeFocuses.add(recipesGui);
        this.showsRecipeFocuses.add(ingredientListOverlay);
        this.showsRecipeFocuses.add(leftAreaDispatcher);
        this.showsRecipeFocuses.add(new GuiContainerWrapper(guiScreenHelper));
    }

    public void registerToEventBus() {
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.KeyboardKeyPressedEvent.Pre.class, InputHandler::onGuiKeyPressedEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.KeyboardCharTypedEvent.Pre.class, InputHandler::onGuiCharTypedEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.KeyboardKeyPressedEvent.Post.class, InputHandler::onGuiKeyboardEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.KeyboardCharTypedEvent.Post.class, InputHandler::onGuiCharTypedEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.MouseClickedEvent.Pre.class, InputHandler::onGuiMouseEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.MouseReleasedEvent.Pre.class, InputHandler::onGuiMouseEvent);
        EventBusHelper.registerWeakListener(this, GuiScreenEvent.MouseScrollEvent.Pre.class, InputHandler::onGuiMouseEvent);
    }

    public void onGuiKeyPressedEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (this.hasKeyboardFocus()) {
            this.handleKeyEvent(event.getKeyCode(), event.getScanCode(), event.getModifiers());
            event.setCanceled(true);
        }
    }

    public void onGuiCharTypedEvent(GuiScreenEvent.KeyboardCharTypedEvent.Pre event) {
        if (this.hasKeyboardFocus() && this.handleCharTyped(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Post event) {
        if (!this.hasKeyboardFocus() && this.handleKeyEvent(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    public void onGuiCharTypedEvent(GuiScreenEvent.KeyboardCharTypedEvent.Post event) {
        if (!this.hasKeyboardFocus() && this.handleCharTyped(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    public void onGuiMouseEvent(GuiScreenEvent.MouseClickedEvent.Pre event) {
        int mouseButton = event.getButton();
        if (mouseButton > -1 && !this.clickHandled.contains(mouseButton)) {
            this.clickHandled.add(mouseButton);
            if (this.handleMouseDrag(mouseButton, event.getMouseX(), event.getMouseY())) {
                event.setCanceled(true);
            }
        }
    }

    public void onGuiMouseEvent(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        int mouseButton = event.getButton();
        if (mouseButton > -1 && this.clickHandled.contains(mouseButton)) {
            this.clickHandled.remove(mouseButton);
            if (this.handleMouseClicked(event.getGui(), mouseButton, event.getMouseX(), event.getMouseY())) {
                event.setCanceled(true);
            }
        }
    }

    public void onGuiMouseEvent(GuiScreenEvent.MouseScrollEvent.Pre event) {
        double mouseY;
        double dWheel = event.getScrollDelta();
        double mouseX = event.getMouseX();
        if (this.ingredientListOverlay.handleMouseScrolled(mouseX, mouseY = event.getMouseY(), dWheel) || this.leftAreaDispatcher.handleMouseScrolled(mouseX, mouseY, dWheel)) {
            event.setCanceled(true);
        }
    }

    private boolean handleMouseDrag(int mouseButton, double mouseX, double mouseY) {
        return this.ingredientListOverlay.handleMouseDragStart(mouseX, mouseY, mouseButton);
    }

    private boolean handleMouseClicked(Screen guiScreen, int mouseButton, double mouseX, double mouseY) {
        ContainerScreen guiContainer;
        IGuiClickableArea clickableArea;
        IClickedIngredient<?> clicked = this.getFocusUnderMouseForClick(mouseX, mouseY);
        if (this.worldConfig.isEditModeEnabled() && clicked != null && this.handleClickEdit(clicked)) {
            return true;
        }
        if (this.ingredientListOverlay.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.leftAreaDispatcher.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (clicked != null && this.handleMouseClickedFocus(mouseButton, clicked)) {
            return true;
        }
        InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(mouseButton);
        if (this.handleFocusKeybinds(input)) {
            return true;
        }
        if (guiScreen instanceof ContainerScreen && (clickableArea = this.guiScreenHelper.getGuiClickableArea(guiContainer = (ContainerScreen)guiScreen, mouseX - (double)guiContainer.getGuiLeft(), mouseY - (double)guiContainer.getGuiTop())) != null) {
            clickableArea.onClick(Focus::new, this.recipesGui);
            return true;
        }
        return this.handleGlobalKeybinds(input);
    }

    @Nullable
    private IClickedIngredient<?> getFocusUnderMouseForClick(double mouseX, double mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            IClickedIngredient<?> clicked;
            if (!gui.canSetFocusWithMouse() || (clicked = gui.getIngredientUnderMouse(mouseX, mouseY)) == null) continue;
            return clicked;
        }
        return null;
    }

    @Nullable
    private IClickedIngredient<?> getIngredientUnderMouseForKey(double mouseX, double mouseY) {
        for (IShowsRecipeFocuses gui : this.showsRecipeFocuses) {
            IClickedIngredient<?> clicked = gui.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked == null) continue;
            return clicked;
        }
        return null;
    }

    private <V> boolean handleMouseClickedFocus(int mouseButton, IClickedIngredient<V> clicked) {
        if (mouseButton == 0) {
            Focus<V> focus = new Focus<V>(IFocus.Mode.OUTPUT, clicked.getValue());
            this.recipesGui.show(focus);
            clicked.onClickHandled();
            return true;
        }
        if (mouseButton == 1) {
            Focus<V> focus = new Focus<V>(IFocus.Mode.INPUT, clicked.getValue());
            this.recipesGui.show(focus);
            clicked.onClickHandled();
            return true;
        }
        return false;
    }

    private <V> boolean handleClickEdit(IClickedIngredient<V> clicked) {
        V ingredient = clicked.getValue();
        IngredientBlacklistType blacklistType = Screen.func_231172_r_() ? IngredientBlacklistType.WILDCARD : IngredientBlacklistType.ITEM;
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        IngredientFilter ingredientFilter = (IngredientFilter)this.weakIngredientFilter.get();
        if (ingredientFilter == null) {
            LOGGER.error("Can't edit the config blacklist, the ingredient filter is null");
        } else if (this.editModeConfig.isIngredientOnConfigBlacklist(ingredient, ingredientHelper)) {
            this.editModeConfig.removeIngredientFromConfigBlacklist(ingredientFilter, this.ingredientManager, ingredient, blacklistType, ingredientHelper);
        } else {
            this.editModeConfig.addIngredientToConfigBlacklist(ingredientFilter, this.ingredientManager, ingredient, blacklistType, ingredientHelper);
        }
        clicked.onClickHandled();
        return true;
    }

    private boolean hasKeyboardFocus() {
        return this.ingredientListOverlay.hasKeyboardFocus();
    }

    private boolean handleCharTyped(char codePoint, int modifiers) {
        return this.ingredientListOverlay.onCharTyped(codePoint, modifiers);
    }

    private boolean handleKeyEvent(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (this.ingredientListOverlay.hasKeyboardFocus()) {
            if (KeyBindings.isInventoryCloseKey(input) || KeyBindings.isEnterKey(keyCode)) {
                this.ingredientListOverlay.clearKeyboardFocus();
                return true;
            }
            if (this.ingredientListOverlay.onKeyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        if (this.handleGlobalKeybinds(input)) {
            return true;
        }
        if (!this.isContainerTextFieldFocused() && !this.ingredientListOverlay.hasKeyboardFocus()) {
            if (this.handleFocusKeybinds(input)) {
                return true;
            }
            return this.ingredientListOverlay.onKeyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private boolean handleGlobalKeybinds(InputMappings.Input input) {
        if (KeyBindings.toggleOverlay.isActiveAndMatches(input)) {
            this.worldConfig.toggleOverlayEnabled();
            return false;
        }
        if (KeyBindings.toggleBookmarkOverlay.isActiveAndMatches(input)) {
            this.worldConfig.toggleBookmarkEnabled();
            return false;
        }
        return this.ingredientListOverlay.onGlobalKeyPressed(input);
    }

    private boolean handleFocusKeybinds(InputMappings.Input input) {
        IClickedIngredient<?> clicked;
        boolean showRecipe = KeyBindings.showRecipe.isActiveAndMatches(input);
        boolean showUses = KeyBindings.showUses.isActiveAndMatches(input);
        boolean bookmark = KeyBindings.bookmark.isActiveAndMatches(input);
        if ((showRecipe || showUses || bookmark) && (clicked = this.getIngredientUnderMouseForKey(MouseUtil.getX(), MouseUtil.getY())) != null) {
            if (bookmark) {
                if (this.bookmarkList.remove(clicked.getValue())) {
                    if (this.bookmarkList.isEmpty()) {
                        this.worldConfig.setBookmarkEnabled(false);
                    }
                    return true;
                }
                this.worldConfig.setBookmarkEnabled(true);
                return this.bookmarkList.add(clicked.getValue());
            }
            IFocus.Mode mode = showRecipe ? IFocus.Mode.OUTPUT : IFocus.Mode.INPUT;
            this.recipesGui.show(new Focus(mode, clicked.getValue()));
            clicked.onClickHandled();
            return true;
        }
        return false;
    }

    private boolean isContainerTextFieldFocused() {
        Minecraft minecraft = Minecraft.func_71410_x();
        Screen screen = minecraft.field_71462_r;
        if (screen == null) {
            return false;
        }
        TextFieldWidget textField = ReflectionUtil.getFieldWithClass(screen, TextFieldWidget.class);
        return textField != null && textField.func_146176_q() && textField.func_230999_j_();
    }
}

