"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DistinguishedName = exports.implementsDistinguishedNameProps = void 0;
function implementsDistinguishedNameProps(value) {
    if (!value || typeof (value) !== 'object') {
        return false;
    }
    if (!value.CN || typeof (value.CN) !== 'string') {
        return false;
    }
    for (const key of ['O', 'OU']) {
        if (value[key] && typeof (value[key]) !== 'string') {
            return false;
        }
    }
    return true;
}
exports.implementsDistinguishedNameProps = implementsDistinguishedNameProps;
class DistinguishedName {
    constructor(props) {
        this.CN = props.CN;
        this.O = props.O;
        this.OU = props.OU;
    }
    toString() {
        let result = `/CN=${this.CN}`;
        if (this.O) {
            result = `${result}/O=${this.O}`;
        }
        if (this.OU) {
            result = `${result}/OU=${this.OU}`;
        }
        return result;
    }
    isValid() {
        let valid = true;
        for (const value of Object.values(this)) {
            valid = valid && (value.indexOf('/') === -1);
        }
        return valid;
    }
}
exports.DistinguishedName = DistinguishedName;
//# sourceMappingURL=data:application/json;base64,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