# Generated by Django 4.0.4 on 2022-05-11 18:56

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import django_countries.fields

import unicef_realm.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=10, unique=True, verbose_name='code')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='name')),
            ],
            bases=(models.Model, unicef_realm.models.TimeStampedModel),
        ),
        migrations.CreateModel(
            name='BusinessArea',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=10, unique=True, verbose_name='code')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='name')),
                ('long_name', models.CharField(max_length=150, verbose_name='long name')),
                ('country', django_countries.fields.CountryField(max_length=2)),
                ('region', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='unicef_realm.region')),
            ],
            options={
                'verbose_name': 'Business Area',
                'verbose_name_plural': 'Business Areas',
            },
            bases=(models.Model, unicef_realm.models.TimeStampedModel),
        ),
        migrations.CreateModel(
            name='UserRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', to='auth.group')),
                ('target', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', to='unicef_realm.businessarea')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'User Role',
                'verbose_name_plural': 'User Roles',
                'ordering': ['group', 'target'],
                'unique_together': {('user', 'group', 'target')},
            },
            bases=(models.Model, unicef_realm.models.TimeStampedModel),
        ),
    ]
