"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LaunchTemplateRequireImdsv2Aspect = exports.InstanceRequireImdsv2Aspect = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const ec2_generated_1 = require("../ec2.generated");
const instance_1 = require("../instance");
const launch_template_1 = require("../launch-template");
/**
 * Base class for Aspect that makes IMDSv2 required.
 */
class RequireImdsv2Aspect {
    constructor(props) {
        var _c;
        this.suppressWarnings = (_c = props === null || props === void 0 ? void 0 : props.suppressWarnings) !== null && _c !== void 0 ? _c : false;
    }
    /**
     * Adds a warning annotation to a node, unless `suppressWarnings` is true.
     *
     * @param node The scope to add the warning to.
     * @param message The warning message.
     * @stability stable
     */
    warn(node, message) {
        if (this.suppressWarnings !== true) {
            cdk.Annotations.of(node).addWarning(`${RequireImdsv2Aspect.name} failed on node ${node.node.id}: ${message}`);
        }
    }
}
/**
 * Aspect that applies IMDS configuration on EC2 Instance constructs.
 *
 * This aspect configures IMDS on an EC2 instance by creating a Launch Template with the
 * IMDS configuration and associating that Launch Template with the instance. If an Instance
 * is already associated with a Launch Template, a warning will (optionally) be added to the
 * construct node and it will be skipped.
 *
 * To cover Instances already associated with Launch Templates, use `LaunchTemplateImdsAspect`.
 *
 * @stability stable
 */
class InstanceRequireImdsv2Aspect extends RequireImdsv2Aspect {
    /**
     * @stability stable
     */
    constructor(props) {
        var _c;
        super(props);
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InstanceRequireImdsv2AspectProps(props);
        this.suppressLaunchTemplateWarning = (_c = props === null || props === void 0 ? void 0 : props.suppressLaunchTemplateWarning) !== null && _c !== void 0 ? _c : false;
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node) {
        if (!(node instanceof instance_1.Instance)) {
            return;
        }
        if (node.instance.launchTemplate !== undefined) {
            this.warn(node, 'Cannot toggle IMDSv1 because this Instance is associated with an existing Launch Template.');
            return;
        }
        const name = `${node.node.id}LaunchTemplate`;
        const launchTemplate = new ec2_generated_1.CfnLaunchTemplate(node, 'LaunchTemplate', {
            launchTemplateData: {
                metadataOptions: {
                    httpTokens: 'required',
                },
            },
            launchTemplateName: name,
        });
        node.instance.launchTemplate = {
            launchTemplateName: name,
            version: launchTemplate.getAtt('LatestVersionNumber').toString(),
        };
    }
    /**
     * Adds a warning annotation to a node, unless `suppressWarnings` is true.
     *
     * @stability stable
     */
    warn(node, message) {
        if (this.suppressLaunchTemplateWarning !== true) {
            super.warn(node, message);
        }
    }
}
exports.InstanceRequireImdsv2Aspect = InstanceRequireImdsv2Aspect;
_a = JSII_RTTI_SYMBOL_1;
InstanceRequireImdsv2Aspect[_a] = { fqn: "@aws-cdk/aws-ec2.InstanceRequireImdsv2Aspect", version: "1.135.0" };
/**
 * Aspect that applies IMDS configuration on EC2 Launch Template constructs.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html
 * @stability stable
 */
class LaunchTemplateRequireImdsv2Aspect extends RequireImdsv2Aspect {
    /**
     * @stability stable
     */
    constructor(props) {
        super(props);
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_LaunchTemplateRequireImdsv2AspectProps(props);
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node) {
        if (!(node instanceof launch_template_1.LaunchTemplate)) {
            return;
        }
        const launchTemplate = node.node.tryFindChild('Resource');
        const data = launchTemplate.launchTemplateData;
        if (cdk.isResolvableObject(data)) {
            this.warn(node, 'LaunchTemplateData is a CDK token.');
            return;
        }
        const metadataOptions = data.metadataOptions;
        if (cdk.isResolvableObject(metadataOptions)) {
            this.warn(node, 'LaunchTemplateData.MetadataOptions is a CDK token.');
            return;
        }
        const newData = {
            ...data,
            metadataOptions: {
                ...metadataOptions,
                httpTokens: 'required',
            },
        };
        launchTemplate.launchTemplateData = newData;
    }
}
exports.LaunchTemplateRequireImdsv2Aspect = LaunchTemplateRequireImdsv2Aspect;
_b = JSII_RTTI_SYMBOL_1;
LaunchTemplateRequireImdsv2Aspect[_b] = { fqn: "@aws-cdk/aws-ec2.LaunchTemplateRequireImdsv2Aspect", version: "1.135.0" };
//# sourceMappingURL=data:application/json;base64,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