"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)


class UserParamsAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.

      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.

    """

    allowed_values = {
        ('locked_reason',): {
            'None': None,
            'NOTLOCKED': "NotLocked",
            'FAILEDLOGINATTEMPTS': "FailedLoginAttempts",
            'LOCKEDBYADMIN': "LockedByAdmin",
            'INACTIVITY': "Inactivity",
            'OTHERREASONS': "OtherReasons",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'sid': (str, none_type,),  # noqa: E501
            'username': (str,),  # noqa: E501
            'domain': (str,),  # noqa: E501
            'local_user_params': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'created_time_msecs': (int, none_type,),  # noqa: E501
            'last_updated_time_msecs': (int, none_type,),  # noqa: E501
            'last_login_time_msecs': (int, none_type,),  # noqa: E501
            'force_password_change': (bool, none_type,),  # noqa: E501
            'primary_group': (str, none_type,),  # noqa: E501
            'other_groups': ([str],),  # noqa: E501
            'tenant_id': (str, none_type,),  # noqa: E501
            's3_account_params': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'locked_reason': (str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'sid': 'sid',  # noqa: E501
        'username': 'username',  # noqa: E501
        'domain': 'domain',  # noqa: E501
        'local_user_params': 'localUserParams',  # noqa: E501
        'created_time_msecs': 'createdTimeMsecs',  # noqa: E501
        'last_updated_time_msecs': 'lastUpdatedTimeMsecs',  # noqa: E501
        'last_login_time_msecs': 'lastLoginTimeMsecs',  # noqa: E501
        'force_password_change': 'forcePasswordChange',  # noqa: E501
        'primary_group': 'primaryGroup',  # noqa: E501
        'other_groups': 'otherGroups',  # noqa: E501
        'tenant_id': 'tenantId',  # noqa: E501
        's3_account_params': 's3AccountParams',  # noqa: E501
        'locked_reason': 'lockedReason',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """UserParamsAllOf - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)

            sid (str, none_type): Specifies the sid of the User.. [optional]  # noqa: E501
            username (str): Specifies the username.. [optional]  # noqa: E501
            domain (str): Specifies the domain of the user. For active directories, this is the fully qualified domain name (FQDN). It is 'LOCAL' for local users on the Cohesity Cluster. A user is uniquely identified by combination of the username and the domain.. [optional]  # noqa: E501
            local_user_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Specifies the LOCAL user properties. This field is required when adding a new LOCAL Cohesity User.. [optional]  # noqa: E501
            created_time_msecs (int, none_type): Specifies the epoch time in milliseconds when the user account was created.. [optional]  # noqa: E501
            last_updated_time_msecs (int, none_type): Specifies the epoch time in milliseconds when the user account was last modified.. [optional]  # noqa: E501
            last_login_time_msecs (int, none_type): Specifies the epoch time in milliseconds when the user last logged in successfully.. [optional]  # noqa: E501
            force_password_change (bool, none_type): Specifies if the user must change password.. [optional]  # noqa: E501
            primary_group (str, none_type): Specifies the primary group of the User. Primary group is used for file access.. [optional]  # noqa: E501
            other_groups ([str]): Specifies additional groups the User may belong to.. [optional]  # noqa: E501
            tenant_id (str, none_type): Specifies the tenant id of the User.. [optional]  # noqa: E501
            s3_account_params ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): Specifies the S3 Account parameters of the User.. [optional]  # noqa: E501
            locked_reason (str, none_type): Specifies the reason for locking the User.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)


        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)


