"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)


class SmbPermission(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.

      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.

    """

    allowed_values = {
        ('type',): {
            'None': None,
            'ALLOW': "Allow",
            'DENY': "Deny",
            'SPECIALTYPE': "SpecialType",
        },
        ('mode',): {
            'None': None,
            'FOLDERSUBFOLDERSANDFILES': "FolderSubFoldersAndFiles",
            'FOLDERANDSUBFOLDERS': "FolderAndSubFolders",
            'FOLDERANDFILES': "FolderAndFiles",
            'FOLDERONLY': "FolderOnly",
            'SUBFOLDERSANDFILESONLY': "SubFoldersAndFilesOnly",
            'SUBFOLDERSONLY': "SubFoldersOnly",
            'FILESONLY': "FilesOnly",
        },
        ('access',): {
            'None': None,
            'READONLY': "ReadOnly",
            'READWRITE': "ReadWrite",
            'MODIFY': "Modify",
            'FULLCONTROL': "FullControl",
            'SPECIALACCESS': "SpecialAccess",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'type': (str, none_type,),  # noqa: E501
            'mode': (str, none_type,),  # noqa: E501
            'access': (str, none_type,),  # noqa: E501
            'sid': (str, none_type,),  # noqa: E501
            'special_type': (int, none_type,),  # noqa: E501
            'special_access_mask': (int, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'type': 'type',  # noqa: E501
        'mode': 'mode',  # noqa: E501
        'access': 'access',  # noqa: E501
        'sid': 'sid',  # noqa: E501
        'special_type': 'specialType',  # noqa: E501
        'special_access_mask': 'specialAccessMask',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """SmbPermission - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)

            type (str, none_type): Specifies the type of permission. 'Allow' indicates access is allowed. 'Deny' indicates access is denied. 'SpecialType' indicates a type defined in the Access Control Entry (ACE) does not map to 'Allow' or 'Deny'.. [optional]  # noqa: E501
            mode (str, none_type): Specifies how the permission should be applied to folders and/or files. 'FolderSubFoldersAndFiles' indicates that permissions are applied to a Folder and it's sub folders and files. 'FolderAndSubFolders' indicates that permissions are applied to a Folder and it's sub folders. 'FolderAndSubFiles' indicates that permissions are applied to a Folder and it's sub files. 'FolderOnly' indicates that permsission are applied to folder only. 'SubFoldersAndFilesOnly' indicates that permissions are applied to sub folders and files only. 'SubFoldersOnly' indicates that permissiona are applied to sub folders only. 'FilesOnly' indicates that permissions are applied to files only.. [optional]  # noqa: E501
            access (str, none_type): Specifies the read/write access to the SMB share. 'ReadyOnly' indicates read only access to the SMB share. 'ReadWrite' indicates read and write access to the SMB share. 'FullControl' indicates full administrative control of the SMB share. 'SpecialAccess' indicates custom permissions to the SMB share using  access masks structures. 'SuperUser' indicates root permissions ignoring all SMB ACLs.. [optional]  # noqa: E501
            sid (str, none_type): Specifies the security identifier (SID) of the principal.. [optional]  # noqa: E501
            special_type (int, none_type): Specifies a custom type. When the type from the Access Control Entry (ACE) cannot be mapped to one of the enums in 'type', this field is populated with the custom type derived from the ACE and 'type' is set to kSpecialType. This is a placeholder for storing an unmapped type and should not be set when creating and editing a View.. [optional]  # noqa: E501
            special_access_mask (int, none_type): Specifies custom access permissions. When the access mask from the Access Control Entry (ACE) cannot be mapped to one of the enums in 'access', this field is populated with the custom mask derived from the ACE and 'access' is set to kSpecialAccess. This is a placeholder for storing an unmapped access permission and should not be set when creating and editing a View.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)


        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)


