"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.api_client import ApiClient, Endpoint as _Endpoint
from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cohesity_sdk.cluster.model.error import Error
from cohesity_sdk.cluster.model.get_protection_runs_status_response_body import GetProtectionRunsStatusResponseBody


class StatsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_protection_runs_stats(
            self,
            **kwargs
        ):
            """Get statistics of protection runs.  # noqa: E501

            Get statistics of protection runs.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_protection_runs_stats(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                start_time_usecs (int): Specify the start time as a Unix epoch Timestamp (in microseconds), only runs executing after this time will be counted. By default it is current time minus a day.. [optional]
                end_time_usecs (int): Specify the end time as a Unix epoch Timestamp (in microseconds), only runs executing before this time will be counted. By default it is current time.. [optional]
                run_status ([str]): Specifies a list of status, runs matching the status will be returned. 'Running' indicates that the run is still running. 'Canceled' indicates that the run has been canceled. 'Failed' indicates that the run has failed. 'Succeeded' indicates that the run has finished successfully. 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetProtectionRunsStatusResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_protection_runs_stats = _Endpoint(
            settings={
                'response_type': (GetProtectionRunsStatusResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/stats/protection-runs',
                'operation_id': 'get_protection_runs_stats',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_time_usecs',
                    'end_time_usecs',
                    'run_status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'run_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('run_status',): {

                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "FAILED": "Failed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning"
                    },
                },
                'openapi_types': {
                    'start_time_usecs':
                        (int,),
                    'end_time_usecs':
                        (int,),
                    'run_status':
                        ([str],),
                },
                'attribute_map': {
                    'start_time_usecs': 'startTimeUsecs',
                    'end_time_usecs': 'endTimeUsecs',
                    'run_status': 'runStatus',
                },
                'location_map': {
                    'start_time_usecs': 'query',
                    'end_time_usecs': 'query',
                    'run_status': 'query',
                },
                'collection_format_map': {
                    'run_status': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_protection_runs_stats
        )
