"""
    Cohesity REST API

    Cohesity API provides a RESTful interface to access the various data management operations on Cohesity cluster and Helios.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cohesity_sdk.cluster.api_client import ApiClient, Endpoint as _Endpoint
from cohesity_sdk.cluster.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from cohesity_sdk.cluster.model.cancel_protection_group_run_request import CancelProtectionGroupRunRequest
from cohesity_sdk.cluster.model.common_protection_group_request_params2384072a0e0849d28bd538044d7ffd40 import CommonProtectionGroupRequestParams2384072a0e0849d28bd538044d7ffd40
from cohesity_sdk.cluster.model.common_protection_group_response_params2bf6a2c107cd4905_a1083e69d22367e8 import CommonProtectionGroupResponseParams2bf6a2c107cd4905A1083e69d22367e8
from cohesity_sdk.cluster.model.create_protection_group_run_request import CreateProtectionGroupRunRequest
from cohesity_sdk.cluster.model.create_protection_group_run_response_body import CreateProtectionGroupRunResponseBody
from cohesity_sdk.cluster.model.error import Error
from cohesity_sdk.cluster.model.get_protection_run_progress_body import GetProtectionRunProgressBody
from cohesity_sdk.cluster.model.protection_group_run import ProtectionGroupRun
from cohesity_sdk.cluster.model.protection_group_runs import ProtectionGroupRuns
from cohesity_sdk.cluster.model.protection_groups import ProtectionGroups
from cohesity_sdk.cluster.model.protection_runs_summary import ProtectionRunsSummary
from cohesity_sdk.cluster.model.update_protection_group_run_request_body import UpdateProtectionGroupRunRequestBody
from cohesity_sdk.cluster.model.update_protection_group_run_response_body import UpdateProtectionGroupRunResponseBody
from cohesity_sdk.cluster.model.update_protection_groups_state import UpdateProtectionGroupsState
from cohesity_sdk.cluster.model.update_protection_groups_state_request import UpdateProtectionGroupsStateRequest


class ProtectionGroupsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __cancel_protection_group_run(
            self,
            id,
            run_id,
            body,
            **kwargs
        ):
            """Cancel protection group run.  # noqa: E501

            Cancel protection run for a given protection group ID and run ID.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.cancel_protection_group_run(id, run_id, body, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique id of the Protection Group.
                run_id (str): Specifies a unique run id of the Protection Group run.
                body (CancelProtectionGroupRunRequest): Specifies the parameters to cancel a protection run.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['run_id'] = \
                run_id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.cancel_protection_group_run = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}/runs/{runId}/cancel',
                'operation_id': 'cancel_protection_group_run',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'run_id',
                    'body',
                ],
                'required': [
                    'id',
                    'run_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'run_id',
                ]
            },
            root_map={
                'validations': {
                    ('run_id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'run_id':
                        (str,),
                    'body':
                        (CancelProtectionGroupRunRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                    'run_id': 'runId',
                },
                'location_map': {
                    'id': 'path',
                    'run_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__cancel_protection_group_run
        )

        def __create_protection_group(
            self,
            body,
            **kwargs
        ):
            """Create a Protection Group.  # noqa: E501

            Create a Protection Group.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_protection_group(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (CommonProtectionGroupRequestParams2384072a0e0849d28bd538044d7ffd40): Specifies the parameters to create a Protection Group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommonProtectionGroupResponseParams2bf6a2c107cd4905A1083e69d22367e8
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.create_protection_group = _Endpoint(
            settings={
                'response_type': (CommonProtectionGroupResponseParams2bf6a2c107cd4905A1083e69d22367e8,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups',
                'operation_id': 'create_protection_group',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (CommonProtectionGroupRequestParams2384072a0e0849d28bd538044d7ffd40,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_protection_group
        )

        def __create_protection_group_run(
            self,
            id,
            body,
            **kwargs
        ):
            """Create a new protection run.  # noqa: E501

            Create a new protection run. This can be used to start a run for a Protection Group on demand, ignoring the schedule and retention specified in the protection policy.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_protection_group_run(id, body, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique id of the Protection Group.
                body (CreateProtectionGroupRunRequest): Specifies the parameters to start a protection run.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateProtectionGroupRunResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.create_protection_group_run = _Endpoint(
            settings={
                'response_type': (CreateProtectionGroupRunResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}/runs',
                'operation_id': 'create_protection_group_run',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'body',
                ],
                'required': [
                    'id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'body':
                        (CreateProtectionGroupRunRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_protection_group_run
        )

        def __delete_protection_group(
            self,
            id,
            **kwargs
        ):
            """Delete a Protection Group.  # noqa: E501

            Returns Success if the Protection Group is deleted.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_protection_group(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique id of the Protection Group.

            Keyword Args:
                delete_snapshots (bool): Specifies if Snapshots generated by the Protection Group should also be deleted when the Protection Group is deleted.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.delete_protection_group = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}',
                'operation_id': 'delete_protection_group',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'delete_snapshots',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'delete_snapshots':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'delete_snapshots': 'deleteSnapshots',
                },
                'location_map': {
                    'id': 'path',
                    'delete_snapshots': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_protection_group
        )

        def __get_protection_group_by_id(
            self,
            id,
            **kwargs
        ):
            """List details about single Protection Group.  # noqa: E501

            Returns the Protection Group corresponding to the specified Group id.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_protection_group_by_id(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique id of the Protection Group.

            Keyword Args:
                request_initiator_type (str): Specifies the type of request from UI, which is used for services like magneto to determine the priority of requests.. [optional]
                include_last_run_info (bool): If true, the response will include last run info. If it is false or not specified, the last run info won't be returned.. [optional]
                prune_excluded_source_ids (bool): If true, the response will not include the list of excluded source IDs in groups that contain this field. This can be set to true in order to improve performance if excluded source IDs are not needed by the user.. [optional]
                prune_source_ids (bool, none_type): If true, the response will exclude the list of source IDs within the group specified.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommonProtectionGroupResponseParams2bf6a2c107cd4905A1083e69d22367e8
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_protection_group_by_id = _Endpoint(
            settings={
                'response_type': (CommonProtectionGroupResponseParams2bf6a2c107cd4905A1083e69d22367e8,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}',
                'operation_id': 'get_protection_group_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'request_initiator_type',
                    'include_last_run_info',
                    'prune_excluded_source_ids',
                    'prune_source_ids',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                    'prune_source_ids',
                ],
                'enum': [
                    'request_initiator_type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('request_initiator_type',): {

                        "UIUSER": "UIUser",
                        "UIAUTO": "UIAuto"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'request_initiator_type':
                        (str,),
                    'include_last_run_info':
                        (bool,),
                    'prune_excluded_source_ids':
                        (bool,),
                    'prune_source_ids':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'id': 'id',
                    'request_initiator_type': 'requestInitiatorType',
                    'include_last_run_info': 'includeLastRunInfo',
                    'prune_excluded_source_ids': 'pruneExcludedSourceIds',
                    'prune_source_ids': 'pruneSourceIds',
                },
                'location_map': {
                    'id': 'path',
                    'request_initiator_type': 'header',
                    'include_last_run_info': 'query',
                    'prune_excluded_source_ids': 'query',
                    'prune_source_ids': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_protection_group_by_id
        )

        def __get_protection_group_run(
            self,
            id,
            run_id,
            **kwargs
        ):
            """Get a run for a Protection Group.  # noqa: E501

            Get a run for a particular Protection Group.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_protection_group_run(id, run_id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique id of the Protection Group.
                run_id (str): Specifies a unique run id of the Protection Group run.

            Keyword Args:
                request_initiator_type (str): Specifies the type of request from UI, which is used for services like magneto to determine the priority of requests.. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which the run is to be returned.. [optional]
                include_tenants (bool): If true, the response will include Protection Group Runs which were created by all tenants which the current user has permission to see. If false, then only Protection Groups created by the current user will be returned. If it's not specified, it is true by default.. [optional]
                include_object_details (bool): Specifies if the result includes the object details for a protection run. If set to true, details of the protected object will be returned. If set to false or not specified, details will not be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProtectionGroupRun
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['run_id'] = \
                run_id
            return self.call_with_http_info(**kwargs)

        self.get_protection_group_run = _Endpoint(
            settings={
                'response_type': (ProtectionGroupRun,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}/runs/{runId}',
                'operation_id': 'get_protection_group_run',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'run_id',
                    'request_initiator_type',
                    'tenant_ids',
                    'include_tenants',
                    'include_object_details',
                ],
                'required': [
                    'id',
                    'run_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'request_initiator_type',
                ],
                'validation': [
                    'run_id',
                ]
            },
            root_map={
                'validations': {
                    ('run_id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('request_initiator_type',): {

                        "UIUSER": "UIUser",
                        "UIAUTO": "UIAuto"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'run_id':
                        (str,),
                    'request_initiator_type':
                        (str,),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'include_object_details':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'run_id': 'runId',
                    'request_initiator_type': 'requestInitiatorType',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'include_object_details': 'includeObjectDetails',
                },
                'location_map': {
                    'id': 'path',
                    'run_id': 'path',
                    'request_initiator_type': 'header',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'include_object_details': 'query',
                },
                'collection_format_map': {
                    'tenant_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_protection_group_run
        )

        def __get_protection_group_runs(
            self,
            id,
            **kwargs
        ):
            """Get the list of runs for a Protection Group.  # noqa: E501

            Get the runs for a particular Protection Group.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_protection_group_runs(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique id of the Protection Group.

            Keyword Args:
                request_initiator_type (str): Specifies the type of request from UI, which is used for services like magneto to determine the priority of requests.. [optional]
                run_id (str): Specifies the protection run id.. [optional]
                start_time_usecs (int): Filter by a start time. Specify the start time as a Unix epoch Timestamp (in microseconds).. [optional]
                end_time_usecs (int): Filter by a end time. Specify the start time as a Unix epoch Timestamp (in microseconds).. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which objects are to be returned.. [optional]
                include_tenants (bool): If true, the response will include Protection Group Runs which were created by all tenants which the current user has permission to see. If false, then only Protection Group Runs created by the current user will be returned.. [optional]
                run_types ([str]): Filter by run type. Only protection run matching the specified types will be returned.. [optional]
                include_object_details (bool): Specifies if the result includes the object details for each protection run. If set to true, details of the protected object will be returned. If set to false or not specified, details will not be returned.. [optional]
                local_backup_run_status ([str]): Specifies a list of local backup status, runs matching the status will be returned.<br> 'Running' indicates that the run is still running.<br> 'Canceled' indicates that the run has been canceled.<br> 'Canceling' indicates that the run is in the process of being canceled.<br> 'Failed' indicates that the run has failed.<br> 'Missed' indicates that the run was unable to take place at the scheduled time because the previous run was still happening.<br> 'Succeeded' indicates that the run has finished successfully.<br> 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                replication_run_status ([str]): Specifies a list of replication status, runs matching the status will be returned.<br> 'Running' indicates that the run is still running.<br> 'Canceled' indicates that the run has been canceled.<br> 'Canceling' indicates that the run is in the process of being canceled.<br> 'Failed' indicates that the run has failed.<br> 'Missed' indicates that the run was unable to take place at the scheduled time because the previous run was still happening.<br> 'Succeeded' indicates that the run has finished successfully.<br> 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                archival_run_status ([str]): Specifies a list of archival status, runs matching the status will be returned.<br> 'Running' indicates that the run is still running.<br> 'Canceled' indicates that the run has been canceled.<br> 'Canceling' indicates that the run is in the process of being canceled.<br> 'Failed' indicates that the run has failed.<br> 'Missed' indicates that the run was unable to take place at the scheduled time because the previous run was still happening.<br> 'Succeeded' indicates that the run has finished successfully.<br> 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                cloud_spin_run_status ([str]): Specifies a list of cloud spin status, runs matching the status will be returned.<br> 'Running' indicates that the run is still running.<br> 'Canceled' indicates that the run has been canceled.<br> 'Canceling' indicates that the run is in the process of being canceled.<br> 'Failed' indicates that the run has failed.<br> 'Missed' indicates that the run was unable to take place at the scheduled time because the previous run was still happening.<br> 'Succeeded' indicates that the run has finished successfully.<br> 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                num_runs (int): Specifies the max number of runs. If not specified, at most 100 runs will be returned.. [optional]
                exclude_non_restorable_runs (bool): Specifies whether to exclude non restorable runs. Run is treated restorable only if there is atleast one object snapshot (which may be either a local or an archival snapshot) which is not deleted or expired. Default value is false.. [optional] if omitted the server will use the default value of False
                run_tags ([str]): Specifies a list of tags for protection runs. If this is specified, only the runs which match these tags will be returned.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProtectionGroupRuns
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_protection_group_runs = _Endpoint(
            settings={
                'response_type': (ProtectionGroupRuns,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}/runs',
                'operation_id': 'get_protection_group_runs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'request_initiator_type',
                    'run_id',
                    'start_time_usecs',
                    'end_time_usecs',
                    'tenant_ids',
                    'include_tenants',
                    'run_types',
                    'include_object_details',
                    'local_backup_run_status',
                    'replication_run_status',
                    'archival_run_status',
                    'cloud_spin_run_status',
                    'num_runs',
                    'exclude_non_restorable_runs',
                    'run_tags',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'request_initiator_type',
                    'run_types',
                    'local_backup_run_status',
                    'replication_run_status',
                    'archival_run_status',
                    'cloud_spin_run_status',
                ],
                'validation': [
                    'run_id',
                    'run_types',
                ]
            },
            root_map={
                'validations': {
                    ('run_id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+$',  # noqa: E501
                        },
                    },
                    ('run_types',): {

                    },
                },
                'allowed_values': {
                    ('request_initiator_type',): {

                        "UIUSER": "UIUser",
                        "UIAUTO": "UIAuto"
                    },
                    ('run_types',): {

                        "KALL": "kAll",
                        "KLOG": "kLog",
                        "KSYSTEM": "kSystem",
                        "KINCREMENTAL": "kIncremental",
                        "KFULL": "kFull"
                    },
                    ('local_backup_run_status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold"
                    },
                    ('replication_run_status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold"
                    },
                    ('archival_run_status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold"
                    },
                    ('cloud_spin_run_status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'request_initiator_type':
                        (str,),
                    'run_id':
                        (str,),
                    'start_time_usecs':
                        (int,),
                    'end_time_usecs':
                        (int,),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'run_types':
                        ([str],),
                    'include_object_details':
                        (bool,),
                    'local_backup_run_status':
                        ([str],),
                    'replication_run_status':
                        ([str],),
                    'archival_run_status':
                        ([str],),
                    'cloud_spin_run_status':
                        ([str],),
                    'num_runs':
                        (int,),
                    'exclude_non_restorable_runs':
                        (bool,),
                    'run_tags':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'request_initiator_type': 'requestInitiatorType',
                    'run_id': 'runId',
                    'start_time_usecs': 'startTimeUsecs',
                    'end_time_usecs': 'endTimeUsecs',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'run_types': 'runTypes',
                    'include_object_details': 'includeObjectDetails',
                    'local_backup_run_status': 'localBackupRunStatus',
                    'replication_run_status': 'replicationRunStatus',
                    'archival_run_status': 'archivalRunStatus',
                    'cloud_spin_run_status': 'cloudSpinRunStatus',
                    'num_runs': 'numRuns',
                    'exclude_non_restorable_runs': 'excludeNonRestorableRuns',
                    'run_tags': 'runTags',
                },
                'location_map': {
                    'id': 'path',
                    'request_initiator_type': 'header',
                    'run_id': 'query',
                    'start_time_usecs': 'query',
                    'end_time_usecs': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'run_types': 'query',
                    'include_object_details': 'query',
                    'local_backup_run_status': 'query',
                    'replication_run_status': 'query',
                    'archival_run_status': 'query',
                    'cloud_spin_run_status': 'query',
                    'num_runs': 'query',
                    'exclude_non_restorable_runs': 'query',
                    'run_tags': 'query',
                },
                'collection_format_map': {
                    'tenant_ids': 'csv',
                    'run_types': 'csv',
                    'local_backup_run_status': 'csv',
                    'replication_run_status': 'csv',
                    'archival_run_status': 'csv',
                    'cloud_spin_run_status': 'csv',
                    'run_tags': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_protection_group_runs
        )

        def __get_protection_groups(
            self,
            **kwargs
        ):
            """Get the list of Protection Groups.  # noqa: E501

            Get the list of Protection Groups.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_protection_groups(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                request_initiator_type (str): Specifies the type of request from UI, which is used for services like magneto to determine the priority of requests.. [optional]
                ids ([str]): Filter by a list of Protection Group ids.. [optional]
                names ([str]): Filter by a list of Protection Group names.. [optional]
                policy_ids ([str]): Filter by Policy ids that are associated with Protection Groups. Only Protection Groups associated with the specified Policy ids, are returned.. [optional]
                storage_domain_id (int): Filter by Storage Domain id. Only Protection Groups writing data to this Storage Domain will be returned.. [optional]
                include_groups_with_datalock_only (bool): Whether to only return Protection Groups with a datalock.. [optional]
                environments ([str]): Filter by environment types such as 'kVMware', 'kView', etc. Only Protection Groups protecting the specified environment types are returned.. [optional]
                office365_workloads ([str]): [optional]
                is_active (bool): Filter by Inactive or Active Protection Groups. If not set, all Inactive and Active Protection Groups are returned. If true, only Active Protection Groups are returned. If false, only Inactive Protection Groups are returned. When you create a Protection Group on a Primary Cluster with a replication schedule, the Cluster creates an Inactive copy of the Protection Group on the Remote Cluster. In addition, when an Active and running Protection Group is deactivated, the Protection Group becomes Inactive.. [optional]
                is_deleted (bool): If true, return only Protection Groups that have been deleted but still have Snapshots associated with them. If false, return all Protection Groups except those Protection Groups that have been deleted and still have Snapshots associated with them. A Protection Group that is deleted with all its Snapshots is not returned for either of these cases.. [optional]
                is_paused (bool): Filter by paused or non paused Protection Groups, If not set, all paused and non paused Protection Groups are returned. If true, only paused Protection Groups are returned. If false, only non paused Protection Groups are returned.. [optional]
                last_run_local_backup_status ([str]): Filter by last local backup run status.<br> 'Running' indicates that the run is still running.<br> 'Canceled' indicates that the run has been canceled.<br> 'Canceling' indicates that the run is in the process of being canceled.<br> 'Failed' indicates that the run has failed.<br> 'Missed' indicates that the run was unable to take place at the scheduled time because the previous run was still happening.<br> 'Succeeded' indicates that the run has finished successfully.<br> 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                last_run_replication_status ([str]): Filter by last remote replication run status.<br> 'Running' indicates that the run is still running.<br> 'Canceled' indicates that the run has been canceled.<br> 'Canceling' indicates that the run is in the process of being canceled.<br> 'Failed' indicates that the run has failed.<br> 'Missed' indicates that the run was unable to take place at the scheduled time because the previous run was still happening.<br> 'Succeeded' indicates that the run has finished successfully.<br> 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                last_run_archival_status ([str]): Filter by last cloud archival run status.<br> 'Running' indicates that the run is still running.<br> 'Canceled' indicates that the run has been canceled.<br> 'Canceling' indicates that the run is in the process of being canceled.<br> 'Failed' indicates that the run has failed.<br> 'Missed' indicates that the run was unable to take place at the scheduled time because the previous run was still happening.<br> 'Succeeded' indicates that the run has finished successfully.<br> 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                last_run_cloud_spin_status ([str]): Filter by last cloud spin run status.<br> 'Running' indicates that the run is still running.<br> 'Canceled' indicates that the run has been canceled.<br> 'Canceling' indicates that the run is in the process of being canceled.<br> 'Failed' indicates that the run has failed.<br> 'Missed' indicates that the run was unable to take place at the scheduled time because the previous run was still happening.<br> 'Succeeded' indicates that the run has finished successfully.<br> 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                last_run_any_status ([str]): Filter by last any run status.<br> 'Running' indicates that the run is still running.<br> 'Canceled' indicates that the run has been canceled.<br> 'Canceling' indicates that the run is in the process of being canceled.<br> 'Failed' indicates that the run has failed.<br> 'Missed' indicates that the run was unable to take place at the scheduled time because the previous run was still happening.<br> 'Succeeded' indicates that the run has finished successfully.<br> 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                is_last_run_sla_violated (bool): If true, return Protection Groups for which last run SLA was violated.. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which objects are to be returned.. [optional]
                include_tenants (bool): If true, the response will include Protection Groups which were created by all tenants which the current user has permission to see. If false, then only Protection Groups created by the current user will be returned.. [optional]
                include_last_run_info (bool): If true, the response will include last run info. If it is false or not specified, the last run info won't be returned.. [optional]
                prune_excluded_source_ids (bool): If true, the response will not include the list of excluded source IDs in groups that contain this field. This can be set to true in order to improve performance if excluded source IDs are not needed by the user.. [optional]
                prune_source_ids (bool, none_type): If true, the response will exclude the list of source IDs within the group specified.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProtectionGroups
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_protection_groups = _Endpoint(
            settings={
                'response_type': (ProtectionGroups,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups',
                'operation_id': 'get_protection_groups',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'request_initiator_type',
                    'ids',
                    'names',
                    'policy_ids',
                    'storage_domain_id',
                    'include_groups_with_datalock_only',
                    'environments',
                    'office365_workloads',
                    'is_active',
                    'is_deleted',
                    'is_paused',
                    'last_run_local_backup_status',
                    'last_run_replication_status',
                    'last_run_archival_status',
                    'last_run_cloud_spin_status',
                    'last_run_any_status',
                    'is_last_run_sla_violated',
                    'tenant_ids',
                    'include_tenants',
                    'include_last_run_info',
                    'prune_excluded_source_ids',
                    'prune_source_ids',
                ],
                'required': [],
                'nullable': [
                    'prune_source_ids',
                ],
                'enum': [
                    'request_initiator_type',
                    'environments',
                    'office365_workloads',
                    'last_run_local_backup_status',
                    'last_run_replication_status',
                    'last_run_archival_status',
                    'last_run_cloud_spin_status',
                    'last_run_any_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('request_initiator_type',): {

                        "UIUSER": "UIUser",
                        "UIAUTO": "UIAuto"
                    },
                    ('environments',): {

                        "KVMWARE": "kVMware",
                        "KHYPERV": "kHyperV",
                        "KAZURE": "kAzure",
                        "KGCP": "kGCP",
                        "KKVM": "kKVM",
                        "KACROPOLIS": "kAcropolis",
                        "KAWS": "kAWS",
                        "KPHYSICAL": "kPhysical",
                        "KGPFS": "kGPFS",
                        "KELASTIFILE": "kElastifile",
                        "KNETAPP": "kNetapp",
                        "KGENERICNAS": "kGenericNas",
                        "KISILON": "kIsilon",
                        "KFLASHBLADE": "kFlashBlade",
                        "KPURE": "kPure",
                        "KSQL": "kSQL",
                        "KEXCHANGE": "kExchange",
                        "KAD": "kAD",
                        "KORACLE": "kOracle",
                        "KVIEW": "kView",
                        "KREMOTEADAPTER": "kRemoteAdapter",
                        "KO365": "kO365",
                        "KKUBERNETES": "kKubernetes",
                        "KCASSANDRA": "kCassandra",
                        "KMONGODB": "kMongoDB",
                        "KCOUCHBASE": "kCouchbase",
                        "KHDFS": "kHdfs",
                        "KHIVE": "kHive",
                        "KHBASE": "kHBase",
                        "KUDA": "kUDA"
                    },
                    ('office365_workloads',): {

                        "KMAILBOX": "kMailbox",
                        "KONEDRIVE": "kOneDrive",
                        "KSHAREPOINT": "kSharePoint",
                        "KPUBLICFOLDERS": "kPublicFolders",
                        "KGROUPS": "kGroups",
                        "KTEAMS": "kTeams"
                    },
                    ('last_run_local_backup_status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold"
                    },
                    ('last_run_replication_status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold"
                    },
                    ('last_run_archival_status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold"
                    },
                    ('last_run_cloud_spin_status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold"
                    },
                    ('last_run_any_status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold"
                    },
                },
                'openapi_types': {
                    'request_initiator_type':
                        (str,),
                    'ids':
                        ([str],),
                    'names':
                        ([str],),
                    'policy_ids':
                        ([str],),
                    'storage_domain_id':
                        (int,),
                    'include_groups_with_datalock_only':
                        (bool,),
                    'environments':
                        ([str],),
                    'office365_workloads':
                        ([str],),
                    'is_active':
                        (bool,),
                    'is_deleted':
                        (bool,),
                    'is_paused':
                        (bool,),
                    'last_run_local_backup_status':
                        ([str],),
                    'last_run_replication_status':
                        ([str],),
                    'last_run_archival_status':
                        ([str],),
                    'last_run_cloud_spin_status':
                        ([str],),
                    'last_run_any_status':
                        ([str],),
                    'is_last_run_sla_violated':
                        (bool,),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'include_last_run_info':
                        (bool,),
                    'prune_excluded_source_ids':
                        (bool,),
                    'prune_source_ids':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'request_initiator_type': 'requestInitiatorType',
                    'ids': 'ids',
                    'names': 'names',
                    'policy_ids': 'policyIds',
                    'storage_domain_id': 'storageDomainId',
                    'include_groups_with_datalock_only': 'includeGroupsWithDatalockOnly',
                    'environments': 'environments',
                    'office365_workloads': 'office365Workloads',
                    'is_active': 'isActive',
                    'is_deleted': 'isDeleted',
                    'is_paused': 'isPaused',
                    'last_run_local_backup_status': 'lastRunLocalBackupStatus',
                    'last_run_replication_status': 'lastRunReplicationStatus',
                    'last_run_archival_status': 'lastRunArchivalStatus',
                    'last_run_cloud_spin_status': 'lastRunCloudSpinStatus',
                    'last_run_any_status': 'lastRunAnyStatus',
                    'is_last_run_sla_violated': 'isLastRunSlaViolated',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'include_last_run_info': 'includeLastRunInfo',
                    'prune_excluded_source_ids': 'pruneExcludedSourceIds',
                    'prune_source_ids': 'pruneSourceIds',
                },
                'location_map': {
                    'request_initiator_type': 'header',
                    'ids': 'query',
                    'names': 'query',
                    'policy_ids': 'query',
                    'storage_domain_id': 'query',
                    'include_groups_with_datalock_only': 'query',
                    'environments': 'query',
                    'office365_workloads': 'query',
                    'is_active': 'query',
                    'is_deleted': 'query',
                    'is_paused': 'query',
                    'last_run_local_backup_status': 'query',
                    'last_run_replication_status': 'query',
                    'last_run_archival_status': 'query',
                    'last_run_cloud_spin_status': 'query',
                    'last_run_any_status': 'query',
                    'is_last_run_sla_violated': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'include_last_run_info': 'query',
                    'prune_excluded_source_ids': 'query',
                    'prune_source_ids': 'query',
                },
                'collection_format_map': {
                    'ids': 'csv',
                    'names': 'csv',
                    'policy_ids': 'csv',
                    'environments': 'csv',
                    'office365_workloads': 'csv',
                    'last_run_local_backup_status': 'csv',
                    'last_run_replication_status': 'csv',
                    'last_run_archival_status': 'csv',
                    'last_run_cloud_spin_status': 'csv',
                    'last_run_any_status': 'csv',
                    'tenant_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_protection_groups
        )

        def __get_protection_run_progress(
            self,
            run_id,
            **kwargs
        ):
            """Get the progress of a run.  # noqa: E501

            Get the progress of a run.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_protection_run_progress(run_id, async_req=True)
            >>> result = thread.get()

            Args:
                run_id (str): Specifies a unique run id of the Protection Run.

            Keyword Args:
                objects ([int]): Specifies the objects whose progress will be returned. This only applies to protection group runs and will be ignored for object runs. If the objects are specified, the run progress will not be returned and only the progress of the specified objects will be returned.. [optional]
                tenant_ids ([str]): TenantIds contains ids of the tenants for which the run is to be returned.. [optional]
                include_tenants (bool): If true, the response will include Protection Group Runs which were created by all tenants which the current user has permission to see. If false, then only Protection Groups created by the current user will be returned. If it's not specified, it is true by default.. [optional]
                include_finished_tasks (bool): Specifies whether to return finished tasks. By default only active tasks are returned.. [optional]
                start_time_usecs (int): Specifies the time after which the progress task starts in Unix epoch Timestamp(in microseconds).. [optional]
                end_time_usecs (int): Specifies the time before which the progress task ends in Unix epoch Timestamp(in microseconds).. [optional]
                max_tasks_num (int): Specifies the maximum number of tasks to return.. [optional]
                exclude_object_details (bool): Specifies whether to return objects. By default all the task tree are returned.. [optional]
                include_event_logs (bool): Specifies whether to include event logs. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                GetProtectionRunProgressBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['run_id'] = \
                run_id
            return self.call_with_http_info(**kwargs)

        self.get_protection_run_progress = _Endpoint(
            settings={
                'response_type': (GetProtectionRunProgressBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/runs/{runId}/progress',
                'operation_id': 'get_protection_run_progress',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'run_id',
                    'objects',
                    'tenant_ids',
                    'include_tenants',
                    'include_finished_tasks',
                    'start_time_usecs',
                    'end_time_usecs',
                    'max_tasks_num',
                    'exclude_object_details',
                    'include_event_logs',
                ],
                'required': [
                    'run_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'run_id':
                        (str,),
                    'objects':
                        ([int],),
                    'tenant_ids':
                        ([str],),
                    'include_tenants':
                        (bool,),
                    'include_finished_tasks':
                        (bool,),
                    'start_time_usecs':
                        (int,),
                    'end_time_usecs':
                        (int,),
                    'max_tasks_num':
                        (int,),
                    'exclude_object_details':
                        (bool,),
                    'include_event_logs':
                        (bool,),
                },
                'attribute_map': {
                    'run_id': 'runId',
                    'objects': 'objects',
                    'tenant_ids': 'tenantIds',
                    'include_tenants': 'includeTenants',
                    'include_finished_tasks': 'includeFinishedTasks',
                    'start_time_usecs': 'startTimeUsecs',
                    'end_time_usecs': 'endTimeUsecs',
                    'max_tasks_num': 'maxTasksNum',
                    'exclude_object_details': 'excludeObjectDetails',
                    'include_event_logs': 'includeEventLogs',
                },
                'location_map': {
                    'run_id': 'path',
                    'objects': 'query',
                    'tenant_ids': 'query',
                    'include_tenants': 'query',
                    'include_finished_tasks': 'query',
                    'start_time_usecs': 'query',
                    'end_time_usecs': 'query',
                    'max_tasks_num': 'query',
                    'exclude_object_details': 'query',
                    'include_event_logs': 'query',
                },
                'collection_format_map': {
                    'objects': 'csv',
                    'tenant_ids': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_protection_run_progress
        )

        def __get_protection_runs(
            self,
            **kwargs
        ):
            """Get the list of runs.  # noqa: E501

            Get a list of protection runs.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_protection_runs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                start_time_usecs (int): Filter by a start time. Specify the start time as a Unix epoch Timestamp (in microseconds), only runs executing after this time will be returned. By default it is endTimeUsecs minus an hour.. [optional]
                end_time_usecs (int): Filter by a end time. Specify the start time as a Unix epoch Timestamp (in microseconds), only runs executing before this time will be returned. By default it is current time.. [optional]
                run_status ([str]): Specifies a list of status, runs matching the status will be returned.<br> 'Running' indicates that the run is still running.<br> 'Canceled' indicates that the run has been canceled.<br> 'Canceling' indicates that the run is in the process of being canceled.<br> 'Failed' indicates that the run has failed.<br> 'Missed' indicates that the run was unable to take place at the scheduled time because the previous run was still happening.<br> 'Succeeded' indicates that the run has finished successfully.<br> 'SucceededWithWarning' indicates that the run finished successfully, but there were some warning messages.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProtectionRunsSummary
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_protection_runs = _Endpoint(
            settings={
                'response_type': (ProtectionRunsSummary,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/runs/summary',
                'operation_id': 'get_protection_runs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start_time_usecs',
                    'end_time_usecs',
                    'run_status',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'run_status',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('run_status',): {

                        "ACCEPTED": "Accepted",
                        "RUNNING": "Running",
                        "CANCELED": "Canceled",
                        "CANCELING": "Canceling",
                        "FAILED": "Failed",
                        "MISSED": "Missed",
                        "SUCCEEDED": "Succeeded",
                        "SUCCEEDEDWITHWARNING": "SucceededWithWarning",
                        "ONHOLD": "OnHold"
                    },
                },
                'openapi_types': {
                    'start_time_usecs':
                        (int,),
                    'end_time_usecs':
                        (int,),
                    'run_status':
                        ([str],),
                },
                'attribute_map': {
                    'start_time_usecs': 'startTimeUsecs',
                    'end_time_usecs': 'endTimeUsecs',
                    'run_status': 'runStatus',
                },
                'location_map': {
                    'start_time_usecs': 'query',
                    'end_time_usecs': 'query',
                    'run_status': 'query',
                },
                'collection_format_map': {
                    'run_status': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_protection_runs
        )

        def __get_run_debug_logs(
            self,
            id,
            run_id,
            **kwargs
        ):
            """Get the debug logs for a run from a Protection Group.  # noqa: E501

            Get the debug logs for all objects of a run for a particular Protection Group.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_run_debug_logs(id, run_id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique id of the Protection Group.
                run_id (str): Specifies a unique run id of the Protection Group run.

            Keyword Args:
                object_id (str): Specifies the id of the object for which debug logs are to be returned. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['run_id'] = \
                run_id
            return self.call_with_http_info(**kwargs)

        self.get_run_debug_logs = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}/runs/{runId}/debug-logs',
                'operation_id': 'get_run_debug_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'run_id',
                    'object_id',
                ],
                'required': [
                    'id',
                    'run_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                    'run_id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+:\d+$',  # noqa: E501
                        },
                    },
                    ('run_id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'run_id':
                        (str,),
                    'object_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'run_id': 'runId',
                    'object_id': 'objectId',
                },
                'location_map': {
                    'id': 'path',
                    'run_id': 'path',
                    'object_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_run_debug_logs
        )

        def __get_run_debug_logs_for_object(
            self,
            id,
            run_id,
            object_id,
            **kwargs
        ):
            """Get the debug logs for a particular object in a run from a Protection Group.  # noqa: E501

            Get the debug logs for a particular object of a run for a particular Protection Group.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_run_debug_logs_for_object(id, run_id, object_id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique id of the Protection Group.
                run_id (str): Specifies a unique run id of the Protection Group run.
                object_id (str): Specifies the id of the object for which debug logs are to be returned. 

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['run_id'] = \
                run_id
            kwargs['object_id'] = \
                object_id
            return self.call_with_http_info(**kwargs)

        self.get_run_debug_logs_for_object = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}/runs/{runId}/objects/{objectId}/debug-logs',
                'operation_id': 'get_run_debug_logs_for_object',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'run_id',
                    'object_id',
                ],
                'required': [
                    'id',
                    'run_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'id',
                    'run_id',
                ]
            },
            root_map={
                'validations': {
                    ('id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+:\d+$',  # noqa: E501
                        },
                    },
                    ('run_id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'run_id':
                        (str,),
                    'object_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'run_id': 'runId',
                    'object_id': 'objectId',
                },
                'location_map': {
                    'id': 'path',
                    'run_id': 'path',
                    'object_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_run_debug_logs_for_object
        )

        def __get_run_errors_report(
            self,
            id,
            run_id,
            object_id,
            **kwargs
        ):
            """Get the CSV of errors/warnings for a given run and an object.  # noqa: E501

            Get an CSV error report for given objectId and run id. Each row in CSV report contains the File Path, error/warning code and error/warning message.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_run_errors_report(id, run_id, object_id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique id of the Protection Group.
                run_id (str): Specifies a unique run id of the Protection Group run.
                object_id (str): Specifies the id of the object for which errors/warnings are to be returned. 

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['run_id'] = \
                run_id
            kwargs['object_id'] = \
                object_id
            return self.call_with_http_info(**kwargs)

        self.get_run_errors_report = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}/runs/{runId}/objects/{objectId}/downloadMessages',
                'operation_id': 'get_run_errors_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'run_id',
                    'object_id',
                ],
                'required': [
                    'id',
                    'run_id',
                    'object_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'run_id',
                ]
            },
            root_map={
                'validations': {
                    ('run_id',): {

                        'regex': {
                            'pattern': r'^\d+:\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'run_id':
                        (str,),
                    'object_id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'run_id': 'runId',
                    'object_id': 'objectId',
                },
                'location_map': {
                    'id': 'path',
                    'run_id': 'path',
                    'object_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_run_errors_report
        )

        def __update_protection_group(
            self,
            id,
            body,
            **kwargs
        ):
            """Update a Protection Group.  # noqa: E501

            Update the specified Protection Group.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_protection_group(id, body, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies the id of the Protection Group.
                body (CommonProtectionGroupRequestParams2384072a0e0849d28bd538044d7ffd40): Specifies the parameters to update a Protection Group.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommonProtectionGroupResponseParams2bf6a2c107cd4905A1083e69d22367e8
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_protection_group = _Endpoint(
            settings={
                'response_type': (CommonProtectionGroupResponseParams2bf6a2c107cd4905A1083e69d22367e8,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}',
                'operation_id': 'update_protection_group',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'body',
                ],
                'required': [
                    'id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'body':
                        (CommonProtectionGroupRequestParams2384072a0e0849d28bd538044d7ffd40,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_protection_group
        )

        def __update_protection_group_run(
            self,
            id,
            body,
            **kwargs
        ):
            """Update runs for a particular Protection Group.  # noqa: E501

            Update runs for a particular Protection Group. A user can perform the following actions: 1. Extend or reduce retention of a local, replication and archival snapshots. 2. Can perform resync operation on failed copy snapshots attempts in this Run. 3. Add new replication and archival snapshot targets to the Run. 4. Add or remove legal hold on the snapshots. Only a user with DSO role can perform this operation. 5. Delete the snapshots that were created as a part of this Run. 6. Apply datalock on existing snapshots where a user cannot manually delete snapshots before the expiry time.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_protection_group_run(id, body, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Specifies a unique id of the Protection Group.
                body (UpdateProtectionGroupRunRequestBody): Specifies the parameters to update a Protection Group Run.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateProtectionGroupRunResponseBody
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_protection_group_run = _Endpoint(
            settings={
                'response_type': (UpdateProtectionGroupRunResponseBody,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/{id}/runs',
                'operation_id': 'update_protection_group_run',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'body',
                ],
                'required': [
                    'id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'body':
                        (UpdateProtectionGroupRunRequestBody,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_protection_group_run
        )

        def __update_protection_groups_state(
            self,
            body,
            **kwargs
        ):
            """Perform an action like pause, resume, active, deactivate on all specified Protection Groups.  # noqa: E501

            Perform an action like pause, resume, active, deactivate on all specified Protection Groups. Note that the pause or resume actions will take effect from next Protection Run. Also, user can specify only one type of action on all the Protection Groups. Deactivate and activate actions are independent of pause and resume state. Deactivate and activate actions are useful in case of failover situations. Returns success if the state of all the Protection Groups state is changed successfully.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_protection_groups_state(body, async_req=True)
            >>> result = thread.get()

            Args:
                body (UpdateProtectionGroupsStateRequest): Specifies the parameters to perform an action of list of Protection Groups.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpdateProtectionGroupsState
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['body'] = \
                body
            return self.call_with_http_info(**kwargs)

        self.update_protection_groups_state = _Endpoint(
            settings={
                'response_type': (UpdateProtectionGroupsState,),
                'auth': [
                    'TokenHeader',
        
                    'APIKeyHeader'
                ],
                'endpoint_path': '/data-protect/protection-groups/states',
                'operation_id': 'update_protection_groups_state',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'body',
                ],
                'required': [
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'body':
                        (UpdateProtectionGroupsStateRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_protection_groups_state
        )
