"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9783
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.ippool_ip_v4_config import IppoolIpV4Config
    from intersight.model.ippool_pool_relationship import IppoolPoolRelationship
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.vnic_iscsi_adapter_policy_inventory_relationship import VnicIscsiAdapterPolicyInventoryRelationship
    from intersight.model.vnic_iscsi_auth_profile import VnicIscsiAuthProfile
    from intersight.model.vnic_iscsi_static_target_policy_inventory_relationship import VnicIscsiStaticTargetPolicyInventoryRelationship
    globals()['IppoolIpV4Config'] = IppoolIpV4Config
    globals()['IppoolPoolRelationship'] = IppoolPoolRelationship
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['VnicIscsiAdapterPolicyInventoryRelationship'] = VnicIscsiAdapterPolicyInventoryRelationship
    globals()['VnicIscsiAuthProfile'] = VnicIscsiAuthProfile
    globals()['VnicIscsiStaticTargetPolicyInventoryRelationship'] = VnicIscsiStaticTargetPolicyInventoryRelationship


class VnicIscsiBootPolicyInventoryAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'VNIC.ISCSIBOOTPOLICYINVENTORY': "vnic.IscsiBootPolicyInventory",
        },
        ('object_type',): {
            'VNIC.ISCSIBOOTPOLICYINVENTORY': "vnic.IscsiBootPolicyInventory",
        },
        ('initiator_ip_source',): {
            'DHCP': "DHCP",
            'STATIC': "Static",
            'POOL': "Pool",
        },
        ('target_source_type',): {
            'STATIC': "Static",
            'AUTO': "Auto",
        },
    }

    validations = {
        ('initiator_static_ip_v4_address',): {
            'regex': {
                'pattern': r'^$|^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'auto_targetvendor_name': (str,),  # noqa: E501
            'chap': (VnicIscsiAuthProfile,),  # noqa: E501
            'initiator_ip_source': (str,),  # noqa: E501
            'initiator_static_ip_v4_address': (str,),  # noqa: E501
            'initiator_static_ip_v4_config': (IppoolIpV4Config,),  # noqa: E501
            'mutual_chap': (VnicIscsiAuthProfile,),  # noqa: E501
            'target_source_type': (str,),  # noqa: E501
            'initiator_ip_pool': (IppoolPoolRelationship,),  # noqa: E501
            'iscsi_adapter_policy': (VnicIscsiAdapterPolicyInventoryRelationship,),  # noqa: E501
            'primary_target_policy': (VnicIscsiStaticTargetPolicyInventoryRelationship,),  # noqa: E501
            'secondary_target_policy': (VnicIscsiStaticTargetPolicyInventoryRelationship,),  # noqa: E501
            'target_mo': (MoBaseMoRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'auto_targetvendor_name': 'AutoTargetvendorName',  # noqa: E501
        'chap': 'Chap',  # noqa: E501
        'initiator_ip_source': 'InitiatorIpSource',  # noqa: E501
        'initiator_static_ip_v4_address': 'InitiatorStaticIpV4Address',  # noqa: E501
        'initiator_static_ip_v4_config': 'InitiatorStaticIpV4Config',  # noqa: E501
        'mutual_chap': 'MutualChap',  # noqa: E501
        'target_source_type': 'TargetSourceType',  # noqa: E501
        'initiator_ip_pool': 'InitiatorIpPool',  # noqa: E501
        'iscsi_adapter_policy': 'IscsiAdapterPolicy',  # noqa: E501
        'primary_target_policy': 'PrimaryTargetPolicy',  # noqa: E501
        'secondary_target_policy': 'SecondaryTargetPolicy',  # noqa: E501
        'target_mo': 'TargetMo',  # noqa: E501
    }

    read_only_vars = {
        'auto_targetvendor_name',  # noqa: E501
        'initiator_ip_source',  # noqa: E501
        'initiator_static_ip_v4_address',  # noqa: E501
        'target_source_type',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """VnicIscsiBootPolicyInventoryAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "vnic.IscsiBootPolicyInventory", must be one of ["vnic.IscsiBootPolicyInventory", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "vnic.IscsiBootPolicyInventory", must be one of ["vnic.IscsiBootPolicyInventory", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            auto_targetvendor_name (str): Auto target interface that is represented via the Initiator name or the DHCP vendor ID. The vendor ID can be up to 32 alphanumeric characters.. [optional]  # noqa: E501
            chap (VnicIscsiAuthProfile): [optional]  # noqa: E501
            initiator_ip_source (str): Source Type of Initiator IP Address - Auto/Static/Pool. * `DHCP` - The IP address is assigned using DHCP, if available. * `Static` - Static IPv4 address is assigned to the iSCSI boot interface based on the information entered in this area. * `Pool` - An IPv4 address is assigned to the iSCSI boot interface from the management IP address pool.. [optional] if omitted the server will use the default value of "DHCP"  # noqa: E501
            initiator_static_ip_v4_address (str): Static IP address provided for iSCSI Initiator.. [optional]  # noqa: E501
            initiator_static_ip_v4_config (IppoolIpV4Config): [optional]  # noqa: E501
            mutual_chap (VnicIscsiAuthProfile): [optional]  # noqa: E501
            target_source_type (str): Source Type of Targets - Auto/Static. * `Static` - Type indicates that static target interface is assigned to iSCSI boot. * `Auto` - Type indicates that the system selects the target interface automatically during iSCSI boot.. [optional] if omitted the server will use the default value of "Static"  # noqa: E501
            initiator_ip_pool (IppoolPoolRelationship): [optional]  # noqa: E501
            iscsi_adapter_policy (VnicIscsiAdapterPolicyInventoryRelationship): [optional]  # noqa: E501
            primary_target_policy (VnicIscsiStaticTargetPolicyInventoryRelationship): [optional]  # noqa: E501
            secondary_target_policy (VnicIscsiStaticTargetPolicyInventoryRelationship): [optional]  # noqa: E501
            target_mo (MoBaseMoRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "vnic.IscsiBootPolicyInventory")
        object_type = kwargs.get('object_type', "vnic.IscsiBootPolicyInventory")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """VnicIscsiBootPolicyInventoryAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "vnic.IscsiBootPolicyInventory", must be one of ["vnic.IscsiBootPolicyInventory", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "vnic.IscsiBootPolicyInventory", must be one of ["vnic.IscsiBootPolicyInventory", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            auto_targetvendor_name (str): Auto target interface that is represented via the Initiator name or the DHCP vendor ID. The vendor ID can be up to 32 alphanumeric characters.. [optional]  # noqa: E501
            chap (VnicIscsiAuthProfile): [optional]  # noqa: E501
            initiator_ip_source (str): Source Type of Initiator IP Address - Auto/Static/Pool. * `DHCP` - The IP address is assigned using DHCP, if available. * `Static` - Static IPv4 address is assigned to the iSCSI boot interface based on the information entered in this area. * `Pool` - An IPv4 address is assigned to the iSCSI boot interface from the management IP address pool.. [optional] if omitted the server will use the default value of "DHCP"  # noqa: E501
            initiator_static_ip_v4_address (str): Static IP address provided for iSCSI Initiator.. [optional]  # noqa: E501
            initiator_static_ip_v4_config (IppoolIpV4Config): [optional]  # noqa: E501
            mutual_chap (VnicIscsiAuthProfile): [optional]  # noqa: E501
            target_source_type (str): Source Type of Targets - Auto/Static. * `Static` - Type indicates that static target interface is assigned to iSCSI boot. * `Auto` - Type indicates that the system selects the target interface automatically during iSCSI boot.. [optional] if omitted the server will use the default value of "Static"  # noqa: E501
            initiator_ip_pool (IppoolPoolRelationship): [optional]  # noqa: E501
            iscsi_adapter_policy (VnicIscsiAdapterPolicyInventoryRelationship): [optional]  # noqa: E501
            primary_target_policy (VnicIscsiStaticTargetPolicyInventoryRelationship): [optional]  # noqa: E501
            secondary_target_policy (VnicIscsiStaticTargetPolicyInventoryRelationship): [optional]  # noqa: E501
            target_mo (MoBaseMoRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "vnic.IscsiBootPolicyInventory")
        object_type = kwargs.get('object_type', "vnic.IscsiBootPolicyInventory")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
