"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9783
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.virtualization_base_host_configuration import VirtualizationBaseHostConfiguration
    from intersight.model.virtualization_base_host_relationship import VirtualizationBaseHostRelationship
    from intersight.model.workflow_workflow_info_relationship import WorkflowWorkflowInfoRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['VirtualizationBaseHostConfiguration'] = VirtualizationBaseHostConfiguration
    globals()['VirtualizationBaseHostRelationship'] = VirtualizationBaseHostRelationship
    globals()['WorkflowWorkflowInfoRelationship'] = WorkflowWorkflowInfoRelationship


class VirtualizationHostAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'VIRTUALIZATION.HOST': "virtualization.Host",
        },
        ('object_type',): {
            'VIRTUALIZATION.HOST': "virtualization.Host",
        },
        ('action',): {
            'NONE': "None",
            'ENTERMAINTENANCEMODE': "EnterMaintenanceMode",
            'EXITMAINTENANCEMODE': "ExitMaintenanceMode",
            'POWEROFFSTORAGECONTROLLER': "PowerOffStorageController",
            'POWERONSTORAGECONTROLLER': "PowerOnStorageController",
        },
        ('hypervisor_type',): {
            'ESXI': "ESXi",
            'HYPERFLEXAP': "HyperFlexAp",
            'IWE': "IWE",
            'HYPER-V': "Hyper-V",
            'UNKNOWN': "Unknown",
        },
        ('maintenance_state',): {
            'NONE': "None",
            'ENTER': "Enter",
            'EXIT': "Exit",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'action': (str,),  # noqa: E501
            'discovered': (bool,),  # noqa: E501
            'evacuate': (bool,),  # noqa: E501
            'host_config': (VirtualizationBaseHostConfiguration,),  # noqa: E501
            'hypervisor_type': (str,),  # noqa: E501
            'identity': (str,),  # noqa: E501
            'maintenance_state': (str,),  # noqa: E501
            'model': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'vendor': (str,),  # noqa: E501
            'inventory': (VirtualizationBaseHostRelationship,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'workflow_info': (WorkflowWorkflowInfoRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'action': 'Action',  # noqa: E501
        'discovered': 'Discovered',  # noqa: E501
        'evacuate': 'Evacuate',  # noqa: E501
        'host_config': 'HostConfig',  # noqa: E501
        'hypervisor_type': 'HypervisorType',  # noqa: E501
        'identity': 'Identity',  # noqa: E501
        'maintenance_state': 'MaintenanceState',  # noqa: E501
        'model': 'Model',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'vendor': 'Vendor',  # noqa: E501
        'inventory': 'Inventory',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'workflow_info': 'WorkflowInfo',  # noqa: E501
    }

    read_only_vars = {
        'discovered',  # noqa: E501
        'hypervisor_type',  # noqa: E501
        'identity',  # noqa: E501
        'model',  # noqa: E501
        'name',  # noqa: E501
        'serial',  # noqa: E501
        'vendor',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """VirtualizationHostAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "virtualization.Host", must be one of ["virtualization.Host", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "virtualization.Host", must be one of ["virtualization.Host", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            action (str): Action to be performed on a host (Create, PowerState, Migrate, Clone etc). * `None` - A place holder for the default value. * `EnterMaintenanceMode` - Put a host into maintenance mode. * `ExitMaintenanceMode` - Put a host into active mode. * `PowerOffStorageController` - Power off HyperFlex storage controller node running on selected hypervisor host. * `PowerOnStorageController` - Power on HyperFlex storage controller node running on selected hypervisor host.. [optional] if omitted the server will use the default value of "None"  # noqa: E501
            discovered (bool): Flag to indicate whether the configuration is created from inventory object.. [optional]  # noqa: E501
            evacuate (bool): If true, move powered-off and suspended virtual machines to other hosts in the cluster.. [optional]  # noqa: E501
            host_config (VirtualizationBaseHostConfiguration): [optional]  # noqa: E501
            hypervisor_type (str): Identifies the broad product type of the hypervisor but without any version information. It is here to easily identify the type of the virtual machine. There are other entities (Host, Cluster, etc.) that can be indirectly used to determine the hypervisor but a direct attribute makes it easier to work with. * `ESXi` - The hypervisor running on the HyperFlex cluster is a Vmware ESXi hypervisor of any version. * `HyperFlexAp` - The hypervisor of the virtualization platform is Cisco HyperFlex Application Platform. * `IWE` - The hypervisor of the virtualization platform is Cisco Intersight Workload Engine. * `Hyper-V` - The hypervisor running on the HyperFlex cluster is Microsoft Hyper-V. * `Unknown` - The hypervisor running on the HyperFlex cluster is not known.. [optional] if omitted the server will use the default value of "ESXi"  # noqa: E501
            identity (str): Unique identifier assigned to the hypervisor host.. [optional]  # noqa: E501
            maintenance_state (str): Expected state of host (enter maintenance, exit maintenance). * `None` - A place holder for the default value. * `Enter` - Power action is performed on the virtual machine. * `Exit` - The virtual machine will be migrated from existing node to a different node in cluster. The behavior depends on the underlying hypervisor.. [optional] if omitted the server will use the default value of "None"  # noqa: E501
            model (str): Commercial model information about this hardware.. [optional]  # noqa: E501
            name (str): Name of the hypervisor host. It must be unique within the target endpoint.. [optional]  # noqa: E501
            serial (str): Serial number of this host (internally generated).. [optional]  # noqa: E501
            vendor (str): Commercial vendor details of this hardware.. [optional]  # noqa: E501
            inventory (VirtualizationBaseHostRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            workflow_info (WorkflowWorkflowInfoRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "virtualization.Host")
        object_type = kwargs.get('object_type', "virtualization.Host")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """VirtualizationHostAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "virtualization.Host", must be one of ["virtualization.Host", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "virtualization.Host", must be one of ["virtualization.Host", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            action (str): Action to be performed on a host (Create, PowerState, Migrate, Clone etc). * `None` - A place holder for the default value. * `EnterMaintenanceMode` - Put a host into maintenance mode. * `ExitMaintenanceMode` - Put a host into active mode. * `PowerOffStorageController` - Power off HyperFlex storage controller node running on selected hypervisor host. * `PowerOnStorageController` - Power on HyperFlex storage controller node running on selected hypervisor host.. [optional] if omitted the server will use the default value of "None"  # noqa: E501
            discovered (bool): Flag to indicate whether the configuration is created from inventory object.. [optional]  # noqa: E501
            evacuate (bool): If true, move powered-off and suspended virtual machines to other hosts in the cluster.. [optional]  # noqa: E501
            host_config (VirtualizationBaseHostConfiguration): [optional]  # noqa: E501
            hypervisor_type (str): Identifies the broad product type of the hypervisor but without any version information. It is here to easily identify the type of the virtual machine. There are other entities (Host, Cluster, etc.) that can be indirectly used to determine the hypervisor but a direct attribute makes it easier to work with. * `ESXi` - The hypervisor running on the HyperFlex cluster is a Vmware ESXi hypervisor of any version. * `HyperFlexAp` - The hypervisor of the virtualization platform is Cisco HyperFlex Application Platform. * `IWE` - The hypervisor of the virtualization platform is Cisco Intersight Workload Engine. * `Hyper-V` - The hypervisor running on the HyperFlex cluster is Microsoft Hyper-V. * `Unknown` - The hypervisor running on the HyperFlex cluster is not known.. [optional] if omitted the server will use the default value of "ESXi"  # noqa: E501
            identity (str): Unique identifier assigned to the hypervisor host.. [optional]  # noqa: E501
            maintenance_state (str): Expected state of host (enter maintenance, exit maintenance). * `None` - A place holder for the default value. * `Enter` - Power action is performed on the virtual machine. * `Exit` - The virtual machine will be migrated from existing node to a different node in cluster. The behavior depends on the underlying hypervisor.. [optional] if omitted the server will use the default value of "None"  # noqa: E501
            model (str): Commercial model information about this hardware.. [optional]  # noqa: E501
            name (str): Name of the hypervisor host. It must be unique within the target endpoint.. [optional]  # noqa: E501
            serial (str): Serial number of this host (internally generated).. [optional]  # noqa: E501
            vendor (str): Commercial vendor details of this hardware.. [optional]  # noqa: E501
            inventory (VirtualizationBaseHostRelationship): [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            workflow_info (WorkflowWorkflowInfoRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "virtualization.Host")
        object_type = kwargs.get('object_type', "virtualization.Host")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
