"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9783
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.compute_alarm_summary import ComputeAlarmSummary
    from intersight.model.compute_blade_relationship import ComputeBladeRelationship
    from intersight.model.equipment_expander_module_relationship import EquipmentExpanderModuleRelationship
    from intersight.model.equipment_fan_control_relationship import EquipmentFanControlRelationship
    from intersight.model.equipment_fan_module_relationship import EquipmentFanModuleRelationship
    from intersight.model.equipment_io_card_relationship import EquipmentIoCardRelationship
    from intersight.model.equipment_locator_led_relationship import EquipmentLocatorLedRelationship
    from intersight.model.equipment_psu_control_relationship import EquipmentPsuControlRelationship
    from intersight.model.equipment_psu_relationship import EquipmentPsuRelationship
    from intersight.model.equipment_system_io_controller_relationship import EquipmentSystemIoControllerRelationship
    from intersight.model.inventory_device_info_relationship import InventoryDeviceInfoRelationship
    from intersight.model.management_interface_relationship import ManagementInterfaceRelationship
    from intersight.model.power_control_state_relationship import PowerControlStateRelationship
    from intersight.model.storage_enclosure_relationship import StorageEnclosureRelationship
    from intersight.model.storage_sas_expander_relationship import StorageSasExpanderRelationship
    from intersight.model.storage_virtual_drive_container_relationship import StorageVirtualDriveContainerRelationship
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['ComputeAlarmSummary'] = ComputeAlarmSummary
    globals()['ComputeBladeRelationship'] = ComputeBladeRelationship
    globals()['EquipmentExpanderModuleRelationship'] = EquipmentExpanderModuleRelationship
    globals()['EquipmentFanControlRelationship'] = EquipmentFanControlRelationship
    globals()['EquipmentFanModuleRelationship'] = EquipmentFanModuleRelationship
    globals()['EquipmentIoCardRelationship'] = EquipmentIoCardRelationship
    globals()['EquipmentLocatorLedRelationship'] = EquipmentLocatorLedRelationship
    globals()['EquipmentPsuControlRelationship'] = EquipmentPsuControlRelationship
    globals()['EquipmentPsuRelationship'] = EquipmentPsuRelationship
    globals()['EquipmentSystemIoControllerRelationship'] = EquipmentSystemIoControllerRelationship
    globals()['InventoryDeviceInfoRelationship'] = InventoryDeviceInfoRelationship
    globals()['ManagementInterfaceRelationship'] = ManagementInterfaceRelationship
    globals()['PowerControlStateRelationship'] = PowerControlStateRelationship
    globals()['StorageEnclosureRelationship'] = StorageEnclosureRelationship
    globals()['StorageSasExpanderRelationship'] = StorageSasExpanderRelationship
    globals()['StorageVirtualDriveContainerRelationship'] = StorageVirtualDriveContainerRelationship


class EquipmentChassisAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
        },
        ('object_type',): {
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
        },
        ('management_mode',): {
            'INTERSIGHTSTANDALONE': "IntersightStandalone",
            'UCSM': "UCSM",
            'INTERSIGHT': "Intersight",
        },
        ('oper_reason',): {
            'None': None,
            'UNKNOWN': "Unknown",
            'OK': "OK",
            'OFFLINE': "Offline",
            'MISSING': "Missing",
            'TEMPERATUREWARNING': "TemperatureWarning",
            'TEMPERATURECRITICAL': "TemperatureCritical",
            'INPUTVOLTAGEWARNING': "InputVoltageWarning",
            'INPUTVOLTAGECRITICAL': "InputVoltageCritical",
            'OUTPUTVOLTAGEWARNING': "OutputVoltageWarning",
            'OUTPUTVOLTAGECRITICAL': "OutputVoltageCritical",
            'OUTPUTCURRENTWARNING': "OutputCurrentWarning",
            'OUTPUTCURRENTCRITICAL': "OutputCurrentCritical",
            'SPEEDWARNING': "SpeedWarning",
            'SPEEDCRITICAL': "SpeedCritical",
            'FANMISSINGWARNING': "FanMissingWarning",
            'FANSMISSINGCRITICAL': "FansMissingCritical",
            'IOCARDPOSTWARNING': "IocardPostWarning",
            'ASICPOSTWARNING': "AsicPostWarning",
            'FRUSTATECRITICAL': "FruStateCritical",
            'FRUSTATEWARNING': "FruStateWarning",
            'ALTERNATEIMAGEWARNING': "AlternateImageWarning",
            'SELECTEDIMAGEWARNING': "SelectedImageWarning",
            'LOWMEMORYCRITICAL': "LowMemoryCritical",
            'LOWMEMORYWARNING': "LowMemoryWarning",
            'POWERCRITICAL': "PowerCritical",
            'POWERWARNING': "PowerWarning",
            'THERMALSAFEMODECRITICAL': "ThermalSafeModeCritical",
            'PSUREDUNDANCYLOSTCRITICAL': "PsuRedundancyLostCritical",
            'INPUTPOWERWARNING': "InputPowerWarning",
            'INPUTPOWERCRITICAL': "InputPowerCritical",
            'OUTPUTPOWERWARNING': "OutputPowerWarning",
            'OUTPUTPOWERCRITICAL': "OutputPowerCritical",
            'FANGENERALCRITICAL': "FanGeneralCritical",
            'POWERSUPPLYGENERALCRITICAL': "PowerSupplyGeneralCritical",
            'POWERSUPPLYINPUTWARNING': "PowerSupplyInputWarning",
            'POWERSUPPLYOUTPUTCRITICAL': "PowerSupplyOutputCritical",
            'POWERSUPPLYINPUTLOSTWARNING': "PowerSupplyInputLostWarning",
            'POWERSUPPLYUNRESPONSIVECRITICAL': "PowerSupplyUnresponsiveCritical",
            'FANUNRESPONSIVECRITICAL': "FanUnresponsiveCritical",
            'MEMORYUNCORRECTABLEERROR': "MemoryUncorrectableError",
            'MEMORYTEMPERATUREWARNING': "MemoryTemperatureWarning",
            'MEMORYTEMPERATURECRITICAL': "MemoryTemperatureCritical",
            'MEMORYBANKERROR': "MemoryBankError",
            'MEMORYRANKERROR': "MemoryRankError",
            'MEMORYPOPERROR': "MemoryPopError",
            'MEMORYRASERROR': "MemoryRasError",
            'MEMORYMISMATCHERROR': "MemoryMismatchError",
            'MEMORYSPDERROR': "MemorySpdError",
            'MEMORYBISTERROR': "MemoryBistError",
            'MEMORYTYPEERROR': "MemoryTypeError",
            'MOTHERBOARDPOWERCRITICAL': "MotherBoardPowerCritical",
            'MOTHERBOARDTEMPERATUREWARNING': "MotherBoardTemperatureWarning",
            'MOTHERBOARDTEMPERATURECRITICAL': "MotherBoardTemperatureCritical",
            'MOTHERBOARDVOLTAGEWARNING': "MotherBoardVoltageWarning",
            'MOTHERBOARDVOLTAGECRITICAL': "MotherBoardVoltageCritical",
            'PROCESSORCATERR': "ProcessorCatErr",
            'PROCESSORTHERMTRIP': "ProcessorThermTrip",
            'COMPONENTNOTOPERATIONAL': "ComponentNotOperational",
            'OPERATIONALTHROUGHFAILOVER': "OperationalThroughFailover",
            'COMPONENTNOTREACHABLE': "ComponentNotReachable",
            'PROCESSORTEMPERATUREWARNING': "ProcessorTemperatureWarning",
            'PROCESSORTEMPERATURECRITICAL': "ProcessorTemperatureCritical",
            'PCIENODERISERMISMATCH': "PCIeNodeRiserMismatch",
            'PCIENODERISER1MISSING': "PCIeNodeRiser1Missing",
            'PCIENODERISER2PRESENTCPU2ABSENT': "PCIeNodeRiser2PresentCPU2Absent",
            'PCIENODEPCIELINKCONFIGISSUE': "PCIeNodePCIeLinkConfigIssue",
            'PCIENODERISER1POWERFAULT': "PCIeNodeRiser1PowerFault",
            'PCIENODERISER2POWERFAULT': "PCIeNodeRiser2PowerFault",
            'PCIENODEPOWERFAULT': "PCIeNodePowerFault",
            'PCIENODEUNSUPPORTEDPCIECARDPRESENTONRISER1': "PCIeNodeUnsupportedPCIeCardPresentOnRiser1",
            'PCIENODEUNSUPPORTEDPCIECARDPRESENTONRISER2': "PCIeNodeUnsupportedPCIeCardPresentOnRiser2",
            'PCIENODEUNKNOWNPCIECARDPRESENTONRISER1': "PCIeNodeUnknownPCIeCardPresentOnRiser1",
            'PCIENODEUNKNOWNPCIECARDPRESENTONRISER2': "PCIeNodeUnknownPCIeCardPresentOnRiser2",
            'PCIENODEPRESENTXFM1ABSENT': "PCIeNodePresentXFM1Absent",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'alarm_summary': (ComputeAlarmSummary,),  # noqa: E501
            'chassis_id': (int,),  # noqa: E501
            'connection_path': (str,),  # noqa: E501
            'connection_status': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'fault_summary': (int,),  # noqa: E501
            'management_mode': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'oper_reason': ([str], none_type,),  # noqa: E501
            'oper_state': (str,),  # noqa: E501
            'part_number': (str,),  # noqa: E501
            'pid': (str,),  # noqa: E501
            'platform_type': (str,),  # noqa: E501
            'product_name': (str,),  # noqa: E501
            'sku': (str,),  # noqa: E501
            'vid': (str,),  # noqa: E501
            'blades': ([ComputeBladeRelationship], none_type,),  # noqa: E501
            'expander_modules': ([EquipmentExpanderModuleRelationship], none_type,),  # noqa: E501
            'fan_control': (EquipmentFanControlRelationship,),  # noqa: E501
            'fanmodules': ([EquipmentFanModuleRelationship], none_type,),  # noqa: E501
            'inventory_device_info': (InventoryDeviceInfoRelationship,),  # noqa: E501
            'ioms': ([EquipmentIoCardRelationship], none_type,),  # noqa: E501
            'locator_led': (EquipmentLocatorLedRelationship,),  # noqa: E501
            'management_interface': (ManagementInterfaceRelationship,),  # noqa: E501
            'power_control_state': (PowerControlStateRelationship,),  # noqa: E501
            'psu_control': (EquipmentPsuControlRelationship,),  # noqa: E501
            'psus': ([EquipmentPsuRelationship], none_type,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
            'sasexpanders': ([StorageSasExpanderRelationship], none_type,),  # noqa: E501
            'siocs': ([EquipmentSystemIoControllerRelationship], none_type,),  # noqa: E501
            'storage_enclosures': ([StorageEnclosureRelationship], none_type,),  # noqa: E501
            'virtual_drive_container': ([StorageVirtualDriveContainerRelationship], none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'alarm_summary': 'AlarmSummary',  # noqa: E501
        'chassis_id': 'ChassisId',  # noqa: E501
        'connection_path': 'ConnectionPath',  # noqa: E501
        'connection_status': 'ConnectionStatus',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'fault_summary': 'FaultSummary',  # noqa: E501
        'management_mode': 'ManagementMode',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'oper_reason': 'OperReason',  # noqa: E501
        'oper_state': 'OperState',  # noqa: E501
        'part_number': 'PartNumber',  # noqa: E501
        'pid': 'Pid',  # noqa: E501
        'platform_type': 'PlatformType',  # noqa: E501
        'product_name': 'ProductName',  # noqa: E501
        'sku': 'Sku',  # noqa: E501
        'vid': 'Vid',  # noqa: E501
        'blades': 'Blades',  # noqa: E501
        'expander_modules': 'ExpanderModules',  # noqa: E501
        'fan_control': 'FanControl',  # noqa: E501
        'fanmodules': 'Fanmodules',  # noqa: E501
        'inventory_device_info': 'InventoryDeviceInfo',  # noqa: E501
        'ioms': 'Ioms',  # noqa: E501
        'locator_led': 'LocatorLed',  # noqa: E501
        'management_interface': 'ManagementInterface',  # noqa: E501
        'power_control_state': 'PowerControlState',  # noqa: E501
        'psu_control': 'PsuControl',  # noqa: E501
        'psus': 'Psus',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
        'sasexpanders': 'Sasexpanders',  # noqa: E501
        'siocs': 'Siocs',  # noqa: E501
        'storage_enclosures': 'StorageEnclosures',  # noqa: E501
        'virtual_drive_container': 'VirtualDriveContainer',  # noqa: E501
    }

    read_only_vars = {
        'chassis_id',  # noqa: E501
        'connection_path',  # noqa: E501
        'connection_status',  # noqa: E501
        'description',  # noqa: E501
        'management_mode',  # noqa: E501
        'name',  # noqa: E501
        'oper_state',  # noqa: E501
        'part_number',  # noqa: E501
        'pid',  # noqa: E501
        'product_name',  # noqa: E501
        'sku',  # noqa: E501
        'vid',  # noqa: E501
        'blades',  # noqa: E501
        'fanmodules',  # noqa: E501
        'ioms',  # noqa: E501
        'psus',  # noqa: E501
        'sasexpanders',  # noqa: E501
        'siocs',  # noqa: E501
        'storage_enclosures',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """EquipmentChassisAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "equipment.Chassis", must be one of ["equipment.Chassis", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "equipment.Chassis", must be one of ["equipment.Chassis", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            alarm_summary (ComputeAlarmSummary): [optional]  # noqa: E501
            chassis_id (int): The assigned identifier for a chassis.. [optional]  # noqa: E501
            connection_path (str): This field identifies the connectivity path for the chassis enclosure.. [optional]  # noqa: E501
            connection_status (str): This field identifies the connectivity status for the chassis enclosure.. [optional]  # noqa: E501
            description (str): This field is to provide description for chassis model.. [optional]  # noqa: E501
            fault_summary (int): This field summarizes the faults on the chassis enclosure.. [optional]  # noqa: E501
            management_mode (str): The management mode of the blade server chassis. * `IntersightStandalone` - Intersight Standalone mode of operation. * `UCSM` - Unified Computing System Manager mode of operation. * `Intersight` - Intersight managed mode of operation.. [optional] if omitted the server will use the default value of "IntersightStandalone"  # noqa: E501
            name (str): This field identifies the name for the chassis enclosure.. [optional]  # noqa: E501
            oper_reason ([str], none_type): [optional]  # noqa: E501
            oper_state (str): This field identifies the Chassis Operational State.. [optional]  # noqa: E501
            part_number (str): Part Number identifier for the chassis enclosure.. [optional]  # noqa: E501
            pid (str): This field identifies the Product ID for the chassis enclosure.. [optional]  # noqa: E501
            platform_type (str): The platform type that the chassis is a part of.. [optional]  # noqa: E501
            product_name (str): This field identifies the Product Name for the chassis enclosure.. [optional]  # noqa: E501
            sku (str): This field identifies the Stock Keeping Unit for the chassis enclosure.. [optional]  # noqa: E501
            vid (str): This field identifies the Vendor ID for the chassis enclosure.. [optional]  # noqa: E501
            blades ([ComputeBladeRelationship], none_type): An array of relationships to computeBlade resources.. [optional]  # noqa: E501
            expander_modules ([EquipmentExpanderModuleRelationship], none_type): An array of relationships to equipmentExpanderModule resources.. [optional]  # noqa: E501
            fan_control (EquipmentFanControlRelationship): [optional]  # noqa: E501
            fanmodules ([EquipmentFanModuleRelationship], none_type): An array of relationships to equipmentFanModule resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            ioms ([EquipmentIoCardRelationship], none_type): An array of relationships to equipmentIoCard resources.. [optional]  # noqa: E501
            locator_led (EquipmentLocatorLedRelationship): [optional]  # noqa: E501
            management_interface (ManagementInterfaceRelationship): [optional]  # noqa: E501
            power_control_state (PowerControlStateRelationship): [optional]  # noqa: E501
            psu_control (EquipmentPsuControlRelationship): [optional]  # noqa: E501
            psus ([EquipmentPsuRelationship], none_type): An array of relationships to equipmentPsu resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            sasexpanders ([StorageSasExpanderRelationship], none_type): An array of relationships to storageSasExpander resources.. [optional]  # noqa: E501
            siocs ([EquipmentSystemIoControllerRelationship], none_type): An array of relationships to equipmentSystemIoController resources.. [optional]  # noqa: E501
            storage_enclosures ([StorageEnclosureRelationship], none_type): An array of relationships to storageEnclosure resources.. [optional]  # noqa: E501
            virtual_drive_container ([StorageVirtualDriveContainerRelationship], none_type): An array of relationships to storageVirtualDriveContainer resources.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "equipment.Chassis")
        object_type = kwargs.get('object_type', "equipment.Chassis")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """EquipmentChassisAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "equipment.Chassis", must be one of ["equipment.Chassis", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "equipment.Chassis", must be one of ["equipment.Chassis", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            alarm_summary (ComputeAlarmSummary): [optional]  # noqa: E501
            chassis_id (int): The assigned identifier for a chassis.. [optional]  # noqa: E501
            connection_path (str): This field identifies the connectivity path for the chassis enclosure.. [optional]  # noqa: E501
            connection_status (str): This field identifies the connectivity status for the chassis enclosure.. [optional]  # noqa: E501
            description (str): This field is to provide description for chassis model.. [optional]  # noqa: E501
            fault_summary (int): This field summarizes the faults on the chassis enclosure.. [optional]  # noqa: E501
            management_mode (str): The management mode of the blade server chassis. * `IntersightStandalone` - Intersight Standalone mode of operation. * `UCSM` - Unified Computing System Manager mode of operation. * `Intersight` - Intersight managed mode of operation.. [optional] if omitted the server will use the default value of "IntersightStandalone"  # noqa: E501
            name (str): This field identifies the name for the chassis enclosure.. [optional]  # noqa: E501
            oper_reason ([str], none_type): [optional]  # noqa: E501
            oper_state (str): This field identifies the Chassis Operational State.. [optional]  # noqa: E501
            part_number (str): Part Number identifier for the chassis enclosure.. [optional]  # noqa: E501
            pid (str): This field identifies the Product ID for the chassis enclosure.. [optional]  # noqa: E501
            platform_type (str): The platform type that the chassis is a part of.. [optional]  # noqa: E501
            product_name (str): This field identifies the Product Name for the chassis enclosure.. [optional]  # noqa: E501
            sku (str): This field identifies the Stock Keeping Unit for the chassis enclosure.. [optional]  # noqa: E501
            vid (str): This field identifies the Vendor ID for the chassis enclosure.. [optional]  # noqa: E501
            blades ([ComputeBladeRelationship], none_type): An array of relationships to computeBlade resources.. [optional]  # noqa: E501
            expander_modules ([EquipmentExpanderModuleRelationship], none_type): An array of relationships to equipmentExpanderModule resources.. [optional]  # noqa: E501
            fan_control (EquipmentFanControlRelationship): [optional]  # noqa: E501
            fanmodules ([EquipmentFanModuleRelationship], none_type): An array of relationships to equipmentFanModule resources.. [optional]  # noqa: E501
            inventory_device_info (InventoryDeviceInfoRelationship): [optional]  # noqa: E501
            ioms ([EquipmentIoCardRelationship], none_type): An array of relationships to equipmentIoCard resources.. [optional]  # noqa: E501
            locator_led (EquipmentLocatorLedRelationship): [optional]  # noqa: E501
            management_interface (ManagementInterfaceRelationship): [optional]  # noqa: E501
            power_control_state (PowerControlStateRelationship): [optional]  # noqa: E501
            psu_control (EquipmentPsuControlRelationship): [optional]  # noqa: E501
            psus ([EquipmentPsuRelationship], none_type): An array of relationships to equipmentPsu resources.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
            sasexpanders ([StorageSasExpanderRelationship], none_type): An array of relationships to storageSasExpander resources.. [optional]  # noqa: E501
            siocs ([EquipmentSystemIoControllerRelationship], none_type): An array of relationships to equipmentSystemIoController resources.. [optional]  # noqa: E501
            storage_enclosures ([StorageEnclosureRelationship], none_type): An array of relationships to storageEnclosure resources.. [optional]  # noqa: E501
            virtual_drive_container ([StorageVirtualDriveContainerRelationship], none_type): An array of relationships to storageVirtualDriveContainer resources.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "equipment.Chassis")
        object_type = kwargs.get('object_type', "equipment.Chassis")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
