# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *

__all__ = ['RoleForServiceAccountsEksArgs', 'RoleForServiceAccountsEks']

@pulumi.input_type
class RoleForServiceAccountsEksArgs:
    def __init__(__self__, *,
                 assume_role_condition_test: Optional[pulumi.Input[str]] = None,
                 force_detach_policies: Optional[pulumi.Input[bool]] = None,
                 max_session_duration: Optional[pulumi.Input[int]] = None,
                 oidc_providers: Optional[pulumi.Input[Mapping[str, pulumi.Input['OIDCProviderArgs']]]] = None,
                 policies: Optional[pulumi.Input['EKSRolePoliciesArgs']] = None,
                 policy_name_prefix: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input['EKSServiceAccountRoleArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a RoleForServiceAccountsEks resource.
        :param pulumi.Input[str] assume_role_condition_test: Name of the IAM condition operator to evaluate when assuming the role.
        :param pulumi.Input[bool] force_detach_policies: Whether policies should be detached from this role when destroying.
        :param pulumi.Input[int] max_session_duration: Maximum CLI/API session duration in seconds between 3600 and 43200.
        :param pulumi.Input[Mapping[str, pulumi.Input['OIDCProviderArgs']]] oidc_providers: Map of OIDC providers.
        :param pulumi.Input[str] policy_name_prefix: IAM policy name prefix.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        if assume_role_condition_test is None:
            assume_role_condition_test = 'StringEquals'
        if assume_role_condition_test is not None:
            pulumi.set(__self__, "assume_role_condition_test", assume_role_condition_test)
        if force_detach_policies is None:
            force_detach_policies = False
        if force_detach_policies is not None:
            pulumi.set(__self__, "force_detach_policies", force_detach_policies)
        if max_session_duration is None:
            max_session_duration = 3600
        if max_session_duration is not None:
            pulumi.set(__self__, "max_session_duration", max_session_duration)
        if oidc_providers is not None:
            pulumi.set(__self__, "oidc_providers", oidc_providers)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if policy_name_prefix is None:
            policy_name_prefix = 'AmazonEKS_'
        if policy_name_prefix is not None:
            pulumi.set(__self__, "policy_name_prefix", policy_name_prefix)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="assumeRoleConditionTest")
    def assume_role_condition_test(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the IAM condition operator to evaluate when assuming the role.
        """
        return pulumi.get(self, "assume_role_condition_test")

    @assume_role_condition_test.setter
    def assume_role_condition_test(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assume_role_condition_test", value)

    @property
    @pulumi.getter(name="forceDetachPolicies")
    def force_detach_policies(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether policies should be detached from this role when destroying.
        """
        return pulumi.get(self, "force_detach_policies")

    @force_detach_policies.setter
    def force_detach_policies(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_detach_policies", value)

    @property
    @pulumi.getter(name="maxSessionDuration")
    def max_session_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum CLI/API session duration in seconds between 3600 and 43200.
        """
        return pulumi.get(self, "max_session_duration")

    @max_session_duration.setter
    def max_session_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_session_duration", value)

    @property
    @pulumi.getter(name="oidcProviders")
    def oidc_providers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['OIDCProviderArgs']]]]:
        """
        Map of OIDC providers.
        """
        return pulumi.get(self, "oidc_providers")

    @oidc_providers.setter
    def oidc_providers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['OIDCProviderArgs']]]]):
        pulumi.set(self, "oidc_providers", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input['EKSRolePoliciesArgs']]:
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input['EKSRolePoliciesArgs']]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="policyNamePrefix")
    def policy_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        IAM policy name prefix.
        """
        return pulumi.get(self, "policy_name_prefix")

    @policy_name_prefix.setter
    def policy_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name_prefix", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input['EKSServiceAccountRoleArgs']]:
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input['EKSServiceAccountRoleArgs']]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to add.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class RoleForServiceAccountsEks(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role_condition_test: Optional[pulumi.Input[str]] = None,
                 force_detach_policies: Optional[pulumi.Input[bool]] = None,
                 max_session_duration: Optional[pulumi.Input[int]] = None,
                 oidc_providers: Optional[pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['OIDCProviderArgs']]]]] = None,
                 policies: Optional[pulumi.Input[pulumi.InputType['EKSRolePoliciesArgs']]] = None,
                 policy_name_prefix: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[pulumi.InputType['EKSServiceAccountRoleArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a RoleForServiceAccountsEks resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assume_role_condition_test: Name of the IAM condition operator to evaluate when assuming the role.
        :param pulumi.Input[bool] force_detach_policies: Whether policies should be detached from this role when destroying.
        :param pulumi.Input[int] max_session_duration: Maximum CLI/API session duration in seconds between 3600 and 43200.
        :param pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['OIDCProviderArgs']]]] oidc_providers: Map of OIDC providers.
        :param pulumi.Input[str] policy_name_prefix: IAM policy name prefix.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to add.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RoleForServiceAccountsEksArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a RoleForServiceAccountsEks resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param RoleForServiceAccountsEksArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleForServiceAccountsEksArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assume_role_condition_test: Optional[pulumi.Input[str]] = None,
                 force_detach_policies: Optional[pulumi.Input[bool]] = None,
                 max_session_duration: Optional[pulumi.Input[int]] = None,
                 oidc_providers: Optional[pulumi.Input[Mapping[str, pulumi.Input[pulumi.InputType['OIDCProviderArgs']]]]] = None,
                 policies: Optional[pulumi.Input[pulumi.InputType['EKSRolePoliciesArgs']]] = None,
                 policy_name_prefix: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[pulumi.InputType['EKSServiceAccountRoleArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleForServiceAccountsEksArgs.__new__(RoleForServiceAccountsEksArgs)

            if assume_role_condition_test is None:
                assume_role_condition_test = 'StringEquals'
            __props__.__dict__["assume_role_condition_test"] = assume_role_condition_test
            if force_detach_policies is None:
                force_detach_policies = False
            __props__.__dict__["force_detach_policies"] = force_detach_policies
            if max_session_duration is None:
                max_session_duration = 3600
            __props__.__dict__["max_session_duration"] = max_session_duration
            __props__.__dict__["oidc_providers"] = oidc_providers
            __props__.__dict__["policies"] = policies
            if policy_name_prefix is None:
                policy_name_prefix = 'AmazonEKS_'
            __props__.__dict__["policy_name_prefix"] = policy_name_prefix
            __props__.__dict__["role"] = role
            __props__.__dict__["tags"] = tags
        super(RoleForServiceAccountsEks, __self__).__init__(
            'aws-iam:index:RoleForServiceAccountsEks',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "role")

