# coding: utf-8

"""
    nlpapiv2

    The powerful Natural Language Processing APIs (v2) let you perform part of speech tagging, entity identification, sentence parsing, and much more to help you understand the meaning of unstructured text.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class WordPosition(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'word': 'str',
        'word_index': 'int',
        'start_position': 'int',
        'end_position': 'int'
    }

    attribute_map = {
        'word': 'Word',
        'word_index': 'WordIndex',
        'start_position': 'StartPosition',
        'end_position': 'EndPosition'
    }

    def __init__(self, word=None, word_index=None, start_position=None, end_position=None):  # noqa: E501
        """WordPosition - a model defined in Swagger"""  # noqa: E501

        self._word = None
        self._word_index = None
        self._start_position = None
        self._end_position = None
        self.discriminator = None

        if word is not None:
            self.word = word
        if word_index is not None:
            self.word_index = word_index
        if start_position is not None:
            self.start_position = start_position
        if end_position is not None:
            self.end_position = end_position

    @property
    def word(self):
        """Gets the word of this WordPosition.  # noqa: E501

        Word as a string  # noqa: E501

        :return: The word of this WordPosition.  # noqa: E501
        :rtype: str
        """
        return self._word

    @word.setter
    def word(self, word):
        """Sets the word of this WordPosition.

        Word as a string  # noqa: E501

        :param word: The word of this WordPosition.  # noqa: E501
        :type: str
        """

        self._word = word

    @property
    def word_index(self):
        """Gets the word_index of this WordPosition.  # noqa: E501

        Zero-based index of the word; first word has index 0, second word has index 1 and so on  # noqa: E501

        :return: The word_index of this WordPosition.  # noqa: E501
        :rtype: int
        """
        return self._word_index

    @word_index.setter
    def word_index(self, word_index):
        """Sets the word_index of this WordPosition.

        Zero-based index of the word; first word has index 0, second word has index 1 and so on  # noqa: E501

        :param word_index: The word_index of this WordPosition.  # noqa: E501
        :type: int
        """

        self._word_index = word_index

    @property
    def start_position(self):
        """Gets the start_position of this WordPosition.  # noqa: E501

        Zero-based character offset at which the word begins in the input string  # noqa: E501

        :return: The start_position of this WordPosition.  # noqa: E501
        :rtype: int
        """
        return self._start_position

    @start_position.setter
    def start_position(self, start_position):
        """Sets the start_position of this WordPosition.

        Zero-based character offset at which the word begins in the input string  # noqa: E501

        :param start_position: The start_position of this WordPosition.  # noqa: E501
        :type: int
        """

        self._start_position = start_position

    @property
    def end_position(self):
        """Gets the end_position of this WordPosition.  # noqa: E501

        Zero-based character offset at which the word ends in the input string  # noqa: E501

        :return: The end_position of this WordPosition.  # noqa: E501
        :rtype: int
        """
        return self._end_position

    @end_position.setter
    def end_position(self, end_position):
        """Sets the end_position of this WordPosition.

        Zero-based character offset at which the word ends in the input string  # noqa: E501

        :param end_position: The end_position of this WordPosition.  # noqa: E501
        :type: int
        """

        self._end_position = end_position

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WordPosition, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WordPosition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
