# Code generated by "autogen"; DO NOT EDIT
# Copyright 2020 Aptpod, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import io
from enum import Enum

from . import data, field


def type2filter(data_type):
    if data_type == data.DataType.can.value:
        return Can
    if data_type == data.DataType.nmea.value:
        return Nmea
    if data_type == data.DataType.general_sensor.value:
        return GeneralSensor
    if data_type == data.DataType.generic.value:
        return Generic
    if data_type == data.DataType.float.value:
        return Float
    if data_type == data.DataType.int.value:
        return Int
    if data_type == data.DataType.string.value:
        return String
    if data_type == data.DataType.bytes.value:
        return Bytes
    raise NotImplementedError


def filter2type(filter):
    if type(filter) == Can:
        return data.DataType.can.value
    if type(filter) == Nmea:
        return data.DataType.nmea.value
    if type(filter) == GeneralSensor:
        return data.DataType.general_sensor.value
    if type(filter) == Generic:
        return data.DataType.generic.value
    if type(filter) == Float:
        return data.DataType.float.value
    if type(filter) == Int:
        return data.DataType.int.value
    if type(filter) == String:
        return data.DataType.string.value
    if type(filter) == Bytes:
        return data.DataType.bytes.value
    raise NotImplementedError


class Can(object):
    def __init__(self, spec_num, specs):
        self.spec_num = spec_num
        self.specs = specs

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        spec_num = field.Uint8._read_from(rd)
        specs = [CanSpec._read_from(rd) for i in range(spec_num.value)]
        return Can(spec_num=spec_num, specs=specs)

    def _write_to(self, wr: io.BufferedWriter):
        self.spec_num._write_to(wr)
        [x._write_to(wr) for x in self.specs]

    def _length(self):
        l = 0
        l += self.spec_num._length()
        l += sum([v._length() for v in self.specs])
        return l


class CanSpec(object):
    def __init__(self, mask, result, flags):
        self.mask = mask
        self.result = result
        self.flags = flags

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        mask = field.Uint32._read_from(rd)
        result = field.Uint32._read_from(rd)
        flags = field.Uint8._read_from(rd)
        return CanSpec(mask=mask, result=result, flags=flags)

    def _write_to(self, wr: io.BufferedWriter):
        self.mask._write_to(wr)
        self.result._write_to(wr)
        self.flags._write_to(wr)

    def _length(self):
        l = 0
        l += self.mask._length()
        l += self.result._length()
        l += self.flags._length()
        return l

    @property
    def accept(self):
        return ((self.flags.value & 1) >> 0) == 1

    @accept.setter
    def accept(self, v):
        i = 1 if v else 0
        self.flags.value = self.flags.value | 1 & (i << 0)


class Nmea(object):
    def __init__(self, spec_num, specs):
        self.spec_num = spec_num
        self.specs = specs

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        spec_num = field.Uint8._read_from(rd)
        specs = [NmeaSpec._read_from(rd) for i in range(spec_num.value)]
        return Nmea(spec_num=spec_num, specs=specs)

    def _write_to(self, wr: io.BufferedWriter):
        self.spec_num._write_to(wr)
        [x._write_to(wr) for x in self.specs]

    def _length(self):
        l = 0
        l += self.spec_num._length()
        l += sum([v._length() for v in self.specs])
        return l


class NmeaSpec(object):
    def __init__(self, mask, result, flags):
        self.mask = mask
        self.result = result
        self.flags = flags

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        mask = field.Uint40._read_from(rd)
        result = field.Uint40._read_from(rd)
        flags = field.Uint8._read_from(rd)
        return NmeaSpec(mask=mask, result=result, flags=flags)

    def _write_to(self, wr: io.BufferedWriter):
        self.mask._write_to(wr)
        self.result._write_to(wr)
        self.flags._write_to(wr)

    def _length(self):
        l = 0
        l += self.mask._length()
        l += self.result._length()
        l += self.flags._length()
        return l

    @property
    def accept(self):
        return ((self.flags.value & 1) >> 0) == 1

    @accept.setter
    def accept(self, v):
        i = 1 if v else 0
        self.flags.value = self.flags.value | 1 & (i << 0)


class GeneralSensor(object):
    def __init__(self, spec_num, specs):
        self.spec_num = spec_num
        self.specs = specs

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        spec_num = field.Uint8._read_from(rd)
        specs = [GeneralSensorSpec._read_from(rd) for i in range(spec_num.value)]
        return GeneralSensor(spec_num=spec_num, specs=specs)

    def _write_to(self, wr: io.BufferedWriter):
        self.spec_num._write_to(wr)
        [x._write_to(wr) for x in self.specs]

    def _length(self):
        l = 0
        l += self.spec_num._length()
        l += sum([v._length() for v in self.specs])
        return l


class GeneralSensorSpec(object):
    def __init__(self, mask, result, flags):
        self.mask = mask
        self.result = result
        self.flags = flags

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        mask = field.Uint16._read_from(rd)
        result = field.Uint16._read_from(rd)
        flags = field.Uint8._read_from(rd)
        return GeneralSensorSpec(mask=mask, result=result, flags=flags)

    def _write_to(self, wr: io.BufferedWriter):
        self.mask._write_to(wr)
        self.result._write_to(wr)
        self.flags._write_to(wr)

    def _length(self):
        l = 0
        l += self.mask._length()
        l += self.result._length()
        l += self.flags._length()
        return l

    @property
    def accept(self):
        return ((self.flags.value & 1) >> 0) == 1

    @accept.setter
    def accept(self, v):
        i = 1 if v else 0
        self.flags.value = self.flags.value | 1 & (i << 0)


class Generic(object):
    def __init__(self, spec_num, specs):
        self.spec_num = spec_num
        self.specs = specs

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        spec_num = field.Uint8._read_from(rd)
        specs = [GenericSpec._read_from(rd) for i in range(spec_num.value)]
        return Generic(spec_num=spec_num, specs=specs)

    def _write_to(self, wr: io.BufferedWriter):
        self.spec_num._write_to(wr)
        [x._write_to(wr) for x in self.specs]

    def _length(self):
        l = 0
        l += self.spec_num._length()
        l += sum([v._length() for v in self.specs])
        return l


class GenericSpec(object):
    def __init__(self, mask, result, flags):
        self.mask = mask
        self.result = result
        self.flags = flags

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        mask = field.Uint32._read_from(rd)
        result = field.Uint32._read_from(rd)
        flags = field.Uint8._read_from(rd)
        return GenericSpec(mask=mask, result=result, flags=flags)

    def _write_to(self, wr: io.BufferedWriter):
        self.mask._write_to(wr)
        self.result._write_to(wr)
        self.flags._write_to(wr)

    def _length(self):
        l = 0
        l += self.mask._length()
        l += self.result._length()
        l += self.flags._length()
        return l

    @property
    def accept(self):
        return ((self.flags.value & 1) >> 0) == 1

    @accept.setter
    def accept(self, v):
        i = 1 if v else 0
        self.flags.value = self.flags.value | 1 & (i << 0)


class Float(object):
    def __init__(self, spec_num, specs):
        self.spec_num = spec_num
        self.specs = specs

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        spec_num = field.Uint8._read_from(rd)
        specs = [PrimitiveSpec._read_from(rd) for i in range(spec_num.value)]
        return Float(spec_num=spec_num, specs=specs)

    def _write_to(self, wr: io.BufferedWriter):
        self.spec_num._write_to(wr)
        [x._write_to(wr) for x in self.specs]

    def _length(self):
        l = 0
        l += self.spec_num._length()
        l += sum([v._length() for v in self.specs])
        return l


class Int(object):
    def __init__(self, spec_num, specs):
        self.spec_num = spec_num
        self.specs = specs

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        spec_num = field.Uint8._read_from(rd)
        specs = [PrimitiveSpec._read_from(rd) for i in range(spec_num.value)]
        return Int(spec_num=spec_num, specs=specs)

    def _write_to(self, wr: io.BufferedWriter):
        self.spec_num._write_to(wr)
        [x._write_to(wr) for x in self.specs]

    def _length(self):
        l = 0
        l += self.spec_num._length()
        l += sum([v._length() for v in self.specs])
        return l


class String(object):
    def __init__(self, spec_num, specs):
        self.spec_num = spec_num
        self.specs = specs

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        spec_num = field.Uint8._read_from(rd)
        specs = [PrimitiveSpec._read_from(rd) for i in range(spec_num.value)]
        return String(spec_num=spec_num, specs=specs)

    def _write_to(self, wr: io.BufferedWriter):
        self.spec_num._write_to(wr)
        [x._write_to(wr) for x in self.specs]

    def _length(self):
        l = 0
        l += self.spec_num._length()
        l += sum([v._length() for v in self.specs])
        return l


class Bytes(object):
    def __init__(self, spec_num, specs):
        self.spec_num = spec_num
        self.specs = specs

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        spec_num = field.Uint8._read_from(rd)
        specs = [PrimitiveSpec._read_from(rd) for i in range(spec_num.value)]
        return Bytes(spec_num=spec_num, specs=specs)

    def _write_to(self, wr: io.BufferedWriter):
        self.spec_num._write_to(wr)
        [x._write_to(wr) for x in self.specs]

    def _length(self):
        l = 0
        l += self.spec_num._length()
        l += sum([v._length() for v in self.specs])
        return l


class PrimitiveSpec(object):
    def __init__(self, label_length, label):
        self.label_length = label_length
        self.label = label

    @staticmethod
    def _read_from(rd: io.BufferedReader):
        label_length = field.Uint8._read_from(rd)
        label = field.String._read_n_from(rd, label_length.value)
        return PrimitiveSpec(label_length=label_length, label=label)

    def _write_to(self, wr: io.BufferedWriter):
        self.label_length._write_to(wr)
        self.label._write_to(wr)

    def _length(self):
        l = 0
        l += self.label_length._length()
        l += self.label._length()
        return l
