"""
This module provides interfaces defined in DB-API 2.0.
"""
from typing import Protocol, Any, Optional
from collections.abc import Sequence


class Cursor(Protocol):
    @property
    def description(self) -> str: ...
    @property
    def rowcount(self) -> int: ...
    @property
    def arraysize(self) -> int: ...

    #def callproc(self, procname: str, *args, **kwargs) -> Any: ...
    #def nextset(self) -> bool: ...
    def close(self) -> None: ...
    def execute(self, operation: str, *args, **kwargs) -> Any: ...
    def executemany(self, operation: str, seq_of_parameters: Sequence[Any]) -> Any: ...
    def fetchone(self) -> Optional[Sequence[Any]]: ...
    def fetchmany(self, size: int = 0) -> Sequence[Sequence[Any]]: ...
    def fetchall(self) -> Sequence[Sequence[Any]]: ...
    def setinputsizes(self, sizes: Sequence[Any]): ...
    def setoutputsize(self, size: int, column: int): ...


class Connection(Protocol):
    def close(self) -> None: ...
    def commit(self) -> None: ...
    def rollback(self) -> None: ...
    def cursor(self) -> Cursor: ...