# Generated by Django 2.2.11 on 2020-03-24 22:07

from django.db import migrations, models
import django.db.models.deletion
import pretix.base.models.base
import pretix_landing_pages.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('pretixbase', '0146_giftcardtransaction_text'),
    ]

    operations = [
        migrations.CreateModel(
            name='LandingpageSettings',
            fields=[
                ('organizer', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='pretixbase.Organizer')),
                ('active', models.BooleanField(default=False)),
                ('index', models.FileField(default=None, null=True, storage=pretix_landing_pages.models.OverwriteStorage('data'), upload_to=pretix_landing_pages.models.get_upload_path)),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, pretix.base.models.base.LoggingMixin),
        ),
        migrations.CreateModel(
            name='StartingpageFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('file', models.FileField(storage=pretix_landing_pages.models.OverwriteStorage('data/media'), upload_to=pretix_landing_pages.models.get_startingpage_path)),
                ('filename', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, pretix.base.models.base.LoggingMixin),
        ),
        migrations.CreateModel(
            name='StartingpageSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('startingpage_active', models.BooleanField(default=False)),
                ('index', models.FileField(default=None, null=True, storage=pretix_landing_pages.models.OverwriteStorage('data'), upload_to=pretix_landing_pages.models.get_startingpage_path)),
                ('redirect_active', models.BooleanField(default=False)),
                ('redirect_link', models.URLField()),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, pretix.base.models.base.LoggingMixin),
        ),
        migrations.CreateModel(
            name='LandingpageFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('file', models.FileField(storage=pretix_landing_pages.models.OverwriteStorage('data/media'), upload_to=pretix_landing_pages.models.get_upload_path)),
                ('filename', models.CharField(max_length=255)),
                ('organizer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='pretixbase.Organizer')),
            ],
            options={
                'unique_together': {('organizer', 'filename')},
            },
            bases=(models.Model, pretix.base.models.base.LoggingMixin),
        ),
    ]
