from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Timing:
	"""Timing commands group definition. 2 total commands, 2 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("timing", core, parent)

	@property
	def offset(self):
		"""offset commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_offset'):
			from .Timing_.Offset import Offset
			self._offset = Offset(self._core, self._base)
		return self._offset

	@property
	def sfnOffset(self):
		"""sfnOffset commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_sfnOffset'):
			from .Timing_.SfnOffset import SfnOffset
			self._sfnOffset = SfnOffset(self._core, self._base)
		return self._sfnOffset

	def clone(self) -> 'Timing':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Timing(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group
