from ......Internal.Core import Core
from ......Internal.CommandsGroup import CommandsGroup


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Ssb:
	"""Ssb commands group definition. 4 total commands, 3 Sub-groups, 0 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("ssb", core, parent)

	@property
	def soffset(self):
		"""soffset commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_soffset'):
			from .Ssb_.Soffset import Soffset
			self._soffset = Soffset(self._core, self._base)
		return self._soffset

	@property
	def paOffset(self):
		"""paOffset commands group. 0 Sub-classes, 1 commands."""
		if not hasattr(self, '_paOffset'):
			from .Ssb_.PaOffset import PaOffset
			self._paOffset = PaOffset(self._core, self._base)
		return self._paOffset

	@property
	def afrequency(self):
		"""afrequency commands group. 2 Sub-classes, 0 commands."""
		if not hasattr(self, '_afrequency'):
			from .Ssb_.Afrequency import Afrequency
			self._afrequency = Afrequency(self._core, self._base)
		return self._afrequency

	def clone(self) -> 'Ssb':
		"""Clones the group by creating new object from it and its whole existing sub-groups
		Also copies all the existing default Repeated Capabilities setting,
		which you can change independently without affecting the original group"""
		new_group = Ssb(self._core, self._base.parent)
		self._base.synchronize_repcaps(new_group)
		return new_group
