from ........Internal.Core import Core
from ........Internal.CommandsGroup import CommandsGroup
from ........Internal import Conversions
from ........Internal.Types import DataType
from ........Internal.ArgSingleList import ArgSingleList
from ........Internal.ArgSingle import ArgSingle


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Rblocks:
	"""Rblocks commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._base = CommandsGroup("rblocks", core, parent)

	def set(self, cell_name: str, resource_blocks: int) -> None:
		"""SCPI: [CONFigure]:SIGNaling:LTE:CELL:RFSettings:DL:RBLocks \n
		Snippet: driver.configure.signaling.lte.cell.rfSettings.downlink.rblocks.set(cell_name = '1', resource_blocks = 1) \n
		Selects the number of downlink RBs for full allocation and thus the downlink channel bandwidth. \n
			:param cell_name: No help available
			:param resource_blocks: No help available
		"""
		param = ArgSingleList().compose_cmd_string(ArgSingle('cell_name', cell_name, DataType.String), ArgSingle('resource_blocks', resource_blocks, DataType.Integer))
		self._core.io.write(f'CONFigure:SIGNaling:LTE:CELL:RFSettings:DL:RBLocks {param}'.rstrip())

	def get(self, cell_name: str) -> int:
		"""SCPI: [CONFigure]:SIGNaling:LTE:CELL:RFSettings:DL:RBLocks \n
		Snippet: value: int = driver.configure.signaling.lte.cell.rfSettings.downlink.rblocks.get(cell_name = '1') \n
		Selects the number of downlink RBs for full allocation and thus the downlink channel bandwidth. \n
			:param cell_name: No help available
			:return: resource_blocks: No help available"""
		param = Conversions.value_to_quoted_str(cell_name)
		response = self._core.io.query_str(f'CONFigure:SIGNaling:LTE:CELL:RFSettings:DL:RBLocks? {param}')
		return Conversions.str_to_int(response)
