
# Overview

Pressio is an open-source computational framework aimed at advancing
the field of reduced-order models (ROMs) for dynamical systems in science and engineering.

Model reduction is a broad and very active field.
Many methods exist, but there is no such thing as "one method to rule them all".
We believe that evaluating the quality of a reduced model requires accounting
for several factors, e.g., the reduction in degrees of freedom, training cost,
evaluation cost, robustness, simplicity, predictive accuracy, etc.
There is no single metric to rely on; it is always a tradeoff.

We believe that there is a lot to explore in this field both in terms
of new research directions as well as assessing robustness of current state-of-the-art methods.
There is no better way than an agile Python framework to incentivize
and foster work to impact this field. Working towards this goal,
pressio4py is our open source contribution to research novel fundamental
ideas on model reduction as well as test state-of-the-art methods on problems
of arbitrary complexity and from arbitrary disciplines. Python is the perfect
language to do so because it benefits from a large community of developers
and has become the de-facto choice for machine learning.
This offers an ideal framework to explore and merge ideas from different fields.

[![](https://img.shields.io/website?label=EXPLORE%20THE%20DOCUMENTATION&url=https%3A%2F%2Fpressio.github.io%2Fpressio4py%2Fhtml%2Findex.html)](https://pressio.github.io/pressio4py/html/index.html)

<!-- [![License](https://img.shields.io/badge/-EXPLORE%20THE%20DOCUMENTATION-brightgreen)](https://opensource.org/licenses/BSD-3-Clause) -->

<!-- <br/>
-> <button name="button" onclick="https://pressio.github.io/pressio4py/html/index.html" style="font-size: larger; color: black; background-color: #96FF33; border: 3pt">EXPLORE THE DOCUMENTATION</button> <- -->

## Questions? Comments?

Open an issue on [github](https://github.com/Pressio/pressio4py), or find us on Slack: https://pressioteam.slack.com.

## License and Citation

The full license is available [here](https://pressio.github.io/various/license/).

[![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause)


We are working on publishing this: you can find our arXiv preprint at: https://arxiv.org/abs/2003.07798.
