# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/log.ipynb (unless otherwise specified).

__all__ = ['LogHandlerWidget']

# Cell
import logging
import ipywidgets as ipyw

# Cell
class LogHandlerWidget( ipyw.Textarea, logging.Handler):

    def __init__(self, **kwargs):
        layout = {'width': '100%', 'height': '250px'}
        super().__init__(layout=layout, disabled=True, **kwargs)
        self.name = 'Log'
        self.level = logging.INFO
        self.setFormatter(logging.Formatter('[%(levelname)s]%(name)s:%(lineno)d: %(message)s'))

    def emit(self, record):
        ''' Overload of logging.Handler method '''
        formatted_record = self.format(record)
        self.value += str(formatted_record) + '\n'

    def js(self, level, msg):
        self.value += '[JS-' + str(level) + ']: ' + str(msg) + '\n'

    def clear(self):
        self.value = ''

    def getLogger(self, name):
        logger = logging.getLogger(name)
        logger.setLevel(self.level)
        logger.addHandler(self)
        return logger