# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/correlation.ipynb (unless otherwise specified).

__all__ = ['CorrModelDropdown', 'CorrlationLandingView', 'CorrelationEstimatesModel', 'CorrPearson', 'CorrPBi',
           'CorrSpearmansRho', 'CorrCramerV', 'CorrTetra', 'CorrelationEstimatesView']

# Cell
import ipywidgets as ipyw
import traitlets
from traitlets import observe, Unicode
import numpy as np
from fastcore.test import test_eq
from IPython.display import display, Javascript

# Cell
from .custom_widgets.ratio import RatioLandingView, RatioEstimatesModel, RatioEstimatesView
from .view.widget_collections import VBox, Box, HBox
from .view.widgets import Textarea, Button
from .model.model import RFunction
from .model.model_collections import Collection
from .rpy import Float, IntArray, Int
from .globals import LinkAllMixin, AddStringsMixin

# Cell
class CorrModelDropdown(ipyw.Dropdown):

    def __init__(self):
        corrModelOptions = [('Pearson\'s Correlation Coefficient', 'pears'),
                            ('Point-biserial', 'point'),
                            ('Spearman\'s rho', 'spear'),
                            ('Cramer\'s V', 'cramer'),
                            ('Tetrachoric', 'tetra')]
        super().__init__(options=corrModelOptions,
            description='Coefficient: ',
            layout=ipyw.Layout(max_width='350px',description_width='100px')
        )

# Cell
class CorrlationLandingView(VBox):
    def __init__(self, dropdown, **kwargs):
        super().__init__(**kwargs)
        ratioLandingView = RatioLandingView(name='ratioLandingView')
        self.children = (dropdown, ratioLandingView)

        # observe dropdown takes place at the global level

# Cell
class CorrelationEstimatesModel(RatioEstimatesModel):

    N = Int()
    r = Float()
    tail = Unicode()
    alternative = Unicode()

    def __init__(self, **kwargs):
        self.r = 0
        self.tail = 'two'
        self.alternative = 'two sided'
        traitlets.directional_link((self, 'alternative'), (self, 'tail'), self.alt_to_tail)
        super().__init__(**kwargs)

    def alt_to_tail(self, change):
        if change == 'two sided':
            return 'two'
        else:
            return 'one'

# Cell
class CorrPearson(RFunction): # one
    argNames = ['N', 'r', 'alternative']
    def __init__(self, argNames=argNames, **kwargs):
        super().__init__(name='corrPearson', argNames=argNames, **kwargs)

class CorrPBi(RFunction): # two
    argNames = ['N', 'r', 'tail']
    def __init__(self, argNames=argNames, **kwargs):
        super().__init__(name='corrPBi', argNames=argNames, **kwargs)

class CorrSpearmansRho(RFunction): # one
    argNames = ['N', 'r', 'alternative']
    def __init__(self, argNames=argNames, **kwargs):
        super().__init__(name='corrSpearmansRho', argNames=argNames, **kwargs)

class CorrCramerV(RFunction): # one
    argNames=['n_row', 'n_col', 'alternative', 'ns_cells', 'N']
    def __init__(self, argNames=argNames, **kwargs):
        super().__init__(name='corrCramerV', argNames=argNames, **kwargs)

class CorrTetra(RFunction): # two
    argNames=['n_row', 'n_col', 'tail', 'ns_cells', 'N']
    def __init__(self, argNames=argNames, **kwargs):
        super().__init__(name='corrTetra', argNames=argNames, **kwargs)

# Cell
class CorrelationEstimatesView(HBox, LinkAllMixin):

    model_name = Unicode('corrCramerV')

    def __init__(self, **kwargs):
        super().__init__(layout = ipyw.Layout(width='100%'), **kwargs)

        self.model = CorrelationEstimatesModel()
        self.funcs = {}
        self.funcs['corrCramerV'] = CorrCramerV()
        self.funcs['corrTetra'] = CorrTetra()
        self.funcs['corrSpearmansRho'] = CorrSpearmansRho()
        self.funcs['corrPBi'] = CorrPBi()
        self.funcs['corrPearson'] = CorrPearson()

        mainBox = VBox(name='mainBox')
        N = ipyw.IntText(description='N')
        r = ipyw.FloatText(description='r', min=-1, max=1, step=0.01)
        mainBox.children = (N, r)

        ratioBox = VBox(name='ratioBox')
        ratioBox.children = (RatioEstimatesView(name='ratioEstimatesView', layout=ipyw.Layout(width='100%')), )

        self.children = (ratioBox, mainBox)
        self['mainBox'].remove()

        self.link_all(self['ratioBox']['ratioEstimatesView'], self.model)
        self.link_all(self['ratioBox']['ratioEstimatesView']['colorInts'], self.model)


    @observe('model_name')
    def observe_model_name(self, change):
        if change['new'] in ('corrCramerV', 'corrTetra'):
            self['ratioBox'].add()
            self['mainBox'].remove()
        else:
            self['mainBox'].add()
            self['ratioBox'].remove()

    def run(self):
        self.funcs[self.model_name].setKwargs(self.model._trait_values)
        result = self.funcs[self.model_name].run()
        print(result)