# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/controller.ipynb (unless otherwise specified).

__all__ = ['logger', 'DropdownOption', 'Controller']

# Cell
from IPython.display import display, Javascript
import json
import traitlets
from traitlets import HasTraits, Int, Unicode, observe
import ipywidgets as ipyw

# Cell
from .view.widgets import IntSlider, Button, Dropdown, FloatText
from .view.widget_collections import Tab, SelectionVBox, VBox, Box, LogAccordion
from .view.tabs import LandingTab, EstimatesTab, ResultsTab, SettingsTab
from .correlation import CorrelationLandingView, CorrelationEstimatesView
from .chiSq import ChiSqLandingView, ChiSqEstimatesView
from .globals import HANDLER
logger = HANDLER.getLogger(__name__)

# Cell
from collections import namedtuple
DropdownOption = namedtuple('DropdownOption', ['name', 'label', 'landing', 'estimates'])

# Cell
class Controller(traitlets.HasTraits):

    modelName = Unicode()
    corrModelName = Unicode()

    def __init__(self):

        logger.info('Autosave off.')
        display(Javascript('Jupyter.notebook.set_autosave_interval(0);'))


        # defaults
        self.modelName = 'chisq'
        self.corrModelName = 'corrCramerV'

        self.create_globalWidgets()
        self.populate_views()
        self.add_views_to_boxes()
        self.view = self.tab_based_view()
        self.add_observations()

    def _ipython_display_(self):
        display(self.view)

    def create_globalWidgets(self):

        corrOptions = [('Pearson\'s Correlation Coefficient', 'corrPearson'),
                            ('Point-biserial', 'corrPBi'),
                            ('Spearman\'s rho', 'corrSpearmansRho'),
                            ('Cramer\'s V', 'corrCramerV'),
                            ('Tetrachoric', 'corrTetra')]
        self.corrDropdown = Dropdown(
            name='corrOptionsDropdown',
            options=corrOptions,
            description='Coefficient: ',
            layout=ipyw.Layout(max_width='350px',description_width='100px')
        )

        self.landingBox = SelectionVBox(name='box')
        self.estimatesBox = SelectionVBox(name='box')

        self.dropdownOptions = []

        self.dropdown = Dropdown(
                options=self.dropdownOptions,
                name='dropdown',
                description='Model Class: ',
                layout=ipyw.Layout(max_width='300px', description_width='80px')
        )

        self.okayButton = Button(name='okayButton', description='Okay', button_style='success')
        self.runButton = Button(name='runButton', description='Run', button_style='success')
        self.restartButton = Button(name='restartButton', description='Restart')
        self.repopulateLanding = Button(name='repopulateLanding', description='Repopulate Landing Tab')
        self.repopulateEstimates = Button(name='repopulateEstimates', description='Repopulate Estimates Tab')
        self.logAccordion = LogAccordion(children=(HANDLER, ))

        tailOptions = [('2-tailed', 'two'), ('1-tailed, less', 'less'), ('1-tailed, greater', 'greater')]
        self.tailWidget = Dropdown(
            name = 'tailWidget',
            options=tailOptions,
            description = 'Tail:')

        self.alphaWidget = FloatText(
            name = 'alphaWidget',
            value=0.05,
            description='α: ',
            step=0.01, min = 0.0, max = 1.0)

    def populate_views(self):
        self.views = []
        self.views.append(DropdownOption('chisq', 'Chi Squared', ChiSqLandingView(name='chisq'), ChiSqEstimatesView(name='chisq')))
        self.views.append(DropdownOption('corr', 'Correlation', CorrelationLandingView(self.corrDropdown, name='corr'), CorrelationEstimatesView(name='corr')))

    def add_views_to_boxes(self):
        for view in self.views:
            self.dropdown.options += ((view.label, view.name), )
            self.landingBox._children += (view.landing, )
            self.estimatesBox._children += (view.estimates, )

    def tab_based_view(self):
        landingTab = LandingTab(self.dropdown, self.landingBox, self.okayButton, name='Landing')
        estimatesTab = EstimatesTab(self.estimatesBox, self.runButton, name='Estimates')
        resultsTab = ResultsTab(self.restartButton, self.repopulateLanding, self.repopulateEstimates, name='Results')
        settingsTab = SettingsTab(self.tailWidget, self.alphaWidget, self.logAccordion, name='Settings')
        return Tab(children=(landingTab, estimatesTab, resultsTab, settingsTab))

    def add_observations(self):
        # buttons
        self.okayButton.on_click(self.on_okayButton_click)
        self.runButton.on_click(self.on_runButton_click)
        self.restartButton.on_click(self.on_restartButton_click)
        self.repopulateLanding.on_click(self.on_repopulateLanding_click)
        self.repopulateEstimates.on_click(self.on_repopulateEstimates_click)

        traitlets.link((self, 'modelName'), (self.dropdown, 'value'))
        traitlets.link((self, 'modelName'), (self.landingBox, 'selected_name'))
        traitlets.link((self, 'modelName'), (self.estimatesBox, 'selected_name'))

        traitlets.link((self, 'corrModelName'), (self.corrDropdown, 'value'))
        traitlets.link((self, 'corrModelName'), (self.estimatesBox['corr'], 'modelName'))

    ''' START: ON BUTTON CLICK'''
    def on_okayButton_click(self, button):
        self.view.selected_name = 'Estimates'

    def on_runButton_click(self, button):
        self.view.selected_name='Results'

    def on_restartButton_click(self, button):
        self.view.selected_name='Landing'

    def on_repopulateLanding_click(self, button):
        self.view.selected_name = 'Landing'

    def on_repopulateEstimates_click(self, button):
        self.view.selected_name = 'Estimates'
    '''END: ON BUTTON CLICK'''