"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const cloudFormation = new aws_sdk_1.CloudFormation();
async function handler(stackName) {
    const template = await cloudFormation.getTemplate({
        StackName: stackName,
    }).promise();
    if (!template.TemplateBody) {
        return [];
    }
    const hashes = template.TemplateBody.match(/[a-f0-9]{64}/g);
    return [...new Set(hashes)];
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXh0cmFjdC10ZW1wbGF0ZS1oYXNoZXMubGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3Rvb2xraXQtY2xlYW5lci9leHRyYWN0LXRlbXBsYXRlLWhhc2hlcy5sYW1iZGEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEscUNBQXlDLENBQUMsd0RBQXdEO0FBRWxHLE1BQU0sY0FBYyxHQUFHLElBQUksd0JBQWMsRUFBRSxDQUFDO0FBRXJDLEtBQUssVUFBVSxPQUFPLENBQUMsU0FBaUI7SUFDN0MsTUFBTSxRQUFRLEdBQUcsTUFBTSxjQUFjLENBQUMsV0FBVyxDQUFDO1FBQ2hELFNBQVMsRUFBRSxTQUFTO0tBQ3JCLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztJQUViLElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxFQUFFO1FBQzFCLE9BQU8sRUFBRSxDQUFDO0tBQ1g7SUFFRCxNQUFNLE1BQU0sR0FBRyxRQUFRLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUU1RCxPQUFPLENBQUMsR0FBRyxJQUFJLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0FBQzlCLENBQUM7QUFaRCwwQkFZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENsb3VkRm9ybWF0aW9uIH0gZnJvbSAnYXdzLXNkayc7IC8vIGVzbGludC1kaXNhYmxlLWxpbmUgaW1wb3J0L25vLWV4dHJhbmVvdXMtZGVwZW5kZW5jaWVzXG5cbmNvbnN0IGNsb3VkRm9ybWF0aW9uID0gbmV3IENsb3VkRm9ybWF0aW9uKCk7XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBoYW5kbGVyKHN0YWNrTmFtZTogc3RyaW5nKSB7XG4gIGNvbnN0IHRlbXBsYXRlID0gYXdhaXQgY2xvdWRGb3JtYXRpb24uZ2V0VGVtcGxhdGUoe1xuICAgIFN0YWNrTmFtZTogc3RhY2tOYW1lLFxuICB9KS5wcm9taXNlKCk7XG5cbiAgaWYgKCF0ZW1wbGF0ZS5UZW1wbGF0ZUJvZHkpIHtcbiAgICByZXR1cm4gW107XG4gIH1cblxuICBjb25zdCBoYXNoZXMgPSB0ZW1wbGF0ZS5UZW1wbGF0ZUJvZHkubWF0Y2goL1thLWYwLTldezY0fS9nKTtcblxuICByZXR1cm4gWy4uLm5ldyBTZXQoaGFzaGVzKV07XG59XG4iXX0=