#!/usr/bin/env python
# coding=utf-8

# Parapheur API
import parapheur
# Scripts API
import scripts
# arguments
import gettext

__author__ = 'Lukas Hameury'

__all__ = ['init', 'echo', 'check']


def convertmessages(s):
    subdict = \
        {'positional arguments': 'Arguments',
         'optional arguments': 'Arguments',
         'show this help message and exit': 'Affiche ce message et quitte'}
    if s in subdict:
        s = subdict[s]
    return s
gettext.gettext = convertmessages
import argparse


def init():
    parser = argparse.ArgumentParser(
        prog='ph-init',
        description="Génère un fichier de configuration par défaut dans le répertoire courant")
    parser.add_argument('-p', help='Chemin du fichier de configuration')
    parser.add_argument('-c', help='Commande pour laquelle générer le fichier de configuration',
                        choices=["recuparchives", "export", "import", "pushdoc"])

    args = parser.parse_args()

    filename = "script"
    path = "."
    if args.p:
        path = args.p
    if args.c:
        filename = args.c

    # Copy the configuration file
    parapheur.copyconfig(filename, path)

    print("Fichier de configuration 'iparapheur-utils.cfg' créé")


def echo():
    parser = argparse.ArgumentParser(
        prog='ph-echo',
        description="Lance un echo via webservice sur un iParapheur")

    parser.add_argument('-s', help="URL du serveur iParapheur")
    parser.add_argument('-c', help='Fichier de configuration')
    parser.add_argument('-u', help='Utilisateur')
    parser.add_argument('-p', help='Mot de passe')

    args = parser.parse_args()

    if args.c:
        parapheur.setconfig(args.c)
    if args.s:
        parapheur.setconfigproperty("Parapheur", "server", args.s)
    if args.u:
        parapheur.setconfigproperty("Parapheur", "username", args.u)
    if args.p:
        parapheur.setconfigproperty("Parapheur", "password", args.p)

    # Initialisation d'API SOAP
    webservice = parapheur.getsoapclient()
    print(webservice.call().echo("coucou"))


def check():
    scripts.checkinstallation()


def recuparchives():
    parser = argparse.ArgumentParser(
        prog='ph-recupArchives',
        description="Lance une récupération / purge des archives")

    parser.add_argument('-s', help="URL du serveur iParapheur")
    parser.add_argument('-c', help='Fichier de configuration')
    parser.add_argument('-u', help='Utilisateur')
    parser.add_argument('-p', help='Mot de passe')

    parser.add_argument('-f', help='Répertoire de destination')
    parser.add_argument('-ps', help='Taille des pages à récupérer')
    parser.add_argument('-r', help='Chemins réduis des téléchargements', choices=["true", "false"])
    parser.add_argument('-pu', help='Active la purge les données', choices=["true", "false"])
    parser.add_argument('-d', help='Télécharge les données', choices=["true", "false"])
    parser.add_argument('-t', help='Filtre sur type')
    parser.add_argument('-st', help='Filtre sur sous-type')
    parser.add_argument('-w', help='Délai de conservation des données')

    args = parser.parse_args()

    if args.c:
        parapheur.setconfig(args.c)
    if args.s:
        parapheur.setconfigproperty("Parapheur", "server", args.s)
    if args.u:
        parapheur.setconfigproperty("Parapheur", "username", args.u)
    if args.p:
        parapheur.setconfigproperty("Parapheur", "password", args.p)

    if args.f:
        parapheur.setconfigproperty("RecupArchives", "folder", args.f)
    if args.ps:
        parapheur.setconfigproperty("RecupArchives", "page_size", args.ps)
    if args.r:
        parapheur.setconfigproperty("RecupArchives", "use_reduced_download_path", args.r)
    if args.pu:
        parapheur.setconfigproperty("RecupArchives", "purge", args.pu)
    if args.d:
        parapheur.setconfigproperty("RecupArchives", "download", args.d)
    if args.t:
        parapheur.setconfigproperty("RecupArchives", "type_filter", args.t)
    if args.st:
        parapheur.setconfigproperty("RecupArchives", "subtype_filter", args.st)
    if args.w:
        parapheur.setconfigproperty("RecupArchives", "waiting_days", args.w)

    # Lancement du script
    scripts.recuparchives()


def import_data():
    parser = argparse.ArgumentParser(
        prog='ph-import',
        description="Importe la configuration ciblée dans un parapheur vierge")

    parser.add_argument('-s', help="URL du serveur iParapheur")
    parser.add_argument('-c', help='Fichier de configuration')
    parser.add_argument('-u', help='Utilisateur administrateur')
    parser.add_argument('-p', help='Mot de passe')
    parser.add_argument('-i', help='Répertoire à importer')

    parser.add_argument('-dh', help='IP du serveur mysql')
    parser.add_argument('-dp', help='Port du serveur mysql')
    parser.add_argument('-du', help='Utilisateur alfresco de mysql')
    parser.add_argument('-dpw', help='Mot de passe utilisateur alfresco de mysql')
    parser.add_argument('-dd', help='Nom de la base mysql')

    args = parser.parse_args()

    if args.c:
        parapheur.setconfig(args.c)
    if args.s:
        parapheur.setconfigproperty("Parapheur", "server", args.s)
    if args.u:
        parapheur.setconfigproperty("Parapheur", "username", args.u)
    if args.p:
        parapheur.setconfigproperty("Parapheur", "password", args.p)
    if args.i:
        parapheur.setconfigproperty("Parapheur", "importdir", args.i)

    if args.dh:
        parapheur.setconfigproperty("Database", "server", args.dh)
    if args.dp:
        parapheur.setconfigproperty("Database", "port", args.dp)
    if args.du:
        parapheur.setconfigproperty("Database", "username", args.du)
    if args.dpw:
        parapheur.setconfigproperty("Database", "password", args.dpw)
    if args.dd:
        parapheur.setconfigproperty("Database", "database", args.dd)

    # Lancement de l'import
    scripts.import_data()


def export_data():
    parser = argparse.ArgumentParser(
        prog='ph-export',
        description="Exporte la configuration du parapheur ciblé vers un dossier")

    parser.add_argument('-s', help="URL du serveur iParapheur")
    parser.add_argument('-c', help='Fichier de configuration')
    parser.add_argument('-u', help='Utilisateur administrateur')
    parser.add_argument('-p', help='Mot de passe')
    parser.add_argument('-i', help='Répertoire de destination')

    parser.add_argument('-dh', help='IP du serveur mysql')
    parser.add_argument('-dp', help='Port du serveur mysql')
    parser.add_argument('-du', help='Utilisateur alfresco de mysql')
    parser.add_argument('-dpw', help='Mot de passe utilisateur alfresco de mysql')
    parser.add_argument('-dd', help='Nom de la base mysql')

    args = parser.parse_args()

    if args.c:
        parapheur.setconfig(args.c)
    if args.s:
        parapheur.setconfigproperty("Parapheur", "server", args.s)
    if args.u:
        parapheur.setconfigproperty("Parapheur", "username", args.u)
    if args.p:
        parapheur.setconfigproperty("Parapheur", "password", args.p)
    if args.i:
        parapheur.setconfigproperty("Parapheur", "exportdir", args.i)

    if args.dh:
        parapheur.setconfigproperty("Database", "server", args.dh)
    if args.dp:
        parapheur.setconfigproperty("Database", "port", args.dp)
    if args.du:
        parapheur.setconfigproperty("Database", "username", args.du)
    if args.dpw:
        parapheur.setconfigproperty("Database", "password", args.dpw)
    if args.dd:
        parapheur.setconfigproperty("Database", "database", args.dd)

    # Lancement de l'import
    scripts.export_data()


def rename():
    parser = argparse.ArgumentParser(
        prog='ph-rename',
        description="Change l'URL d'accès du i-Parapheur")

    parser.add_argument('-n', help="Nouvelle URL du serveur iParapheur", required=True)

    args = parser.parse_args()

    parapheur.setconfigproperty("Parapheur", "new_url", args.n)

    # Lancement du changement de nom
    scripts.rename()


def remove_ldap():
    parser = argparse.ArgumentParser(
        prog='ph-removeldap',
        description="Supprime les utilisateurs synchronisés LDAP n'ayant aucune liaison avec un bureau")

    args = parser.parse_args()

    # Lancement du changement de nom
    scripts.remove_ldap()


def pushdoc():
    parser = argparse.ArgumentParser(
        prog='ph-pushdoc',
        description="Permet une gestion plus simple du connecteur générique pushdoc dans les cas les plus classiques")

    parser.add_argument('-c', help='Fichier de configuration')

    parser.add_argument('-j', help='Fichier JAR du pushdoc')
    parser.add_argument('-i', help='Répertoire à traiter')
    parser.add_argument('-e', help='Courriel de l\'utilisateur webservice')
    parser.add_argument('-x', help='xPath par défaut dans le cas d\'un envoi de flux PES')
    parser.add_argument('-v', help='Visuel PDF à utiliser dans le cas d\'un envoi de flux PES')

    args = parser.parse_args()

    if args.c:
        parapheur.setconfig(args.c)
    if args.j:
        parapheur.setconfigproperty("Pushdoc", "jar_file", args.j)
    if args.i:
        parapheur.setconfigproperty("Pushdoc", "import_dir", args.i)
    if args.e:
        parapheur.setconfigproperty("Pushdoc", "user_mail", args.e)
    if args.x:
        parapheur.setconfigproperty("Pushdoc", "default_xpath", args.x)
    if args.v:
        parapheur.setconfigproperty("Pushdoc", "template_pdf_file", args.v)

    # Lancement du pushdoc
    scripts.pushdoc()


def properties_merger():
    scripts.properties_merger()


if __name__ == "__main__":
    properties_merger()
