# coding: utf-8

"""
    BoldSign API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Contact: support@boldsign.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from boldsign.models.phone_number import PhoneNumber
from typing import Optional, Set, Tuple
from typing_extensions import Self
import io
from pydantic import StrictBool
from typing import Union

class TemplateSignerDetails(BaseModel):
    """
    TemplateSignerDetails
    """ # noqa: E501
    signer_name: Optional[StrictStr] = Field(default=None, alias="signerName")
    signer_role: Optional[StrictStr] = Field(default=None, alias="signerRole")
    signer_email: Optional[StrictStr] = Field(default=None, alias="signerEmail")
    phone_number: Optional[PhoneNumber] = Field(default=None, alias="phoneNumber")
    status: Optional[StrictStr] = None
    enable_access_code: Optional[StrictBool] = Field(default=None, alias="enableAccessCode")
    enable_email_otp: Optional[StrictBool] = Field(default=None, alias="enableEmailOTP")
    impose_authentication: Optional[StrictStr] = Field(default=None, alias="imposeAuthentication")
    delivery_mode: Optional[StrictStr] = Field(default=None, alias="deliveryMode")
    allow_field_configuration: Optional[StrictBool] = Field(default=False, alias="allowFieldConfiguration")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    order: Optional[StrictInt] = None
    signer_type: Optional[StrictStr] = Field(default='Signer', alias="signerType")
    host_email: Optional[StrictStr] = Field(default=None, alias="hostEmail")
    host_name: Optional[StrictStr] = Field(default=None, alias="hostName")
    host_user_id: Optional[StrictStr] = Field(default=None, alias="hostUserId")
    sign_type: Optional[StrictStr] = Field(default=None, alias="signType")
    __properties: ClassVar[List[str]] = ["signerName", "signerRole", "signerEmail", "phoneNumber", "status", "enableAccessCode", "enableEmailOTP", "imposeAuthentication", "deliveryMode", "allowFieldConfiguration", "userId", "order", "signerType", "hostEmail", "hostName", "hostUserId", "signType"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'NotCompleted', 'Completed', 'Declined', 'Revoked', 'Expired']):
            raise ValueError("must be one of enum values ('None', 'NotCompleted', 'Completed', 'Declined', 'Revoked', 'Expired')")
        return value

    @field_validator('impose_authentication')
    def impose_authentication_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'EmailOTP', 'AccessCode', 'SMSOTP', 'IdVerification']):
            raise ValueError("must be one of enum values ('None', 'EmailOTP', 'AccessCode', 'SMSOTP', 'IdVerification')")
        return value

    @field_validator('delivery_mode')
    def delivery_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Email', 'SMS', 'EmailAndSMS']):
            raise ValueError("must be one of enum values ('Email', 'SMS', 'EmailAndSMS')")
        return value

    @field_validator('signer_type')
    def signer_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Signer', 'Reviewer', 'InPersonSigner']):
            raise ValueError("must be one of enum values ('Signer', 'Reviewer', 'InPersonSigner')")
        return value

    @field_validator('sign_type')
    def sign_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Single', 'Group']):
            raise ValueError("must be one of enum values ('Single', 'Group')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(self, excluded_fields: Set[str] = None) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            elif isinstance(value, list):
                for index, item in enumerate(value):
                    if(isinstance(item, (int, str, bool))):
                        data.append((f'{key}[{index}]', item))
                    else:
                        data.append((key, json.dumps(value[index], ensure_ascii=False)))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TemplateSignerDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TemplateSignerDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "signerName": obj.get("signerName"),
            "signerRole": obj.get("signerRole"),
            "signerEmail": obj.get("signerEmail"),
            "phoneNumber": PhoneNumber.from_dict(obj["phoneNumber"]) if obj.get("phoneNumber") is not None else None,
            "status": obj.get("status"),
            "enableAccessCode": obj.get("enableAccessCode"),
            "enableEmailOTP": obj.get("enableEmailOTP"),
            "imposeAuthentication": obj.get("imposeAuthentication"),
            "deliveryMode": obj.get("deliveryMode"),
            "allowFieldConfiguration": obj.get("allowFieldConfiguration") if obj.get("allowFieldConfiguration") is not None else False,
            "userId": obj.get("userId"),
            "order": obj.get("order"),
            "signerType": obj.get("signerType") if obj.get("signerType") is not None else 'Signer',
            "hostEmail": obj.get("hostEmail"),
            "hostName": obj.get("hostName"),
            "hostUserId": obj.get("hostUserId"),
            "signType": obj.get("signType")
        })
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "signer_name": "(str,)",
            "signer_role": "(str,)",
            "signer_email": "(str,)",
            "phone_number": "(PhoneNumber,)",
            "status": "(str,)",
            "enable_access_code": "(bool,)",
            "enable_email_otp": "(bool,)",
            "impose_authentication": "(str,)",
            "delivery_mode": "(str,)",
            "allow_field_configuration": "(bool,)",
            "user_id": "(str,)",
            "order": "(int,)",
            "signer_type": "(str,)",
            "host_email": "(str,)",
            "host_name": "(str,)",
            "host_user_id": "(str,)",
            "sign_type": "(str,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in [
        ]

