# coding: utf-8

"""
    BoldSign API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Contact: support@boldsign.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from boldsign.models.behalf_of import BehalfOf
from boldsign.models.document_files import DocumentFiles
from boldsign.models.document_info import DocumentInfo
from boldsign.models.form_group import FormGroup
from boldsign.models.recipient_notification_settings import RecipientNotificationSettings
from boldsign.models.roles import Roles
from boldsign.models.template_form_fields import TemplateFormFields
from boldsign.models.template_sender_detail import TemplateSenderDetail
from boldsign.models.template_shared_template_detail import TemplateSharedTemplateDetail
from typing import Optional, Set, Tuple
from typing_extensions import Self
import io
from pydantic import StrictBool
from typing import Union

class TemplateProperties(BaseModel):
    """
    TemplateProperties
    """ # noqa: E501
    template_id: Optional[StrictStr] = Field(default=None, alias="templateId")
    title: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    document_title: Optional[StrictStr] = Field(default=None, alias="documentTitle")
    document_message: Optional[StrictStr] = Field(default=None, alias="documentMessage")
    files: Optional[List[DocumentFiles]] = None
    roles: Optional[List[Roles]] = None
    form_groups: Optional[List[FormGroup]] = Field(default=None, alias="formGroups")
    common_fields: Optional[List[TemplateFormFields]] = Field(default=None, alias="commonFields")
    c_c_details: Optional[List[StrictStr]] = Field(default=None, alias="cCDetails")
    brand_id: Optional[StrictStr] = Field(default=None, alias="brandId")
    allow_message_editing: Optional[StrictBool] = Field(default=None, alias="allowMessageEditing")
    allow_new_roles: Optional[StrictBool] = Field(default=None, alias="allowNewRoles")
    allow_new_files: Optional[StrictBool] = Field(default=None, alias="allowNewFiles")
    allow_modify_files: Optional[StrictBool] = Field(default=None, alias="allowModifyFiles")
    enable_reassign: Optional[StrictBool] = Field(default=None, alias="enableReassign")
    enable_print_and_sign: Optional[StrictBool] = Field(default=None, alias="EnablePrintAndSign")
    enable_signing_order: Optional[StrictBool] = Field(default=None, alias="enableSigningOrder")
    created_date: Optional[StrictInt] = Field(default=None, alias="createdDate")
    created_by: Optional[TemplateSenderDetail] = Field(default=None, alias="createdBy")
    shared_template_detail: Optional[List[TemplateSharedTemplateDetail]] = Field(default=None, alias="sharedTemplateDetail")
    document_info: Optional[List[DocumentInfo]] = Field(default=None, alias="documentInfo")
    labels: Optional[List[StrictStr]] = None
    template_labels: Optional[List[StrictStr]] = Field(default=None, alias="templateLabels")
    behalf_of: Optional[BehalfOf] = Field(default=None, alias="behalfOf")
    document_download_option: Optional[StrictStr] = Field(default=None, alias="documentDownloadOption")
    recipient_notification_settings: Optional[RecipientNotificationSettings] = Field(default=None, alias="recipientNotificationSettings")
    __properties: ClassVar[List[str]] = ["templateId", "title", "description", "documentTitle", "documentMessage", "files", "roles", "formGroups", "commonFields", "cCDetails", "brandId", "allowMessageEditing", "allowNewRoles", "allowNewFiles", "allowModifyFiles", "enableReassign", "EnablePrintAndSign", "enableSigningOrder", "createdDate", "createdBy", "sharedTemplateDetail", "documentInfo", "labels", "templateLabels", "behalfOf", "documentDownloadOption", "recipientNotificationSettings"]

    @field_validator('document_download_option')
    def document_download_option_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Combined', 'Individually']):
            raise ValueError("must be one of enum values ('Combined', 'Individually')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(self, excluded_fields: Set[str] = None) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            elif isinstance(value, list):
                for index, item in enumerate(value):
                    if(isinstance(item, (int, str, bool))):
                        data.append((f'{key}[{index}]', item))
                    else:
                        data.append((key, json.dumps(value[index], ensure_ascii=False)))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TemplateProperties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TemplateProperties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "templateId": obj.get("templateId"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "documentTitle": obj.get("documentTitle"),
            "documentMessage": obj.get("documentMessage"),
            "files": [DocumentFiles.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None,
            "roles": [Roles.from_dict(_item) for _item in obj["roles"]] if obj.get("roles") is not None else None,
            "formGroups": [FormGroup.from_dict(_item) for _item in obj["formGroups"]] if obj.get("formGroups") is not None else None,
            "commonFields": [TemplateFormFields.from_dict(_item) for _item in obj["commonFields"]] if obj.get("commonFields") is not None else None,
            "cCDetails": obj.get("cCDetails"),
            "brandId": obj.get("brandId"),
            "allowMessageEditing": obj.get("allowMessageEditing"),
            "allowNewRoles": obj.get("allowNewRoles"),
            "allowNewFiles": obj.get("allowNewFiles"),
            "allowModifyFiles": obj.get("allowModifyFiles"),
            "enableReassign": obj.get("enableReassign"),
            "EnablePrintAndSign": obj.get("EnablePrintAndSign"),
            "enableSigningOrder": obj.get("enableSigningOrder"),
            "createdDate": obj.get("createdDate"),
            "createdBy": TemplateSenderDetail.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "sharedTemplateDetail": [TemplateSharedTemplateDetail.from_dict(_item) for _item in obj["sharedTemplateDetail"]] if obj.get("sharedTemplateDetail") is not None else None,
            "documentInfo": [DocumentInfo.from_dict(_item) for _item in obj["documentInfo"]] if obj.get("documentInfo") is not None else None,
            "labels": obj.get("labels"),
            "templateLabels": obj.get("templateLabels"),
            "behalfOf": BehalfOf.from_dict(obj["behalfOf"]) if obj.get("behalfOf") is not None else None,
            "documentDownloadOption": obj.get("documentDownloadOption"),
            "recipientNotificationSettings": RecipientNotificationSettings.from_dict(obj["recipientNotificationSettings"]) if obj.get("recipientNotificationSettings") is not None else None
        })
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "template_id": "(str,)",
            "title": "(str,)",
            "description": "(str,)",
            "document_title": "(str,)",
            "document_message": "(str,)",
            "files": "(List[DocumentFiles],)",
            "roles": "(List[Roles],)",
            "form_groups": "(List[FormGroup],)",
            "common_fields": "(List[TemplateFormFields],)",
            "c_c_details": "(List[str],)",
            "brand_id": "(str,)",
            "allow_message_editing": "(bool,)",
            "allow_new_roles": "(bool,)",
            "allow_new_files": "(bool,)",
            "allow_modify_files": "(bool,)",
            "enable_reassign": "(bool,)",
            "enable_print_and_sign": "(bool,)",
            "enable_signing_order": "(bool,)",
            "created_date": "(int,)",
            "created_by": "(TemplateSenderDetail,)",
            "shared_template_detail": "(List[TemplateSharedTemplateDetail],)",
            "document_info": "(List[DocumentInfo],)",
            "labels": "(List[str],)",
            "template_labels": "(List[str],)",
            "behalf_of": "(BehalfOf,)",
            "document_download_option": "(str,)",
            "recipient_notification_settings": "(RecipientNotificationSettings,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in [
            "files",
            "roles",
            "form_groups",
            "common_fields",
            "c_c_details",
            "shared_template_detail",
            "document_info",
            "labels",
            "template_labels",
        ]

