# coding: utf-8

"""
    BoldSign API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Contact: support@boldsign.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set, Tuple
from typing_extensions import Self
import io
from pydantic import StrictBool
from typing import Union

class EmbeddedTemplateEditRequest(BaseModel):
    """
    EmbeddedTemplateEditRequest
    """ # noqa: E501
    redirect_url: Optional[StrictStr] = Field(default=None, alias="redirectUrl")
    show_toolbar: Optional[StrictBool] = Field(default=False, alias="showToolbar")
    view_option: Optional[StrictStr] = Field(default='PreparePage', alias="viewOption")
    show_save_button: Optional[StrictBool] = Field(default=True, alias="showSaveButton")
    locale: Optional[StrictStr] = 'EN'
    show_create_button: Optional[StrictBool] = Field(default=True, alias="showCreateButton")
    show_preview_button: Optional[StrictBool] = Field(default=True, alias="showPreviewButton")
    show_navigation_buttons: Optional[StrictBool] = Field(default=True, alias="showNavigationButtons")
    link_valid_till: Optional[datetime] = Field(default=None, alias="linkValidTill")
    show_tooltip: Optional[StrictBool] = Field(default=False, alias="showTooltip")
    on_behalf_of: Optional[StrictStr] = Field(default=None, alias="onBehalfOf")
    __properties: ClassVar[List[str]] = ["redirectUrl", "showToolbar", "viewOption", "showSaveButton", "locale", "showCreateButton", "showPreviewButton", "showNavigationButtons", "linkValidTill", "showTooltip", "onBehalfOf"]

    @field_validator('view_option')
    def view_option_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['PreparePage', 'FillingPage']):
            raise ValueError("must be one of enum values ('PreparePage', 'FillingPage')")
        return value

    @field_validator('locale')
    def locale_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['EN', 'NO', 'FR', 'DE', 'ES', 'BG', 'CS', 'DA', 'IT', 'NL', 'PL', 'PT', 'RO', 'RU', 'SV', 'Default']):
            raise ValueError("must be one of enum values ('EN', 'NO', 'FR', 'DE', 'ES', 'BG', 'CS', 'DA', 'IT', 'NL', 'PL', 'PT', 'RO', 'RU', 'SV', 'Default')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(self, excluded_fields: Set[str] = None) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            elif isinstance(value, list):
                for index, item in enumerate(value):
                    if(isinstance(item, (int, str, bool))):
                        data.append((f'{key}[{index}]', item))
                    else:
                        data.append((key, json.dumps(value[index], ensure_ascii=False)))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmbeddedTemplateEditRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmbeddedTemplateEditRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "redirectUrl": obj.get("redirectUrl"),
            "showToolbar": obj.get("showToolbar") if obj.get("showToolbar") is not None else False,
            "viewOption": obj.get("viewOption") if obj.get("viewOption") is not None else 'PreparePage',
            "showSaveButton": obj.get("showSaveButton") if obj.get("showSaveButton") is not None else True,
            "locale": obj.get("locale") if obj.get("locale") is not None else 'EN',
            "showCreateButton": obj.get("showCreateButton") if obj.get("showCreateButton") is not None else True,
            "showPreviewButton": obj.get("showPreviewButton") if obj.get("showPreviewButton") is not None else True,
            "showNavigationButtons": obj.get("showNavigationButtons") if obj.get("showNavigationButtons") is not None else True,
            "linkValidTill": obj.get("linkValidTill"),
            "showTooltip": obj.get("showTooltip") if obj.get("showTooltip") is not None else False,
            "onBehalfOf": obj.get("onBehalfOf")
        })
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "redirect_url": "(str,)",
            "show_toolbar": "(bool,)",
            "view_option": "(str,)",
            "show_save_button": "(bool,)",
            "locale": "(str,)",
            "show_create_button": "(bool,)",
            "show_preview_button": "(bool,)",
            "show_navigation_buttons": "(bool,)",
            "link_valid_till": "(datetime,)",
            "show_tooltip": "(bool,)",
            "on_behalf_of": "(str,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in [
        ]

