# coding: utf-8

"""
    BoldSign API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Contact: support@boldsign.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from boldsign.models.document_cc import DocumentCC
from boldsign.models.document_info import DocumentInfo
from boldsign.models.form_group import FormGroup
from boldsign.models.recipient_notification_settings import RecipientNotificationSettings
from boldsign.models.template_role import TemplateRole
from typing import Optional, Set, Tuple
from typing_extensions import Self
import io
from pydantic import StrictBool
from typing import Union

class EditTemplateRequest(BaseModel):
    """
    EditTemplateRequest
    """ # noqa: E501
    title: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=256)]] = None
    description: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=5000)]] = None
    document_title: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=256)]] = Field(default=None, alias="documentTitle")
    document_message: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=5000)]] = Field(default=None, alias="documentMessage")
    roles: Optional[List[TemplateRole]] = None
    cc: Optional[List[DocumentCC]] = None
    brand_id: Optional[StrictStr] = Field(default=None, alias="brandId")
    allow_message_editing: Optional[StrictBool] = Field(default=None, alias="allowMessageEditing")
    allow_new_roles: Optional[StrictBool] = Field(default=None, alias="allowNewRoles")
    allow_new_files: Optional[StrictBool] = Field(default=None, alias="allowNewFiles")
    enable_reassign: Optional[StrictBool] = Field(default=None, alias="enableReassign")
    enable_print_and_sign: Optional[StrictBool] = Field(default=None, alias="enablePrintAndSign")
    enable_signing_order: Optional[StrictBool] = Field(default=None, alias="enableSigningOrder")
    document_info: Optional[List[DocumentInfo]] = Field(default=None, alias="documentInfo")
    on_behalf_of: Optional[StrictStr] = Field(default=None, alias="onBehalfOf")
    labels: Optional[List[StrictStr]] = None
    template_labels: Optional[List[StrictStr]] = Field(default=None, alias="templateLabels")
    form_groups: Optional[List[FormGroup]] = Field(default=None, alias="formGroups")
    recipient_notification_settings: Optional[RecipientNotificationSettings] = Field(default=None, alias="recipientNotificationSettings")
    __properties: ClassVar[List[str]] = ["title", "description", "documentTitle", "documentMessage", "roles", "cc", "brandId", "allowMessageEditing", "allowNewRoles", "allowNewFiles", "enableReassign", "enablePrintAndSign", "enableSigningOrder", "documentInfo", "onBehalfOf", "labels", "templateLabels", "formGroups", "recipientNotificationSettings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(self, excluded_fields: Set[str] = None) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            elif isinstance(value, list):
                for index, item in enumerate(value):
                    if(isinstance(item, (int, str, bool))):
                        data.append((f'{key}[{index}]', item))
                    else:
                        data.append((key, json.dumps(value[index], ensure_ascii=False)))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EditTemplateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EditTemplateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "description": obj.get("description"),
            "documentTitle": obj.get("documentTitle"),
            "documentMessage": obj.get("documentMessage"),
            "roles": [TemplateRole.from_dict(_item) for _item in obj["roles"]] if obj.get("roles") is not None else None,
            "cc": [DocumentCC.from_dict(_item) for _item in obj["cc"]] if obj.get("cc") is not None else None,
            "brandId": obj.get("brandId"),
            "allowMessageEditing": obj.get("allowMessageEditing"),
            "allowNewRoles": obj.get("allowNewRoles"),
            "allowNewFiles": obj.get("allowNewFiles"),
            "enableReassign": obj.get("enableReassign"),
            "enablePrintAndSign": obj.get("enablePrintAndSign"),
            "enableSigningOrder": obj.get("enableSigningOrder"),
            "documentInfo": [DocumentInfo.from_dict(_item) for _item in obj["documentInfo"]] if obj.get("documentInfo") is not None else None,
            "onBehalfOf": obj.get("onBehalfOf"),
            "labels": obj.get("labels"),
            "templateLabels": obj.get("templateLabels"),
            "formGroups": [FormGroup.from_dict(_item) for _item in obj["formGroups"]] if obj.get("formGroups") is not None else None,
            "recipientNotificationSettings": RecipientNotificationSettings.from_dict(obj["recipientNotificationSettings"]) if obj.get("recipientNotificationSettings") is not None else None
        })
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "title": "(str,)",
            "description": "(str,)",
            "document_title": "(str,)",
            "document_message": "(str,)",
            "roles": "(List[TemplateRole],)",
            "cc": "(List[DocumentCC],)",
            "brand_id": "(str,)",
            "allow_message_editing": "(bool,)",
            "allow_new_roles": "(bool,)",
            "allow_new_files": "(bool,)",
            "enable_reassign": "(bool,)",
            "enable_print_and_sign": "(bool,)",
            "enable_signing_order": "(bool,)",
            "document_info": "(List[DocumentInfo],)",
            "on_behalf_of": "(str,)",
            "labels": "(List[str],)",
            "template_labels": "(List[str],)",
            "form_groups": "(List[FormGroup],)",
            "recipient_notification_settings": "(RecipientNotificationSettings,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in [
            "roles",
            "cc",
            "document_info",
            "labels",
            "template_labels",
            "form_groups",
        ]

