# coding: utf-8

"""
    BoldSign API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Contact: support@boldsign.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from boldsign.models.behalf_of import BehalfOf
from boldsign.models.document_cc_details import DocumentCcDetails
from boldsign.models.document_sender_detail import DocumentSenderDetail
from boldsign.models.document_signer_details import DocumentSignerDetails
from typing import Optional, Set, Tuple
from typing_extensions import Self
import io
from pydantic import StrictBool
from typing import Union

class BehalfDocument(BaseModel):
    """
    BehalfDocument
    """ # noqa: E501
    behalf_of: Optional[BehalfOf] = Field(default=None, alias="behalfOf")
    document_id: Optional[StrictStr] = Field(default=None, alias="documentId")
    sender_detail: Optional[DocumentSenderDetail] = Field(default=None, alias="senderDetail")
    cc_details: Optional[List[DocumentCcDetails]] = Field(default=None, alias="ccDetails")
    created_date: Optional[StrictInt] = Field(default=None, alias="createdDate")
    activity_date: Optional[StrictInt] = Field(default=None, alias="activityDate")
    activity_by: Optional[StrictStr] = Field(default=None, alias="activityBy")
    message_title: Optional[StrictStr] = Field(default=None, alias="messageTitle")
    status: Optional[StrictStr] = None
    signer_details: Optional[List[DocumentSignerDetails]] = Field(default=None, alias="signerDetails")
    expiry_date: Optional[StrictInt] = Field(default=None, alias="expiryDate")
    enable_signing_order: Optional[StrictBool] = Field(default=None, alias="enableSigningOrder")
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted")
    labels: Optional[List[StrictStr]] = None
    cursor: Optional[StrictInt] = None
    brand_id: Optional[StrictStr] = Field(default=None, alias="brandId")
    scheduled_send_time: Optional[StrictInt] = Field(default=None, alias="scheduledSendTime")
    __properties: ClassVar[List[str]] = ["behalfOf", "documentId", "senderDetail", "ccDetails", "createdDate", "activityDate", "activityBy", "messageTitle", "status", "signerDetails", "expiryDate", "enableSigningOrder", "isDeleted", "labels", "cursor", "brandId", "scheduledSendTime"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['InProgress', 'Completed', 'Declined', 'Expired', 'Revoked', 'Draft', 'Scheduled']):
            raise ValueError("must be one of enum values ('InProgress', 'Completed', 'Declined', 'Expired', 'Revoked', 'Draft', 'Scheduled')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(self, excluded_fields: Set[str] = None) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            elif isinstance(value, list):
                for index, item in enumerate(value):
                    if(isinstance(item, (int, str, bool))):
                        data.append((f'{key}[{index}]', item))
                    else:
                        data.append((key, json.dumps(value[index], ensure_ascii=False)))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BehalfDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BehalfDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "behalfOf": BehalfOf.from_dict(obj["behalfOf"]) if obj.get("behalfOf") is not None else None,
            "documentId": obj.get("documentId"),
            "senderDetail": DocumentSenderDetail.from_dict(obj["senderDetail"]) if obj.get("senderDetail") is not None else None,
            "ccDetails": [DocumentCcDetails.from_dict(_item) for _item in obj["ccDetails"]] if obj.get("ccDetails") is not None else None,
            "createdDate": obj.get("createdDate"),
            "activityDate": obj.get("activityDate"),
            "activityBy": obj.get("activityBy"),
            "messageTitle": obj.get("messageTitle"),
            "status": obj.get("status"),
            "signerDetails": [DocumentSignerDetails.from_dict(_item) for _item in obj["signerDetails"]] if obj.get("signerDetails") is not None else None,
            "expiryDate": obj.get("expiryDate"),
            "enableSigningOrder": obj.get("enableSigningOrder"),
            "isDeleted": obj.get("isDeleted"),
            "labels": obj.get("labels"),
            "cursor": obj.get("cursor"),
            "brandId": obj.get("brandId"),
            "scheduledSendTime": obj.get("scheduledSendTime")
        })
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "behalf_of": "(BehalfOf,)",
            "document_id": "(str,)",
            "sender_detail": "(DocumentSenderDetail,)",
            "cc_details": "(List[DocumentCcDetails],)",
            "created_date": "(int,)",
            "activity_date": "(int,)",
            "activity_by": "(str,)",
            "message_title": "(str,)",
            "status": "(str,)",
            "signer_details": "(List[DocumentSignerDetails],)",
            "expiry_date": "(int,)",
            "enable_signing_order": "(bool,)",
            "is_deleted": "(bool,)",
            "labels": "(List[str],)",
            "cursor": "(int,)",
            "brand_id": "(str,)",
            "scheduled_send_time": "(int,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in [
            "cc_details",
            "signer_details",
            "labels",
        ]

