# coding: utf-8

"""
    BoldSign API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Contact: support@boldsign.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from boldsign.models.identity_verification_settings import IdentityVerificationSettings
from boldsign.models.phone_number import PhoneNumber
from typing import Optional, Set, Tuple
from typing_extensions import Self
import io
from pydantic import StrictBool
from typing import Union

class AccessCodeDetail(BaseModel):
    """
    AccessCodeDetail
    """ # noqa: E501
    authentication_type: StrictStr = Field(alias="authenticationType")
    email_id: Optional[StrictStr] = Field(default=None, alias="emailId")
    order: Optional[Annotated[int, Field(le=50, strict=True, ge=1)]] = None
    access_code: Optional[StrictStr] = Field(default=None, alias="accessCode")
    on_behalf_of: Optional[StrictStr] = Field(default=None, alias="onBehalfOf")
    phone_number: Optional[PhoneNumber] = Field(default=None, alias="phoneNumber")
    identity_verification_settings: Optional[IdentityVerificationSettings] = Field(default=None, alias="identityVerificationSettings")
    authentication_retry_count: Optional[Annotated[int, Field(le=10, strict=True, ge=1)]] = Field(default=None, alias="authenticationRetryCount")
    __properties: ClassVar[List[str]] = ["authenticationType", "emailId", "order", "accessCode", "onBehalfOf", "phoneNumber", "identityVerificationSettings", "authenticationRetryCount"]

    @field_validator('authentication_type')
    def authentication_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['None', 'EmailOTP', 'AccessCode', 'SMSOTP', 'IdVerification']):
            raise ValueError("must be one of enum values ('None', 'EmailOTP', 'AccessCode', 'SMSOTP', 'IdVerification')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(self, excluded_fields: Set[str] = None) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            elif isinstance(value, list):
                for index, item in enumerate(value):
                    if(isinstance(item, (int, str, bool))):
                        data.append((f'{key}[{index}]', item))
                    else:
                        data.append((key, json.dumps(value[index], ensure_ascii=False)))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccessCodeDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccessCodeDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "authenticationType": obj.get("authenticationType"),
            "emailId": obj.get("emailId"),
            "order": obj.get("order"),
            "accessCode": obj.get("accessCode"),
            "onBehalfOf": obj.get("onBehalfOf"),
            "phoneNumber": PhoneNumber.from_dict(obj["phoneNumber"]) if obj.get("phoneNumber") is not None else None,
            "identityVerificationSettings": IdentityVerificationSettings.from_dict(obj["identityVerificationSettings"]) if obj.get("identityVerificationSettings") is not None else None,
            "authenticationRetryCount": obj.get("authenticationRetryCount")
        })
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "authentication_type": "(str,)",
            "email_id": "(str,)",
            "order": "(int,)",
            "access_code": "(str,)",
            "on_behalf_of": "(str,)",
            "phone_number": "(PhoneNumber,)",
            "identity_verification_settings": "(IdentityVerificationSettings,)",
            "authentication_retry_count": "(int,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in [
        ]

