# coding: utf-8

"""
    BoldSign API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Contact: support@boldsign.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBytes, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from boldsign.models.create_template_request import CreateTemplateRequest
from boldsign.models.document_created import DocumentCreated
from boldsign.models.edit_template_request import EditTemplateRequest
from boldsign.models.embedded_create_template_request import EmbeddedCreateTemplateRequest
from boldsign.models.embedded_send_created import EmbeddedSendCreated
from boldsign.models.embedded_send_template_form_request import EmbeddedSendTemplateFormRequest
from boldsign.models.embedded_template_created import EmbeddedTemplateCreated
from boldsign.models.embedded_template_edit_request import EmbeddedTemplateEditRequest
from boldsign.models.embedded_template_edited import EmbeddedTemplateEdited
from boldsign.models.merge_and_send_for_sign_form import MergeAndSendForSignForm
from boldsign.models.send_for_sign_from_template_form import SendForSignFromTemplateForm
from boldsign.models.template_created import TemplateCreated
from boldsign.models.template_properties import TemplateProperties
from boldsign.models.template_records import TemplateRecords
from boldsign.models.template_tag import TemplateTag

from boldsign.api_client import ApiClient, RequestSerialized
from boldsign.api_response import ApiResponse
from boldsign.rest import RESTResponseType
import io


class TemplateApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def add_tag(
        self,
        template_tag: Annotated[Optional[TemplateTag], Field(description="ContainsTemplateId and Label Names for AddingTags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Add the Tags in Templates.


        :param template_tag: ContainsTemplateId and Label Names for AddingTags.
        :type template_tag: TemplateTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_tag_serialize(
            template_tag=template_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def add_tag_with_http_info(
        self,
        template_tag: Annotated[Optional[TemplateTag], Field(description="ContainsTemplateId and Label Names for AddingTags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Add the Tags in Templates.


        :param template_tag: ContainsTemplateId and Label Names for AddingTags.
        :type template_tag: TemplateTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_tag_serialize(
            template_tag=template_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def add_tag_without_preload_content(
        self,
        template_tag: Annotated[Optional[TemplateTag], Field(description="ContainsTemplateId and Label Names for AddingTags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add the Tags in Templates.


        :param template_tag: ContainsTemplateId and Label Names for AddingTags.
        :type template_tag: TemplateTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_tag_serialize(
            template_tag=template_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_tag_serialize(
        self,
        template_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = template_tag
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if template_tag is not None and has_files is False:
            _body_params = template_tag


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/template/addTags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_embedded_request_url_template(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        embedded_send_template_form_request: Annotated[Optional[EmbeddedSendTemplateFormRequest], Field(description="Embedded send template json request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmbeddedSendCreated:
        """Generates a send URL using a template which embeds document sending process into your application.


        :param template_id: The template id. (required)
        :type template_id: str
        :param embedded_send_template_form_request: Embedded send template json request.
        :type embedded_send_template_form_request: EmbeddedSendTemplateFormRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_embedded_request_url_template_serialize(
            template_id=template_id,
            embedded_send_template_form_request=embedded_send_template_form_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedSendCreated",
            '422': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_embedded_request_url_template_with_http_info(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        embedded_send_template_form_request: Annotated[Optional[EmbeddedSendTemplateFormRequest], Field(description="Embedded send template json request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmbeddedSendCreated]:
        """Generates a send URL using a template which embeds document sending process into your application.


        :param template_id: The template id. (required)
        :type template_id: str
        :param embedded_send_template_form_request: Embedded send template json request.
        :type embedded_send_template_form_request: EmbeddedSendTemplateFormRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_embedded_request_url_template_serialize(
            template_id=template_id,
            embedded_send_template_form_request=embedded_send_template_form_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedSendCreated",
            '422': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_embedded_request_url_template_without_preload_content(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        embedded_send_template_form_request: Annotated[Optional[EmbeddedSendTemplateFormRequest], Field(description="Embedded send template json request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generates a send URL using a template which embeds document sending process into your application.


        :param template_id: The template id. (required)
        :type template_id: str
        :param embedded_send_template_form_request: Embedded send template json request.
        :type embedded_send_template_form_request: EmbeddedSendTemplateFormRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_embedded_request_url_template_serialize(
            template_id=template_id,
            embedded_send_template_form_request=embedded_send_template_form_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedSendCreated",
            '422': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_embedded_request_url_template_serialize(
        self,
        template_id,
        embedded_send_template_form_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = embedded_send_template_form_request
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if template_id is not None:
            
            _query_params.append(('templateId', template_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if embedded_send_template_form_request is not None and has_files is False:
            _body_params = embedded_send_template_form_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/template/createEmbeddedRequestUrl',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_embedded_template_url(
        self,
        embedded_create_template_request: Annotated[Optional[EmbeddedCreateTemplateRequest], Field(description="The create embedded template request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmbeddedTemplateCreated:
        """Generates a create URL to embeds template create process into your application.


        :param embedded_create_template_request: The create embedded template request body.
        :type embedded_create_template_request: EmbeddedCreateTemplateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_embedded_template_url_serialize(
            embedded_create_template_request=embedded_create_template_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedTemplateCreated",
            '401': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_embedded_template_url_with_http_info(
        self,
        embedded_create_template_request: Annotated[Optional[EmbeddedCreateTemplateRequest], Field(description="The create embedded template request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmbeddedTemplateCreated]:
        """Generates a create URL to embeds template create process into your application.


        :param embedded_create_template_request: The create embedded template request body.
        :type embedded_create_template_request: EmbeddedCreateTemplateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_embedded_template_url_serialize(
            embedded_create_template_request=embedded_create_template_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedTemplateCreated",
            '401': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_embedded_template_url_without_preload_content(
        self,
        embedded_create_template_request: Annotated[Optional[EmbeddedCreateTemplateRequest], Field(description="The create embedded template request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generates a create URL to embeds template create process into your application.


        :param embedded_create_template_request: The create embedded template request body.
        :type embedded_create_template_request: EmbeddedCreateTemplateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_embedded_template_url_serialize(
            embedded_create_template_request=embedded_create_template_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedTemplateCreated",
            '401': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_embedded_template_url_serialize(
        self,
        embedded_create_template_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = embedded_create_template_request
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if embedded_create_template_request is not None and has_files is False:
            _body_params = embedded_create_template_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/template/createEmbeddedTemplateUrl',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_template(
        self,
        create_template_request: Annotated[Optional[CreateTemplateRequest], Field(description="The create template request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TemplateCreated:
        """Creates a new template.


        :param create_template_request: The create template request body.
        :type create_template_request: CreateTemplateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_template_serialize(
            create_template_request=create_template_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "TemplateCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_template_with_http_info(
        self,
        create_template_request: Annotated[Optional[CreateTemplateRequest], Field(description="The create template request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TemplateCreated]:
        """Creates a new template.


        :param create_template_request: The create template request body.
        :type create_template_request: CreateTemplateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_template_serialize(
            create_template_request=create_template_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "TemplateCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_template_without_preload_content(
        self,
        create_template_request: Annotated[Optional[CreateTemplateRequest], Field(description="The create template request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates a new template.


        :param create_template_request: The create template request body.
        :type create_template_request: CreateTemplateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_template_serialize(
            create_template_request=create_template_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "TemplateCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_template_serialize(
        self,
        create_template_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = create_template_request
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_template_request is not None and has_files is False:
            _body_params = create_template_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/template/create',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_tag(
        self,
        template_tag: Annotated[Optional[TemplateTag], Field(description="Contains TemplateId and LabelNames for Adding Tags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete the Tags in Templates.


        :param template_tag: Contains TemplateId and LabelNames for Adding Tags.
        :type template_tag: TemplateTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tag_serialize(
            template_tag=template_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '400': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_tag_with_http_info(
        self,
        template_tag: Annotated[Optional[TemplateTag], Field(description="Contains TemplateId and LabelNames for Adding Tags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete the Tags in Templates.


        :param template_tag: Contains TemplateId and LabelNames for Adding Tags.
        :type template_tag: TemplateTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tag_serialize(
            template_tag=template_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '400': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_tag_without_preload_content(
        self,
        template_tag: Annotated[Optional[TemplateTag], Field(description="Contains TemplateId and LabelNames for Adding Tags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete the Tags in Templates.


        :param template_tag: Contains TemplateId and LabelNames for Adding Tags.
        :type template_tag: TemplateTag
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tag_serialize(
            template_tag=template_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '400': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_tag_serialize(
        self,
        template_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = template_tag
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if template_tag is not None and has_files is False:
            _body_params = template_tag


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/template/deleteTags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_template(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Deletes a template.


        :param template_id: The template id. (required)
        :type template_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_template_serialize(
            template_id=template_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_template_with_http_info(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Deletes a template.


        :param template_id: The template id. (required)
        :type template_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_template_serialize(
            template_id=template_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_template_without_preload_content(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Deletes a template.


        :param template_id: The template id. (required)
        :type template_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_template_serialize(
            template_id=template_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_template_serialize(
        self,
        template_id,
        on_behalf_of,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if template_id is not None:
            
            _query_params.append(('templateId', template_id))
            
        if on_behalf_of is not None:
            
            _query_params.append(('onBehalfOf', on_behalf_of))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/template/delete',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download(
        self,
        template_id: Annotated[StrictStr, Field(description="Template Id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> io.IOBase:
        """Download the template.


        :param template_id: Template Id. (required)
        :type template_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_serialize(
            template_id=template_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '400': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_with_http_info(
        self,
        template_id: Annotated[StrictStr, Field(description="Template Id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[io.IOBase]:
        """Download the template.


        :param template_id: Template Id. (required)
        :type template_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_serialize(
            template_id=template_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '400': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_without_preload_content(
        self,
        template_id: Annotated[StrictStr, Field(description="Template Id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Download the template.


        :param template_id: Template Id. (required)
        :type template_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_serialize(
            template_id=template_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '400': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_serialize(
        self,
        template_id,
        on_behalf_of,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if template_id is not None:
            
            _query_params.append(('templateId', template_id))
            
        if on_behalf_of is not None:
            
            _query_params.append(('onBehalfOf', on_behalf_of))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/template/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def edit_template(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        edit_template_request: Annotated[EditTemplateRequest, Field(description="The edit template request body.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Edit and updates an existing template.


        :param template_id: The template id. (required)
        :type template_id: str
        :param edit_template_request: The edit template request body. (required)
        :type edit_template_request: EditTemplateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_template_serialize(
            template_id=template_id,
            edit_template_request=edit_template_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResult",
            '422': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def edit_template_with_http_info(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        edit_template_request: Annotated[EditTemplateRequest, Field(description="The edit template request body.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Edit and updates an existing template.


        :param template_id: The template id. (required)
        :type template_id: str
        :param edit_template_request: The edit template request body. (required)
        :type edit_template_request: EditTemplateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_template_serialize(
            template_id=template_id,
            edit_template_request=edit_template_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResult",
            '422': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def edit_template_without_preload_content(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        edit_template_request: Annotated[EditTemplateRequest, Field(description="The edit template request body.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Edit and updates an existing template.


        :param template_id: The template id. (required)
        :type template_id: str
        :param edit_template_request: The edit template request body. (required)
        :type edit_template_request: EditTemplateRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_template_serialize(
            template_id=template_id,
            edit_template_request=edit_template_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResult",
            '422': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _edit_template_serialize(
        self,
        template_id,
        edit_template_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = edit_template_request
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if template_id is not None:
            
            _query_params.append(('templateId', template_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if edit_template_request is not None and has_files is False:
            _body_params = edit_template_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/template/edit',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_embedded_template_edit_url(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        embedded_template_edit_request: Annotated[Optional[EmbeddedTemplateEditRequest], Field(description="The embedded edit template request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmbeddedTemplateEdited:
        """Generates a edit URL to embeds template edit process into your application.


        :param template_id: The template id. (required)
        :type template_id: str
        :param embedded_template_edit_request: The embedded edit template request body.
        :type embedded_template_edit_request: EmbeddedTemplateEditRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_embedded_template_edit_url_serialize(
            template_id=template_id,
            embedded_template_edit_request=embedded_template_edit_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedTemplateEdited",
            '400': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_embedded_template_edit_url_with_http_info(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        embedded_template_edit_request: Annotated[Optional[EmbeddedTemplateEditRequest], Field(description="The embedded edit template request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmbeddedTemplateEdited]:
        """Generates a edit URL to embeds template edit process into your application.


        :param template_id: The template id. (required)
        :type template_id: str
        :param embedded_template_edit_request: The embedded edit template request body.
        :type embedded_template_edit_request: EmbeddedTemplateEditRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_embedded_template_edit_url_serialize(
            template_id=template_id,
            embedded_template_edit_request=embedded_template_edit_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedTemplateEdited",
            '400': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_embedded_template_edit_url_without_preload_content(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        embedded_template_edit_request: Annotated[Optional[EmbeddedTemplateEditRequest], Field(description="The embedded edit template request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generates a edit URL to embeds template edit process into your application.


        :param template_id: The template id. (required)
        :type template_id: str
        :param embedded_template_edit_request: The embedded edit template request body.
        :type embedded_template_edit_request: EmbeddedTemplateEditRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_embedded_template_edit_url_serialize(
            template_id=template_id,
            embedded_template_edit_request=embedded_template_edit_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedTemplateEdited",
            '400': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_embedded_template_edit_url_serialize(
        self,
        template_id,
        embedded_template_edit_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = embedded_template_edit_request
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if template_id is not None:
            
            _query_params.append(('templateId', template_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if embedded_template_edit_request is not None and has_files is False:
            _body_params = embedded_template_edit_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/template/getEmbeddedTemplateEditUrl',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_properties(
        self,
        template_id: Annotated[StrictStr, Field(description="Template Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TemplateProperties:
        """Get summary of the template.


        :param template_id: Template Id. (required)
        :type template_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_properties_serialize(
            template_id=template_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TemplateProperties",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_properties_with_http_info(
        self,
        template_id: Annotated[StrictStr, Field(description="Template Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TemplateProperties]:
        """Get summary of the template.


        :param template_id: Template Id. (required)
        :type template_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_properties_serialize(
            template_id=template_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TemplateProperties",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_properties_without_preload_content(
        self,
        template_id: Annotated[StrictStr, Field(description="Template Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get summary of the template.


        :param template_id: Template Id. (required)
        :type template_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_properties_serialize(
            template_id=template_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TemplateProperties",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_properties_serialize(
        self,
        template_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if template_id is not None:
            
            _query_params.append(('templateId', template_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/template/properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_templates(
        self,
        page: StrictInt,
        template_type: Optional[StrictStr] = None,
        page_size: Optional[StrictInt] = None,
        search_key: Optional[StrictStr] = None,
        on_behalf_of: Annotated[Optional[List[StrictStr]], Field(description="The sender identity's email used to filter the templates returned in the API. The API will return templates that were sent on behalf of the specified email address.")] = None,
        created_by: Annotated[Optional[List[StrictStr]], Field(description="The templates can be listed by the creator of the template.")] = None,
        template_labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the template.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the template")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the template")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the template.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TemplateRecords:
        """List all the templates.


        :param page: (required)
        :type page: int
        :param template_type:
        :type template_type: str
        :param page_size:
        :type page_size: int
        :param search_key:
        :type search_key: str
        :param on_behalf_of: The sender identity's email used to filter the templates returned in the API. The API will return templates that were sent on behalf of the specified email address.
        :type on_behalf_of: List[str]
        :param created_by: The templates can be listed by the creator of the template.
        :type created_by: List[str]
        :param template_labels: Labels of the template.
        :type template_labels: List[str]
        :param start_date: Start date of the template
        :type start_date: datetime
        :param end_date: End date of the template
        :type end_date: datetime
        :param brand_ids: BrandId(s) of the template.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_templates_serialize(
            page=page,
            template_type=template_type,
            page_size=page_size,
            search_key=search_key,
            on_behalf_of=on_behalf_of,
            created_by=created_by,
            template_labels=template_labels,
            start_date=start_date,
            end_date=end_date,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TemplateRecords",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_templates_with_http_info(
        self,
        page: StrictInt,
        template_type: Optional[StrictStr] = None,
        page_size: Optional[StrictInt] = None,
        search_key: Optional[StrictStr] = None,
        on_behalf_of: Annotated[Optional[List[StrictStr]], Field(description="The sender identity's email used to filter the templates returned in the API. The API will return templates that were sent on behalf of the specified email address.")] = None,
        created_by: Annotated[Optional[List[StrictStr]], Field(description="The templates can be listed by the creator of the template.")] = None,
        template_labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the template.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the template")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the template")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the template.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TemplateRecords]:
        """List all the templates.


        :param page: (required)
        :type page: int
        :param template_type:
        :type template_type: str
        :param page_size:
        :type page_size: int
        :param search_key:
        :type search_key: str
        :param on_behalf_of: The sender identity's email used to filter the templates returned in the API. The API will return templates that were sent on behalf of the specified email address.
        :type on_behalf_of: List[str]
        :param created_by: The templates can be listed by the creator of the template.
        :type created_by: List[str]
        :param template_labels: Labels of the template.
        :type template_labels: List[str]
        :param start_date: Start date of the template
        :type start_date: datetime
        :param end_date: End date of the template
        :type end_date: datetime
        :param brand_ids: BrandId(s) of the template.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_templates_serialize(
            page=page,
            template_type=template_type,
            page_size=page_size,
            search_key=search_key,
            on_behalf_of=on_behalf_of,
            created_by=created_by,
            template_labels=template_labels,
            start_date=start_date,
            end_date=end_date,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TemplateRecords",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_templates_without_preload_content(
        self,
        page: StrictInt,
        template_type: Optional[StrictStr] = None,
        page_size: Optional[StrictInt] = None,
        search_key: Optional[StrictStr] = None,
        on_behalf_of: Annotated[Optional[List[StrictStr]], Field(description="The sender identity's email used to filter the templates returned in the API. The API will return templates that were sent on behalf of the specified email address.")] = None,
        created_by: Annotated[Optional[List[StrictStr]], Field(description="The templates can be listed by the creator of the template.")] = None,
        template_labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the template.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the template")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the template")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the template.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List all the templates.


        :param page: (required)
        :type page: int
        :param template_type:
        :type template_type: str
        :param page_size:
        :type page_size: int
        :param search_key:
        :type search_key: str
        :param on_behalf_of: The sender identity's email used to filter the templates returned in the API. The API will return templates that were sent on behalf of the specified email address.
        :type on_behalf_of: List[str]
        :param created_by: The templates can be listed by the creator of the template.
        :type created_by: List[str]
        :param template_labels: Labels of the template.
        :type template_labels: List[str]
        :param start_date: Start date of the template
        :type start_date: datetime
        :param end_date: End date of the template
        :type end_date: datetime
        :param brand_ids: BrandId(s) of the template.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_templates_serialize(
            page=page,
            template_type=template_type,
            page_size=page_size,
            search_key=search_key,
            on_behalf_of=on_behalf_of,
            created_by=created_by,
            template_labels=template_labels,
            start_date=start_date,
            end_date=end_date,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TemplateRecords",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_templates_serialize(
        self,
        page,
        template_type,
        page_size,
        search_key,
        on_behalf_of,
        created_by,
        template_labels,
        start_date,
        end_date,
        brand_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'OnBehalfOf': 'multi',
            'CreatedBy': 'multi',
            'TemplateLabels': 'multi',
            'BrandIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if template_type is not None:
            
            _query_params.append(('TemplateType', template_type))
            
        if page_size is not None:
            
            _query_params.append(('PageSize', page_size))
            
        if page is not None:
            
            _query_params.append(('Page', page))
            
        if search_key is not None:
            
            _query_params.append(('SearchKey', search_key))
            
        if on_behalf_of is not None:
            
            _query_params.append(('OnBehalfOf', on_behalf_of))
            
        if created_by is not None:
            
            _query_params.append(('CreatedBy', created_by))
            
        if template_labels is not None:
            
            _query_params.append(('TemplateLabels', template_labels))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'StartDate',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('StartDate', start_date))
            
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'EndDate',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('EndDate', end_date))
            
        if brand_ids is not None:
            
            _query_params.append(('BrandIds', brand_ids))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/template/list',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def merge_and_send(
        self,
        merge_and_send_for_sign_form: Annotated[Optional[MergeAndSendForSignForm], Field(description="The merge and send details as JSON.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Send the document by merging multiple templates.


        :param merge_and_send_for_sign_form: The merge and send details as JSON.
        :type merge_and_send_for_sign_form: MergeAndSendForSignForm
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._merge_and_send_serialize(
            merge_and_send_for_sign_form=merge_and_send_for_sign_form,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '422': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def merge_and_send_with_http_info(
        self,
        merge_and_send_for_sign_form: Annotated[Optional[MergeAndSendForSignForm], Field(description="The merge and send details as JSON.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Send the document by merging multiple templates.


        :param merge_and_send_for_sign_form: The merge and send details as JSON.
        :type merge_and_send_for_sign_form: MergeAndSendForSignForm
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._merge_and_send_serialize(
            merge_and_send_for_sign_form=merge_and_send_for_sign_form,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '422': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def merge_and_send_without_preload_content(
        self,
        merge_and_send_for_sign_form: Annotated[Optional[MergeAndSendForSignForm], Field(description="The merge and send details as JSON.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send the document by merging multiple templates.


        :param merge_and_send_for_sign_form: The merge and send details as JSON.
        :type merge_and_send_for_sign_form: MergeAndSendForSignForm
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._merge_and_send_serialize(
            merge_and_send_for_sign_form=merge_and_send_for_sign_form,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '422': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _merge_and_send_serialize(
        self,
        merge_and_send_for_sign_form,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = merge_and_send_for_sign_form
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if merge_and_send_for_sign_form is not None and has_files is False:
            _body_params = merge_and_send_for_sign_form


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/template/mergeAndSend',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def send_using_template(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        send_for_sign_from_template_form: Annotated[Optional[SendForSignFromTemplateForm], Field(description="The send template details as JSON.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DocumentCreated:
        """Send a document for signature using a Template.


        :param template_id: The template id. (required)
        :type template_id: str
        :param send_for_sign_from_template_form: The send template details as JSON.
        :type send_for_sign_from_template_form: SendForSignFromTemplateForm
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._send_using_template_serialize(
            template_id=template_id,
            send_for_sign_from_template_form=send_for_sign_from_template_form,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DocumentCreated",
            '401': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def send_using_template_with_http_info(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        send_for_sign_from_template_form: Annotated[Optional[SendForSignFromTemplateForm], Field(description="The send template details as JSON.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DocumentCreated]:
        """Send a document for signature using a Template.


        :param template_id: The template id. (required)
        :type template_id: str
        :param send_for_sign_from_template_form: The send template details as JSON.
        :type send_for_sign_from_template_form: SendForSignFromTemplateForm
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._send_using_template_serialize(
            template_id=template_id,
            send_for_sign_from_template_form=send_for_sign_from_template_form,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DocumentCreated",
            '401': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def send_using_template_without_preload_content(
        self,
        template_id: Annotated[StrictStr, Field(description="The template id.")],
        send_for_sign_from_template_form: Annotated[Optional[SendForSignFromTemplateForm], Field(description="The send template details as JSON.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send a document for signature using a Template.


        :param template_id: The template id. (required)
        :type template_id: str
        :param send_for_sign_from_template_form: The send template details as JSON.
        :type send_for_sign_from_template_form: SendForSignFromTemplateForm
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._send_using_template_serialize(
            template_id=template_id,
            send_for_sign_from_template_form=send_for_sign_from_template_form,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DocumentCreated",
            '401': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _send_using_template_serialize(
        self,
        template_id,
        send_for_sign_from_template_form,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = send_for_sign_from_template_form
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if template_id is not None:
            
            _query_params.append(('templateId', template_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if send_for_sign_from_template_form is not None and has_files is False:
            _body_params = send_for_sign_from_template_form


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/template/send',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


