# coding: utf-8

"""
    BoldSign API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Contact: support@boldsign.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from boldsign.models.access_code_detail import AccessCodeDetail
from boldsign.models.access_code_details import AccessCodeDetails
from boldsign.models.behalf_document_records import BehalfDocumentRecords
from boldsign.models.change_recipient import ChangeRecipient
from boldsign.models.document_created import DocumentCreated
from boldsign.models.document_properties import DocumentProperties
from boldsign.models.document_records import DocumentRecords
from boldsign.models.document_tags import DocumentTags
from boldsign.models.embedded_document_request import EmbeddedDocumentRequest
from boldsign.models.embedded_send_created import EmbeddedSendCreated
from boldsign.models.embedded_signing_link import EmbeddedSigningLink
from boldsign.models.extend_expiry import ExtendExpiry
from boldsign.models.prefill_field_request import PrefillFieldRequest
from boldsign.models.reminder_message import ReminderMessage
from boldsign.models.remove_authentication import RemoveAuthentication
from boldsign.models.revoke_document import RevokeDocument
from boldsign.models.send_for_sign import SendForSign
from boldsign.models.team_document_records import TeamDocumentRecords

from boldsign.api_client import ApiClient, RequestSerialized
from boldsign.api_response import ApiResponse
from boldsign.rest import RESTResponseType
import io


class DocumentApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def add_authentication(
        self,
        document_id: Annotated[StrictStr, Field(description="The DocumentId.")],
        access_code_detail: Annotated[Optional[AccessCodeDetail], Field(description="Access code details.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """The add authentication to recipient.


        :param document_id: The DocumentId. (required)
        :type document_id: str
        :param access_code_detail: Access code details.
        :type access_code_detail: AccessCodeDetail
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_authentication_serialize(
            document_id=document_id,
            access_code_detail=access_code_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def add_authentication_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="The DocumentId.")],
        access_code_detail: Annotated[Optional[AccessCodeDetail], Field(description="Access code details.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """The add authentication to recipient.


        :param document_id: The DocumentId. (required)
        :type document_id: str
        :param access_code_detail: Access code details.
        :type access_code_detail: AccessCodeDetail
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_authentication_serialize(
            document_id=document_id,
            access_code_detail=access_code_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def add_authentication_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="The DocumentId.")],
        access_code_detail: Annotated[Optional[AccessCodeDetail], Field(description="Access code details.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """The add authentication to recipient.


        :param document_id: The DocumentId. (required)
        :type document_id: str
        :param access_code_detail: Access code details.
        :type access_code_detail: AccessCodeDetail
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_authentication_serialize(
            document_id=document_id,
            access_code_detail=access_code_detail,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_authentication_serialize(
        self,
        document_id,
        access_code_detail,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = access_code_detail
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if access_code_detail is not None and has_files is False:
            _body_params = access_code_detail


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/document/addAuthentication',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def add_tag(
        self,
        document_tags: Annotated[Optional[DocumentTags], Field(description="Contains DocumentId and LabelNames for Adding Tags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Add the Tags in Documents.


        :param document_tags: Contains DocumentId and LabelNames for Adding Tags.
        :type document_tags: DocumentTags
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_tag_serialize(
            document_tags=document_tags,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def add_tag_with_http_info(
        self,
        document_tags: Annotated[Optional[DocumentTags], Field(description="Contains DocumentId and LabelNames for Adding Tags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Add the Tags in Documents.


        :param document_tags: Contains DocumentId and LabelNames for Adding Tags.
        :type document_tags: DocumentTags
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_tag_serialize(
            document_tags=document_tags,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def add_tag_without_preload_content(
        self,
        document_tags: Annotated[Optional[DocumentTags], Field(description="Contains DocumentId and LabelNames for Adding Tags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add the Tags in Documents.


        :param document_tags: Contains DocumentId and LabelNames for Adding Tags.
        :type document_tags: DocumentTags
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._add_tag_serialize(
            document_tags=document_tags,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '400': "ErrorResult",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _add_tag_serialize(
        self,
        document_tags,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = document_tags
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if document_tags is not None and has_files is False:
            _body_params = document_tags


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/document/addTags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def behalf_documents(
        self,
        page: Annotated[StrictInt, Field(description="Page index specified in get document list request.")],
        page_type: Annotated[Optional[StrictStr], Field(description="The filter used to differentiate between documents sent on the user's behalf and documents sent by the user on behalf of others. The API will return documents based on the specified value.")] = None,
        email_address: Annotated[Optional[List[StrictStr]], Field(description="The sender identity's email used to filter the documents returned in the API. The API will return documents that were sent on behalf of the specified email address.")] = None,
        signers: Annotated[Optional[List[StrictStr]], Field(description="A list of signer email addresses used to filter the documents returned in the API. The API will return documents where the signer's email address matches one of the email addresses provided in this list")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size specified in get document list request.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the document")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the document")] = None,
        search_key: Annotated[Optional[StrictStr], Field(description="Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the document.")] = None,
        next_cursor: Annotated[Optional[StrictInt], Field(description="Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the document.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BehalfDocumentRecords:
        """Gets the behalf documents.


        :param page: Page index specified in get document list request. (required)
        :type page: int
        :param page_type: The filter used to differentiate between documents sent on the user's behalf and documents sent by the user on behalf of others. The API will return documents based on the specified value.
        :type page_type: str
        :param email_address: The sender identity's email used to filter the documents returned in the API. The API will return documents that were sent on behalf of the specified email address.
        :type email_address: List[str]
        :param signers: A list of signer email addresses used to filter the documents returned in the API. The API will return documents where the signer's email address matches one of the email addresses provided in this list
        :type signers: List[str]
        :param page_size: Page size specified in get document list request.
        :type page_size: int
        :param start_date: Start date of the document
        :type start_date: datetime
        :param status: Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.
        :type status: List[str]
        :param end_date: End date of the document
        :type end_date: datetime
        :param search_key: Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,
        :type search_key: str
        :param labels: Labels of the document.
        :type labels: List[str]
        :param next_cursor: Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.
        :type next_cursor: int
        :param brand_ids: BrandId(s) of the document.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._behalf_documents_serialize(
            page=page,
            page_type=page_type,
            email_address=email_address,
            signers=signers,
            page_size=page_size,
            start_date=start_date,
            status=status,
            end_date=end_date,
            search_key=search_key,
            labels=labels,
            next_cursor=next_cursor,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BehalfDocumentRecords",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def behalf_documents_with_http_info(
        self,
        page: Annotated[StrictInt, Field(description="Page index specified in get document list request.")],
        page_type: Annotated[Optional[StrictStr], Field(description="The filter used to differentiate between documents sent on the user's behalf and documents sent by the user on behalf of others. The API will return documents based on the specified value.")] = None,
        email_address: Annotated[Optional[List[StrictStr]], Field(description="The sender identity's email used to filter the documents returned in the API. The API will return documents that were sent on behalf of the specified email address.")] = None,
        signers: Annotated[Optional[List[StrictStr]], Field(description="A list of signer email addresses used to filter the documents returned in the API. The API will return documents where the signer's email address matches one of the email addresses provided in this list")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size specified in get document list request.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the document")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the document")] = None,
        search_key: Annotated[Optional[StrictStr], Field(description="Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the document.")] = None,
        next_cursor: Annotated[Optional[StrictInt], Field(description="Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the document.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BehalfDocumentRecords]:
        """Gets the behalf documents.


        :param page: Page index specified in get document list request. (required)
        :type page: int
        :param page_type: The filter used to differentiate between documents sent on the user's behalf and documents sent by the user on behalf of others. The API will return documents based on the specified value.
        :type page_type: str
        :param email_address: The sender identity's email used to filter the documents returned in the API. The API will return documents that were sent on behalf of the specified email address.
        :type email_address: List[str]
        :param signers: A list of signer email addresses used to filter the documents returned in the API. The API will return documents where the signer's email address matches one of the email addresses provided in this list
        :type signers: List[str]
        :param page_size: Page size specified in get document list request.
        :type page_size: int
        :param start_date: Start date of the document
        :type start_date: datetime
        :param status: Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.
        :type status: List[str]
        :param end_date: End date of the document
        :type end_date: datetime
        :param search_key: Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,
        :type search_key: str
        :param labels: Labels of the document.
        :type labels: List[str]
        :param next_cursor: Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.
        :type next_cursor: int
        :param brand_ids: BrandId(s) of the document.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._behalf_documents_serialize(
            page=page,
            page_type=page_type,
            email_address=email_address,
            signers=signers,
            page_size=page_size,
            start_date=start_date,
            status=status,
            end_date=end_date,
            search_key=search_key,
            labels=labels,
            next_cursor=next_cursor,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BehalfDocumentRecords",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def behalf_documents_without_preload_content(
        self,
        page: Annotated[StrictInt, Field(description="Page index specified in get document list request.")],
        page_type: Annotated[Optional[StrictStr], Field(description="The filter used to differentiate between documents sent on the user's behalf and documents sent by the user on behalf of others. The API will return documents based on the specified value.")] = None,
        email_address: Annotated[Optional[List[StrictStr]], Field(description="The sender identity's email used to filter the documents returned in the API. The API will return documents that were sent on behalf of the specified email address.")] = None,
        signers: Annotated[Optional[List[StrictStr]], Field(description="A list of signer email addresses used to filter the documents returned in the API. The API will return documents where the signer's email address matches one of the email addresses provided in this list")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size specified in get document list request.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the document")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the document")] = None,
        search_key: Annotated[Optional[StrictStr], Field(description="Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the document.")] = None,
        next_cursor: Annotated[Optional[StrictInt], Field(description="Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the document.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets the behalf documents.


        :param page: Page index specified in get document list request. (required)
        :type page: int
        :param page_type: The filter used to differentiate between documents sent on the user's behalf and documents sent by the user on behalf of others. The API will return documents based on the specified value.
        :type page_type: str
        :param email_address: The sender identity's email used to filter the documents returned in the API. The API will return documents that were sent on behalf of the specified email address.
        :type email_address: List[str]
        :param signers: A list of signer email addresses used to filter the documents returned in the API. The API will return documents where the signer's email address matches one of the email addresses provided in this list
        :type signers: List[str]
        :param page_size: Page size specified in get document list request.
        :type page_size: int
        :param start_date: Start date of the document
        :type start_date: datetime
        :param status: Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.
        :type status: List[str]
        :param end_date: End date of the document
        :type end_date: datetime
        :param search_key: Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,
        :type search_key: str
        :param labels: Labels of the document.
        :type labels: List[str]
        :param next_cursor: Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.
        :type next_cursor: int
        :param brand_ids: BrandId(s) of the document.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._behalf_documents_serialize(
            page=page,
            page_type=page_type,
            email_address=email_address,
            signers=signers,
            page_size=page_size,
            start_date=start_date,
            status=status,
            end_date=end_date,
            search_key=search_key,
            labels=labels,
            next_cursor=next_cursor,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BehalfDocumentRecords",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _behalf_documents_serialize(
        self,
        page,
        page_type,
        email_address,
        signers,
        page_size,
        start_date,
        status,
        end_date,
        search_key,
        labels,
        next_cursor,
        brand_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'EmailAddress': 'multi',
            'Signers': 'multi',
            'Status': 'multi',
            'Labels': 'multi',
            'BrandIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page_type is not None:
            
            _query_params.append(('PageType', page_type))
            
        if email_address is not None:
            
            _query_params.append(('EmailAddress', email_address))
            
        if signers is not None:
            
            _query_params.append(('Signers', signers))
            
        if page_size is not None:
            
            _query_params.append(('PageSize', page_size))
            
        if page is not None:
            
            _query_params.append(('Page', page))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'StartDate',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('StartDate', start_date))
            
        if status is not None:
            
            _query_params.append(('Status', status))
            
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'EndDate',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('EndDate', end_date))
            
        if search_key is not None:
            
            _query_params.append(('SearchKey', search_key))
            
        if labels is not None:
            
            _query_params.append(('Labels', labels))
            
        if next_cursor is not None:
            
            _query_params.append(('NextCursor', next_cursor))
            
        if brand_ids is not None:
            
            _query_params.append(('BrandIds', brand_ids))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/document/behalfList',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def change_access_code(
        self,
        document_id: StrictStr,
        access_code_details: Annotated[AccessCodeDetails, Field(description="The new access code.")],
        email_id: Optional[StrictStr] = None,
        z_order: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Changes the access code for the given document signer.


        :param document_id: (required)
        :type document_id: str
        :param access_code_details: The new access code. (required)
        :type access_code_details: AccessCodeDetails
        :param email_id:
        :type email_id: str
        :param z_order:
        :type z_order: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._change_access_code_serialize(
            document_id=document_id,
            access_code_details=access_code_details,
            email_id=email_id,
            z_order=z_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def change_access_code_with_http_info(
        self,
        document_id: StrictStr,
        access_code_details: Annotated[AccessCodeDetails, Field(description="The new access code.")],
        email_id: Optional[StrictStr] = None,
        z_order: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Changes the access code for the given document signer.


        :param document_id: (required)
        :type document_id: str
        :param access_code_details: The new access code. (required)
        :type access_code_details: AccessCodeDetails
        :param email_id:
        :type email_id: str
        :param z_order:
        :type z_order: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._change_access_code_serialize(
            document_id=document_id,
            access_code_details=access_code_details,
            email_id=email_id,
            z_order=z_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def change_access_code_without_preload_content(
        self,
        document_id: StrictStr,
        access_code_details: Annotated[AccessCodeDetails, Field(description="The new access code.")],
        email_id: Optional[StrictStr] = None,
        z_order: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Changes the access code for the given document signer.


        :param document_id: (required)
        :type document_id: str
        :param access_code_details: The new access code. (required)
        :type access_code_details: AccessCodeDetails
        :param email_id:
        :type email_id: str
        :param z_order:
        :type z_order: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._change_access_code_serialize(
            document_id=document_id,
            access_code_details=access_code_details,
            email_id=email_id,
            z_order=z_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _change_access_code_serialize(
        self,
        document_id,
        access_code_details,
        email_id,
        z_order,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = access_code_details
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('DocumentId', document_id))
            
        if email_id is not None:
            
            _query_params.append(('EmailId', email_id))
            
        if z_order is not None:
            
            _query_params.append(('ZOrder', z_order))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if access_code_details is not None and has_files is False:
            _body_params = access_code_details


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/document/changeAccessCode',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def change_recipient(
        self,
        document_id: Annotated[StrictStr, Field(description="The documentID details.")],
        change_recipient: Annotated[ChangeRecipient, Field(description="The new recipient details.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Change recipient details of a document.


        :param document_id: The documentID details. (required)
        :type document_id: str
        :param change_recipient: The new recipient details. (required)
        :type change_recipient: ChangeRecipient
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._change_recipient_serialize(
            document_id=document_id,
            change_recipient=change_recipient,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def change_recipient_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="The documentID details.")],
        change_recipient: Annotated[ChangeRecipient, Field(description="The new recipient details.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Change recipient details of a document.


        :param document_id: The documentID details. (required)
        :type document_id: str
        :param change_recipient: The new recipient details. (required)
        :type change_recipient: ChangeRecipient
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._change_recipient_serialize(
            document_id=document_id,
            change_recipient=change_recipient,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def change_recipient_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="The documentID details.")],
        change_recipient: Annotated[ChangeRecipient, Field(description="The new recipient details.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Change recipient details of a document.


        :param document_id: The documentID details. (required)
        :type document_id: str
        :param change_recipient: The new recipient details. (required)
        :type change_recipient: ChangeRecipient
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._change_recipient_serialize(
            document_id=document_id,
            change_recipient=change_recipient,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _change_recipient_serialize(
        self,
        document_id,
        change_recipient,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = change_recipient
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if change_recipient is not None and has_files is False:
            _body_params = change_recipient


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/document/changeRecipient',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_embedded_request_url_document(
        self,
        embedded_document_request: Annotated[Optional[EmbeddedDocumentRequest], Field(description="The embedded send document request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmbeddedSendCreated:
        """Generates a send URL which embeds document sending process into your application.


        :param embedded_document_request: The embedded send document request body.
        :type embedded_document_request: EmbeddedDocumentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_embedded_request_url_document_serialize(
            embedded_document_request=embedded_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedSendCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '400': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_embedded_request_url_document_with_http_info(
        self,
        embedded_document_request: Annotated[Optional[EmbeddedDocumentRequest], Field(description="The embedded send document request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmbeddedSendCreated]:
        """Generates a send URL which embeds document sending process into your application.


        :param embedded_document_request: The embedded send document request body.
        :type embedded_document_request: EmbeddedDocumentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_embedded_request_url_document_serialize(
            embedded_document_request=embedded_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedSendCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '400': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_embedded_request_url_document_without_preload_content(
        self,
        embedded_document_request: Annotated[Optional[EmbeddedDocumentRequest], Field(description="The embedded send document request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generates a send URL which embeds document sending process into your application.


        :param embedded_document_request: The embedded send document request body.
        :type embedded_document_request: EmbeddedDocumentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_embedded_request_url_document_serialize(
            embedded_document_request=embedded_document_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "EmbeddedSendCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '400': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_embedded_request_url_document_serialize(
        self,
        embedded_document_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = embedded_document_request
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if embedded_document_request is not None and has_files is False:
            _body_params = embedded_document_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/document/createEmbeddedRequestUrl',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_document(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        delete_permanently: Annotated[Optional[StrictBool], Field(description="Delete Permanently.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param delete_permanently: Delete Permanently.
        :type delete_permanently: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_document_serialize(
            document_id=document_id,
            delete_permanently=delete_permanently,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_document_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        delete_permanently: Annotated[Optional[StrictBool], Field(description="Delete Permanently.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param delete_permanently: Delete Permanently.
        :type delete_permanently: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_document_serialize(
            document_id=document_id,
            delete_permanently=delete_permanently,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_document_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        delete_permanently: Annotated[Optional[StrictBool], Field(description="Delete Permanently.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param delete_permanently: Delete Permanently.
        :type delete_permanently: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_document_serialize(
            document_id=document_id,
            delete_permanently=delete_permanently,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_document_serialize(
        self,
        document_id,
        delete_permanently,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        if delete_permanently is not None:
            
            _query_params.append(('deletePermanently', delete_permanently))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/document/delete',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_tag(
        self,
        document_tags: Annotated[Optional[DocumentTags], Field(description="Contains DocumentId and LabelNames for Adding Tags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete the Tags in Documents.


        :param document_tags: Contains DocumentId and LabelNames for Adding Tags.
        :type document_tags: DocumentTags
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tag_serialize(
            document_tags=document_tags,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '400': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_tag_with_http_info(
        self,
        document_tags: Annotated[Optional[DocumentTags], Field(description="Contains DocumentId and LabelNames for Adding Tags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete the Tags in Documents.


        :param document_tags: Contains DocumentId and LabelNames for Adding Tags.
        :type document_tags: DocumentTags
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tag_serialize(
            document_tags=document_tags,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '400': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_tag_without_preload_content(
        self,
        document_tags: Annotated[Optional[DocumentTags], Field(description="Contains DocumentId and LabelNames for Adding Tags.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete the Tags in Documents.


        :param document_tags: Contains DocumentId and LabelNames for Adding Tags.
        :type document_tags: DocumentTags
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_tag_serialize(
            document_tags=document_tags,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '400': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_tag_serialize(
        self,
        document_tags,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = document_tags
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if document_tags is not None and has_files is False:
            _body_params = document_tags


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/document/deleteTags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download_attachment(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        attachment_id: Annotated[StrictStr, Field(description="Attachment Id(Get attachment ID from Properties API).")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> io.IOBase:
        """Download the Attachment.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param attachment_id: Attachment Id(Get attachment ID from Properties API). (required)
        :type attachment_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_attachment_serialize(
            document_id=document_id,
            attachment_id=attachment_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_attachment_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        attachment_id: Annotated[StrictStr, Field(description="Attachment Id(Get attachment ID from Properties API).")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[io.IOBase]:
        """Download the Attachment.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param attachment_id: Attachment Id(Get attachment ID from Properties API). (required)
        :type attachment_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_attachment_serialize(
            document_id=document_id,
            attachment_id=attachment_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_attachment_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        attachment_id: Annotated[StrictStr, Field(description="Attachment Id(Get attachment ID from Properties API).")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Download the Attachment.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param attachment_id: Attachment Id(Get attachment ID from Properties API). (required)
        :type attachment_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_attachment_serialize(
            document_id=document_id,
            attachment_id=attachment_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_attachment_serialize(
        self,
        document_id,
        attachment_id,
        on_behalf_of,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        if attachment_id is not None:
            
            _query_params.append(('attachmentId', attachment_id))
            
        if on_behalf_of is not None:
            
            _query_params.append(('onBehalfOf', on_behalf_of))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/document/downloadAttachment',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download_audit_log(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> io.IOBase:
        """Download the audit trail document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_audit_log_serialize(
            document_id=document_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_audit_log_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[io.IOBase]:
        """Download the audit trail document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_audit_log_serialize(
            document_id=document_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_audit_log_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Download the audit trail document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_audit_log_serialize(
            document_id=document_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_audit_log_serialize(
        self,
        document_id,
        on_behalf_of,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        if on_behalf_of is not None:
            
            _query_params.append(('onBehalfOf', on_behalf_of))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/document/downloadAuditLog',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def download_document(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> io.IOBase:
        """Download the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_document_serialize(
            document_id=document_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def download_document_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[io.IOBase]:
        """Download the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_document_serialize(
            document_id=document_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def download_document_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        on_behalf_of: Annotated[Optional[StrictStr], Field(description="The on behalfof email address.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Download the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param on_behalf_of: The on behalfof email address.
        :type on_behalf_of: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._download_document_serialize(
            document_id=document_id,
            on_behalf_of=on_behalf_of,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "io.IOBase",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _download_document_serialize(
        self,
        document_id,
        on_behalf_of,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        if on_behalf_of is not None:
            
            _query_params.append(('onBehalfOf', on_behalf_of))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/document/download',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def extend_expiry(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        extend_expiry: Annotated[Optional[ExtendExpiry], Field(description="The new expiry value should be specified in yyyy-MM-dd format for days type, ISO date time format for specific date time and integer for hours type.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Extends the expiration date of the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param extend_expiry: The new expiry value should be specified in yyyy-MM-dd format for days type, ISO date time format for specific date time and integer for hours type.
        :type extend_expiry: ExtendExpiry
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._extend_expiry_serialize(
            document_id=document_id,
            extend_expiry=extend_expiry,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def extend_expiry_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        extend_expiry: Annotated[Optional[ExtendExpiry], Field(description="The new expiry value should be specified in yyyy-MM-dd format for days type, ISO date time format for specific date time and integer for hours type.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Extends the expiration date of the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param extend_expiry: The new expiry value should be specified in yyyy-MM-dd format for days type, ISO date time format for specific date time and integer for hours type.
        :type extend_expiry: ExtendExpiry
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._extend_expiry_serialize(
            document_id=document_id,
            extend_expiry=extend_expiry,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def extend_expiry_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        extend_expiry: Annotated[Optional[ExtendExpiry], Field(description="The new expiry value should be specified in yyyy-MM-dd format for days type, ISO date time format for specific date time and integer for hours type.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Extends the expiration date of the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param extend_expiry: The new expiry value should be specified in yyyy-MM-dd format for days type, ISO date time format for specific date time and integer for hours type.
        :type extend_expiry: ExtendExpiry
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._extend_expiry_serialize(
            document_id=document_id,
            extend_expiry=extend_expiry,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _extend_expiry_serialize(
        self,
        document_id,
        extend_expiry,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = extend_expiry
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if extend_expiry is not None and has_files is False:
            _body_params = extend_expiry


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/document/extendExpiry',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_embedded_sign_link(
        self,
        document_id: StrictStr,
        signer_email: Optional[StrictStr] = None,
        country_code: Optional[StrictStr] = None,
        phone_number: Optional[StrictStr] = None,
        sign_link_valid_till: Optional[datetime] = None,
        redirect_url: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmbeddedSigningLink:
        """Get sign link for Embedded Sign.


        :param document_id: (required)
        :type document_id: str
        :param signer_email:
        :type signer_email: str
        :param country_code:
        :type country_code: str
        :param phone_number:
        :type phone_number: str
        :param sign_link_valid_till:
        :type sign_link_valid_till: datetime
        :param redirect_url:
        :type redirect_url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_embedded_sign_link_serialize(
            document_id=document_id,
            signer_email=signer_email,
            country_code=country_code,
            phone_number=phone_number,
            sign_link_valid_till=sign_link_valid_till,
            redirect_url=redirect_url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EmbeddedSigningLink",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_embedded_sign_link_with_http_info(
        self,
        document_id: StrictStr,
        signer_email: Optional[StrictStr] = None,
        country_code: Optional[StrictStr] = None,
        phone_number: Optional[StrictStr] = None,
        sign_link_valid_till: Optional[datetime] = None,
        redirect_url: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmbeddedSigningLink]:
        """Get sign link for Embedded Sign.


        :param document_id: (required)
        :type document_id: str
        :param signer_email:
        :type signer_email: str
        :param country_code:
        :type country_code: str
        :param phone_number:
        :type phone_number: str
        :param sign_link_valid_till:
        :type sign_link_valid_till: datetime
        :param redirect_url:
        :type redirect_url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_embedded_sign_link_serialize(
            document_id=document_id,
            signer_email=signer_email,
            country_code=country_code,
            phone_number=phone_number,
            sign_link_valid_till=sign_link_valid_till,
            redirect_url=redirect_url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EmbeddedSigningLink",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_embedded_sign_link_without_preload_content(
        self,
        document_id: StrictStr,
        signer_email: Optional[StrictStr] = None,
        country_code: Optional[StrictStr] = None,
        phone_number: Optional[StrictStr] = None,
        sign_link_valid_till: Optional[datetime] = None,
        redirect_url: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get sign link for Embedded Sign.


        :param document_id: (required)
        :type document_id: str
        :param signer_email:
        :type signer_email: str
        :param country_code:
        :type country_code: str
        :param phone_number:
        :type phone_number: str
        :param sign_link_valid_till:
        :type sign_link_valid_till: datetime
        :param redirect_url:
        :type redirect_url: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_embedded_sign_link_serialize(
            document_id=document_id,
            signer_email=signer_email,
            country_code=country_code,
            phone_number=phone_number,
            sign_link_valid_till=sign_link_valid_till,
            redirect_url=redirect_url,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EmbeddedSigningLink",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_embedded_sign_link_serialize(
        self,
        document_id,
        signer_email,
        country_code,
        phone_number,
        sign_link_valid_till,
        redirect_url,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('DocumentId', document_id))
            
        if signer_email is not None:
            
            _query_params.append(('SignerEmail', signer_email))
            
        if country_code is not None:
            
            _query_params.append(('CountryCode', country_code))
            
        if phone_number is not None:
            
            _query_params.append(('PhoneNumber', phone_number))
            
        if sign_link_valid_till is not None:
            if isinstance(sign_link_valid_till, datetime):
                _query_params.append(
                    (
                        'SignLinkValidTill',
                        sign_link_valid_till.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('SignLinkValidTill', sign_link_valid_till))
            
        if redirect_url is not None:
            
            _query_params.append(('RedirectUrl', redirect_url))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/document/getEmbeddedSignLink',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_properties(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DocumentProperties:
        """Get summary of the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_properties_serialize(
            document_id=document_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentProperties",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_properties_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DocumentProperties]:
        """Get summary of the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_properties_serialize(
            document_id=document_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentProperties",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_properties_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get summary of the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_properties_serialize(
            document_id=document_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentProperties",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_properties_serialize(
        self,
        document_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/document/properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_documents(
        self,
        page: Annotated[StrictInt, Field(description="Page index specified in get document list request.")],
        sent_by: Optional[List[StrictStr]] = None,
        recipients: Optional[List[StrictStr]] = None,
        transmit_type: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size specified in get document list request.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the document")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the document")] = None,
        search_key: Annotated[Optional[StrictStr], Field(description="Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the document.")] = None,
        next_cursor: Annotated[Optional[StrictInt], Field(description="Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the document.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DocumentRecords:
        """List user documents.


        :param page: Page index specified in get document list request. (required)
        :type page: int
        :param sent_by:
        :type sent_by: List[str]
        :param recipients:
        :type recipients: List[str]
        :param transmit_type:
        :type transmit_type: str
        :param page_size: Page size specified in get document list request.
        :type page_size: int
        :param start_date: Start date of the document
        :type start_date: datetime
        :param status: Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.
        :type status: List[str]
        :param end_date: End date of the document
        :type end_date: datetime
        :param search_key: Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,
        :type search_key: str
        :param labels: Labels of the document.
        :type labels: List[str]
        :param next_cursor: Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.
        :type next_cursor: int
        :param brand_ids: BrandId(s) of the document.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_documents_serialize(
            page=page,
            sent_by=sent_by,
            recipients=recipients,
            transmit_type=transmit_type,
            page_size=page_size,
            start_date=start_date,
            status=status,
            end_date=end_date,
            search_key=search_key,
            labels=labels,
            next_cursor=next_cursor,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentRecords",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_documents_with_http_info(
        self,
        page: Annotated[StrictInt, Field(description="Page index specified in get document list request.")],
        sent_by: Optional[List[StrictStr]] = None,
        recipients: Optional[List[StrictStr]] = None,
        transmit_type: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size specified in get document list request.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the document")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the document")] = None,
        search_key: Annotated[Optional[StrictStr], Field(description="Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the document.")] = None,
        next_cursor: Annotated[Optional[StrictInt], Field(description="Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the document.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DocumentRecords]:
        """List user documents.


        :param page: Page index specified in get document list request. (required)
        :type page: int
        :param sent_by:
        :type sent_by: List[str]
        :param recipients:
        :type recipients: List[str]
        :param transmit_type:
        :type transmit_type: str
        :param page_size: Page size specified in get document list request.
        :type page_size: int
        :param start_date: Start date of the document
        :type start_date: datetime
        :param status: Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.
        :type status: List[str]
        :param end_date: End date of the document
        :type end_date: datetime
        :param search_key: Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,
        :type search_key: str
        :param labels: Labels of the document.
        :type labels: List[str]
        :param next_cursor: Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.
        :type next_cursor: int
        :param brand_ids: BrandId(s) of the document.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_documents_serialize(
            page=page,
            sent_by=sent_by,
            recipients=recipients,
            transmit_type=transmit_type,
            page_size=page_size,
            start_date=start_date,
            status=status,
            end_date=end_date,
            search_key=search_key,
            labels=labels,
            next_cursor=next_cursor,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentRecords",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_documents_without_preload_content(
        self,
        page: Annotated[StrictInt, Field(description="Page index specified in get document list request.")],
        sent_by: Optional[List[StrictStr]] = None,
        recipients: Optional[List[StrictStr]] = None,
        transmit_type: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size specified in get document list request.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the document")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the document")] = None,
        search_key: Annotated[Optional[StrictStr], Field(description="Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the document.")] = None,
        next_cursor: Annotated[Optional[StrictInt], Field(description="Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the document.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List user documents.


        :param page: Page index specified in get document list request. (required)
        :type page: int
        :param sent_by:
        :type sent_by: List[str]
        :param recipients:
        :type recipients: List[str]
        :param transmit_type:
        :type transmit_type: str
        :param page_size: Page size specified in get document list request.
        :type page_size: int
        :param start_date: Start date of the document
        :type start_date: datetime
        :param status: Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.
        :type status: List[str]
        :param end_date: End date of the document
        :type end_date: datetime
        :param search_key: Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,
        :type search_key: str
        :param labels: Labels of the document.
        :type labels: List[str]
        :param next_cursor: Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.
        :type next_cursor: int
        :param brand_ids: BrandId(s) of the document.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_documents_serialize(
            page=page,
            sent_by=sent_by,
            recipients=recipients,
            transmit_type=transmit_type,
            page_size=page_size,
            start_date=start_date,
            status=status,
            end_date=end_date,
            search_key=search_key,
            labels=labels,
            next_cursor=next_cursor,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DocumentRecords",
            '401': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_documents_serialize(
        self,
        page,
        sent_by,
        recipients,
        transmit_type,
        page_size,
        start_date,
        status,
        end_date,
        search_key,
        labels,
        next_cursor,
        brand_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'SentBy': 'multi',
            'Recipients': 'multi',
            'Status': 'multi',
            'Labels': 'multi',
            'BrandIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if sent_by is not None:
            
            _query_params.append(('SentBy', sent_by))
            
        if recipients is not None:
            
            _query_params.append(('Recipients', recipients))
            
        if transmit_type is not None:
            
            _query_params.append(('TransmitType', transmit_type))
            
        if page_size is not None:
            
            _query_params.append(('PageSize', page_size))
            
        if page is not None:
            
            _query_params.append(('Page', page))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'StartDate',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('StartDate', start_date))
            
        if status is not None:
            
            _query_params.append(('Status', status))
            
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'EndDate',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('EndDate', end_date))
            
        if search_key is not None:
            
            _query_params.append(('SearchKey', search_key))
            
        if labels is not None:
            
            _query_params.append(('Labels', labels))
            
        if next_cursor is not None:
            
            _query_params.append(('NextCursor', next_cursor))
            
        if brand_ids is not None:
            
            _query_params.append(('BrandIds', brand_ids))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/document/list',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def prefill_fields(
        self,
        document_id: Annotated[StrictStr, Field(description="The DocumentId.")],
        prefill_field_request: Annotated[PrefillFieldRequest, Field(description="The prefill field request.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Updates the value (prefill) of the fields in the document.


        :param document_id: The DocumentId. (required)
        :type document_id: str
        :param prefill_field_request: The prefill field request. (required)
        :type prefill_field_request: PrefillFieldRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._prefill_fields_serialize(
            document_id=document_id,
            prefill_field_request=prefill_field_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def prefill_fields_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="The DocumentId.")],
        prefill_field_request: Annotated[PrefillFieldRequest, Field(description="The prefill field request.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Updates the value (prefill) of the fields in the document.


        :param document_id: The DocumentId. (required)
        :type document_id: str
        :param prefill_field_request: The prefill field request. (required)
        :type prefill_field_request: PrefillFieldRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._prefill_fields_serialize(
            document_id=document_id,
            prefill_field_request=prefill_field_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def prefill_fields_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="The DocumentId.")],
        prefill_field_request: Annotated[PrefillFieldRequest, Field(description="The prefill field request.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Updates the value (prefill) of the fields in the document.


        :param document_id: The DocumentId. (required)
        :type document_id: str
        :param prefill_field_request: The prefill field request. (required)
        :type prefill_field_request: PrefillFieldRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._prefill_fields_serialize(
            document_id=document_id,
            prefill_field_request=prefill_field_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _prefill_fields_serialize(
        self,
        document_id,
        prefill_field_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = prefill_field_request
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if prefill_field_request is not None and has_files is False:
            _body_params = prefill_field_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/document/prefillFields',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def remind_document(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        receiver_emails: Annotated[Optional[List[StrictStr]], Field(description="Signer emails.")] = None,
        reminder_message: Annotated[Optional[ReminderMessage], Field(description="Reminder Message for signers.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Send reminder to pending signers.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param receiver_emails: Signer emails.
        :type receiver_emails: List[str]
        :param reminder_message: Reminder Message for signers.
        :type reminder_message: ReminderMessage
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remind_document_serialize(
            document_id=document_id,
            receiver_emails=receiver_emails,
            reminder_message=reminder_message,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def remind_document_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        receiver_emails: Annotated[Optional[List[StrictStr]], Field(description="Signer emails.")] = None,
        reminder_message: Annotated[Optional[ReminderMessage], Field(description="Reminder Message for signers.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Send reminder to pending signers.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param receiver_emails: Signer emails.
        :type receiver_emails: List[str]
        :param reminder_message: Reminder Message for signers.
        :type reminder_message: ReminderMessage
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remind_document_serialize(
            document_id=document_id,
            receiver_emails=receiver_emails,
            reminder_message=reminder_message,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def remind_document_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        receiver_emails: Annotated[Optional[List[StrictStr]], Field(description="Signer emails.")] = None,
        reminder_message: Annotated[Optional[ReminderMessage], Field(description="Reminder Message for signers.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send reminder to pending signers.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param receiver_emails: Signer emails.
        :type receiver_emails: List[str]
        :param reminder_message: Reminder Message for signers.
        :type reminder_message: ReminderMessage
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remind_document_serialize(
            document_id=document_id,
            receiver_emails=receiver_emails,
            reminder_message=reminder_message,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _remind_document_serialize(
        self,
        document_id,
        receiver_emails,
        reminder_message,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'receiverEmails': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = reminder_message
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        if receiver_emails is not None:
            
            _query_params.append(('receiverEmails', receiver_emails))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if reminder_message is not None and has_files is False:
            _body_params = reminder_message


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/document/remind',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def remove_authentication(
        self,
        document_id: Annotated[StrictStr, Field(description="Document ID of the signature request")],
        remove_authentication: Annotated[Optional[RemoveAuthentication], Field(description="To remove access code.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Remove the access code for the given document signer.


        :param document_id: Document ID of the signature request (required)
        :type document_id: str
        :param remove_authentication: To remove access code.
        :type remove_authentication: RemoveAuthentication
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_authentication_serialize(
            document_id=document_id,
            remove_authentication=remove_authentication,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def remove_authentication_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="Document ID of the signature request")],
        remove_authentication: Annotated[Optional[RemoveAuthentication], Field(description="To remove access code.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Remove the access code for the given document signer.


        :param document_id: Document ID of the signature request (required)
        :type document_id: str
        :param remove_authentication: To remove access code.
        :type remove_authentication: RemoveAuthentication
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_authentication_serialize(
            document_id=document_id,
            remove_authentication=remove_authentication,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def remove_authentication_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="Document ID of the signature request")],
        remove_authentication: Annotated[Optional[RemoveAuthentication], Field(description="To remove access code.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Remove the access code for the given document signer.


        :param document_id: Document ID of the signature request (required)
        :type document_id: str
        :param remove_authentication: To remove access code.
        :type remove_authentication: RemoveAuthentication
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._remove_authentication_serialize(
            document_id=document_id,
            remove_authentication=remove_authentication,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _remove_authentication_serialize(
        self,
        document_id,
        remove_authentication,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = remove_authentication
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('DocumentId', document_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if remove_authentication is not None and has_files is False:
            _body_params = remove_authentication


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/document/RemoveAuthentication',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def revoke_document(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        revoke_document: Annotated[RevokeDocument, Field(description="RevokeDetails.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Revoke the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param revoke_document: RevokeDetails. (required)
        :type revoke_document: RevokeDocument
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._revoke_document_serialize(
            document_id=document_id,
            revoke_document=revoke_document,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def revoke_document_with_http_info(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        revoke_document: Annotated[RevokeDocument, Field(description="RevokeDetails.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Revoke the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param revoke_document: RevokeDetails. (required)
        :type revoke_document: RevokeDocument
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._revoke_document_serialize(
            document_id=document_id,
            revoke_document=revoke_document,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def revoke_document_without_preload_content(
        self,
        document_id: Annotated[StrictStr, Field(description="Document Id.")],
        revoke_document: Annotated[RevokeDocument, Field(description="RevokeDetails.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Revoke the document.


        :param document_id: Document Id. (required)
        :type document_id: str
        :param revoke_document: RevokeDetails. (required)
        :type revoke_document: RevokeDocument
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._revoke_document_serialize(
            document_id=document_id,
            revoke_document=revoke_document,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _revoke_document_serialize(
        self,
        document_id,
        revoke_document,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = revoke_document
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if document_id is not None:
            
            _query_params.append(('documentId', document_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if revoke_document is not None and has_files is False:
            _body_params = revoke_document


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/document/revoke',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def send_document(
        self,
        send_for_sign: Annotated[Optional[SendForSign], Field(description="The send for sign request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DocumentCreated:
        """Sends the document for sign.


        :param send_for_sign: The send for sign request body.
        :type send_for_sign: SendForSign
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._send_document_serialize(
            send_for_sign=send_for_sign,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DocumentCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '400': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def send_document_with_http_info(
        self,
        send_for_sign: Annotated[Optional[SendForSign], Field(description="The send for sign request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DocumentCreated]:
        """Sends the document for sign.


        :param send_for_sign: The send for sign request body.
        :type send_for_sign: SendForSign
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._send_document_serialize(
            send_for_sign=send_for_sign,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DocumentCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '400': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def send_document_without_preload_content(
        self,
        send_for_sign: Annotated[Optional[SendForSign], Field(description="The send for sign request body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Sends the document for sign.


        :param send_for_sign: The send for sign request body.
        :type send_for_sign: SendForSign
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._send_document_serialize(
            send_for_sign=send_for_sign,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DocumentCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '400': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _send_document_serialize(
        self,
        send_for_sign,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = send_for_sign
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if send_for_sign is not None and has_files is False:
            _body_params = send_for_sign


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/document/send',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def team_documents(
        self,
        page: Annotated[StrictInt, Field(description="Page index specified in get document list request.")],
        user_id: Annotated[Optional[List[StrictStr]], Field(description="UserId of the  Team document.")] = None,
        team_id: Annotated[Optional[List[StrictStr]], Field(description="TeamId  of the  Team document.")] = None,
        transmit_type: Annotated[Optional[StrictStr], Field(description="Transmit type as Sent, Received and Both.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size specified in get document list request.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the document")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the document")] = None,
        search_key: Annotated[Optional[StrictStr], Field(description="Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the document.")] = None,
        next_cursor: Annotated[Optional[StrictInt], Field(description="Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the document.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TeamDocumentRecords:
        """Get user Team documents.


        :param page: Page index specified in get document list request. (required)
        :type page: int
        :param user_id: UserId of the  Team document.
        :type user_id: List[str]
        :param team_id: TeamId  of the  Team document.
        :type team_id: List[str]
        :param transmit_type: Transmit type as Sent, Received and Both.
        :type transmit_type: str
        :param page_size: Page size specified in get document list request.
        :type page_size: int
        :param start_date: Start date of the document
        :type start_date: datetime
        :param status: Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.
        :type status: List[str]
        :param end_date: End date of the document
        :type end_date: datetime
        :param search_key: Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,
        :type search_key: str
        :param labels: Labels of the document.
        :type labels: List[str]
        :param next_cursor: Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.
        :type next_cursor: int
        :param brand_ids: BrandId(s) of the document.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._team_documents_serialize(
            page=page,
            user_id=user_id,
            team_id=team_id,
            transmit_type=transmit_type,
            page_size=page_size,
            start_date=start_date,
            status=status,
            end_date=end_date,
            search_key=search_key,
            labels=labels,
            next_cursor=next_cursor,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TeamDocumentRecords",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def team_documents_with_http_info(
        self,
        page: Annotated[StrictInt, Field(description="Page index specified in get document list request.")],
        user_id: Annotated[Optional[List[StrictStr]], Field(description="UserId of the  Team document.")] = None,
        team_id: Annotated[Optional[List[StrictStr]], Field(description="TeamId  of the  Team document.")] = None,
        transmit_type: Annotated[Optional[StrictStr], Field(description="Transmit type as Sent, Received and Both.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size specified in get document list request.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the document")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the document")] = None,
        search_key: Annotated[Optional[StrictStr], Field(description="Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the document.")] = None,
        next_cursor: Annotated[Optional[StrictInt], Field(description="Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the document.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TeamDocumentRecords]:
        """Get user Team documents.


        :param page: Page index specified in get document list request. (required)
        :type page: int
        :param user_id: UserId of the  Team document.
        :type user_id: List[str]
        :param team_id: TeamId  of the  Team document.
        :type team_id: List[str]
        :param transmit_type: Transmit type as Sent, Received and Both.
        :type transmit_type: str
        :param page_size: Page size specified in get document list request.
        :type page_size: int
        :param start_date: Start date of the document
        :type start_date: datetime
        :param status: Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.
        :type status: List[str]
        :param end_date: End date of the document
        :type end_date: datetime
        :param search_key: Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,
        :type search_key: str
        :param labels: Labels of the document.
        :type labels: List[str]
        :param next_cursor: Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.
        :type next_cursor: int
        :param brand_ids: BrandId(s) of the document.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._team_documents_serialize(
            page=page,
            user_id=user_id,
            team_id=team_id,
            transmit_type=transmit_type,
            page_size=page_size,
            start_date=start_date,
            status=status,
            end_date=end_date,
            search_key=search_key,
            labels=labels,
            next_cursor=next_cursor,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TeamDocumentRecords",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def team_documents_without_preload_content(
        self,
        page: Annotated[StrictInt, Field(description="Page index specified in get document list request.")],
        user_id: Annotated[Optional[List[StrictStr]], Field(description="UserId of the  Team document.")] = None,
        team_id: Annotated[Optional[List[StrictStr]], Field(description="TeamId  of the  Team document.")] = None,
        transmit_type: Annotated[Optional[StrictStr], Field(description="Transmit type as Sent, Received and Both.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size specified in get document list request.")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date of the document")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date of the document")] = None,
        search_key: Annotated[Optional[StrictStr], Field(description="Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,")] = None,
        labels: Annotated[Optional[List[StrictStr]], Field(description="Labels of the document.")] = None,
        next_cursor: Annotated[Optional[StrictInt], Field(description="Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.")] = None,
        brand_ids: Annotated[Optional[List[StrictStr]], Field(description="BrandId(s) of the document.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get user Team documents.


        :param page: Page index specified in get document list request. (required)
        :type page: int
        :param user_id: UserId of the  Team document.
        :type user_id: List[str]
        :param team_id: TeamId  of the  Team document.
        :type team_id: List[str]
        :param transmit_type: Transmit type as Sent, Received and Both.
        :type transmit_type: str
        :param page_size: Page size specified in get document list request.
        :type page_size: int
        :param start_date: Start date of the document
        :type start_date: datetime
        :param status: Status of the document such as In-progress, Completed, Decline, Expired, Revoked, Draft.
        :type status: List[str]
        :param end_date: End date of the document
        :type end_date: datetime
        :param search_key: Documents can be listed by the search key present in the document like document title, document ID, sender or recipient(s) name, etc.,
        :type search_key: str
        :param labels: Labels of the document.
        :type labels: List[str]
        :param next_cursor: Next cursor value for pagination, required for fetching the next set of documents beyond 10,000 records.
        :type next_cursor: int
        :param brand_ids: BrandId(s) of the document.
        :type brand_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._team_documents_serialize(
            page=page,
            user_id=user_id,
            team_id=team_id,
            transmit_type=transmit_type,
            page_size=page_size,
            start_date=start_date,
            status=status,
            end_date=end_date,
            search_key=search_key,
            labels=labels,
            next_cursor=next_cursor,
            brand_ids=brand_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TeamDocumentRecords",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _team_documents_serialize(
        self,
        page,
        user_id,
        team_id,
        transmit_type,
        page_size,
        start_date,
        status,
        end_date,
        search_key,
        labels,
        next_cursor,
        brand_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'UserId': 'multi',
            'TeamId': 'multi',
            'Status': 'multi',
            'Labels': 'multi',
            'BrandIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('UserId', user_id))
            
        if team_id is not None:
            
            _query_params.append(('TeamId', team_id))
            
        if transmit_type is not None:
            
            _query_params.append(('TransmitType', transmit_type))
            
        if page_size is not None:
            
            _query_params.append(('PageSize', page_size))
            
        if page is not None:
            
            _query_params.append(('Page', page))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'StartDate',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('StartDate', start_date))
            
        if status is not None:
            
            _query_params.append(('Status', status))
            
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'EndDate',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('EndDate', end_date))
            
        if search_key is not None:
            
            _query_params.append(('SearchKey', search_key))
            
        if labels is not None:
            
            _query_params.append(('Labels', labels))
            
        if next_cursor is not None:
            
            _query_params.append(('NextCursor', next_cursor))
            
        if brand_ids is not None:
            
            _query_params.append(('BrandIds', brand_ids))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/document/teamlist',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


