# coding: utf-8

"""
    BoldSign API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Contact: support@boldsign.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated
from boldsign.models.brand_custom_field_details import BrandCustomFieldDetails
from boldsign.models.custom_field_collection import CustomFieldCollection
from boldsign.models.custom_field_message import CustomFieldMessage
from boldsign.models.delete_custom_field_reply import DeleteCustomFieldReply
from boldsign.models.embedded_custom_field_created import EmbeddedCustomFieldCreated

from boldsign.api_client import ApiClient, RequestSerialized
from boldsign.api_response import ApiResponse
from boldsign.rest import RESTResponseType
import io


class CustomFieldApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_custom_field(
        self,
        brand_custom_field_details: Annotated[BrandCustomFieldDetails, Field(description="The custom field details.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CustomFieldMessage:
        """Create the custom field.


        :param brand_custom_field_details: The custom field details. (required)
        :type brand_custom_field_details: BrandCustomFieldDetails
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_custom_field_serialize(
            brand_custom_field_details=brand_custom_field_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomFieldMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_custom_field_with_http_info(
        self,
        brand_custom_field_details: Annotated[BrandCustomFieldDetails, Field(description="The custom field details.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CustomFieldMessage]:
        """Create the custom field.


        :param brand_custom_field_details: The custom field details. (required)
        :type brand_custom_field_details: BrandCustomFieldDetails
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_custom_field_serialize(
            brand_custom_field_details=brand_custom_field_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomFieldMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_custom_field_without_preload_content(
        self,
        brand_custom_field_details: Annotated[BrandCustomFieldDetails, Field(description="The custom field details.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create the custom field.


        :param brand_custom_field_details: The custom field details. (required)
        :type brand_custom_field_details: BrandCustomFieldDetails
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_custom_field_serialize(
            brand_custom_field_details=brand_custom_field_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomFieldMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_custom_field_serialize(
        self,
        brand_custom_field_details,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = brand_custom_field_details
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if brand_custom_field_details is not None and has_files is False:
            _body_params = brand_custom_field_details


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/customField/create',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def custom_fields_list(
        self,
        brand_id: Annotated[StrictStr, Field(description="The brand id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CustomFieldCollection:
        """List the custom fields respective to the brand id.


        :param brand_id: The brand id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._custom_fields_list_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomFieldCollection",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def custom_fields_list_with_http_info(
        self,
        brand_id: Annotated[StrictStr, Field(description="The brand id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CustomFieldCollection]:
        """List the custom fields respective to the brand id.


        :param brand_id: The brand id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._custom_fields_list_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomFieldCollection",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def custom_fields_list_without_preload_content(
        self,
        brand_id: Annotated[StrictStr, Field(description="The brand id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List the custom fields respective to the brand id.


        :param brand_id: The brand id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._custom_fields_list_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomFieldCollection",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _custom_fields_list_serialize(
        self,
        brand_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if brand_id is not None:
            
            _query_params.append(('brandId', brand_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/customField/list',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_custom_field(
        self,
        custom_field_id: Annotated[StrictStr, Field(description="The custom field id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteCustomFieldReply:
        """Delete the custom field.


        :param custom_field_id: The custom field id. (required)
        :type custom_field_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_custom_field_serialize(
            custom_field_id=custom_field_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCustomFieldReply",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_custom_field_with_http_info(
        self,
        custom_field_id: Annotated[StrictStr, Field(description="The custom field id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteCustomFieldReply]:
        """Delete the custom field.


        :param custom_field_id: The custom field id. (required)
        :type custom_field_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_custom_field_serialize(
            custom_field_id=custom_field_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCustomFieldReply",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_custom_field_without_preload_content(
        self,
        custom_field_id: Annotated[StrictStr, Field(description="The custom field id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete the custom field.


        :param custom_field_id: The custom field id. (required)
        :type custom_field_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_custom_field_serialize(
            custom_field_id=custom_field_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCustomFieldReply",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_custom_field_serialize(
        self,
        custom_field_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if custom_field_id is not None:
            
            _query_params.append(('customFieldId', custom_field_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/customField/delete',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def edit_custom_field(
        self,
        custom_field_id: Annotated[StrictStr, Field(description="The custom field id.")],
        brand_custom_field_details: Annotated[BrandCustomFieldDetails, Field(description="The custom field details.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CustomFieldMessage:
        """Edit the custom field.


        :param custom_field_id: The custom field id. (required)
        :type custom_field_id: str
        :param brand_custom_field_details: The custom field details. (required)
        :type brand_custom_field_details: BrandCustomFieldDetails
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_custom_field_serialize(
            custom_field_id=custom_field_id,
            brand_custom_field_details=brand_custom_field_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomFieldMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def edit_custom_field_with_http_info(
        self,
        custom_field_id: Annotated[StrictStr, Field(description="The custom field id.")],
        brand_custom_field_details: Annotated[BrandCustomFieldDetails, Field(description="The custom field details.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CustomFieldMessage]:
        """Edit the custom field.


        :param custom_field_id: The custom field id. (required)
        :type custom_field_id: str
        :param brand_custom_field_details: The custom field details. (required)
        :type brand_custom_field_details: BrandCustomFieldDetails
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_custom_field_serialize(
            custom_field_id=custom_field_id,
            brand_custom_field_details=brand_custom_field_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomFieldMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def edit_custom_field_without_preload_content(
        self,
        custom_field_id: Annotated[StrictStr, Field(description="The custom field id.")],
        brand_custom_field_details: Annotated[BrandCustomFieldDetails, Field(description="The custom field details.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Edit the custom field.


        :param custom_field_id: The custom field id. (required)
        :type custom_field_id: str
        :param brand_custom_field_details: The custom field details. (required)
        :type brand_custom_field_details: BrandCustomFieldDetails
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_custom_field_serialize(
            custom_field_id=custom_field_id,
            brand_custom_field_details=brand_custom_field_details,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CustomFieldMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _edit_custom_field_serialize(
        self,
        custom_field_id,
        brand_custom_field_details,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        has_files = False
        body_param = brand_custom_field_details
        excluded_json_fields = set([])
        # Check if body_param is a list of models
        if isinstance(body_param, list):
            for item in body_param:
                if hasattr(item, 'openapi_types'):
                    for param_name, param_type in item.openapi_types().items():
                        param_value = getattr(item, param_name)
                        if param_value is None:
                            continue

                        if "io.IOBase" in param_type:
                            has_files = True
                            _content_type = "multipart/form-data"
                            excluded_json_fields.add(param_name)

                            if isinstance(param_value, list):
                                for index, file_item in enumerate(param_value):
                                    _files[f'{param_name}[{index}]'] = file_item
                            else:
                                _files[param_name] = param_value

                    if has_files is True:
                        _form_params += item.to_json_form_params(excluded_json_fields)
        else:
            # Handle a single object
            for param_name, param_type in body_param.openapi_types().items():
                param_value = getattr(body_param, param_name)
                if param_value is None:
                    continue

                if "io.IOBase" in param_type:
                    has_files = True
                    _content_type = "multipart/form-data"
                    excluded_json_fields.add(param_name)

                    if isinstance(param_value, list):
                        for index, item in enumerate(param_value):
                            _files[f'{param_name}[{index}]'] = item
                    else:
                        _files[param_name] = param_value

            if has_files is True:
                _form_params = body_param.to_json_form_params(excluded_json_fields)

        # process the path parameters
        # process the query parameters
        if custom_field_id is not None:
            
            _query_params.append(('customFieldId', custom_field_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if brand_custom_field_details is not None and has_files is False:
            _body_params = brand_custom_field_details


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json;odata.metadata=minimal;odata.streaming=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false', 
                        'application/json;odata.metadata=minimal', 
                        'application/json;odata.metadata=full;odata.streaming=true', 
                        'application/json;odata.metadata=full;odata.streaming=false', 
                        'application/json;odata.metadata=full', 
                        'application/json;odata.metadata=none;odata.streaming=true', 
                        'application/json;odata.metadata=none;odata.streaming=false', 
                        'application/json;odata.metadata=none', 
                        'application/json;odata.streaming=true', 
                        'application/json;odata.streaming=false', 
                        'application/json', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                        'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=full;IEEE754Compatible=false', 
                        'application/json;odata.metadata=full;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=false', 
                        'application/json;odata.metadata=none;IEEE754Compatible=true', 
                        'application/json;odata.streaming=true;IEEE754Compatible=false', 
                        'application/json;odata.streaming=true;IEEE754Compatible=true', 
                        'application/json;odata.streaming=false;IEEE754Compatible=false', 
                        'application/json;odata.streaming=false;IEEE754Compatible=true', 
                        'application/json;IEEE754Compatible=false', 
                        'application/json;IEEE754Compatible=true', 
                        'application/xml', 
                        'text/plain', 
                        'application/json-patch+json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/customField/edit',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def embed_custom_field(
        self,
        brand_id: Annotated[StrictStr, Field(description="The Brand ID for custom fields must be configured")],
        link_valid_till: Annotated[Optional[datetime], Field(description="This property is used to set the validity of the generated URL. Its maximum validity is 30 days")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmbeddedCustomFieldCreated:
        """Generates a URL for creating or modifying custom fields within your application's embedded Designer.


        :param brand_id: The Brand ID for custom fields must be configured (required)
        :type brand_id: str
        :param link_valid_till: This property is used to set the validity of the generated URL. Its maximum validity is 30 days
        :type link_valid_till: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._embed_custom_field_serialize(
            brand_id=brand_id,
            link_valid_till=link_valid_till,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EmbeddedCustomFieldCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def embed_custom_field_with_http_info(
        self,
        brand_id: Annotated[StrictStr, Field(description="The Brand ID for custom fields must be configured")],
        link_valid_till: Annotated[Optional[datetime], Field(description="This property is used to set the validity of the generated URL. Its maximum validity is 30 days")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmbeddedCustomFieldCreated]:
        """Generates a URL for creating or modifying custom fields within your application's embedded Designer.


        :param brand_id: The Brand ID for custom fields must be configured (required)
        :type brand_id: str
        :param link_valid_till: This property is used to set the validity of the generated URL. Its maximum validity is 30 days
        :type link_valid_till: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._embed_custom_field_serialize(
            brand_id=brand_id,
            link_valid_till=link_valid_till,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EmbeddedCustomFieldCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def embed_custom_field_without_preload_content(
        self,
        brand_id: Annotated[StrictStr, Field(description="The Brand ID for custom fields must be configured")],
        link_valid_till: Annotated[Optional[datetime], Field(description="This property is used to set the validity of the generated URL. Its maximum validity is 30 days")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generates a URL for creating or modifying custom fields within your application's embedded Designer.


        :param brand_id: The Brand ID for custom fields must be configured (required)
        :type brand_id: str
        :param link_valid_till: This property is used to set the validity of the generated URL. Its maximum validity is 30 days
        :type link_valid_till: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._embed_custom_field_serialize(
            brand_id=brand_id,
            link_valid_till=link_valid_till,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EmbeddedCustomFieldCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _embed_custom_field_serialize(
        self,
        brand_id,
        link_valid_till,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if brand_id is not None:
            
            _query_params.append(('BrandId', brand_id))
            
        if link_valid_till is not None:
            if isinstance(link_valid_till, datetime):
                _query_params.append(
                    (
                        'LinkValidTill',
                        link_valid_till.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('LinkValidTill', link_valid_till))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/customField/createEmbeddedCustomFieldUrl',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


