# coding: utf-8

"""
    BoldSign API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Contact: support@boldsign.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr, field_validator
from typing import Optional, Union
from typing_extensions import Annotated
from boldsign.models.brand_created import BrandCreated
from boldsign.models.branding_message import BrandingMessage
from boldsign.models.branding_records import BrandingRecords
from boldsign.models.view_brand_details import ViewBrandDetails

from boldsign.api_client import ApiClient, RequestSerialized
from boldsign.api_response import ApiResponse
from boldsign.rest import RESTResponseType
import io


class BrandingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def brand_list(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BrandingRecords:
        """List all the brands.


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._brand_list_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandingRecords",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def brand_list_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BrandingRecords]:
        """List all the brands.


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._brand_list_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandingRecords",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def brand_list_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List all the brands.


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._brand_list_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandingRecords",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _brand_list_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/brand/list',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_brand(
        self,
        brand_name: StrictStr,
        brand_logo: Union[StrictBytes, StrictStr],
        background_color: Optional[StrictStr] = None,
        button_color: Optional[StrictStr] = None,
        button_text_color: Optional[StrictStr] = None,
        email_display_name: Optional[StrictStr] = None,
        disclaimer_description: Optional[StrictStr] = None,
        disclaimer_title: Optional[StrictStr] = None,
        redirect_url: Optional[StrictStr] = None,
        is_default: Optional[StrictBool] = None,
        can_hide_tag_line: Optional[StrictBool] = None,
        combine_audit_trail: Optional[StrictBool] = None,
        exclude_audit_trail_from_email: Optional[StrictBool] = None,
        email_signed_document: Optional[StrictStr] = None,
        document_time_zone: Optional[StrictStr] = None,
        show_built_in_form_fields: Optional[StrictBool] = None,
        allow_custom_field_creation: Optional[StrictBool] = None,
        show_shared_custom_fields: Optional[StrictBool] = None,
        hide_decline: Optional[StrictBool] = None,
        hide_save: Optional[StrictBool] = None,
        document_expiry_settings_expiry_date_type: Optional[StrictStr] = None,
        document_expiry_settings_expiry_value: Optional[StrictInt] = None,
        document_expiry_settings_enable_default_expiry_alert: Optional[StrictBool] = None,
        document_expiry_settings_enable_auto_reminder: Optional[StrictBool] = None,
        document_expiry_settings_reminder_days: Optional[Annotated[int, Field(le=180, strict=True, ge=1)]] = None,
        document_expiry_settings_reminder_count: Optional[StrictInt] = None,
        custom_domain_settings_domain_name: Optional[StrictStr] = None,
        custom_domain_settings_from_name: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BrandCreated:
        """Create the brand.


        :param brand_name: (required)
        :type brand_name: str
        :param brand_logo: (required)
        :type brand_logo: io.IOBase
        :param background_color:
        :type background_color: str
        :param button_color:
        :type button_color: str
        :param button_text_color:
        :type button_text_color: str
        :param email_display_name:
        :type email_display_name: str
        :param disclaimer_description:
        :type disclaimer_description: str
        :param disclaimer_title:
        :type disclaimer_title: str
        :param redirect_url:
        :type redirect_url: str
        :param is_default:
        :type is_default: bool
        :param can_hide_tag_line:
        :type can_hide_tag_line: bool
        :param combine_audit_trail:
        :type combine_audit_trail: bool
        :param exclude_audit_trail_from_email:
        :type exclude_audit_trail_from_email: bool
        :param email_signed_document:
        :type email_signed_document: str
        :param document_time_zone:
        :type document_time_zone: str
        :param show_built_in_form_fields:
        :type show_built_in_form_fields: bool
        :param allow_custom_field_creation:
        :type allow_custom_field_creation: bool
        :param show_shared_custom_fields:
        :type show_shared_custom_fields: bool
        :param hide_decline:
        :type hide_decline: bool
        :param hide_save:
        :type hide_save: bool
        :param document_expiry_settings_expiry_date_type:
        :type document_expiry_settings_expiry_date_type: str
        :param document_expiry_settings_expiry_value:
        :type document_expiry_settings_expiry_value: int
        :param document_expiry_settings_enable_default_expiry_alert:
        :type document_expiry_settings_enable_default_expiry_alert: bool
        :param document_expiry_settings_enable_auto_reminder:
        :type document_expiry_settings_enable_auto_reminder: bool
        :param document_expiry_settings_reminder_days:
        :type document_expiry_settings_reminder_days: int
        :param document_expiry_settings_reminder_count:
        :type document_expiry_settings_reminder_count: int
        :param custom_domain_settings_domain_name:
        :type custom_domain_settings_domain_name: str
        :param custom_domain_settings_from_name:
        :type custom_domain_settings_from_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_brand_serialize(
            brand_name=brand_name,
            brand_logo=brand_logo,
            background_color=background_color,
            button_color=button_color,
            button_text_color=button_text_color,
            email_display_name=email_display_name,
            disclaimer_description=disclaimer_description,
            disclaimer_title=disclaimer_title,
            redirect_url=redirect_url,
            is_default=is_default,
            can_hide_tag_line=can_hide_tag_line,
            combine_audit_trail=combine_audit_trail,
            exclude_audit_trail_from_email=exclude_audit_trail_from_email,
            email_signed_document=email_signed_document,
            document_time_zone=document_time_zone,
            show_built_in_form_fields=show_built_in_form_fields,
            allow_custom_field_creation=allow_custom_field_creation,
            show_shared_custom_fields=show_shared_custom_fields,
            hide_decline=hide_decline,
            hide_save=hide_save,
            document_expiry_settings_expiry_date_type=document_expiry_settings_expiry_date_type,
            document_expiry_settings_expiry_value=document_expiry_settings_expiry_value,
            document_expiry_settings_enable_default_expiry_alert=document_expiry_settings_enable_default_expiry_alert,
            document_expiry_settings_enable_auto_reminder=document_expiry_settings_enable_auto_reminder,
            document_expiry_settings_reminder_days=document_expiry_settings_reminder_days,
            document_expiry_settings_reminder_count=document_expiry_settings_reminder_count,
            custom_domain_settings_domain_name=custom_domain_settings_domain_name,
            custom_domain_settings_from_name=custom_domain_settings_from_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_brand_with_http_info(
        self,
        brand_name: StrictStr,
        brand_logo: Union[StrictBytes, StrictStr],
        background_color: Optional[StrictStr] = None,
        button_color: Optional[StrictStr] = None,
        button_text_color: Optional[StrictStr] = None,
        email_display_name: Optional[StrictStr] = None,
        disclaimer_description: Optional[StrictStr] = None,
        disclaimer_title: Optional[StrictStr] = None,
        redirect_url: Optional[StrictStr] = None,
        is_default: Optional[StrictBool] = None,
        can_hide_tag_line: Optional[StrictBool] = None,
        combine_audit_trail: Optional[StrictBool] = None,
        exclude_audit_trail_from_email: Optional[StrictBool] = None,
        email_signed_document: Optional[StrictStr] = None,
        document_time_zone: Optional[StrictStr] = None,
        show_built_in_form_fields: Optional[StrictBool] = None,
        allow_custom_field_creation: Optional[StrictBool] = None,
        show_shared_custom_fields: Optional[StrictBool] = None,
        hide_decline: Optional[StrictBool] = None,
        hide_save: Optional[StrictBool] = None,
        document_expiry_settings_expiry_date_type: Optional[StrictStr] = None,
        document_expiry_settings_expiry_value: Optional[StrictInt] = None,
        document_expiry_settings_enable_default_expiry_alert: Optional[StrictBool] = None,
        document_expiry_settings_enable_auto_reminder: Optional[StrictBool] = None,
        document_expiry_settings_reminder_days: Optional[Annotated[int, Field(le=180, strict=True, ge=1)]] = None,
        document_expiry_settings_reminder_count: Optional[StrictInt] = None,
        custom_domain_settings_domain_name: Optional[StrictStr] = None,
        custom_domain_settings_from_name: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BrandCreated]:
        """Create the brand.


        :param brand_name: (required)
        :type brand_name: str
        :param brand_logo: (required)
        :type brand_logo: io.IOBase
        :param background_color:
        :type background_color: str
        :param button_color:
        :type button_color: str
        :param button_text_color:
        :type button_text_color: str
        :param email_display_name:
        :type email_display_name: str
        :param disclaimer_description:
        :type disclaimer_description: str
        :param disclaimer_title:
        :type disclaimer_title: str
        :param redirect_url:
        :type redirect_url: str
        :param is_default:
        :type is_default: bool
        :param can_hide_tag_line:
        :type can_hide_tag_line: bool
        :param combine_audit_trail:
        :type combine_audit_trail: bool
        :param exclude_audit_trail_from_email:
        :type exclude_audit_trail_from_email: bool
        :param email_signed_document:
        :type email_signed_document: str
        :param document_time_zone:
        :type document_time_zone: str
        :param show_built_in_form_fields:
        :type show_built_in_form_fields: bool
        :param allow_custom_field_creation:
        :type allow_custom_field_creation: bool
        :param show_shared_custom_fields:
        :type show_shared_custom_fields: bool
        :param hide_decline:
        :type hide_decline: bool
        :param hide_save:
        :type hide_save: bool
        :param document_expiry_settings_expiry_date_type:
        :type document_expiry_settings_expiry_date_type: str
        :param document_expiry_settings_expiry_value:
        :type document_expiry_settings_expiry_value: int
        :param document_expiry_settings_enable_default_expiry_alert:
        :type document_expiry_settings_enable_default_expiry_alert: bool
        :param document_expiry_settings_enable_auto_reminder:
        :type document_expiry_settings_enable_auto_reminder: bool
        :param document_expiry_settings_reminder_days:
        :type document_expiry_settings_reminder_days: int
        :param document_expiry_settings_reminder_count:
        :type document_expiry_settings_reminder_count: int
        :param custom_domain_settings_domain_name:
        :type custom_domain_settings_domain_name: str
        :param custom_domain_settings_from_name:
        :type custom_domain_settings_from_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_brand_serialize(
            brand_name=brand_name,
            brand_logo=brand_logo,
            background_color=background_color,
            button_color=button_color,
            button_text_color=button_text_color,
            email_display_name=email_display_name,
            disclaimer_description=disclaimer_description,
            disclaimer_title=disclaimer_title,
            redirect_url=redirect_url,
            is_default=is_default,
            can_hide_tag_line=can_hide_tag_line,
            combine_audit_trail=combine_audit_trail,
            exclude_audit_trail_from_email=exclude_audit_trail_from_email,
            email_signed_document=email_signed_document,
            document_time_zone=document_time_zone,
            show_built_in_form_fields=show_built_in_form_fields,
            allow_custom_field_creation=allow_custom_field_creation,
            show_shared_custom_fields=show_shared_custom_fields,
            hide_decline=hide_decline,
            hide_save=hide_save,
            document_expiry_settings_expiry_date_type=document_expiry_settings_expiry_date_type,
            document_expiry_settings_expiry_value=document_expiry_settings_expiry_value,
            document_expiry_settings_enable_default_expiry_alert=document_expiry_settings_enable_default_expiry_alert,
            document_expiry_settings_enable_auto_reminder=document_expiry_settings_enable_auto_reminder,
            document_expiry_settings_reminder_days=document_expiry_settings_reminder_days,
            document_expiry_settings_reminder_count=document_expiry_settings_reminder_count,
            custom_domain_settings_domain_name=custom_domain_settings_domain_name,
            custom_domain_settings_from_name=custom_domain_settings_from_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_brand_without_preload_content(
        self,
        brand_name: StrictStr,
        brand_logo: Union[StrictBytes, StrictStr],
        background_color: Optional[StrictStr] = None,
        button_color: Optional[StrictStr] = None,
        button_text_color: Optional[StrictStr] = None,
        email_display_name: Optional[StrictStr] = None,
        disclaimer_description: Optional[StrictStr] = None,
        disclaimer_title: Optional[StrictStr] = None,
        redirect_url: Optional[StrictStr] = None,
        is_default: Optional[StrictBool] = None,
        can_hide_tag_line: Optional[StrictBool] = None,
        combine_audit_trail: Optional[StrictBool] = None,
        exclude_audit_trail_from_email: Optional[StrictBool] = None,
        email_signed_document: Optional[StrictStr] = None,
        document_time_zone: Optional[StrictStr] = None,
        show_built_in_form_fields: Optional[StrictBool] = None,
        allow_custom_field_creation: Optional[StrictBool] = None,
        show_shared_custom_fields: Optional[StrictBool] = None,
        hide_decline: Optional[StrictBool] = None,
        hide_save: Optional[StrictBool] = None,
        document_expiry_settings_expiry_date_type: Optional[StrictStr] = None,
        document_expiry_settings_expiry_value: Optional[StrictInt] = None,
        document_expiry_settings_enable_default_expiry_alert: Optional[StrictBool] = None,
        document_expiry_settings_enable_auto_reminder: Optional[StrictBool] = None,
        document_expiry_settings_reminder_days: Optional[Annotated[int, Field(le=180, strict=True, ge=1)]] = None,
        document_expiry_settings_reminder_count: Optional[StrictInt] = None,
        custom_domain_settings_domain_name: Optional[StrictStr] = None,
        custom_domain_settings_from_name: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create the brand.


        :param brand_name: (required)
        :type brand_name: str
        :param brand_logo: (required)
        :type brand_logo: io.IOBase
        :param background_color:
        :type background_color: str
        :param button_color:
        :type button_color: str
        :param button_text_color:
        :type button_text_color: str
        :param email_display_name:
        :type email_display_name: str
        :param disclaimer_description:
        :type disclaimer_description: str
        :param disclaimer_title:
        :type disclaimer_title: str
        :param redirect_url:
        :type redirect_url: str
        :param is_default:
        :type is_default: bool
        :param can_hide_tag_line:
        :type can_hide_tag_line: bool
        :param combine_audit_trail:
        :type combine_audit_trail: bool
        :param exclude_audit_trail_from_email:
        :type exclude_audit_trail_from_email: bool
        :param email_signed_document:
        :type email_signed_document: str
        :param document_time_zone:
        :type document_time_zone: str
        :param show_built_in_form_fields:
        :type show_built_in_form_fields: bool
        :param allow_custom_field_creation:
        :type allow_custom_field_creation: bool
        :param show_shared_custom_fields:
        :type show_shared_custom_fields: bool
        :param hide_decline:
        :type hide_decline: bool
        :param hide_save:
        :type hide_save: bool
        :param document_expiry_settings_expiry_date_type:
        :type document_expiry_settings_expiry_date_type: str
        :param document_expiry_settings_expiry_value:
        :type document_expiry_settings_expiry_value: int
        :param document_expiry_settings_enable_default_expiry_alert:
        :type document_expiry_settings_enable_default_expiry_alert: bool
        :param document_expiry_settings_enable_auto_reminder:
        :type document_expiry_settings_enable_auto_reminder: bool
        :param document_expiry_settings_reminder_days:
        :type document_expiry_settings_reminder_days: int
        :param document_expiry_settings_reminder_count:
        :type document_expiry_settings_reminder_count: int
        :param custom_domain_settings_domain_name:
        :type custom_domain_settings_domain_name: str
        :param custom_domain_settings_from_name:
        :type custom_domain_settings_from_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_brand_serialize(
            brand_name=brand_name,
            brand_logo=brand_logo,
            background_color=background_color,
            button_color=button_color,
            button_text_color=button_text_color,
            email_display_name=email_display_name,
            disclaimer_description=disclaimer_description,
            disclaimer_title=disclaimer_title,
            redirect_url=redirect_url,
            is_default=is_default,
            can_hide_tag_line=can_hide_tag_line,
            combine_audit_trail=combine_audit_trail,
            exclude_audit_trail_from_email=exclude_audit_trail_from_email,
            email_signed_document=email_signed_document,
            document_time_zone=document_time_zone,
            show_built_in_form_fields=show_built_in_form_fields,
            allow_custom_field_creation=allow_custom_field_creation,
            show_shared_custom_fields=show_shared_custom_fields,
            hide_decline=hide_decline,
            hide_save=hide_save,
            document_expiry_settings_expiry_date_type=document_expiry_settings_expiry_date_type,
            document_expiry_settings_expiry_value=document_expiry_settings_expiry_value,
            document_expiry_settings_enable_default_expiry_alert=document_expiry_settings_enable_default_expiry_alert,
            document_expiry_settings_enable_auto_reminder=document_expiry_settings_enable_auto_reminder,
            document_expiry_settings_reminder_days=document_expiry_settings_reminder_days,
            document_expiry_settings_reminder_count=document_expiry_settings_reminder_count,
            custom_domain_settings_domain_name=custom_domain_settings_domain_name,
            custom_domain_settings_from_name=custom_domain_settings_from_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_brand_serialize(
        self,
        brand_name,
        brand_logo,
        background_color,
        button_color,
        button_text_color,
        email_display_name,
        disclaimer_description,
        disclaimer_title,
        redirect_url,
        is_default,
        can_hide_tag_line,
        combine_audit_trail,
        exclude_audit_trail_from_email,
        email_signed_document,
        document_time_zone,
        show_built_in_form_fields,
        allow_custom_field_creation,
        show_shared_custom_fields,
        hide_decline,
        hide_save,
        document_expiry_settings_expiry_date_type,
        document_expiry_settings_expiry_value,
        document_expiry_settings_enable_default_expiry_alert,
        document_expiry_settings_enable_auto_reminder,
        document_expiry_settings_reminder_days,
        document_expiry_settings_reminder_count,
        custom_domain_settings_domain_name,
        custom_domain_settings_from_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if brand_name is not None:
            _form_params.append(('BrandName', brand_name))
        if brand_logo is not None:
            _files['BrandLogo'] = brand_logo
        if background_color is not None:
            _form_params.append(('BackgroundColor', background_color))
        if button_color is not None:
            _form_params.append(('ButtonColor', button_color))
        if button_text_color is not None:
            _form_params.append(('ButtonTextColor', button_text_color))
        if email_display_name is not None:
            _form_params.append(('EmailDisplayName', email_display_name))
        if disclaimer_description is not None:
            _form_params.append(('DisclaimerDescription', disclaimer_description))
        if disclaimer_title is not None:
            _form_params.append(('DisclaimerTitle', disclaimer_title))
        if redirect_url is not None:
            _form_params.append(('RedirectUrl', redirect_url))
        if is_default is not None:
            _form_params.append(('IsDefault', is_default))
        if can_hide_tag_line is not None:
            _form_params.append(('CanHideTagLine', can_hide_tag_line))
        if combine_audit_trail is not None:
            _form_params.append(('CombineAuditTrail', combine_audit_trail))
        if exclude_audit_trail_from_email is not None:
            _form_params.append(('ExcludeAuditTrailFromEmail', exclude_audit_trail_from_email))
        if email_signed_document is not None:
            _form_params.append(('EmailSignedDocument', email_signed_document))
        if document_time_zone is not None:
            _form_params.append(('DocumentTimeZone', document_time_zone))
        if show_built_in_form_fields is not None:
            _form_params.append(('ShowBuiltInFormFields', show_built_in_form_fields))
        if allow_custom_field_creation is not None:
            _form_params.append(('AllowCustomFieldCreation', allow_custom_field_creation))
        if show_shared_custom_fields is not None:
            _form_params.append(('ShowSharedCustomFields', show_shared_custom_fields))
        if hide_decline is not None:
            _form_params.append(('HideDecline', hide_decline))
        if hide_save is not None:
            _form_params.append(('HideSave', hide_save))
        if document_expiry_settings_expiry_date_type is not None:
            _form_params.append(('DocumentExpirySettings.ExpiryDateType', document_expiry_settings_expiry_date_type))
        if document_expiry_settings_expiry_value is not None:
            _form_params.append(('DocumentExpirySettings.ExpiryValue', document_expiry_settings_expiry_value))
        if document_expiry_settings_enable_default_expiry_alert is not None:
            _form_params.append(('DocumentExpirySettings.EnableDefaultExpiryAlert', document_expiry_settings_enable_default_expiry_alert))
        if document_expiry_settings_enable_auto_reminder is not None:
            _form_params.append(('DocumentExpirySettings.EnableAutoReminder', document_expiry_settings_enable_auto_reminder))
        if document_expiry_settings_reminder_days is not None:
            _form_params.append(('DocumentExpirySettings.ReminderDays', document_expiry_settings_reminder_days))
        if document_expiry_settings_reminder_count is not None:
            _form_params.append(('DocumentExpirySettings.ReminderCount', document_expiry_settings_reminder_count))
        if custom_domain_settings_domain_name is not None:
            _form_params.append(('CustomDomainSettings.DomainName', custom_domain_settings_domain_name))
        if custom_domain_settings_from_name is not None:
            _form_params.append(('CustomDomainSettings.FromName', custom_domain_settings_from_name))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/brand/create',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_brand(
        self,
        brand_id: Annotated[StrictStr, Field(description="brand Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BrandingMessage:
        """Delete the brand.


        :param brand_id: brand Id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_brand_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandingMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_brand_with_http_info(
        self,
        brand_id: Annotated[StrictStr, Field(description="brand Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BrandingMessage]:
        """Delete the brand.


        :param brand_id: brand Id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_brand_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandingMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_brand_without_preload_content(
        self,
        brand_id: Annotated[StrictStr, Field(description="brand Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete the brand.


        :param brand_id: brand Id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_brand_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandingMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_brand_serialize(
        self,
        brand_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if brand_id is not None:
            
            _query_params.append(('brandId', brand_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/brand/delete',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def edit_brand(
        self,
        brand_id: Annotated[StrictStr, Field(description="The brand id.")],
        brand_name: Optional[StrictStr] = None,
        brand_logo: Optional[Union[StrictBytes, StrictStr]] = None,
        background_color: Optional[StrictStr] = None,
        button_color: Optional[StrictStr] = None,
        button_text_color: Optional[StrictStr] = None,
        email_display_name: Optional[StrictStr] = None,
        disclaimer_description: Optional[StrictStr] = None,
        disclaimer_title: Optional[StrictStr] = None,
        redirect_url: Optional[StrictStr] = None,
        is_default: Optional[StrictBool] = None,
        can_hide_tag_line: Optional[StrictBool] = None,
        combine_audit_trail: Optional[StrictBool] = None,
        exclude_audit_trail_from_email: Optional[StrictBool] = None,
        email_signed_document: Optional[StrictStr] = None,
        document_time_zone: Optional[StrictStr] = None,
        show_built_in_form_fields: Optional[StrictBool] = None,
        allow_custom_field_creation: Optional[StrictBool] = None,
        show_shared_custom_fields: Optional[StrictBool] = None,
        hide_decline: Optional[StrictBool] = None,
        hide_save: Optional[StrictBool] = None,
        document_expiry_settings_expiry_date_type: Optional[StrictStr] = None,
        document_expiry_settings_expiry_value: Optional[StrictInt] = None,
        document_expiry_settings_enable_default_expiry_alert: Optional[StrictBool] = None,
        document_expiry_settings_enable_auto_reminder: Optional[StrictBool] = None,
        document_expiry_settings_reminder_days: Optional[Annotated[int, Field(le=180, strict=True, ge=1)]] = None,
        document_expiry_settings_reminder_count: Optional[StrictInt] = None,
        custom_domain_settings_domain_name: Optional[StrictStr] = None,
        custom_domain_settings_from_name: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BrandCreated:
        """Edit the brand.


        :param brand_id: The brand id. (required)
        :type brand_id: str
        :param brand_name:
        :type brand_name: str
        :param brand_logo:
        :type brand_logo: io.IOBase
        :param background_color:
        :type background_color: str
        :param button_color:
        :type button_color: str
        :param button_text_color:
        :type button_text_color: str
        :param email_display_name:
        :type email_display_name: str
        :param disclaimer_description:
        :type disclaimer_description: str
        :param disclaimer_title:
        :type disclaimer_title: str
        :param redirect_url:
        :type redirect_url: str
        :param is_default:
        :type is_default: bool
        :param can_hide_tag_line:
        :type can_hide_tag_line: bool
        :param combine_audit_trail:
        :type combine_audit_trail: bool
        :param exclude_audit_trail_from_email:
        :type exclude_audit_trail_from_email: bool
        :param email_signed_document:
        :type email_signed_document: str
        :param document_time_zone:
        :type document_time_zone: str
        :param show_built_in_form_fields:
        :type show_built_in_form_fields: bool
        :param allow_custom_field_creation:
        :type allow_custom_field_creation: bool
        :param show_shared_custom_fields:
        :type show_shared_custom_fields: bool
        :param hide_decline:
        :type hide_decline: bool
        :param hide_save:
        :type hide_save: bool
        :param document_expiry_settings_expiry_date_type:
        :type document_expiry_settings_expiry_date_type: str
        :param document_expiry_settings_expiry_value:
        :type document_expiry_settings_expiry_value: int
        :param document_expiry_settings_enable_default_expiry_alert:
        :type document_expiry_settings_enable_default_expiry_alert: bool
        :param document_expiry_settings_enable_auto_reminder:
        :type document_expiry_settings_enable_auto_reminder: bool
        :param document_expiry_settings_reminder_days:
        :type document_expiry_settings_reminder_days: int
        :param document_expiry_settings_reminder_count:
        :type document_expiry_settings_reminder_count: int
        :param custom_domain_settings_domain_name:
        :type custom_domain_settings_domain_name: str
        :param custom_domain_settings_from_name:
        :type custom_domain_settings_from_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_brand_serialize(
            brand_id=brand_id,
            brand_name=brand_name,
            brand_logo=brand_logo,
            background_color=background_color,
            button_color=button_color,
            button_text_color=button_text_color,
            email_display_name=email_display_name,
            disclaimer_description=disclaimer_description,
            disclaimer_title=disclaimer_title,
            redirect_url=redirect_url,
            is_default=is_default,
            can_hide_tag_line=can_hide_tag_line,
            combine_audit_trail=combine_audit_trail,
            exclude_audit_trail_from_email=exclude_audit_trail_from_email,
            email_signed_document=email_signed_document,
            document_time_zone=document_time_zone,
            show_built_in_form_fields=show_built_in_form_fields,
            allow_custom_field_creation=allow_custom_field_creation,
            show_shared_custom_fields=show_shared_custom_fields,
            hide_decline=hide_decline,
            hide_save=hide_save,
            document_expiry_settings_expiry_date_type=document_expiry_settings_expiry_date_type,
            document_expiry_settings_expiry_value=document_expiry_settings_expiry_value,
            document_expiry_settings_enable_default_expiry_alert=document_expiry_settings_enable_default_expiry_alert,
            document_expiry_settings_enable_auto_reminder=document_expiry_settings_enable_auto_reminder,
            document_expiry_settings_reminder_days=document_expiry_settings_reminder_days,
            document_expiry_settings_reminder_count=document_expiry_settings_reminder_count,
            custom_domain_settings_domain_name=custom_domain_settings_domain_name,
            custom_domain_settings_from_name=custom_domain_settings_from_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def edit_brand_with_http_info(
        self,
        brand_id: Annotated[StrictStr, Field(description="The brand id.")],
        brand_name: Optional[StrictStr] = None,
        brand_logo: Optional[Union[StrictBytes, StrictStr]] = None,
        background_color: Optional[StrictStr] = None,
        button_color: Optional[StrictStr] = None,
        button_text_color: Optional[StrictStr] = None,
        email_display_name: Optional[StrictStr] = None,
        disclaimer_description: Optional[StrictStr] = None,
        disclaimer_title: Optional[StrictStr] = None,
        redirect_url: Optional[StrictStr] = None,
        is_default: Optional[StrictBool] = None,
        can_hide_tag_line: Optional[StrictBool] = None,
        combine_audit_trail: Optional[StrictBool] = None,
        exclude_audit_trail_from_email: Optional[StrictBool] = None,
        email_signed_document: Optional[StrictStr] = None,
        document_time_zone: Optional[StrictStr] = None,
        show_built_in_form_fields: Optional[StrictBool] = None,
        allow_custom_field_creation: Optional[StrictBool] = None,
        show_shared_custom_fields: Optional[StrictBool] = None,
        hide_decline: Optional[StrictBool] = None,
        hide_save: Optional[StrictBool] = None,
        document_expiry_settings_expiry_date_type: Optional[StrictStr] = None,
        document_expiry_settings_expiry_value: Optional[StrictInt] = None,
        document_expiry_settings_enable_default_expiry_alert: Optional[StrictBool] = None,
        document_expiry_settings_enable_auto_reminder: Optional[StrictBool] = None,
        document_expiry_settings_reminder_days: Optional[Annotated[int, Field(le=180, strict=True, ge=1)]] = None,
        document_expiry_settings_reminder_count: Optional[StrictInt] = None,
        custom_domain_settings_domain_name: Optional[StrictStr] = None,
        custom_domain_settings_from_name: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BrandCreated]:
        """Edit the brand.


        :param brand_id: The brand id. (required)
        :type brand_id: str
        :param brand_name:
        :type brand_name: str
        :param brand_logo:
        :type brand_logo: io.IOBase
        :param background_color:
        :type background_color: str
        :param button_color:
        :type button_color: str
        :param button_text_color:
        :type button_text_color: str
        :param email_display_name:
        :type email_display_name: str
        :param disclaimer_description:
        :type disclaimer_description: str
        :param disclaimer_title:
        :type disclaimer_title: str
        :param redirect_url:
        :type redirect_url: str
        :param is_default:
        :type is_default: bool
        :param can_hide_tag_line:
        :type can_hide_tag_line: bool
        :param combine_audit_trail:
        :type combine_audit_trail: bool
        :param exclude_audit_trail_from_email:
        :type exclude_audit_trail_from_email: bool
        :param email_signed_document:
        :type email_signed_document: str
        :param document_time_zone:
        :type document_time_zone: str
        :param show_built_in_form_fields:
        :type show_built_in_form_fields: bool
        :param allow_custom_field_creation:
        :type allow_custom_field_creation: bool
        :param show_shared_custom_fields:
        :type show_shared_custom_fields: bool
        :param hide_decline:
        :type hide_decline: bool
        :param hide_save:
        :type hide_save: bool
        :param document_expiry_settings_expiry_date_type:
        :type document_expiry_settings_expiry_date_type: str
        :param document_expiry_settings_expiry_value:
        :type document_expiry_settings_expiry_value: int
        :param document_expiry_settings_enable_default_expiry_alert:
        :type document_expiry_settings_enable_default_expiry_alert: bool
        :param document_expiry_settings_enable_auto_reminder:
        :type document_expiry_settings_enable_auto_reminder: bool
        :param document_expiry_settings_reminder_days:
        :type document_expiry_settings_reminder_days: int
        :param document_expiry_settings_reminder_count:
        :type document_expiry_settings_reminder_count: int
        :param custom_domain_settings_domain_name:
        :type custom_domain_settings_domain_name: str
        :param custom_domain_settings_from_name:
        :type custom_domain_settings_from_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_brand_serialize(
            brand_id=brand_id,
            brand_name=brand_name,
            brand_logo=brand_logo,
            background_color=background_color,
            button_color=button_color,
            button_text_color=button_text_color,
            email_display_name=email_display_name,
            disclaimer_description=disclaimer_description,
            disclaimer_title=disclaimer_title,
            redirect_url=redirect_url,
            is_default=is_default,
            can_hide_tag_line=can_hide_tag_line,
            combine_audit_trail=combine_audit_trail,
            exclude_audit_trail_from_email=exclude_audit_trail_from_email,
            email_signed_document=email_signed_document,
            document_time_zone=document_time_zone,
            show_built_in_form_fields=show_built_in_form_fields,
            allow_custom_field_creation=allow_custom_field_creation,
            show_shared_custom_fields=show_shared_custom_fields,
            hide_decline=hide_decline,
            hide_save=hide_save,
            document_expiry_settings_expiry_date_type=document_expiry_settings_expiry_date_type,
            document_expiry_settings_expiry_value=document_expiry_settings_expiry_value,
            document_expiry_settings_enable_default_expiry_alert=document_expiry_settings_enable_default_expiry_alert,
            document_expiry_settings_enable_auto_reminder=document_expiry_settings_enable_auto_reminder,
            document_expiry_settings_reminder_days=document_expiry_settings_reminder_days,
            document_expiry_settings_reminder_count=document_expiry_settings_reminder_count,
            custom_domain_settings_domain_name=custom_domain_settings_domain_name,
            custom_domain_settings_from_name=custom_domain_settings_from_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def edit_brand_without_preload_content(
        self,
        brand_id: Annotated[StrictStr, Field(description="The brand id.")],
        brand_name: Optional[StrictStr] = None,
        brand_logo: Optional[Union[StrictBytes, StrictStr]] = None,
        background_color: Optional[StrictStr] = None,
        button_color: Optional[StrictStr] = None,
        button_text_color: Optional[StrictStr] = None,
        email_display_name: Optional[StrictStr] = None,
        disclaimer_description: Optional[StrictStr] = None,
        disclaimer_title: Optional[StrictStr] = None,
        redirect_url: Optional[StrictStr] = None,
        is_default: Optional[StrictBool] = None,
        can_hide_tag_line: Optional[StrictBool] = None,
        combine_audit_trail: Optional[StrictBool] = None,
        exclude_audit_trail_from_email: Optional[StrictBool] = None,
        email_signed_document: Optional[StrictStr] = None,
        document_time_zone: Optional[StrictStr] = None,
        show_built_in_form_fields: Optional[StrictBool] = None,
        allow_custom_field_creation: Optional[StrictBool] = None,
        show_shared_custom_fields: Optional[StrictBool] = None,
        hide_decline: Optional[StrictBool] = None,
        hide_save: Optional[StrictBool] = None,
        document_expiry_settings_expiry_date_type: Optional[StrictStr] = None,
        document_expiry_settings_expiry_value: Optional[StrictInt] = None,
        document_expiry_settings_enable_default_expiry_alert: Optional[StrictBool] = None,
        document_expiry_settings_enable_auto_reminder: Optional[StrictBool] = None,
        document_expiry_settings_reminder_days: Optional[Annotated[int, Field(le=180, strict=True, ge=1)]] = None,
        document_expiry_settings_reminder_count: Optional[StrictInt] = None,
        custom_domain_settings_domain_name: Optional[StrictStr] = None,
        custom_domain_settings_from_name: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Edit the brand.


        :param brand_id: The brand id. (required)
        :type brand_id: str
        :param brand_name:
        :type brand_name: str
        :param brand_logo:
        :type brand_logo: io.IOBase
        :param background_color:
        :type background_color: str
        :param button_color:
        :type button_color: str
        :param button_text_color:
        :type button_text_color: str
        :param email_display_name:
        :type email_display_name: str
        :param disclaimer_description:
        :type disclaimer_description: str
        :param disclaimer_title:
        :type disclaimer_title: str
        :param redirect_url:
        :type redirect_url: str
        :param is_default:
        :type is_default: bool
        :param can_hide_tag_line:
        :type can_hide_tag_line: bool
        :param combine_audit_trail:
        :type combine_audit_trail: bool
        :param exclude_audit_trail_from_email:
        :type exclude_audit_trail_from_email: bool
        :param email_signed_document:
        :type email_signed_document: str
        :param document_time_zone:
        :type document_time_zone: str
        :param show_built_in_form_fields:
        :type show_built_in_form_fields: bool
        :param allow_custom_field_creation:
        :type allow_custom_field_creation: bool
        :param show_shared_custom_fields:
        :type show_shared_custom_fields: bool
        :param hide_decline:
        :type hide_decline: bool
        :param hide_save:
        :type hide_save: bool
        :param document_expiry_settings_expiry_date_type:
        :type document_expiry_settings_expiry_date_type: str
        :param document_expiry_settings_expiry_value:
        :type document_expiry_settings_expiry_value: int
        :param document_expiry_settings_enable_default_expiry_alert:
        :type document_expiry_settings_enable_default_expiry_alert: bool
        :param document_expiry_settings_enable_auto_reminder:
        :type document_expiry_settings_enable_auto_reminder: bool
        :param document_expiry_settings_reminder_days:
        :type document_expiry_settings_reminder_days: int
        :param document_expiry_settings_reminder_count:
        :type document_expiry_settings_reminder_count: int
        :param custom_domain_settings_domain_name:
        :type custom_domain_settings_domain_name: str
        :param custom_domain_settings_from_name:
        :type custom_domain_settings_from_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._edit_brand_serialize(
            brand_id=brand_id,
            brand_name=brand_name,
            brand_logo=brand_logo,
            background_color=background_color,
            button_color=button_color,
            button_text_color=button_text_color,
            email_display_name=email_display_name,
            disclaimer_description=disclaimer_description,
            disclaimer_title=disclaimer_title,
            redirect_url=redirect_url,
            is_default=is_default,
            can_hide_tag_line=can_hide_tag_line,
            combine_audit_trail=combine_audit_trail,
            exclude_audit_trail_from_email=exclude_audit_trail_from_email,
            email_signed_document=email_signed_document,
            document_time_zone=document_time_zone,
            show_built_in_form_fields=show_built_in_form_fields,
            allow_custom_field_creation=allow_custom_field_creation,
            show_shared_custom_fields=show_shared_custom_fields,
            hide_decline=hide_decline,
            hide_save=hide_save,
            document_expiry_settings_expiry_date_type=document_expiry_settings_expiry_date_type,
            document_expiry_settings_expiry_value=document_expiry_settings_expiry_value,
            document_expiry_settings_enable_default_expiry_alert=document_expiry_settings_enable_default_expiry_alert,
            document_expiry_settings_enable_auto_reminder=document_expiry_settings_enable_auto_reminder,
            document_expiry_settings_reminder_days=document_expiry_settings_reminder_days,
            document_expiry_settings_reminder_count=document_expiry_settings_reminder_count,
            custom_domain_settings_domain_name=custom_domain_settings_domain_name,
            custom_domain_settings_from_name=custom_domain_settings_from_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandCreated",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _edit_brand_serialize(
        self,
        brand_id,
        brand_name,
        brand_logo,
        background_color,
        button_color,
        button_text_color,
        email_display_name,
        disclaimer_description,
        disclaimer_title,
        redirect_url,
        is_default,
        can_hide_tag_line,
        combine_audit_trail,
        exclude_audit_trail_from_email,
        email_signed_document,
        document_time_zone,
        show_built_in_form_fields,
        allow_custom_field_creation,
        show_shared_custom_fields,
        hide_decline,
        hide_save,
        document_expiry_settings_expiry_date_type,
        document_expiry_settings_expiry_value,
        document_expiry_settings_enable_default_expiry_alert,
        document_expiry_settings_enable_auto_reminder,
        document_expiry_settings_reminder_days,
        document_expiry_settings_reminder_count,
        custom_domain_settings_domain_name,
        custom_domain_settings_from_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if brand_id is not None:
            
            _query_params.append(('brandId', brand_id))
            
        # process the header parameters
        # process the form parameters
        if brand_name is not None:
            _form_params.append(('BrandName', brand_name))
        if brand_logo is not None:
            _files['BrandLogo'] = brand_logo
        if background_color is not None:
            _form_params.append(('BackgroundColor', background_color))
        if button_color is not None:
            _form_params.append(('ButtonColor', button_color))
        if button_text_color is not None:
            _form_params.append(('ButtonTextColor', button_text_color))
        if email_display_name is not None:
            _form_params.append(('EmailDisplayName', email_display_name))
        if disclaimer_description is not None:
            _form_params.append(('DisclaimerDescription', disclaimer_description))
        if disclaimer_title is not None:
            _form_params.append(('DisclaimerTitle', disclaimer_title))
        if redirect_url is not None:
            _form_params.append(('RedirectUrl', redirect_url))
        if is_default is not None:
            _form_params.append(('IsDefault', is_default))
        if can_hide_tag_line is not None:
            _form_params.append(('CanHideTagLine', can_hide_tag_line))
        if combine_audit_trail is not None:
            _form_params.append(('CombineAuditTrail', combine_audit_trail))
        if exclude_audit_trail_from_email is not None:
            _form_params.append(('ExcludeAuditTrailFromEmail', exclude_audit_trail_from_email))
        if email_signed_document is not None:
            _form_params.append(('EmailSignedDocument', email_signed_document))
        if document_time_zone is not None:
            _form_params.append(('DocumentTimeZone', document_time_zone))
        if show_built_in_form_fields is not None:
            _form_params.append(('ShowBuiltInFormFields', show_built_in_form_fields))
        if allow_custom_field_creation is not None:
            _form_params.append(('AllowCustomFieldCreation', allow_custom_field_creation))
        if show_shared_custom_fields is not None:
            _form_params.append(('ShowSharedCustomFields', show_shared_custom_fields))
        if hide_decline is not None:
            _form_params.append(('HideDecline', hide_decline))
        if hide_save is not None:
            _form_params.append(('HideSave', hide_save))
        if document_expiry_settings_expiry_date_type is not None:
            _form_params.append(('DocumentExpirySettings.ExpiryDateType', document_expiry_settings_expiry_date_type))
        if document_expiry_settings_expiry_value is not None:
            _form_params.append(('DocumentExpirySettings.ExpiryValue', document_expiry_settings_expiry_value))
        if document_expiry_settings_enable_default_expiry_alert is not None:
            _form_params.append(('DocumentExpirySettings.EnableDefaultExpiryAlert', document_expiry_settings_enable_default_expiry_alert))
        if document_expiry_settings_enable_auto_reminder is not None:
            _form_params.append(('DocumentExpirySettings.EnableAutoReminder', document_expiry_settings_enable_auto_reminder))
        if document_expiry_settings_reminder_days is not None:
            _form_params.append(('DocumentExpirySettings.ReminderDays', document_expiry_settings_reminder_days))
        if document_expiry_settings_reminder_count is not None:
            _form_params.append(('DocumentExpirySettings.ReminderCount', document_expiry_settings_reminder_count))
        if custom_domain_settings_domain_name is not None:
            _form_params.append(('CustomDomainSettings.DomainName', custom_domain_settings_domain_name))
        if custom_domain_settings_from_name is not None:
            _form_params.append(('CustomDomainSettings.FromName', custom_domain_settings_from_name))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/brand/edit',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_brand(
        self,
        brand_id: Annotated[StrictStr, Field(description="The brand id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ViewBrandDetails:
        """Get the specific brand details.


        :param brand_id: The brand id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_brand_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ViewBrandDetails",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_brand_with_http_info(
        self,
        brand_id: Annotated[StrictStr, Field(description="The brand id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ViewBrandDetails]:
        """Get the specific brand details.


        :param brand_id: The brand id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_brand_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ViewBrandDetails",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_brand_without_preload_content(
        self,
        brand_id: Annotated[StrictStr, Field(description="The brand id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get the specific brand details.


        :param brand_id: The brand id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_brand_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ViewBrandDetails",
            '401': "ErrorResult",
            '403': "ErrorResult",
            '422': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_brand_serialize(
        self,
        brand_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if brand_id is not None:
            
            _query_params.append(('brandId', brand_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/brand/get',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def reset_default_brand(
        self,
        brand_id: Annotated[StrictStr, Field(description="brand Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BrandingMessage:
        """Reset default brand.


        :param brand_id: brand Id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._reset_default_brand_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandingMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def reset_default_brand_with_http_info(
        self,
        brand_id: Annotated[StrictStr, Field(description="brand Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BrandingMessage]:
        """Reset default brand.


        :param brand_id: brand Id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._reset_default_brand_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandingMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def reset_default_brand_without_preload_content(
        self,
        brand_id: Annotated[StrictStr, Field(description="brand Id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Reset default brand.


        :param brand_id: brand Id. (required)
        :type brand_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._reset_default_brand_serialize(
            brand_id=brand_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BrandingMessage",
            '401': "ErrorResult",
            '403': "ErrorResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _reset_default_brand_serialize(
        self,
        brand_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if brand_id is not None:
            
            _query_params.append(('brandId', brand_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json;odata.metadata=minimal;odata.streaming=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false', 
                    'application/json;odata.metadata=minimal', 
                    'application/json;odata.metadata=full;odata.streaming=true', 
                    'application/json;odata.metadata=full;odata.streaming=false', 
                    'application/json;odata.metadata=full', 
                    'application/json;odata.metadata=none;odata.streaming=true', 
                    'application/json;odata.metadata=none;odata.streaming=false', 
                    'application/json;odata.metadata=none', 
                    'application/json;odata.streaming=true', 
                    'application/json;odata.streaming=false', 
                    'application/json', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=false', 
                    'application/json;odata.metadata=minimal;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=full;IEEE754Compatible=false', 
                    'application/json;odata.metadata=full;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;odata.metadata=none;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=false', 
                    'application/json;odata.metadata=none;IEEE754Compatible=true', 
                    'application/json;odata.streaming=true;IEEE754Compatible=false', 
                    'application/json;odata.streaming=true;IEEE754Compatible=true', 
                    'application/json;odata.streaming=false;IEEE754Compatible=false', 
                    'application/json;odata.streaming=false;IEEE754Compatible=true', 
                    'application/json;IEEE754Compatible=false', 
                    'application/json;IEEE754Compatible=true', 
                    'application/xml', 
                    'text/plain', 
                    'application/octet-stream', 
                    'text/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'X-API-KEY', 
            'Bearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/brand/resetdefault',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


