"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ControlPolicy = exports.ControlPolicyProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cloudfw_generated_1 = require("./cloudfw.generated");
Object.defineProperty(exports, "ControlPolicyProperty", { enumerable: true, get: function () { return cloudfw_generated_1.RosControlPolicy; } });
/**
 * A ROS resource type:  `ALIYUN::CLOUDFW::ControlPolicy`
 */
class ControlPolicy extends ros.Resource {
    /**
     * Create a new `ALIYUN::CLOUDFW::ControlPolicy`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosControlPolicy = new cloudfw_generated_1.RosControlPolicy(this, id, {
            destination: props.destination,
            applicationName: props.applicationName,
            description: props.description,
            sourceType: props.sourceType,
            destPort: props.destPort,
            aclAction: props.aclAction,
            destinationType: props.destinationType,
            direction: props.direction,
            source: props.source,
            destPortType: props.destPortType,
            proto: props.proto,
            regionId: props.regionId === undefined || props.regionId === null ? 'cn-hangzhou' : props.regionId,
            newOrder: props.newOrder,
            destPortGroup: props.destPortGroup,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosControlPolicy;
        this.attrAclUuid = rosControlPolicy.attrAclUuid;
    }
}
exports.ControlPolicy = ControlPolicy;
//# sourceMappingURL=data:application/json;base64,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