"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = exports.TopicProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kafka_generated_1 = require("./kafka.generated");
Object.defineProperty(exports, "TopicProperty", { enumerable: true, get: function () { return kafka_generated_1.RosTopic; } });
/**
 * A ROS resource type:  `ALIYUN::KAFKA::Topic`
 */
class Topic extends ros.Resource {
    /**
     * Create a new `ALIYUN::KAFKA::Topic`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTopic = new kafka_generated_1.RosTopic(this, id, {
            partitionNum: props.partitionNum,
            compactTopic: props.compactTopic,
            replicationFactor: props.replicationFactor,
            instanceId: props.instanceId,
            config: props.config,
            minInsyncReplicas: props.minInsyncReplicas,
            topic: props.topic,
            localTopic: props.localTopic,
            tags: props.tags,
            remark: props.remark,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTopic;
        this.attrInstanceId = rosTopic.attrInstanceId;
        this.attrTopic = rosTopic.attrTopic;
    }
}
exports.Topic = Topic;
//# sourceMappingURL=data:application/json;base64,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