"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosTopic = exports.RosInstance = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('deployType', ros.requiredValidator)(properties.deployType));
    if (properties.deployType && (typeof properties.deployType) !== 'object') {
        errors.collect(ros.propertyValidator('deployType', ros.validateAllowedValues)({
            data: properties.deployType,
            allowedValues: [4, 5],
        }));
    }
    errors.collect(ros.propertyValidator('deployType', ros.validateNumber)(properties.deployType));
    errors.collect(ros.propertyValidator('eipMax', ros.validateNumber)(properties.eipMax));
    if (properties.specType && (typeof properties.specType) !== 'object') {
        errors.collect(ros.propertyValidator('specType', ros.validateAllowedValues)({
            data: properties.specType,
            allowedValues: ["normal", "professional", "professionalForHighRead"],
        }));
    }
    errors.collect(ros.propertyValidator('specType', ros.validateString)(properties.specType));
    errors.collect(ros.propertyValidator('ioMax', ros.validateNumber)(properties.ioMax));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["Hour", "Month"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    errors.collect(ros.propertyValidator('diskType', ros.requiredValidator)(properties.diskType));
    if (properties.diskType && (typeof properties.diskType) !== 'object') {
        errors.collect(ros.propertyValidator('diskType', ros.validateAllowedValues)({
            data: properties.diskType,
            allowedValues: ["0", "1"],
        }));
    }
    errors.collect(ros.propertyValidator('diskType', ros.validateString)(properties.diskType));
    errors.collect(ros.propertyValidator('deployOption', RosInstance_DeployOptionPropertyValidator)(properties.deployOption));
    errors.collect(ros.propertyValidator('deletionForce', ros.validateBoolean)(properties.deletionForce));
    errors.collect(ros.propertyValidator('ioMaxSpec', ros.validateString)(properties.ioMaxSpec));
    errors.collect(ros.propertyValidator('diskSize', ros.requiredValidator)(properties.diskSize));
    errors.collect(ros.propertyValidator('diskSize', ros.validateNumber)(properties.diskSize));
    errors.collect(ros.propertyValidator('topicQuota', ros.requiredValidator)(properties.topicQuota));
    errors.collect(ros.propertyValidator('topicQuota', ros.validateNumber)(properties.topicQuota));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: undefined,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosInstance_TagsPropertyValidator))(properties.tags));
    errors.collect(ros.propertyValidator('openConnector', ros.validateBoolean)(properties.openConnector));
    return errors.wrap('supplied properties not correct for "RosInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::KAFKA::Instance` resource
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::KAFKA::Instance` resource.
 */
// @ts-ignore TS6133
function rosInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosInstancePropsValidator(properties).assertSuccess();
    }
    return {
        DeployType: ros.numberToRosTemplate(properties.deployType),
        DiskSize: ros.numberToRosTemplate(properties.diskSize),
        DiskType: ros.stringToRosTemplate(properties.diskType),
        TopicQuota: ros.numberToRosTemplate(properties.topicQuota),
        DeletionForce: ros.booleanToRosTemplate(properties.deletionForce),
        DeployOption: rosInstanceDeployOptionPropertyToRosTemplate(properties.deployOption),
        EipMax: ros.numberToRosTemplate(properties.eipMax),
        IoMax: ros.numberToRosTemplate(properties.ioMax),
        IoMaxSpec: ros.stringToRosTemplate(properties.ioMaxSpec),
        OpenConnector: ros.booleanToRosTemplate(properties.openConnector),
        PayType: ros.stringToRosTemplate(properties.payType),
        SpecType: ros.stringToRosTemplate(properties.specType),
        Tags: ros.listMapper(rosInstanceTagsPropertyToRosTemplate)(properties.tags),
    };
}
/**
 * A ROS template type:  `ALIYUN::KAFKA::Instance`
 */
class RosInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::KAFKA::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDomainEndpoint = this.getAtt('DomainEndpoint');
        this.attrEndpoint = this.getAtt('Endpoint');
        this.attrInstanceId = this.getAtt('InstanceId');
        this.attrName = this.getAtt('Name');
        this.attrOrderId = this.getAtt('OrderId');
        this.attrSaslDomainEndpoint = this.getAtt('SaslDomainEndpoint');
        this.attrSslDomainEndpoint = this.getAtt('SslDomainEndpoint');
        this.attrSslEndpoint = this.getAtt('SslEndpoint');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.deployType = props.deployType;
        this.diskSize = props.diskSize;
        this.diskType = props.diskType;
        this.topicQuota = props.topicQuota;
        this.deletionForce = props.deletionForce;
        this.deployOption = props.deployOption;
        this.eipMax = props.eipMax;
        this.ioMax = props.ioMax;
        this.ioMaxSpec = props.ioMaxSpec;
        this.openConnector = props.openConnector;
        this.payType = props.payType;
        this.specType = props.specType;
        this.tags = props.tags;
    }
    get rosProperties() {
        return {
            deployType: this.deployType,
            diskSize: this.diskSize,
            diskType: this.diskType,
            topicQuota: this.topicQuota,
            deletionForce: this.deletionForce,
            deployOption: this.deployOption,
            eipMax: this.eipMax,
            ioMax: this.ioMax,
            ioMaxSpec: this.ioMaxSpec,
            openConnector: this.openConnector,
            payType: this.payType,
            specType: this.specType,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return rosInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosInstance = RosInstance;
/**
 * The resource type name for this resource class.
 */
RosInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::KAFKA::Instance";
/**
 * Determine whether the given properties match those of a `DeployOptionProperty`
 *
 * @param properties - the TypeScript properties of a `DeployOptionProperty`
 *
 * @returns the result of the validation.
 */
function RosInstance_DeployOptionPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('isEipInner', ros.validateBoolean)(properties.isEipInner));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    if (properties.username && (typeof properties.username) !== 'object') {
        errors.collect(ros.propertyValidator('username', ros.validateAllowedPattern)({
            data: properties.username,
            reg: /[a-zA-Z0-9]{8,40}/
        }));
    }
    errors.collect(ros.propertyValidator('username', ros.validateString)(properties.username));
    errors.collect(ros.propertyValidator('config', ros.hashValidator(ros.validateAny))(properties.config));
    errors.collect(ros.propertyValidator('vSwitchId', ros.requiredValidator)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('serviceVersion', ros.validateString)(properties.serviceVersion));
    errors.collect(ros.propertyValidator('securityGroup', ros.validateString)(properties.securityGroup));
    errors.collect(ros.propertyValidator('deployModule', ros.requiredValidator)(properties.deployModule));
    if (properties.deployModule && (typeof properties.deployModule) !== 'object') {
        errors.collect(ros.propertyValidator('deployModule', ros.validateAllowedValues)({
            data: properties.deployModule,
            allowedValues: ["vpc", "eip"],
        }));
    }
    errors.collect(ros.propertyValidator('deployModule', ros.validateString)(properties.deployModule));
    errors.collect(ros.propertyValidator('isSetUserAndPassword', ros.validateBoolean)(properties.isSetUserAndPassword));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    if (properties.password && (typeof properties.password) !== 'object') {
        errors.collect(ros.propertyValidator('password', ros.validateAllowedPattern)({
            data: properties.password,
            reg: /^(?=.*?\d)(?=.*?[A-Z])(?=.*?[a-z])[A-Za-z\d]{8,40}$/
        }));
    }
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "DeployOptionProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::KAFKA::Instance.DeployOption` resource
 *
 * @param properties - the TypeScript properties of a `DeployOptionProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::KAFKA::Instance.DeployOption` resource.
 */
// @ts-ignore TS6133
function rosInstanceDeployOptionPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosInstance_DeployOptionPropertyValidator(properties).assertSuccess();
    return {
        IsEipInner: ros.booleanToRosTemplate(properties.isEipInner),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
        Username: ros.stringToRosTemplate(properties.username),
        Config: ros.hashMapper(ros.objectToRosTemplate)(properties.config),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        ServiceVersion: ros.stringToRosTemplate(properties.serviceVersion),
        SecurityGroup: ros.stringToRosTemplate(properties.securityGroup),
        DeployModule: ros.stringToRosTemplate(properties.deployModule),
        IsSetUserAndPassword: ros.booleanToRosTemplate(properties.isSetUserAndPassword),
        Name: ros.stringToRosTemplate(properties.name),
        Password: ros.stringToRosTemplate(properties.password),
    };
}
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosInstance_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::KAFKA::Instance.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::KAFKA::Instance.Tags` resource.
 */
// @ts-ignore TS6133
function rosInstanceTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosInstance_TagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosTopicProps`
 *
 * @param properties - the TypeScript properties of a `RosTopicProps`
 *
 * @returns the result of the validation.
 */
function RosTopicPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('partitionNum', ros.validateNumber)(properties.partitionNum));
    errors.collect(ros.propertyValidator('compactTopic', ros.validateBoolean)(properties.compactTopic));
    if (properties.replicationFactor && (typeof properties.replicationFactor) !== 'object') {
        errors.collect(ros.propertyValidator('replicationFactor', ros.validateRange)({
            data: properties.replicationFactor,
            min: 1,
            max: 3,
        }));
    }
    errors.collect(ros.propertyValidator('replicationFactor', ros.validateNumber)(properties.replicationFactor));
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('config', ros.hashValidator(ros.validateAny))(properties.config));
    if (properties.minInsyncReplicas && (typeof properties.minInsyncReplicas) !== 'object') {
        errors.collect(ros.propertyValidator('minInsyncReplicas', ros.validateRange)({
            data: properties.minInsyncReplicas,
            min: 1,
            max: 3,
        }));
    }
    errors.collect(ros.propertyValidator('minInsyncReplicas', ros.validateNumber)(properties.minInsyncReplicas));
    errors.collect(ros.propertyValidator('topic', ros.requiredValidator)(properties.topic));
    errors.collect(ros.propertyValidator('topic', ros.validateString)(properties.topic));
    errors.collect(ros.propertyValidator('localTopic', ros.validateBoolean)(properties.localTopic));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: undefined,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosTopic_TagsPropertyValidator))(properties.tags));
    errors.collect(ros.propertyValidator('remark', ros.requiredValidator)(properties.remark));
    errors.collect(ros.propertyValidator('remark', ros.validateString)(properties.remark));
    return errors.wrap('supplied properties not correct for "RosTopicProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::KAFKA::Topic` resource
 *
 * @param properties - the TypeScript properties of a `RosTopicProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::KAFKA::Topic` resource.
 */
// @ts-ignore TS6133
function rosTopicPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosTopicPropsValidator(properties).assertSuccess();
    }
    return {
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        Remark: ros.stringToRosTemplate(properties.remark),
        Topic: ros.stringToRosTemplate(properties.topic),
        CompactTopic: ros.booleanToRosTemplate(properties.compactTopic),
        Config: ros.hashMapper(ros.objectToRosTemplate)(properties.config),
        LocalTopic: ros.booleanToRosTemplate(properties.localTopic),
        MinInsyncReplicas: ros.numberToRosTemplate(properties.minInsyncReplicas),
        PartitionNum: ros.numberToRosTemplate(properties.partitionNum),
        ReplicationFactor: ros.numberToRosTemplate(properties.replicationFactor),
        Tags: ros.listMapper(rosTopicTagsPropertyToRosTemplate)(properties.tags),
    };
}
/**
 * A ROS template type:  `ALIYUN::KAFKA::Topic`
 */
class RosTopic extends ros.RosResource {
    /**
     * Create a new `ALIYUN::KAFKA::Topic`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosTopic.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrInstanceId = this.getAtt('InstanceId');
        this.attrTopic = this.getAtt('Topic');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceId = props.instanceId;
        this.remark = props.remark;
        this.topic = props.topic;
        this.compactTopic = props.compactTopic;
        this.config = props.config;
        this.localTopic = props.localTopic;
        this.minInsyncReplicas = props.minInsyncReplicas;
        this.partitionNum = props.partitionNum;
        this.replicationFactor = props.replicationFactor;
        this.tags = props.tags;
    }
    get rosProperties() {
        return {
            instanceId: this.instanceId,
            remark: this.remark,
            topic: this.topic,
            compactTopic: this.compactTopic,
            config: this.config,
            localTopic: this.localTopic,
            minInsyncReplicas: this.minInsyncReplicas,
            partitionNum: this.partitionNum,
            replicationFactor: this.replicationFactor,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return rosTopicPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosTopic = RosTopic;
/**
 * The resource type name for this resource class.
 */
RosTopic.ROS_RESOURCE_TYPE_NAME = "ALIYUN::KAFKA::Topic";
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosTopic_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::KAFKA::Topic.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::KAFKA::Topic.Tags` resource.
 */
// @ts-ignore TS6133
function rosTopicTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosTopic_TagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
//# sourceMappingURL=data:application/json;base64,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