# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class ErrorRepository(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ErrorRepository - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'code': 'str',
            'message': 'str',
            'more_info': 'str',
            'target': 'ErrorRepositoryTarget'
        }

        self.attribute_map = {
            'code': 'code',
            'message': 'message',
            'more_info': 'more_info',
            'target': 'target'
        }

        self._code = None
        self._message = None
        self._more_info = None
        self._target = None

    @property
    def code(self):
        """
        Gets the code of this ErrorRepository.


        :return: The code of this ErrorRepository.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this ErrorRepository.


        :param code: The code of this ErrorRepository.
        :type: str
        """
        self._code = code

    @property
    def message(self):
        """
        Gets the message of this ErrorRepository.


        :return: The message of this ErrorRepository.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this ErrorRepository.


        :param message: The message of this ErrorRepository.
        :type: str
        """
        self._message = message

    @property
    def more_info(self):
        """
        Gets the more_info of this ErrorRepository.


        :return: The more_info of this ErrorRepository.
        :rtype: str
        """
        return self._more_info

    @more_info.setter
    def more_info(self, more_info):
        """
        Sets the more_info of this ErrorRepository.


        :param more_info: The more_info of this ErrorRepository.
        :type: str
        """
        self._more_info = more_info

    @property
    def target(self):
        """
        Gets the target of this ErrorRepository.


        :return: The target of this ErrorRepository.
        :rtype: ErrorRepositoryTarget
        """
        return self._target

    @target.setter
    def target(self, target):
        """
        Sets the target of this ErrorRepository.


        :param target: The target of this ErrorRepository.
        :type: ErrorRepositoryTarget
        """
        self._target = target

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

