# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class BaseApiSshCmdArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ssh_port': 'float',
        'user_name': 'str',
        'password': 'str',
        'private_key': 'str',
        'passphrase': 'str'
    }

    attribute_map = {
        'ssh_port': 'sshPort',
        'user_name': 'userName',
        'password': 'password',
        'private_key': 'privateKey',
        'passphrase': 'passphrase'
    }

    def __init__(self, ssh_port=None, user_name=None, password=None, private_key=None, passphrase=None):
        """
        BaseApiSshCmdArguments - a model defined in Swagger
        """

        self._ssh_port = None
        self._user_name = None
        self._password = None
        self._private_key = None
        self._passphrase = None

        if ssh_port is not None:
          self.ssh_port = ssh_port
        if user_name is not None:
          self.user_name = user_name
        if password is not None:
          self.password = password
        if private_key is not None:
          self.private_key = private_key
        if passphrase is not None:
          self.passphrase = passphrase

    @property
    def ssh_port(self):
        """
        Gets the ssh_port of this BaseApiSshCmdArguments.
        SSH port. If unset, defaults to 22.

        :return: The ssh_port of this BaseApiSshCmdArguments.
        :rtype: float
        """
        return self._ssh_port

    @ssh_port.setter
    def ssh_port(self, ssh_port):
        """
        Sets the ssh_port of this BaseApiSshCmdArguments.
        SSH port. If unset, defaults to 22.

        :param ssh_port: The ssh_port of this BaseApiSshCmdArguments.
        :type: float
        """

        self._ssh_port = ssh_port

    @property
    def user_name(self):
        """
        Gets the user_name of this BaseApiSshCmdArguments.
        The username used to authenticate with the hosts. Root access to your hosts is required to install Cloudera packages. The installer will connect to your hosts via SSH and log in either directly as root or as another user with password-less sudo privileges to become root.

        :return: The user_name of this BaseApiSshCmdArguments.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this BaseApiSshCmdArguments.
        The username used to authenticate with the hosts. Root access to your hosts is required to install Cloudera packages. The installer will connect to your hosts via SSH and log in either directly as root or as another user with password-less sudo privileges to become root.

        :param user_name: The user_name of this BaseApiSshCmdArguments.
        :type: str
        """

        self._user_name = user_name

    @property
    def password(self):
        """
        Gets the password of this BaseApiSshCmdArguments.
        The password used to authenticate with the hosts. Specify either this or a private key. For password-less login, use an empty string as password.

        :return: The password of this BaseApiSshCmdArguments.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this BaseApiSshCmdArguments.
        The password used to authenticate with the hosts. Specify either this or a private key. For password-less login, use an empty string as password.

        :param password: The password of this BaseApiSshCmdArguments.
        :type: str
        """

        self._password = password

    @property
    def private_key(self):
        """
        Gets the private_key of this BaseApiSshCmdArguments.
        The private key to authenticate with the hosts. Specify either this or a password. <br> The private key, if specified, needs to be a standard PEM-encoded key as a single string, with all line breaks replaced with the line-feed control character '\\n'. <br> A value will typically look like the following string: <br> -----BEGIN RSA PRIVATE KEY-----\\n[base-64 encoded key]\\n-----END RSA PRIVATE KEY----- <br>

        :return: The private_key of this BaseApiSshCmdArguments.
        :rtype: str
        """
        return self._private_key

    @private_key.setter
    def private_key(self, private_key):
        """
        Sets the private_key of this BaseApiSshCmdArguments.
        The private key to authenticate with the hosts. Specify either this or a password. <br> The private key, if specified, needs to be a standard PEM-encoded key as a single string, with all line breaks replaced with the line-feed control character '\\n'. <br> A value will typically look like the following string: <br> -----BEGIN RSA PRIVATE KEY-----\\n[base-64 encoded key]\\n-----END RSA PRIVATE KEY----- <br>

        :param private_key: The private_key of this BaseApiSshCmdArguments.
        :type: str
        """

        self._private_key = private_key

    @property
    def passphrase(self):
        """
        Gets the passphrase of this BaseApiSshCmdArguments.
        The passphrase associated with the private key used to authenticate with the hosts (optional).

        :return: The passphrase of this BaseApiSshCmdArguments.
        :rtype: str
        """
        return self._passphrase

    @passphrase.setter
    def passphrase(self, passphrase):
        """
        Sets the passphrase of this BaseApiSshCmdArguments.
        The passphrase associated with the private key used to authenticate with the hosts (optional).

        :param passphrase: The passphrase of this BaseApiSshCmdArguments.
        :type: str
        """

        self._passphrase = passphrase

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, BaseApiSshCmdArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
