# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiUserSession(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'remote_addr': 'str',
        'last_request': 'str'
    }

    attribute_map = {
        'name': 'name',
        'remote_addr': 'remoteAddr',
        'last_request': 'lastRequest'
    }

    def __init__(self, name=None, remote_addr=None, last_request=None):
        """
        ApiUserSession - a model defined in Swagger
        """

        self._name = None
        self._remote_addr = None
        self._last_request = None

        if name is not None:
          self.name = name
        if remote_addr is not None:
          self.remote_addr = remote_addr
        if last_request is not None:
          self.last_request = last_request

    @property
    def name(self):
        """
        Gets the name of this ApiUserSession.
        The username associated with the session. <p> This will be the same value shown to the logged in user in the UI, which will normally be the same value they typed when logging in, but it is possible that in certain external authentication scenarios, it will differ from that value.

        :return: The name of this ApiUserSession.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiUserSession.
        The username associated with the session. <p> This will be the same value shown to the logged in user in the UI, which will normally be the same value they typed when logging in, but it is possible that in certain external authentication scenarios, it will differ from that value.

        :param name: The name of this ApiUserSession.
        :type: str
        """

        self._name = name

    @property
    def remote_addr(self):
        """
        Gets the remote_addr of this ApiUserSession.
        The remote IP address for the session. <p> This will be the remote IP address for the last request made as part of this session. It is not guaranteed to be the same IP address as was previously used, or the address used to initiate the session.

        :return: The remote_addr of this ApiUserSession.
        :rtype: str
        """
        return self._remote_addr

    @remote_addr.setter
    def remote_addr(self, remote_addr):
        """
        Sets the remote_addr of this ApiUserSession.
        The remote IP address for the session. <p> This will be the remote IP address for the last request made as part of this session. It is not guaranteed to be the same IP address as was previously used, or the address used to initiate the session.

        :param remote_addr: The remote_addr of this ApiUserSession.
        :type: str
        """

        self._remote_addr = remote_addr

    @property
    def last_request(self):
        """
        Gets the last_request of this ApiUserSession.
        The date and time of the last request received as part of this session. <p> This will be returned in ISO 8601 format from the REST API.

        :return: The last_request of this ApiUserSession.
        :rtype: str
        """
        return self._last_request

    @last_request.setter
    def last_request(self, last_request):
        """
        Sets the last_request of this ApiUserSession.
        The date and time of the last request received as part of this session. <p> This will be returned in ISO 8601 format from the REST API.

        :param last_request: The last_request of this ApiUserSession.
        :type: str
        """

        self._last_request = last_request

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiUserSession):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
