# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiTimeSeriesData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'timestamp': 'str',
        'value': 'float',
        'type': 'str',
        'aggregate_statistics': 'ApiTimeSeriesAggregateStatistics'
    }

    attribute_map = {
        'timestamp': 'timestamp',
        'value': 'value',
        'type': 'type',
        'aggregate_statistics': 'aggregateStatistics'
    }

    def __init__(self, timestamp=None, value=None, type=None, aggregate_statistics=None):
        """
        ApiTimeSeriesData - a model defined in Swagger
        """

        self._timestamp = None
        self._value = None
        self._type = None
        self._aggregate_statistics = None

        if timestamp is not None:
          self.timestamp = timestamp
        if value is not None:
          self.value = value
        if type is not None:
          self.type = type
        if aggregate_statistics is not None:
          self.aggregate_statistics = aggregate_statistics

    @property
    def timestamp(self):
        """
        Gets the timestamp of this ApiTimeSeriesData.
        The timestamp for this time series data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.

        :return: The timestamp of this ApiTimeSeriesData.
        :rtype: str
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this ApiTimeSeriesData.
        The timestamp for this time series data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.

        :param timestamp: The timestamp of this ApiTimeSeriesData.
        :type: str
        """

        self._timestamp = timestamp

    @property
    def value(self):
        """
        Gets the value of this ApiTimeSeriesData.
        The value of the time series data.

        :return: The value of this ApiTimeSeriesData.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ApiTimeSeriesData.
        The value of the time series data.

        :param value: The value of this ApiTimeSeriesData.
        :type: float
        """

        self._value = value

    @property
    def type(self):
        """
        Gets the type of this ApiTimeSeriesData.
        The type of the time series data.

        :return: The type of this ApiTimeSeriesData.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ApiTimeSeriesData.
        The type of the time series data.

        :param type: The type of this ApiTimeSeriesData.
        :type: str
        """

        self._type = type

    @property
    def aggregate_statistics(self):
        """
        Gets the aggregate_statistics of this ApiTimeSeriesData.
        Available from v6 for data points containing aggregate data. It includes further statistics about the data point. An aggregate can be across entities (e.g., fd_open_across_datanodes), over time (e.g., a daily point for the fd_open metric for a specific DataNode), or both (e.g., a daily point for the fd_open_across_datanodes metric). If the data point is for non-aggregate date this will return null.

        :return: The aggregate_statistics of this ApiTimeSeriesData.
        :rtype: ApiTimeSeriesAggregateStatistics
        """
        return self._aggregate_statistics

    @aggregate_statistics.setter
    def aggregate_statistics(self, aggregate_statistics):
        """
        Sets the aggregate_statistics of this ApiTimeSeriesData.
        Available from v6 for data points containing aggregate data. It includes further statistics about the data point. An aggregate can be across entities (e.g., fd_open_across_datanodes), over time (e.g., a daily point for the fd_open metric for a specific DataNode), or both (e.g., a daily point for the fd_open_across_datanodes metric). If the data point is for non-aggregate date this will return null.

        :param aggregate_statistics: The aggregate_statistics of this ApiTimeSeriesData.
        :type: ApiTimeSeriesAggregateStatistics
        """

        self._aggregate_statistics = aggregate_statistics

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiTimeSeriesData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
