# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v41</h1>       <p>Introduced in Cloudera Manager 7.1.1</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.1.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiTimeSeriesAggregateStatistics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'sample_time': 'str',
        'sample_value': 'float',
        'count': 'float',
        'min': 'float',
        'min_time': 'str',
        'max': 'float',
        'max_time': 'str',
        'mean': 'float',
        'std_dev': 'float',
        'cross_entity_metadata': 'ApiTimeSeriesCrossEntityMetadata'
    }

    attribute_map = {
        'sample_time': 'sampleTime',
        'sample_value': 'sampleValue',
        'count': 'count',
        'min': 'min',
        'min_time': 'minTime',
        'max': 'max',
        'max_time': 'maxTime',
        'mean': 'mean',
        'std_dev': 'stdDev',
        'cross_entity_metadata': 'crossEntityMetadata'
    }

    def __init__(self, sample_time=None, sample_value=None, count=None, min=None, min_time=None, max=None, max_time=None, mean=None, std_dev=None, cross_entity_metadata=None):
        """
        ApiTimeSeriesAggregateStatistics - a model defined in Swagger
        """

        self._sample_time = None
        self._sample_value = None
        self._count = None
        self._min = None
        self._min_time = None
        self._max = None
        self._max_time = None
        self._mean = None
        self._std_dev = None
        self._cross_entity_metadata = None

        if sample_time is not None:
          self.sample_time = sample_time
        if sample_value is not None:
          self.sample_value = sample_value
        if count is not None:
          self.count = count
        if min is not None:
          self.min = min
        if min_time is not None:
          self.min_time = min_time
        if max is not None:
          self.max = max
        if max_time is not None:
          self.max_time = max_time
        if mean is not None:
          self.mean = mean
        if std_dev is not None:
          self.std_dev = std_dev
        if cross_entity_metadata is not None:
          self.cross_entity_metadata = cross_entity_metadata

    @property
    def sample_time(self):
        """
        Gets the sample_time of this ApiTimeSeriesAggregateStatistics.
        The timestamp of the sample data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.

        :return: The sample_time of this ApiTimeSeriesAggregateStatistics.
        :rtype: str
        """
        return self._sample_time

    @sample_time.setter
    def sample_time(self, sample_time):
        """
        Sets the sample_time of this ApiTimeSeriesAggregateStatistics.
        The timestamp of the sample data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.

        :param sample_time: The sample_time of this ApiTimeSeriesAggregateStatistics.
        :type: str
        """

        self._sample_time = sample_time

    @property
    def sample_value(self):
        """
        Gets the sample_value of this ApiTimeSeriesAggregateStatistics.
        The sample data point value representing an actual sample value picked from the underlying data that is being aggregated.

        :return: The sample_value of this ApiTimeSeriesAggregateStatistics.
        :rtype: float
        """
        return self._sample_value

    @sample_value.setter
    def sample_value(self, sample_value):
        """
        Sets the sample_value of this ApiTimeSeriesAggregateStatistics.
        The sample data point value representing an actual sample value picked from the underlying data that is being aggregated.

        :param sample_value: The sample_value of this ApiTimeSeriesAggregateStatistics.
        :type: float
        """

        self._sample_value = sample_value

    @property
    def count(self):
        """
        Gets the count of this ApiTimeSeriesAggregateStatistics.
        The number of individual data points aggregated in this data point.

        :return: The count of this ApiTimeSeriesAggregateStatistics.
        :rtype: float
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this ApiTimeSeriesAggregateStatistics.
        The number of individual data points aggregated in this data point.

        :param count: The count of this ApiTimeSeriesAggregateStatistics.
        :type: float
        """

        self._count = count

    @property
    def min(self):
        """
        Gets the min of this ApiTimeSeriesAggregateStatistics.
        This minimum value encountered while producing this aggregate data point. If this is a cross-time aggregate then this is the minimum value encountered during the aggregation period. If this is a cross-entity aggregate then this is the minimum value encountered across all entities. If this is a cross-time, cross-entity aggregate, then this is the minimum value for any entity across the aggregation period.

        :return: The min of this ApiTimeSeriesAggregateStatistics.
        :rtype: float
        """
        return self._min

    @min.setter
    def min(self, min):
        """
        Sets the min of this ApiTimeSeriesAggregateStatistics.
        This minimum value encountered while producing this aggregate data point. If this is a cross-time aggregate then this is the minimum value encountered during the aggregation period. If this is a cross-entity aggregate then this is the minimum value encountered across all entities. If this is a cross-time, cross-entity aggregate, then this is the minimum value for any entity across the aggregation period.

        :param min: The min of this ApiTimeSeriesAggregateStatistics.
        :type: float
        """

        self._min = min

    @property
    def min_time(self):
        """
        Gets the min_time of this ApiTimeSeriesAggregateStatistics.
        The timestamp of the minimum data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.

        :return: The min_time of this ApiTimeSeriesAggregateStatistics.
        :rtype: str
        """
        return self._min_time

    @min_time.setter
    def min_time(self, min_time):
        """
        Sets the min_time of this ApiTimeSeriesAggregateStatistics.
        The timestamp of the minimum data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.

        :param min_time: The min_time of this ApiTimeSeriesAggregateStatistics.
        :type: str
        """

        self._min_time = min_time

    @property
    def max(self):
        """
        Gets the max of this ApiTimeSeriesAggregateStatistics.
        This maximum value encountered while producing this aggregate data point. If this is a cross-time aggregate then this is the maximum value encountered during the aggregation period. If this is a cross-entity aggregate then this is the maximum value encountered across all entities. If this is a cross-time, cross-entity aggregate, then this is the maximum value for any entity across the aggregation period.

        :return: The max of this ApiTimeSeriesAggregateStatistics.
        :rtype: float
        """
        return self._max

    @max.setter
    def max(self, max):
        """
        Sets the max of this ApiTimeSeriesAggregateStatistics.
        This maximum value encountered while producing this aggregate data point. If this is a cross-time aggregate then this is the maximum value encountered during the aggregation period. If this is a cross-entity aggregate then this is the maximum value encountered across all entities. If this is a cross-time, cross-entity aggregate, then this is the maximum value for any entity across the aggregation period.

        :param max: The max of this ApiTimeSeriesAggregateStatistics.
        :type: float
        """

        self._max = max

    @property
    def max_time(self):
        """
        Gets the max_time of this ApiTimeSeriesAggregateStatistics.
        The timestamp of the maximum data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.

        :return: The max_time of this ApiTimeSeriesAggregateStatistics.
        :rtype: str
        """
        return self._max_time

    @max_time.setter
    def max_time(self, max_time):
        """
        Sets the max_time of this ApiTimeSeriesAggregateStatistics.
        The timestamp of the maximum data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.

        :param max_time: The max_time of this ApiTimeSeriesAggregateStatistics.
        :type: str
        """

        self._max_time = max_time

    @property
    def mean(self):
        """
        Gets the mean of this ApiTimeSeriesAggregateStatistics.
        The mean of the values of all data-points for this aggregate data point.

        :return: The mean of this ApiTimeSeriesAggregateStatistics.
        :rtype: float
        """
        return self._mean

    @mean.setter
    def mean(self, mean):
        """
        Sets the mean of this ApiTimeSeriesAggregateStatistics.
        The mean of the values of all data-points for this aggregate data point.

        :param mean: The mean of this ApiTimeSeriesAggregateStatistics.
        :type: float
        """

        self._mean = mean

    @property
    def std_dev(self):
        """
        Gets the std_dev of this ApiTimeSeriesAggregateStatistics.
        The standard deviation of the values of all data-points for this aggregate data point.

        :return: The std_dev of this ApiTimeSeriesAggregateStatistics.
        :rtype: float
        """
        return self._std_dev

    @std_dev.setter
    def std_dev(self, std_dev):
        """
        Sets the std_dev of this ApiTimeSeriesAggregateStatistics.
        The standard deviation of the values of all data-points for this aggregate data point.

        :param std_dev: The std_dev of this ApiTimeSeriesAggregateStatistics.
        :type: float
        """

        self._std_dev = std_dev

    @property
    def cross_entity_metadata(self):
        """
        Gets the cross_entity_metadata of this ApiTimeSeriesAggregateStatistics.
        If the data-point is for a cross entity aggregate (e.g., fd_open_across_datanodes) returns the cross entity metadata, null otherwise.

        :return: The cross_entity_metadata of this ApiTimeSeriesAggregateStatistics.
        :rtype: ApiTimeSeriesCrossEntityMetadata
        """
        return self._cross_entity_metadata

    @cross_entity_metadata.setter
    def cross_entity_metadata(self, cross_entity_metadata):
        """
        Sets the cross_entity_metadata of this ApiTimeSeriesAggregateStatistics.
        If the data-point is for a cross entity aggregate (e.g., fd_open_across_datanodes) returns the cross entity metadata, null otherwise.

        :param cross_entity_metadata: The cross_entity_metadata of this ApiTimeSeriesAggregateStatistics.
        :type: ApiTimeSeriesCrossEntityMetadata
        """

        self._cross_entity_metadata = cross_entity_metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiTimeSeriesAggregateStatistics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
